/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.zone.ZoneType;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StaticAbilityMustAttack {
    static String MODE_Creature = "MustAttack";
    static String MODE_Player = "PlayerMustAttack";

    public static List<GameEntity> entitiesMustAttack(Card attacker) {
        ArrayList<GameEntity> entityList = new ArrayList<GameEntity>();
        Game game = attacker.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE_Creature) || !stAb.matchesValidParam("ValidCreature", attacker)) continue;
                if (stAb.hasParam("MustAttack")) {
                    FCollection<GameEntity> def = AbilityUtils.getDefinedEntities(stAb.getHostCard(), stAb.getParam("MustAttack"), (CardTraitBase)stAb);
                    for (GameEntity e : def) {
                        if (e instanceof Player) {
                            Player attackPl = (Player)e;
                            if (game.getPhaseHandler().isPlayerTurn(attackPl)) continue;
                            entityList.add(e);
                            continue;
                        }
                        if (!(e instanceof Card)) continue;
                        Card attackPW = (Card)e;
                        if (game.getPhaseHandler().isPlayerTurn(attackPW.getController())) continue;
                        entityList.add(e);
                    }
                    continue;
                }
                entityList.add(attacker);
            }
        }
        return entityList;
    }

    public static List<Set<GameEntity>> mustAttackSpecific(Player attackingPlayer, FCollectionView<GameEntity> possibleDefenders) {
        ArrayList<Set<GameEntity>> defToAtt = new ArrayList<Set<GameEntity>>();
        for (Card ca : attackingPlayer.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE_Player) || !stAb.matchesValidParam("ValidPlayer", attackingPlayer)) continue;
                HashSet<GameEntity> attackWithOne = new HashSet<GameEntity>();
                for (GameEntity ge : possibleDefenders) {
                    if (!stAb.matchesValidParam("MustAttack", ge)) continue;
                    attackWithOne.add(ge);
                }
                defToAtt.add(attackWithOne);
            }
        }
        return defToAtt;
    }
}

