/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.base.Predicates;
import com.google.common.collect.Table;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class StaticAbilityDisableTriggers {
    static String MODE = "DisableTriggers";

    public static boolean disabled(Game game, Trigger regtrig, Map<AbilityKey, Object> runParams) {
        CardCollectionView cardList = null;
        if ((regtrig.getMode() == TriggerType.ChangesZone || regtrig.getMode() == TriggerType.ChangesZoneAll) && "Battlefield".equals(regtrig.getParam("Origin"))) {
            if (runParams.containsKey((Object)AbilityKey.LastStateBattlefield)) {
                cardList = (CardCollectionView)runParams.get((Object)AbilityKey.LastStateBattlefield);
            }
            if (cardList == null) {
                cardList = game.getLastStateBattlefield();
            }
        } else {
            cardList = game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES);
        }
        for (Card ca : cardList) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MODE) || !StaticAbilityDisableTriggers.isDisabled(stAb, regtrig, runParams)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDisabled(StaticAbility stAb, Trigger regtrig, Map<AbilityKey, Object> runParams) {
        TriggerType trigMode = regtrig.getMode();
        if (stAb.hasParam("ValidCard") && regtrig.getSpawningAbility() != null) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidCard", regtrig.getHostCard())) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidTrigger", regtrig.getOverridingAbility())) {
            return false;
        }
        if (stAb.hasParam("ValidMode") && !ArrayUtils.contains(stAb.getParam("ValidMode").split(","), trigMode.toString())) {
            return false;
        }
        if (trigMode.equals((Object)TriggerType.ChangesZone)) {
            Card moved = (Card)runParams.get((Object)AbilityKey.Card);
            if ("Battlefield".equals(regtrig.getParam("Origin"))) {
                moved = (Card)runParams.get((Object)AbilityKey.CardLKI);
            }
            if (!stAb.matchesValidParam("ValidCause", moved)) {
                return false;
            }
            if (!stAb.matchesValidParam("Destination", runParams.get((Object)AbilityKey.Destination))) {
                return false;
            }
            if (!stAb.matchesValidParam("Origin", runParams.get((Object)AbilityKey.Origin))) {
                return false;
            }
            if ("Graveyard".equals(runParams.get((Object)AbilityKey.Destination)) && "Battlefield".equals(runParams.get((Object)AbilityKey.Origin)) && "Card.Self".equals(regtrig.getParam("ValidCard")) && (!regtrig.hasParam("Origin") || "Any".equals(regtrig.getParam("Origin")))) {
                return false;
            }
        } else if (trigMode.equals((Object)TriggerType.ChangesZoneAll)) {
            String origin = stAb.getParam("Origin");
            String destination = stAb.getParam("Destination");
            CardZoneTable table = (CardZoneTable)runParams.get((Object)AbilityKey.CardsFiltered);
            if (table == null) {
                table = (CardZoneTable)runParams.get((Object)AbilityKey.Cards);
            }
            CardZoneTable filtered = new CardZoneTable(table.getLastStateBattlefield(), table.getLastStateGraveyard());
            boolean possiblyDisabled = false;
            for (Table.Cell cell : table.cellSet()) {
                CardCollection changers = (CardCollection)cell.getValue();
                if (!(origin != null && cell.getRowKey() != ZoneType.valueOf(origin) || destination != null && cell.getColumnKey() != ZoneType.valueOf(destination) || (changers = CardLists.filter((Iterable<Card>)changers, Predicates.not(CardPredicates.restriction(stAb.getParam("ValidCause").split(","), stAb.getHostCard().getController(), stAb.getHostCard(), (CardTraitBase)stAb)))).size() >= ((CardCollection)cell.getValue()).size())) {
                    possiblyDisabled = true;
                }
                filtered.put((ZoneType)((Object)cell.getRowKey()), (ZoneType)((Object)cell.getColumnKey()), changers);
            }
            if (!possiblyDisabled) {
                return false;
            }
            EnumMap<AbilityKey, Object> runParamsFiltered = AbilityKey.newMap(runParams);
            runParamsFiltered.put(AbilityKey.Cards, (Object)filtered);
            if (regtrig.performTest(runParamsFiltered)) {
                runParams.put(AbilityKey.CardsFiltered, filtered);
                return false;
            }
        }
        return true;
    }
}

