/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.GameCommand;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.RemoveType;
import forge.card.mana.ManaCost;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.StaticEffect;
import forge.game.StaticEffects;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardState;
import forge.game.card.CardUtil;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.AbilityStatic;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityLayer;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class StaticAbilityContinuous {
    private StaticAbilityContinuous() {
    }

    public static CardCollectionView applyContinuousAbility(StaticAbility stAb, StaticAbilityLayer layer, CardCollectionView preList) {
        CardCollectionView affectedCards = StaticAbilityContinuous.getAffectedCards(stAb, preList);
        return StaticAbilityContinuous.applyContinuousAbility(stAb, affectedCards, layer);
    }

    /*
     * WARNING - void declaration
     */
    public static CardCollectionView applyContinuousAbility(StaticAbility stAb, CardCollectionView affectedCards, StaticAbilityLayer layer) {
        Map<String, String> params = stAb.getMapParams();
        Card hostCard = stAb.getHostCard();
        Player controller = hostCard.getController();
        List<Player> affectedPlayers = StaticAbilityContinuous.getAffectedPlayers(stAb);
        Game game = hostCard.getGame();
        StaticEffects effects = game.getStaticEffects();
        StaticEffect se = effects.getStaticEffect(stAb);
        se.setAffectedCards(affectedCards);
        se.setAffectedPlayers(affectedPlayers);
        se.setParams(params);
        se.setTimestamp(hostCard.getLayerTimestamp());
        if (stAb.hasParam("Affected") && affectedPlayers.isEmpty() && affectedCards.isEmpty()) {
            return affectedCards;
        }
        String addP = "";
        int powerBonus = 0;
        String addT = "";
        int toughnessBonus = 0;
        String setP = "";
        Integer setPower = null;
        String setT = "";
        Integer setToughness = null;
        List<String> addKeywords = null;
        ArrayList<String> addHiddenKeywords = Lists.newArrayList();
        List<String> removeKeywords = null;
        String[] addAbilities = null;
        String[] addReplacements = null;
        String[] addSVars = null;
        List<String> addTypes = null;
        ArrayList<String> removeTypes = null;
        ColorSet addColors = null;
        String[] addTriggers = null;
        String[] addStatics = null;
        boolean removeAllAbilities = false;
        boolean removeNonMana = false;
        boolean addAllCreatureTypes = false;
        EnumSet<RemoveType> remove = EnumSet.noneOf(RemoveType.class);
        boolean overwriteColors = false;
        Set<Keyword> cantHaveKeyword = null;
        PlayerCollection mayLookAt = null;
        boolean controllerMayPlay = false;
        boolean mayPlayWithoutManaCost = false;
        boolean mayPlayWithFlash = false;
        String mayPlayAltManaCost = null;
        boolean mayPlayGrantZonePermissions = true;
        Integer mayPlayLimit = null;
        if (layer == StaticAbilityLayer.SETPT || layer == StaticAbilityLayer.CHARACTERISTIC) {
            if (params.containsKey("SetPower")) {
                setP = params.get("SetPower");
                setPower = AbilityUtils.calculateAmount(hostCard, setP, stAb);
            }
            if (params.containsKey("SetToughness")) {
                setT = params.get("SetToughness");
                setToughness = AbilityUtils.calculateAmount(hostCard, setT, stAb);
            }
        }
        if (layer == StaticAbilityLayer.MODIFYPT) {
            if (params.containsKey("AddPower")) {
                addP = params.get("AddPower");
                powerBonus = AbilityUtils.calculateAmount(hostCard, addP, stAb, true);
            }
            if (params.containsKey("AddToughness")) {
                addT = params.get("AddToughness");
                toughnessBonus = AbilityUtils.calculateAmount(hostCard, addT, stAb, true);
            }
        }
        if (layer == StaticAbilityLayer.ABILITIES) {
            if (params.containsKey("AddKeyword")) {
                addKeywords = Lists.newArrayList(Arrays.asList(params.get("AddKeyword").split(" & ")));
                ArrayList newKeywords = Lists.newArrayList();
                String hostCardUID = Integer.toString(hostCard.getId());
                Iterables.removeIf(addKeywords, input -> {
                    if (!hostCard.hasChosenColor() && input.contains("ChosenColor")) {
                        return true;
                    }
                    if (!hostCard.hasChosenType() && input.contains("ChosenType")) {
                        return true;
                    }
                    if (!hostCard.hasChosenNumber() && input.contains("ChosenNumber")) {
                        return true;
                    }
                    if (!hostCard.hasChosenPlayer() && input.contains("ChosenPlayer")) {
                        return true;
                    }
                    if (!hostCard.hasNamedCard() && input.contains("ChosenName")) {
                        return true;
                    }
                    if (!hostCard.hasChosenEvenOdd() && (input.contains("ChosenEvenOdd") || input.contains("chosenEvenOdd"))) {
                        return true;
                    }
                    if (input.contains("AllColors") || input.contains("allColors")) {
                        for (byte color : MagicColor.WUBRG) {
                            String colorWord = MagicColor.toLongString(color);
                            String y = input.replaceAll("AllColors", StringUtils.capitalize(colorWord));
                            y = y.replaceAll("allColors", colorWord);
                            newKeywords.add(y);
                        }
                        return true;
                    }
                    if (input.contains("CommanderColorID")) {
                        if (!hostCard.getController().getCommanders().isEmpty()) {
                            if (input.contains("NotCommanderColorID")) {
                                for (Byte color : hostCard.getController().getNotCommanderColorID()) {
                                    newKeywords.add(input.replace("NotCommanderColorID", MagicColor.toLongString(color)));
                                }
                                return true;
                            }
                            for (Byte color : hostCard.getController().getCommanderColorID()) {
                                newKeywords.add(input.replace("CommanderColorID", MagicColor.toLongString(color)));
                            }
                            return true;
                        }
                        return true;
                    }
                    if (input.contains("ColorsYouCtrl") || input.contains("colorsYouCtrl")) {
                        ColorSet colorsYouCtrl = CardUtil.getColorsFromCards(controller.getCardsIn(ZoneType.Battlefield));
                        for (byte color : colorsYouCtrl) {
                            String colorWord = MagicColor.toLongString(color);
                            String y = input.replaceAll("ColorsYouCtrl", StringUtils.capitalize(colorWord));
                            y = y.replaceAll("colorsYouCtrl", colorWord);
                            newKeywords.add(y);
                        }
                        return true;
                    }
                    if (input.contains("YourBasic")) {
                        CardCollection lands = hostCard.getController().getLandsInPlay();
                        ImmutableList<String> basic = MagicColor.Constant.BASIC_LANDS;
                        for (String type : basic) {
                            if (!Iterables.any(lands, CardPredicates.isType(type))) continue;
                            String y = input.replaceAll("YourBasic", type);
                            newKeywords.add(y);
                        }
                        return true;
                    }
                    if (input.contains("EachCMCAmongDefined")) {
                        String keywordDefined = (String)params.get("KeywordDefined");
                        CardCollectionView definedCards = game.getCardsIn(ZoneType.Battlefield);
                        definedCards = CardLists.getValidCards((Iterable<Card>)definedCards, keywordDefined, hostCard.getController(), hostCard, (CardTraitBase)stAb);
                        for (Card c : definedCards) {
                            int cmc = c.getCMC();
                            String y = input.replace(" from EachCMCAmongDefined", ":Card.cmcEQ" + cmc + ":Protection from mana value " + cmc);
                            if (newKeywords.contains(y)) continue;
                            newKeywords.add(y);
                        }
                        return true;
                    }
                    return false;
                });
                addKeywords.addAll(newKeywords);
                addKeywords = Lists.transform(addKeywords, input -> {
                    if (hostCard.hasChosenColor()) {
                        input = input.replaceAll("ChosenColor", StringUtils.capitalize(hostCard.getChosenColor()));
                        input = input.replaceAll("chosenColor", hostCard.getChosenColor().toLowerCase());
                    }
                    if (hostCard.hasChosenType()) {
                        input = input.replaceAll("ChosenType", hostCard.getChosenType());
                    }
                    if (hostCard.hasChosenNumber()) {
                        input = input.replaceAll("ChosenNumber", String.valueOf(hostCard.getChosenNumber()));
                    }
                    if (hostCard.hasChosenPlayer()) {
                        Player cp = hostCard.getChosenPlayer();
                        input = input.replaceAll("ChosenPlayerUID", String.valueOf(cp.getId()));
                        input = input.replaceAll("ChosenPlayerName", cp.getName());
                    }
                    if (hostCard.hasNamedCard()) {
                        String chosenName = hostCard.getNamedCard().replace(",", ";");
                        input = input.replaceAll("ChosenName", "Card.named" + chosenName);
                    }
                    if (hostCard.hasChosenEvenOdd()) {
                        input = input.replaceAll("ChosenEvenOdd", hostCard.getChosenEvenOdd().toString());
                        input = input.replaceAll("chosenEvenOdd", hostCard.getChosenEvenOdd().toString().toLowerCase());
                    }
                    input = input.replace("HostCardUID", hostCardUID);
                    if (params.containsKey("CalcKeywordN")) {
                        input = input.replace("N", String.valueOf(AbilityUtils.calculateAmount(hostCard, (String)params.get("CalcKeywordN"), stAb)));
                    }
                    return input;
                });
                if (params.containsKey("SharedKeywordsZone")) {
                    String[] stringArray;
                    List<ZoneType> zones = ZoneType.listValueOf(params.get("SharedKeywordsZone"));
                    if (params.containsKey("SharedRestrictions")) {
                        stringArray = params.get("SharedRestrictions").split(",");
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "Card";
                    }
                    String[] restrictions = stringArray;
                    addKeywords = CardFactoryUtil.sharedKeywords(addKeywords, restrictions, zones, hostCard, stAb);
                }
                if (params.containsKey("FromDraftNotes")) {
                    addKeywords = Lists.newArrayList(hostCard.getController().getDraftNotes().getOrDefault(params.get("FromDraftNotes"), "").split(","));
                }
            } else if (params.containsKey("ShareRememberedKeywords")) {
                ArrayList<String> kwToShare = Lists.newArrayList();
                for (Object o : hostCard.getRemembered()) {
                    String k = (String)o;
                    kwToShare.add(k);
                }
                if (!kwToShare.isEmpty()) {
                    addKeywords = kwToShare;
                }
            }
            if (params.containsKey("CantHaveKeyword")) {
                cantHaveKeyword = Keyword.setValueOf(params.get("CantHaveKeyword"));
            }
            if (params.containsKey("RemoveKeyword")) {
                removeKeywords = Arrays.asList(params.get("RemoveKeyword").split(" & "));
            }
        }
        if (layer == StaticAbilityLayer.RULES && params.containsKey("AddHiddenKeyword")) {
            addHiddenKeywords.addAll(Arrays.asList(params.get("AddHiddenKeyword").split(" & ")));
        }
        if (layer == StaticAbilityLayer.ABILITIES) {
            String[] sVars;
            if (params.containsKey("RemoveAllAbilities")) {
                removeAllAbilities = true;
                if (params.containsKey("ExceptManaAbilities")) {
                    removeNonMana = true;
                }
            }
            if (params.containsKey("AddAbility")) {
                sVars = params.get("AddAbility").split(" & ");
                for (int i = 0; i < sVars.length; ++i) {
                    sVars[i] = AbilityUtils.getSVar(stAb, sVars[i]);
                }
                addAbilities = sVars;
            }
            if (params.containsKey("AddReplacementEffect")) {
                sVars = params.get("AddReplacementEffect").split(" & ");
                for (int i = 0; i < sVars.length; ++i) {
                    sVars[i] = AbilityUtils.getSVar(stAb, sVars[i]);
                }
                addReplacements = sVars;
            }
            if (params.containsKey("AddTrigger")) {
                sVars = params.get("AddTrigger").split(" & ");
                for (int i = 0; i < sVars.length; ++i) {
                    sVars[i] = AbilityUtils.getSVar(stAb, sVars[i]);
                }
                addTriggers = sVars;
            }
            if (params.containsKey("AddStaticAbility")) {
                sVars = params.get("AddStaticAbility").split(" & ");
                for (int i = 0; i < sVars.length; ++i) {
                    sVars[i] = AbilityUtils.getSVar(stAb, sVars[i]);
                }
                addStatics = sVars;
            }
            if (params.containsKey("AddSVar")) {
                addSVars = params.get("AddSVar").split(" & ");
            }
        }
        if (layer == StaticAbilityLayer.TYPE) {
            if (params.containsKey("AddType")) {
                addTypes = Lists.newArrayList(Arrays.asList(params.get("AddType").split(" & ")));
                ArrayList newTypes = Lists.newArrayList();
                Iterables.removeIf(addTypes, input -> {
                    if (input.equals("ChosenType") && !hostCard.hasChosenType()) {
                        return true;
                    }
                    if (input.equals("ChosenType2") && !hostCard.hasChosenType2()) {
                        return true;
                    }
                    if (input.equals("ImprintedCreatureType")) {
                        if (hostCard.hasImprintedCard()) {
                            newTypes.addAll(((Card)hostCard.getImprintedCards().getLast()).getType().getCreatureTypes());
                        }
                        return true;
                    }
                    if (input.equals("AllBasicLandType")) {
                        newTypes.addAll(CardType.getBasicTypes());
                        return true;
                    }
                    if (input.equals("AllNonBasicLandType")) {
                        newTypes.addAll(CardType.getNonBasicTypes());
                        return true;
                    }
                    return false;
                });
                addTypes.addAll(newTypes);
                addTypes = Lists.transform(addTypes, input -> {
                    if (hostCard.hasChosenType2()) {
                        input = input.replaceAll("ChosenType2", hostCard.getChosenType2());
                    }
                    if (hostCard.hasChosenType()) {
                        input = input.replaceAll("ChosenType", hostCard.getChosenType());
                    }
                    return input;
                });
            }
            if (params.containsKey("RemoveType")) {
                removeTypes = Lists.newArrayList(Arrays.asList(params.get("RemoveType").split(" & ")));
                Iterables.removeIf(removeTypes, input -> input.equals("ChosenType") && !hostCard.hasChosenType());
            }
            if (params.containsKey("AddAllCreatureTypes")) {
                addAllCreatureTypes = true;
            }
            if (addTypes == null || !addTypes.isEmpty()) {
                if (params.containsKey("RemoveSuperTypes")) {
                    remove.add(RemoveType.SuperTypes);
                }
                if (params.containsKey("RemoveCardTypes")) {
                    remove.add(RemoveType.CardTypes);
                }
                if (params.containsKey("RemoveSubTypes")) {
                    remove.add(RemoveType.SubTypes);
                }
                if (params.containsKey("RemoveLandTypes")) {
                    remove.add(RemoveType.LandTypes);
                }
                if (params.containsKey("RemoveCreatureTypes")) {
                    remove.add(RemoveType.CreatureTypes);
                }
                if (params.containsKey("RemoveArtifactTypes")) {
                    remove.add(RemoveType.ArtifactTypes);
                }
                if (params.containsKey("RemoveEnchantmentTypes")) {
                    remove.add(RemoveType.EnchantmentTypes);
                }
            }
        }
        if (layer == StaticAbilityLayer.COLOR) {
            String colors;
            if (params.containsKey("AddColor")) {
                colors = params.get("AddColor");
                if (colors.equals("ChosenColor")) {
                    if (hostCard.hasChosenColor()) {
                        addColors = ColorSet.fromNames(hostCard.getChosenColors());
                    }
                } else {
                    addColors = colors.equals("All") ? ColorSet.ALL_COLORS : ColorSet.fromNames(colors.split(" & "));
                }
            }
            if (params.containsKey("SetColor")) {
                colors = params.get("SetColor");
                if (colors.equals("ChosenColor")) {
                    if (hostCard.hasChosenColor()) {
                        addColors = ColorSet.fromNames(hostCard.getChosenColors());
                    }
                } else {
                    addColors = colors.equals("All") ? ColorSet.ALL_COLORS : ColorSet.fromNames(colors.split(" & "));
                }
                overwriteColors = true;
            }
        }
        if (layer == StaticAbilityLayer.RULES) {
            if (params.containsKey("MayLookAt")) {
                String look = params.get("MayLookAt");
                if ("True".equals(look)) {
                    look = "You";
                }
                mayLookAt = AbilityUtils.getDefinedPlayers(hostCard, look, stAb);
            }
            if (params.containsKey("MayPlay")) {
                controllerMayPlay = true;
                if (params.containsKey("MayPlayWithoutManaCost")) {
                    mayPlayWithoutManaCost = true;
                } else if (params.containsKey("MayPlayAltManaCost")) {
                    mayPlayAltManaCost = params.get("MayPlayAltManaCost");
                }
                if (params.containsKey("MayPlayWithFlash")) {
                    mayPlayWithFlash = true;
                }
                if (params.containsKey("MayPlayLimit")) {
                    mayPlayLimit = Integer.parseInt(params.get("MayPlayLimit"));
                }
                if (params.containsKey("MayPlayDontGrantZonePermissions")) {
                    mayPlayGrantZonePermissions = false;
                }
            }
            if (params.containsKey("IgnoreEffectCost")) {
                String cost = params.get("IgnoreEffectCost");
                StaticAbilityContinuous.buildIgnorEffectAbility(stAb, cost, affectedPlayers, affectedCards);
            }
        }
        for (Player p : affectedPlayers) {
            PlayerCollection players;
            String mhs;
            if (addKeywords != null && !addKeywords.isEmpty()) {
                p.addChangedKeywords(addKeywords, removeKeywords, se.getTimestamp(), stAb.getId());
            }
            if (addStatics != null) {
                for (String s2 : addStatics) {
                    StaticAbility staticAbility = p.addStaticAbility(hostCard, s2);
                    staticAbility.setIntrinsic(false);
                }
            }
            if (layer != StaticAbilityLayer.RULES) continue;
            if (params.containsKey("SetMaxHandSize")) {
                mhs = params.get("SetMaxHandSize");
                if (mhs.equals("Unlimited")) {
                    p.setUnlimitedHandSize(true);
                } else {
                    p.setUnlimitedHandSize(false);
                    int max = AbilityUtils.calculateAmount(hostCard, mhs, stAb);
                    p.setMaxHandSize(max);
                }
            }
            if (params.containsKey("RaiseMaxHandSize")) {
                String rmhs = params.get("RaiseMaxHandSize");
                int rmax = AbilityUtils.calculateAmount(hostCard, rmhs, stAb);
                p.setMaxHandSize(p.getMaxHandSize() + rmax);
            }
            if (params.containsKey("AdjustLandPlays")) {
                mhs = params.get("AdjustLandPlays");
                if (mhs.equals("Unlimited")) {
                    p.addMaxLandPlaysInfinite(se.getTimestamp());
                } else {
                    int add = AbilityUtils.calculateAmount(hostCard, mhs, stAb);
                    p.addMaxLandPlays(se.getTimestamp(), add);
                }
            }
            if (params.containsKey("ControlOpponentsSearchingLibrary")) {
                Player cntl = Iterables.getFirst(AbilityUtils.getDefinedPlayers(hostCard, params.get("ControlOpponentsSearchingLibrary"), stAb), null);
                p.addControlledWhileSearching(se.getTimestamp(), cntl);
            }
            if (params.containsKey("ControlVote")) {
                p.addControlVote(se.getTimestamp());
            }
            if (params.containsKey("AdditionalVote")) {
                mhs = params.get("AdditionalVote");
                int add = AbilityUtils.calculateAmount(hostCard, mhs, stAb);
                p.addAdditionalVote(se.getTimestamp(), add);
            }
            if (params.containsKey("AdditionalOptionalVote")) {
                mhs = params.get("AdditionalOptionalVote");
                int add = AbilityUtils.calculateAmount(hostCard, mhs, stAb);
                p.addAdditionalOptionalVote(se.getTimestamp(), add);
            }
            if (params.containsKey("AdditionalVillainousChoice")) {
                mhs = params.get("AdditionalVillainousChoice");
                int add = AbilityUtils.calculateAmount(hostCard, mhs, stAb);
                p.addAdditionalVillainousChoices(se.getTimestamp(), add);
            }
            if (params.containsKey("DeclaresAttackers") && !(players = AbilityUtils.getDefinedPlayers(hostCard, params.get("DeclaresAttackers"), stAb)).isEmpty()) {
                p.addDeclaresAttackers(se.getTimestamp(), (Player)players.getFirst());
            }
            if (!params.containsKey("DeclaresBlockers") || (players = AbilityUtils.getDefinedPlayers(hostCard, params.get("DeclaresBlockers"), stAb)).isEmpty()) continue;
            p.addDeclaresBlockers(se.getTimestamp(), (Player)players.getFirst());
        }
        for (int i = 0; i < affectedCards.size(); ++i) {
            PlayerCollection gain;
            Card affectedCard = (Card)affectedCards.get(i);
            if (layer == StaticAbilityLayer.CONTROL && params.containsKey("GainControl") && !(gain = AbilityUtils.getDefinedPlayers(hostCard, params.get("GainControl"), stAb)).isEmpty()) {
                affectedCard.addTempController((Player)gain.get(false), se.getTimestamp());
            }
            if (layer == StaticAbilityLayer.TEXT) {
                CardCollection allValid;
                if (params.containsKey("GainTextOf") && !(allValid = AbilityUtils.getDefinedCards(hostCard, params.get("GainTextOf"), stAb)).isEmpty()) {
                    Card first = (Card)allValid.getFirst();
                    CardState state = first.getState(affectedCard.isFlipped() && first.isFlipCard() ? CardStateName.Flipped : first.getCurrentStateName());
                    ArrayList<SpellAbility> spellAbilities = Lists.newArrayList();
                    ArrayList<Trigger> arrayList = Lists.newArrayList();
                    ArrayList<ReplacementEffect> replacementEffects = Lists.newArrayList();
                    ArrayList<StaticAbility> staticAbilities = Lists.newArrayList();
                    ArrayList<KeywordInterface> arrayList2 = Lists.newArrayList();
                    for (SpellAbility sa : state.getSpellAbilities()) {
                        spellAbilities.add(affectedCard.getSpellAbilityForStaticAbilityByText(sa, stAb));
                    }
                    if (params.containsKey("GainTextAbilities")) {
                        for (String ability : params.get("GainTextAbilities").split(" & ")) {
                            spellAbilities.add(affectedCard.getSpellAbilityForStaticAbilityGainedByText(AbilityUtils.getSVar(stAb, ability), stAb));
                        }
                    }
                    for (Trigger tr : state.getTriggers()) {
                        arrayList.add(affectedCard.getTriggerForStaticAbilityByText(tr, stAb));
                    }
                    for (ReplacementEffect re : state.getReplacementEffects()) {
                        replacementEffects.add(affectedCard.getReplacementEffectForStaticAbilityByText(re, stAb));
                    }
                    for (StaticAbility st : state.getStaticAbilities()) {
                        staticAbilities.add(affectedCard.getStaticAbilityForStaticAbilityByText(st, stAb));
                    }
                    long kwIdx = 1L;
                    for (KeywordInterface ki : state.getIntrinsicKeywords()) {
                        arrayList2.add(affectedCard.getKeywordForStaticAbilityByText(ki, stAb, kwIdx));
                        ++kwIdx;
                    }
                    affectedCard.addChangedName(state.getName(), false, se.getTimestamp(), stAb.getId());
                    affectedCard.addChangedManaCost(state.getManaCost(), se.getTimestamp(), stAb.getId());
                    affectedCard.addColorByText(ColorSet.fromMask(state.getColor()), se.getTimestamp(), stAb.getId());
                    affectedCard.addChangedCardTypesByText(new CardType(state.getType()), se.getTimestamp(), stAb.getId());
                    affectedCard.addChangedCardTraitsByText(spellAbilities, arrayList, replacementEffects, staticAbilities, se.getTimestamp(), stAb.getId());
                    affectedCard.addChangedCardKeywordsByText(arrayList2, se.getTimestamp(), stAb.getId(), false);
                    affectedCard.addNewPTByText(state.getBasePower(), state.getBaseToughness(), se.getTimestamp(), stAb.getId());
                }
                if (stAb.hasParam("AddNames")) {
                    affectedCard.addChangedName(null, true, se.getTimestamp(), stAb.getId());
                }
                if (stAb.hasParam("SetName")) {
                    String newName = stAb.getParam("SetName");
                    if (newName.equals("ChosenName")) {
                        newName = hostCard.getNamedCard();
                    }
                    if (!newName.isEmpty()) {
                        affectedCard.addChangedName(newName, false, se.getTimestamp(), stAb.getId());
                    }
                }
                if (params.containsKey("ChangeColorWordsTo")) {
                    String changeColorWordsTo = params.get("ChangeColorWordsTo");
                    byte color = changeColorWordsTo.equals("ChosenColor") ? (hostCard.hasChosenColor() ? MagicColor.fromName(Iterables.getFirst(hostCard.getChosenColors(), null)) : (byte)0) : MagicColor.fromName(changeColorWordsTo);
                    if (color != 0) {
                        String colorName = MagicColor.toLongString(color);
                        affectedCard.addChangedTextColorWord(stAb.getParamOrDefault("ChangeColorWordsFrom", "Any"), colorName, se.getTimestamp(), stAb.getId());
                    }
                }
            }
            if (!(layer != StaticAbilityLayer.SETPT && layer != StaticAbilityLayer.CHARACTERISTIC || setPower == null && setToughness == null)) {
                if (setP.contains("Affected")) {
                    setPower = AbilityUtils.calculateAmount(affectedCard, setP, stAb, true);
                }
                if (setT.contains("Affected")) {
                    setToughness = AbilityUtils.calculateAmount(affectedCard, setT, stAb, true);
                }
                affectedCard.addNewPT(setPower, setToughness, se.getTimestamp(), stAb.getId(), layer == StaticAbilityLayer.CHARACTERISTIC);
            }
            if (layer == StaticAbilityLayer.MODIFYPT) {
                if (addP.contains("Affected")) {
                    powerBonus = AbilityUtils.calculateAmount(affectedCard, addP, stAb, true);
                }
                if (addT.contains("Affected")) {
                    toughnessBonus = AbilityUtils.calculateAmount(affectedCard, addT, stAb, true);
                }
                affectedCard.addPTBoost(powerBonus, toughnessBonus, se.getTimestamp(), stAb.getId());
            }
            if (addKeywords != null && !addKeywords.isEmpty() || removeKeywords != null || removeAllAbilities) {
                List<String> newKeywords = null;
                if (addKeywords != null) {
                    newKeywords = Lists.newArrayList(addKeywords);
                    String[] extraKeywords = Lists.newArrayList();
                    Iterables.removeIf(newKeywords, arg_0 -> StaticAbilityContinuous.lambda$applyContinuousAbility$5(affectedCard, (List)extraKeywords, arg_0));
                    newKeywords.addAll((Collection<String>)extraKeywords);
                    newKeywords = Lists.transform(newKeywords, input -> {
                        int reduced = 0;
                        if (stAb.hasParam("ReduceCost")) {
                            reduced = AbilityUtils.calculateAmount(hostCard, stAb.getParam("ReduceCost"), stAb);
                        }
                        if (input.contains("CardManaCost")) {
                            ManaCost cost;
                            if (reduced > 0) {
                                ManaCostBeingPaid mcbp = new ManaCostBeingPaid(affectedCard.getManaCost());
                                mcbp.decreaseGenericMana(reduced);
                                cost = mcbp.toManaCost();
                            } else {
                                cost = affectedCard.getManaCost();
                            }
                            input = input.replace("CardManaCost", cost.getShortString());
                        } else if (input.contains("ConvertedManaCost")) {
                            String costcmc = Integer.toString(affectedCard.getCMC());
                            input = input.replace("ConvertedManaCost", costcmc);
                        }
                        return input;
                    });
                }
                affectedCard.addChangedCardKeywords(newKeywords, removeKeywords, removeAllAbilities, se.getTimestamp(), stAb, true);
            }
            if (!addHiddenKeywords.isEmpty()) {
                affectedCard.addHiddenExtrinsicKeywords(se.getTimestamp(), stAb.getId(), addHiddenKeywords);
            }
            if (addSVars != null) {
                HashMap<String, String> map = Maps.newHashMap();
                for (String string : addSVars) {
                    String actualSVar = AbilityUtils.getSVar(stAb, string);
                    String name = string;
                    if (actualSVar.startsWith("SVar:")) {
                        actualSVar = actualSVar.split("SVar:")[1];
                        name = actualSVar.split(":")[0];
                        actualSVar = actualSVar.split(":")[1];
                    }
                    map.put(name, actualSVar);
                }
                affectedCard.addChangedSVars(map, se.getTimestamp(), stAb.getId());
            }
            if (layer == StaticAbilityLayer.ABILITIES) {
                ArrayList<SpellAbility> addedAbilities = Lists.newArrayList();
                ArrayList<ReplacementEffect> addedReplacementEffects = Lists.newArrayList();
                ArrayList<Trigger> addedTrigger = Lists.newArrayList();
                ArrayList<StaticAbility> addedStaticAbility = Lists.newArrayList();
                if (addAbilities != null) {
                    for (String string : addAbilities) {
                        void var51_104;
                        if (string.contains("CardManaCost")) {
                            String string2 = TextUtil.fastReplace(string, "CardManaCost", affectedCard.getManaCost().getShortString());
                        } else if (string.contains("ConvertedManaCost")) {
                            String costcmc = Integer.toString(affectedCard.getCMC());
                            String string3 = TextUtil.fastReplace(string, "ConvertedManaCost", costcmc);
                        }
                        if (!var51_104.startsWith("AB") && !var51_104.startsWith("ST")) continue;
                        addedAbilities.add(affectedCard.getSpellAbilityForStaticAbility((String)var51_104, stAb));
                    }
                }
                if (params.containsKey("GainsAbilitiesOf") || params.containsKey("GainsAbilitiesOfDefined")) {
                    CardCollection cardCollection = StaticAbilityContinuous.cardsGainedFrom(params.containsKey("GainsAbilitiesOfDefined") ? "GainsAbilitiesOfDefined" : "GainsAbilitiesOf", params, hostCard, stAb, game);
                    for (Card c : cardCollection) {
                        for (SpellAbility sa : c.getSpellAbilities()) {
                            if (!sa.isActivatedAbility() || !stAb.matchesValidParam("GainsValidAbilities", sa)) continue;
                            SpellAbility newSA = sa.copy(affectedCard, sa.getActivatingPlayer(), false, true);
                            if (params.containsKey("GainsAbilitiesLimitPerTurn")) {
                                newSA.setRestrictions(sa.getRestrictions());
                                newSA.getRestrictions().setLimitToCheck(params.get("GainsAbilitiesLimitPerTurn"));
                            }
                            newSA.setOriginalAbility(sa);
                            newSA.setGrantorStatic(stAb);
                            newSA.setIntrinsic(false);
                            addedAbilities.add(newSA);
                        }
                    }
                }
                if (addReplacements != null) {
                    for (String string : addReplacements) {
                        addedReplacementEffects.add(affectedCard.getReplacementEffectForStaticAbility(string, stAb));
                    }
                }
                if (addTriggers != null) {
                    for (String string : addTriggers) {
                        Trigger actualTrigger = affectedCard.getTriggerForStaticAbility(string, stAb);
                        addedTrigger.add(actualTrigger);
                    }
                }
                if (params.containsKey("GainsTriggerAbsOf")) {
                    CardCollection cardCollection = StaticAbilityContinuous.cardsGainedFrom("GainsTriggerAbsOf", params, hostCard, stAb, game);
                    for (Card c : cardCollection) {
                        for (Trigger trig : c.getTriggers()) {
                            Trigger newTrigger = affectedCard.addTriggerForStaticAbility(trig, stAb);
                            addedTrigger.add(newTrigger);
                        }
                    }
                }
                if (addStatics != null) {
                    for (String string : addStatics) {
                        void var51_111;
                        if (string.contains("ConvertedManaCost")) {
                            String costcmc = Integer.toString(affectedCard.getCMC());
                            String string4 = TextUtil.fastReplace(string, "ConvertedManaCost", costcmc);
                        }
                        addedStaticAbility.add(affectedCard.getStaticAbilityForStaticAbility((String)var51_111, stAb));
                    }
                }
                if (!addedAbilities.isEmpty() || !addedTrigger.isEmpty() || addReplacements != null || addStatics != null || removeAllAbilities) {
                    affectedCard.addChangedCardTraits(addedAbilities, null, addedTrigger, addedReplacementEffects, addedStaticAbility, removeAllAbilities, removeNonMana, se.getTimestamp(), stAb.getId());
                }
                if (cantHaveKeyword != null) {
                    affectedCard.addCantHaveKeyword(se.getTimestamp(), cantHaveKeyword);
                }
            }
            if (addTypes != null && !addTypes.isEmpty() || removeTypes != null && !removeTypes.isEmpty() || addAllCreatureTypes || !remove.isEmpty()) {
                affectedCard.addChangedCardTypes(addTypes, removeTypes, addAllCreatureTypes, remove, se.getTimestamp(), (long)stAb.getId(), true, stAb.hasParam("CharacteristicDefining"));
            }
            if (addColors != null) {
                affectedCard.addColor(addColors, !overwriteColors, se.getTimestamp(), stAb.getId(), stAb.hasParam("CharacteristicDefining"));
            }
            if (layer == StaticAbilityLayer.RULES) {
                if (params.containsKey("Goad")) {
                    affectedCard.addGoad(se.getTimestamp(), hostCard.getController());
                }
                if (params.containsKey("CanBlockAny")) {
                    affectedCard.addCanBlockAny(se.getTimestamp());
                }
                if (params.containsKey("CanBlockAmount")) {
                    int v = AbilityUtils.calculateAmount(hostCard, params.get("CanBlockAmount"), stAb, true);
                    affectedCard.addCanBlockAdditional(v, se.getTimestamp());
                }
            }
            if (!(mayLookAt == null || affectedCard.getOwner().getTopXCardsFromLibrary(1).contains(affectedCard) && game.getTopLibForPlayer(affectedCard.getOwner()) != null && game.getTopLibForPlayer(affectedCard.getOwner()) != affectedCard)) {
                affectedCard.addMayLookAt(se.getTimestamp(), mayLookAt);
            }
            if (!controllerMayPlay || mayPlayLimit != null && stAb.getMayPlayTurn() >= mayPlayLimit) continue;
            String mayPlayAltCost = mayPlayAltManaCost;
            if (mayPlayAltCost != null && mayPlayAltCost.contains("ConvertedManaCost")) {
                String costcmc = Integer.toString(affectedCard.getCMC());
                mayPlayAltCost = mayPlayAltCost.replace("ConvertedManaCost", costcmc);
            }
            Player mayPlayController = params.containsKey("MayPlayPlayer") ? (Player)AbilityUtils.getDefinedPlayers(affectedCard, params.get("MayPlayPlayer"), stAb).get(false) : controller;
            affectedCard.setMayPlay(mayPlayController, mayPlayWithoutManaCost, mayPlayAltCost != null ? new Cost(mayPlayAltCost, false, affectedCard.equals(hostCard)) : null, mayPlayWithFlash, mayPlayGrantZonePermissions, stAb);
            if (!stAb.hasParam("Affected") || !stAb.getParam("Affected").equals("Card.Self") || !affectedCard.isInZone(ZoneType.Graveyard)) continue;
            for (Player p : game.getPlayers()) {
                if (!p.hasKeyword("Shaman's Trance") || mayPlayController == p) continue;
                affectedCard.setMayPlay(p, mayPlayWithoutManaCost, mayPlayAltCost != null ? new Cost(mayPlayAltCost, false) : null, mayPlayWithFlash, mayPlayGrantZonePermissions, stAb);
            }
        }
        return affectedCards;
    }

    private static void buildIgnorEffectAbility(final StaticAbility stAb, String costString, List<Player> players, final CardCollectionView cards) {
        final ArrayList<Player> validActivator = new ArrayList<Player>(players);
        for (Card c : cards) {
            validActivator.add(c.getController());
        }
        final Card sourceCard = stAb.getHostCard();
        Cost cost = new Cost(costString, true);
        AbilityStatic addIgnore = new AbilityStatic(sourceCard, cost, null){

            @Override
            public void resolve() {
                stAb.addIgnoreEffectPlayers(this.getActivatingPlayer());
                stAb.setIgnoreEffectCards(cards);
            }

            @Override
            public boolean canPlay() {
                return validActivator.contains(this.getActivatingPlayer()) && sourceCard.isInPlay();
            }
        };
        addIgnore.setIntrinsic(false);
        addIgnore.setApi(ApiType.InternalIgnoreEffect);
        addIgnore.setDescription(cost + " Ignore the effect until end of turn.");
        sourceCard.addChangedCardTraits(ImmutableList.of(addIgnore), null, null, null, null, false, false, sourceCard.getLayerTimestamp(), stAb.getId());
        GameCommand removeIgnore = new GameCommand(){
            private static final long serialVersionUID = -5415775215053216360L;

            @Override
            public void run() {
                stAb.clearIgnoreEffects();
            }
        };
        sourceCard.getGame().getEndOfTurn().addUntil(removeIgnore);
        sourceCard.addLeavesPlayCommand(removeIgnore);
    }

    private static CardCollection cardsGainedFrom(String param, Map<String, String> params, Card hostCard, StaticAbility stAb, Game game) {
        CardCollection cards = new CardCollection();
        if (param.contains("Defined")) {
            cards.addAll(AbilityUtils.getDefinedCards(hostCard, params.get(param), stAb));
        } else {
            String[] valids = params.get(param).split(",");
            List<ZoneType> validZones = params.containsKey("GainsAbilitiesOfZones") ? ZoneType.listValueOf(params.get("GainsAbilitiesOfZones")) : ImmutableList.of(ZoneType.Battlefield);
            cards.addAll(CardLists.getValidCards((Iterable<Card>)game.getCardsIn(validZones), valids, hostCard.getController(), hostCard, (CardTraitBase)stAb));
        }
        return cards;
    }

    private static List<Player> getAffectedPlayers(StaticAbility stAb) {
        Map<String, String> params = stAb.getMapParams();
        Card hostCard = stAb.getHostCard();
        Player controller = hostCard.getController();
        ArrayList<Player> players = new ArrayList<Player>();
        if (!params.containsKey("Affected")) {
            return players;
        }
        String[] strngs = params.get("Affected").split(",");
        for (Player p : controller.getGame().getPlayersInTurnOrder()) {
            if (!p.isValid(strngs, controller, hostCard, (CardTraitBase)stAb)) continue;
            players.add(p);
        }
        players.removeAll(stAb.getIgnoreEffectPlayers());
        return players;
    }

    private static CardCollectionView getAffectedCards(StaticAbility stAb, CardCollectionView preList) {
        Card hostCard = stAb.getHostCard();
        Game game = hostCard.getGame();
        Player controller = hostCard.getController();
        if (stAb.hasParam("CharacteristicDefining")) {
            if (stAb.hasParam("ExcludeZone")) {
                for (ZoneType zt : ZoneType.listValueOf(stAb.getParam("ExcludeZone"))) {
                    if (!hostCard.isInZone(zt)) continue;
                    return CardCollection.EMPTY;
                }
            }
            return new CardCollection(hostCard);
        }
        CardCollection affectedCards = new CardCollection();
        if (!preList.isEmpty()) {
            if (stAb.hasParam("AffectedZone")) {
                affectedCards.addAll(CardLists.filter((Iterable<Card>)preList, CardPredicates.inZone(ZoneType.listValueOf(stAb.getParam("AffectedZone")))));
            } else {
                affectedCards.addAll(CardLists.filter((Iterable<Card>)preList, CardPredicates.inZone(ZoneType.Battlefield)));
            }
        }
        if (stAb.hasParam("AffectedZone")) {
            affectedCards.addAll(game.getCardsIn(ZoneType.listValueOf(stAb.getParam("AffectedZone"))));
        } else {
            affectedCards.addAll(game.getCardsIn(ZoneType.Battlefield));
        }
        if (stAb.hasParam("Affected")) {
            CardCollection affectedCardsOriginal = null;
            if (controller.hasKeyword("Shaman's Trance") && stAb.hasParam("MayPlay")) {
                affectedCardsOriginal = new CardCollection(affectedCards);
            }
            affectedCards = CardLists.getValidCards((Iterable<Card>)affectedCards, stAb.getParam("Affected"), controller, hostCard, (CardTraitBase)stAb);
            if (affectedCardsOriginal != null) {
                String affectedParam = stAb.getParam("Affected");
                affectedParam = affectedParam.replaceAll("[\\.\\+]YouOwn", "");
                affectedParam = affectedParam.replaceAll("[\\.\\+]YouCtrl", "");
                String[] restrictions = affectedParam.split(",");
                for (Card card : affectedCardsOriginal) {
                    if (!card.isInZone(ZoneType.Graveyard) || card.getController() == controller || !card.isValid(restrictions, controller, hostCard, (CardTraitBase)stAb)) continue;
                    affectedCards.add(card);
                }
            }
        }
        affectedCards.removeAll(stAb.getIgnoreEffectCards());
        return affectedCards;
    }

    private static /* synthetic */ boolean lambda$applyContinuousAbility$5(Card affectedCard, List extraKeywords, String input) {
        if (input.contains("CardManaCost") && affectedCard.getManaCost().isNoCost()) {
            return true;
        }
        if (input.startsWith("Protection") && input.contains("CardColors")) {
            for (Byte color : affectedCard.getColor()) {
                extraKeywords.add(input.replace("CardColors", MagicColor.toLongString(color)));
            }
            return true;
        }
        return false;
    }
}

