/*
 * Decompiled with CFR 0.152.
 */
package forge.game.staticability;

import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCanAttackDefender;
import forge.game.staticability.StaticAbilityIgnoreLandwalk;
import forge.game.zone.ZoneType;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class StaticAbilityCantAttackBlock {
    public static String CantAttackMode = "CantAttack";
    public static String CantBlockByMode = "CantBlockBy";
    public static String CanAttackIfHasteMode = "CanAttackIfHaste";
    public static String CanBlockIfReachMode = "CanBlockIfReach";
    public static String MinMaxBlockerMode = "MinMaxBlocker";

    public static boolean cantAttack(Card attacker, GameEntity defender) {
        if (attacker.hasKeyword("CARDNAME can't attack.") || attacker.hasKeyword("CARDNAME can't attack or block.")) {
            return true;
        }
        for (Card ca : attacker.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CantAttackMode) || !StaticAbilityCantAttackBlock.applyCantAttackAbility(stAb, attacker, defender)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantAttackAbility(StaticAbility stAb, Card card, GameEntity target) {
        CardCollectionView list;
        String type;
        Card c;
        Card hostCard = stAb.getHostCard();
        Game game = hostCard.getGame();
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        if (!stAb.matchesValidParam("Target", target)) {
            return false;
        }
        if (stAb.isKeyword(Keyword.DEFENDER) && StaticAbilityCanAttackDefender.canAttack(card, target)) {
            return false;
        }
        Player defender = target instanceof Player ? (Player)target : ((c = (Card)target).isBattle() ? c.getProtectingPlayer() : c.getController());
        if (stAb.hasParam("UnlessDefenderControls")) {
            type = stAb.getParam("UnlessDefenderControls");
            list = defender.getCardsIn(ZoneType.Battlefield);
            if (Iterables.any(list, CardPredicates.restriction(type.split(","), hostCard.getController(), hostCard, (CardTraitBase)stAb))) {
                return false;
            }
        }
        if (stAb.hasParam("IfDefenderControls")) {
            type = stAb.getParam("IfDefenderControls");
            list = defender.getCardsIn(ZoneType.Battlefield);
            if (!Iterables.any(list, CardPredicates.restriction(type.split(","), hostCard.getController(), hostCard, (CardTraitBase)stAb))) {
                return false;
            }
        }
        if (stAb.hasParam("DefenderNotNearestToYouInChosenDirection")) {
            if (hostCard.getChosenDirection() == null) {
                return false;
            }
            if (target instanceof Card && ((Card)target).isBattle()) {
                return false;
            }
            Player next = card.getController();
            while (!next.isOpponentOf(card.getController())) {
                next = game.getNextPlayerAfter(next, hostCard.getChosenDirection());
            }
            if (defender.equals(next)) {
                return false;
            }
        }
        return !stAb.hasParam("UnlessDefender") || !defender.hasProperty(type = stAb.getParam("UnlessDefender"), hostCard.getController(), hostCard, stAb);
    }

    public static boolean cantBlockBy(Card attacker, Card blocker) {
        CardCollection list = new CardCollection(attacker.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES));
        list.add(attacker);
        if (blocker != null) {
            list.add(blocker);
        }
        for (Card ca : list) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CantBlockByMode) || !StaticAbilityCantAttackBlock.applyCantBlockByAbility(stAb, attacker, blocker)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCantBlockByAbility(StaticAbility stAb, Card attacker, Card blocker) {
        Card host = stAb.getHostCard();
        if (!stAb.matchesValidParam("ValidAttacker", attacker)) {
            return false;
        }
        if (stAb.hasParam("ValidBlocker")) {
            boolean stillblock = true;
            for (String v : stAb.getParam("ValidBlocker").split(",")) {
                if (blocker == null || !blocker.isValid(v, host.getController(), host, (CardTraitBase)stAb)) continue;
                stillblock = false;
                if (v.contains("withoutReach") && StaticAbilityCantAttackBlock.canBlockIfReach(attacker, blocker)) {
                    stillblock = true;
                }
                if (!stillblock) break;
            }
            if (stillblock) {
                return false;
            }
        }
        if (!stAb.matchesValidParam("ValidAttackerRelative", attacker, blocker)) {
            return false;
        }
        if (!stAb.matchesValidParam("ValidBlockerRelative", blocker, attacker)) {
            return false;
        }
        if (blocker == null || !stAb.matchesValidParam("ValidDefender", blocker.getController())) {
            return false;
        }
        return !stAb.isKeyword(Keyword.LANDWALK) || !StaticAbilityIgnoreLandwalk.ignoreLandWalk(attacker, blocker, stAb.getKeyword());
    }

    public static boolean canBlockIfReach(Card attacker, Card blocker) {
        for (Card ca : attacker.getGame().getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CanBlockIfReachMode) || !StaticAbilityCantAttackBlock.applyCanBlockIfReachAbility(stAb, attacker, blocker)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCanBlockIfReachAbility(StaticAbility stAb, Card attacker, Card blocker) {
        if (!stAb.matchesValidParam("ValidAttacker", attacker)) {
            return false;
        }
        return stAb.matchesValidParam("ValidBlocker", blocker);
    }

    public static Cost getAttackCost(StaticAbility stAb, Card attacker, GameEntity target) {
        Card hostCard = stAb.getHostCard();
        if (!stAb.matchesValidParam("ValidCard", attacker)) {
            return null;
        }
        if (!stAb.matchesValidParam("Target", target)) {
            return null;
        }
        String costString = stAb.getParam("Cost");
        if (stAb.hasSVar(costString)) {
            boolean remember = stAb.hasParam("RememberingAttacker");
            if (remember) {
                hostCard.addRemembered(attacker);
            }
            boolean addX = costString.startsWith("X");
            costString = Integer.toString(AbilityUtils.calculateAmount(hostCard, stAb.getSVar(costString), stAb));
            if (addX) {
                costString = costString + " X";
            }
            if (remember) {
                hostCard.removeRemembered(attacker);
            }
        }
        Cost cost = new Cost(costString, true);
        if (stAb.hasParam("Trigger")) {
            cost.getCostParts().get(0).setTrigger(stAb.getPayingTrigSA());
        }
        return cost;
    }

    public static Cost getBlockCost(StaticAbility stAb, Card blocker, GameEntity attacker) {
        Card hostCard = stAb.getHostCard();
        if (!stAb.matchesValidParam("ValidCard", blocker)) {
            return null;
        }
        if (!stAb.matchesValidParam("Attacker", attacker)) {
            return null;
        }
        String costString = stAb.getParam("Cost");
        if (stAb.hasSVar(costString)) {
            boolean addX = costString.startsWith("X");
            costString = Integer.toString(AbilityUtils.calculateAmount(hostCard, stAb.getSVar(costString), stAb));
            if (addX) {
                costString = costString + " X";
            }
        }
        return new Cost(costString, true);
    }

    public static boolean canAttackHaste(Card attacker, GameEntity defender) {
        Game game = attacker.getGame();
        if (!attacker.isSick()) {
            return true;
        }
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(CanAttackIfHasteMode) || !StaticAbilityCantAttackBlock.applyCanAttackHasteAbility(stAb, attacker, defender)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean applyCanAttackHasteAbility(StaticAbility stAb, Card card, GameEntity target) {
        if (!stAb.matchesValidParam("ValidCard", card)) {
            return false;
        }
        return stAb.matchesValidParam("ValidTarget", target);
    }

    public static Pair<Integer, Integer> getMinMaxBlocker(Card attacker, Player defender) {
        MutablePair<Integer, Integer> result = MutablePair.of(1, Integer.MAX_VALUE);
        if (attacker.hasKeyword(Keyword.MENACE)) {
            result.setLeft(2);
        }
        Game game = attacker.getGame();
        for (Card ca : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : ca.getStaticAbilities()) {
                if (!stAb.checkConditions(MinMaxBlockerMode)) continue;
                StaticAbilityCantAttackBlock.applyMinMaxBlockerAbility(stAb, attacker, defender, result);
            }
        }
        return result;
    }

    public static void applyMinMaxBlockerAbility(StaticAbility stAb, Card attacker, Player defender, MutablePair<Integer, Integer> result) {
        if (!stAb.matchesValidParam("ValidCard", attacker)) {
            return;
        }
        if (stAb.hasParam("Min")) {
            if ("All".equals(stAb.getParam("Min"))) {
                if (defender != null) {
                    result.setLeft(defender.getCreaturesInPlay().size());
                }
            } else {
                result.setLeft(AbilityUtils.calculateAmount(stAb.getHostCard(), stAb.getParam("Min"), stAb));
            }
        }
        if (stAb.hasParam("Max")) {
            result.setRight(AbilityUtils.calculateAmount(stAb.getHostCard(), stAb.getParam("Max"), stAb));
        }
    }
}

