/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.Sets;
import forge.game.GameObject;
import forge.game.IIdentifiable;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.card.IHasCardView;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.StackItemView;
import forge.game.spellability.TargetChoices;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.util.TextUtil;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;

public class SpellAbilityStackInstance
implements IIdentifiable,
IHasCardView {
    private static int maxId = 0;
    private final int id;
    private final SpellAbility ability;
    private final SpellAbilityStackInstance subInstance;
    private String stackDescription = null;
    private final StackItemView view;

    public static int nextId() {
        return ++maxId;
    }

    public SpellAbilityStackInstance(SpellAbility sa) {
        this(sa, SpellAbilityStackInstance.nextId());
    }

    public SpellAbilityStackInstance(SpellAbility sa, int assignedId) {
        this.id = assignedId;
        this.ability = sa;
        this.stackDescription = sa.getStackDescription();
        this.subInstance = this.ability.getSubAbility() == null ? null : new SpellAbilityStackInstance(this.ability.getSubAbility());
        Map<String, String> sVars = (this.ability.isWrapper() ? ((WrappedAbility)this.ability).getWrappedAbility() : this.ability).getDirectSVars();
        if (ApiType.SetState == sa.getApi() && !sVars.containsKey("StoredTransform")) {
            sVars.put("StoredTransform", String.valueOf(this.ability.getHostCard().getTransformedTimestamp()));
        }
        if (sa.getApi() == ApiType.Charm && sa.hasParam("ChoiceRestriction")) {
            sa.getHostCard().addChosenModes(sa, sa.getSubAbility().getDescription(), sa.getHostCard().getGame().getPhaseHandler().inCombat());
        }
        this.view = new StackItemView(this);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public final SpellAbility getSpellAbility() {
        return this.ability;
    }

    public final String getStackDescription() {
        return this.stackDescription.replaceAll("\\\\r\\\\n", "").replaceAll("\\.\u2022", ";").replaceAll("\u2022", "");
    }

    public final Card getSourceCard() {
        return this.ability.getHostCard();
    }

    public final boolean isSpell() {
        return this.ability.isSpell();
    }

    public final boolean isAbility() {
        return this.ability.isAbility();
    }

    public final boolean isTrigger() {
        return this.ability.isTrigger();
    }

    public final boolean isStateTrigger(int id) {
        return this.ability.getSourceTrigger() == id;
    }

    public final boolean isOptionalTrigger() {
        return this.ability.isOptionalTrigger();
    }

    public final SpellAbilityStackInstance getSubInstance() {
        return this.subInstance;
    }

    public final TargetChoices getTargetChoices() {
        return this.ability.getTargets();
    }

    public void updateTarget(TargetChoices target, Card cause) {
        if (target != null) {
            TargetChoices oldTarget = this.ability.getTargets();
            this.ability.setTargets(target);
            this.stackDescription = this.ability.getStackDescription();
            this.view.updateTargetCards(this);
            this.view.updateTargetPlayers(this);
            this.view.updateText(this);
            HashSet<GameObject> distinctObjects = Sets.newHashSet();
            for (GameObject tgt : target) {
                if (oldTarget != null && oldTarget.contains(tgt) || !distinctObjects.add(tgt)) continue;
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                runParams.put(AbilityKey.SourceSA, this.ability);
                if (tgt instanceof Card && !((Card)tgt).hasBecomeTargetThisTurn()) {
                    runParams.put(AbilityKey.FirstTime, null);
                    ((Card)tgt).setBecameTargetThisTurn(true);
                }
                if (tgt instanceof Card && !((Card)tgt).isValiant() && cause.getController().equals(((Card)tgt).getController())) {
                    runParams.put(AbilityKey.Valiant, null);
                    ((Card)tgt).setValiant(true);
                }
                runParams.put(AbilityKey.Target, tgt);
                this.getSourceCard().getGame().getTriggerHandler().runTrigger(TriggerType.BecomesTarget, runParams, false);
            }
            if (!distinctObjects.isEmpty()) {
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                runParams.put(AbilityKey.SourceSA, this.ability);
                runParams.put(AbilityKey.Targets, distinctObjects);
                runParams.put(AbilityKey.Cause, cause);
                this.getSourceCard().getGame().getTriggerHandler().runTrigger(TriggerType.BecomesTargetOnce, runParams, false);
            }
        }
    }

    public boolean addTriggeringObject(AbilityKey trigObj, Object value) {
        if (!this.ability.hasTriggeringObject(trigObj)) {
            this.ability.setTriggeringObject(trigObj, value);
            return true;
        }
        return false;
    }

    public boolean updateTriggeringObject(AbilityKey trigObj, Object value) {
        if (this.ability.hasTriggeringObject(trigObj)) {
            this.ability.setTriggeringObject(trigObj, value);
            return true;
        }
        return false;
    }

    public Object getTriggeringObject(AbilityKey trigObj) {
        return this.ability.getTriggeringObject(trigObj);
    }

    public Player getActivatingPlayer() {
        return this.ability.getActivatingPlayer();
    }

    public void setActivatingPlayer(Player activatingPlayer0) {
        this.ability.setActivatingPlayer(activatingPlayer0);
        this.view.updateActivatingPlayer(this);
        if (this.subInstance != null) {
            this.subInstance.setActivatingPlayer(activatingPlayer0);
        }
    }

    public String toString() {
        return TextUtil.concatNoSpace(this.getSourceCard().toString(), "->", this.getStackDescription());
    }

    public StackItemView getView() {
        return this.view;
    }

    @Override
    public CardView getCardView() {
        return CardView.get(this.getSourceCard());
    }
}

