/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import forge.GameCommand;
import forge.card.CardStateName;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.game.CardTraitBase;
import forge.game.ForgeScript;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameObject;
import forge.game.IHasSVars;
import forge.game.IIdentifiable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardDamageMap;
import forge.game.card.CardFactory;
import forge.game.card.CardPlayOption;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.CostSacrifice;
import forge.game.cost.CostTap;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.Mana;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.Untap;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.AbilityStatic;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.AlternativeCost;
import forge.game.spellability.ISpellAbility;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.SpellAbilityCondition;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.spellability.SpellAbilityView;
import forge.game.spellability.TargetChoices;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCastWithFlash;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class SpellAbility
extends CardTraitBase
implements ISpellAbility,
IIdentifiable,
Comparable<SpellAbility> {
    private static int maxId = 0;
    private int id;
    private String originalDescription = "";
    private String description = "";
    private String originalStackDescription = "";
    private String stackDescription = "";
    private Player activatingPlayer;
    private Player targetingPlayer;
    private Player choosingPlayer;
    private Pair<Long, Player> controlledByPlayer;
    private ManaCostBeingPaid manaCostBeingPaid;
    private int spentPhyrexian = 0;
    private int paidLifeAmount = 0;
    private SpellAbility grantorOriginal;
    private StaticAbility grantorStatic;
    private CardCollection splicedCards = null;
    private boolean basicSpell = true;
    private Trigger triggerObj;
    private boolean optionalTrigger = false;
    private ReplacementEffect replacementEffect = null;
    private int sourceTrigger = -1;
    private List<Object> triggerRemembered = Lists.newArrayList();
    private AlternativeCost altCost = null;
    private EnumSet<OptionalCost> optionalCosts = EnumSet.noneOf(OptionalCost.class);
    private Table<Keyword, Pair<Long, Long>, Integer> optionalKeywordAmount = HashBasedTable.create();
    private boolean aftermath = false;
    private Cost payCosts;
    private SpellAbilityRestriction restrictions;
    private SpellAbilityCondition conditions = new SpellAbilityCondition();
    private AbilitySub subAbility;
    private Map<String, SpellAbility> additionalAbilities = Maps.newHashMap();
    private Map<String, List<AbilitySub>> additionalAbilityLists = Maps.newHashMap();
    protected ApiType api = null;
    private List<Mana> payingMana = Lists.newArrayList();
    private List<SpellAbility> paidAbilities = Lists.newArrayList();
    private Integer xManaCostPaid = null;
    private TreeBasedTable<String, Boolean, CardCollection> paidLists = TreeBasedTable.create();
    private EnumMap<AbilityKey, Object> triggeringObjects = AbilityKey.newMap();
    private EnumMap<AbilityKey, Object> replacingObjects = AbilityKey.newMap();
    private final List<String> pipsToReduce = new ArrayList<String>();
    private List<AbilitySub> chosenList = null;
    private CardCollection tappedForConvoke = new CardCollection();
    private Card sacrificedAsOffering;
    private Card sacrificedAsEmerge;
    private AbilityManaPart manaPart;
    private boolean undoable;
    private boolean isCopied = false;
    private boolean mayChooseNewTargets = false;
    private boolean isCastFromPlayEffect = false;
    private TargetRestrictions targetRestrictions;
    private TargetChoices targetChosen = new TargetChoices();
    private Integer dividedValue = null;
    private SpellAbilityView view;
    private CardPlayOption mayPlay;
    private CardCollection lastStateBattlefield;
    private CardCollection lastStateGraveyard;
    private CardCollection rollbackEffects = new CardCollection();
    private CardDamageMap damageMap;
    private CardDamageMap preventMap;
    private GameEntityCounterTable counterTable;
    private CardZoneTable changeZoneTable;
    private Map<Player, Integer> loseLifeMap;

    private static int nextId() {
        return ++maxId;
    }

    public CardCollection getLastStateBattlefield() {
        return this.lastStateBattlefield;
    }

    public void setLastStateBattlefield(CardCollectionView lastStateBattlefield) {
        this.lastStateBattlefield = new CardCollection(lastStateBattlefield);
    }

    public CardCollection getLastStateGraveyard() {
        return this.lastStateGraveyard;
    }

    public void setLastStateGraveyard(CardCollectionView lastStateGraveyard) {
        this.lastStateGraveyard = new CardCollection(lastStateGraveyard);
    }

    public void clearLastState() {
        this.lastStateBattlefield = null;
        this.lastStateGraveyard = null;
    }

    protected SpellAbility(Card iSourceCard, Cost toPay) {
        this(iSourceCard, toPay, null);
    }

    protected SpellAbility(Card iSourceCard, Cost toPay, SpellAbilityView view0) {
        this.id = SpellAbility.nextId();
        this.hostCard = iSourceCard;
        this.payCosts = toPay;
        if (view0 == null) {
            view0 = new SpellAbilityView(this);
        }
        this.view = view0;
        if (!(this instanceof AbilitySub)) {
            this.restrictions = new SpellAbilityRestriction();
        }
    }

    @Override
    public final int getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(SpellAbility.class, this.getId());
    }

    public boolean equals(Object obj) {
        return obj instanceof SpellAbility && this.id == ((SpellAbility)obj).id;
    }

    @Override
    public void setHostCard(Card c) {
        if (this.hostCard == c) {
            return;
        }
        super.setHostCard(c);
        if (this.manaPart != null) {
            this.manaPart.setSourceCard(c);
        }
        if (this.subAbility != null) {
            this.subAbility.setHostCard(c);
        }
        for (SpellAbility spellAbility : this.additionalAbilities.values()) {
            if (spellAbility.getHostCard() == c) continue;
            spellAbility.setHostCard(c);
        }
        for (List list : this.additionalAbilityLists.values()) {
            for (AbilitySub sa : list) {
                if (sa.getHostCard() == c) continue;
                sa.setHostCard(c);
            }
        }
        this.view.updateHostCard(this);
        this.view.updateDescription(this);
    }

    @Override
    public void setKeyword(KeywordInterface kw) {
        super.setKeyword(kw);
        if (this.subAbility != null) {
            this.subAbility.setKeyword(kw);
        }
        for (SpellAbility spellAbility : this.additionalAbilities.values()) {
            spellAbility.setKeyword(kw);
        }
        for (List list : this.additionalAbilityLists.values()) {
            for (AbilitySub sa : list) {
                sa.setKeyword(kw);
            }
        }
    }

    public boolean canThisProduce(String s2) {
        AbilityManaPart mp = this.getManaPart();
        return mp != null && this.metConditions() && mp.canProduce(s2, this);
    }

    public boolean canProduce(String s2) {
        if (this.canThisProduce(s2)) {
            return true;
        }
        return this.subAbility != null && this.subAbility.canProduce(s2);
    }

    public boolean isManaAbilityFor(SpellAbility saPaidFor, byte colorNeeded) {
        AbilityManaPart mp;
        if (this.getParent() == null) {
            if (!this.canPlay()) {
                return false;
            }
            if (this.isAbility() && this.getRestrictions().isInstantSpeed()) {
                return false;
            }
        }
        if ((mp = this.getManaPart()) != null && this.metConditions() && mp.meetsManaRestrictions(saPaidFor) && mp.abilityProducesManaColor(this, colorNeeded) && saPaidFor.allowsPayingWithShard(mp.getSourceCard(), colorNeeded)) {
            return true;
        }
        return this.subAbility != null && this.subAbility.isManaAbilityFor(saPaidFor, colorNeeded);
    }

    public boolean isManaCannotCounter(SpellAbility saPaidFor) {
        AbilityManaPart mp = this.getManaPart();
        if (mp != null && this.metConditions() && mp.meetsManaRestrictions(saPaidFor) && mp.cannotCounterPaidWith(saPaidFor)) {
            return true;
        }
        return this.subAbility != null && this.subAbility.isManaCannotCounter(saPaidFor);
    }

    public int amountOfManaGenerated(boolean multiply) {
        int result = 0;
        AbilityManaPart mp = this.getManaPart();
        if (mp != null && this.metConditions()) {
            int amount;
            int n = amount = this.hasParam("Amount") ? AbilityUtils.calculateAmount(this.getHostCard(), this.getParam("Amount"), this) : 1;
            result = !multiply || mp.isAnyMana() || mp.isComboMana() || mp.isSpecialMana() ? (result += amount) : (result += mp.mana(this).split(" ").length * amount);
        }
        return result;
    }

    public int totalAmountOfManaGenerated(SpellAbility saPaidFor, boolean multiply) {
        int result = 0;
        AbilityManaPart mp = this.getManaPart();
        if (mp != null && this.metConditions() && mp.meetsManaRestrictions(saPaidFor)) {
            result += this.amountOfManaGenerated(multiply);
        }
        return result += this.subAbility != null ? this.subAbility.totalAmountOfManaGenerated(saPaidFor, multiply) : 0;
    }

    public void setManaExpressChoice(ColorSet cs) {
        AbilityManaPart mp = this.getManaPart();
        if (mp != null) {
            mp.setExpressChoice(cs);
        }
        if (this.subAbility != null) {
            this.subAbility.setManaExpressChoice(cs);
        }
    }

    public final AbilityManaPart getManaPart() {
        return this.manaPart;
    }

    public final List<AbilityManaPart> getAllManaParts() {
        AbilityManaPart mp = this.getManaPart();
        if (mp == null && this.subAbility == null) {
            return ImmutableList.of();
        }
        ArrayList<AbilityManaPart> result = Lists.newArrayList();
        if (mp != null) {
            result.add(mp);
        }
        if (this.subAbility != null) {
            result.addAll(this.subAbility.getAllManaParts());
        }
        return result;
    }

    public final boolean isManaAbility() {
        if (this.isSpell()) {
            return false;
        }
        if (this.usesTargeting()) {
            return false;
        }
        if (this.isPwAbility()) {
            return false;
        }
        if (this.isTrigger() && this.getTrigger().getMode() != TriggerType.TapsForMana && this.getTrigger().getMode() != TriggerType.ManaAdded) {
            return false;
        }
        for (SpellAbility tail = this; tail != null; tail = tail.getSubAbility()) {
            if (tail.manaPart == null) continue;
            return true;
        }
        return false;
    }

    protected final void setManaPart(AbilityManaPart manaPart0) {
        this.manaPart = manaPart0;
    }

    public boolean allowsPayingWithShard(Card src, byte shard) {
        if (!this.hasParam("ManaRestriction")) {
            return true;
        }
        String res = this.getParam("ManaRestriction");
        if (res.equals("None")) {
            return false;
        }
        if (res.equals("ChosenColor")) {
            return this.getHostCard().hasChosenColor() && shard == ManaAtom.fromName(this.getHostCard().getChosenColor());
        }
        return src.isValid(res, null, null, (CardTraitBase)this);
    }

    public abstract boolean canPlay();

    public boolean canPlay(boolean checkOptionalCosts) {
        if (this.canPlay()) {
            return true;
        }
        if (!checkOptionalCosts) {
            return false;
        }
        for (OptionalCostValue val : GameActionUtil.getOptionalCostValues(this)) {
            if (!this.canPlayWithOptionalCost(val)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlayWithOptionalCost(OptionalCostValue opt) {
        return GameActionUtil.addOptionalCosts(this, Lists.newArrayList(opt)).canPlay();
    }

    public boolean isPossible() {
        return this.canPlay();
    }

    public boolean promptIfOnlyPossibleAbility() {
        return false;
    }

    public abstract void resolve();

    public Player getActivatingPlayer() {
        return this.activatingPlayer;
    }

    public void setActivatingPlayer(Player player) {
        this.setActivatingPlayer(player, false);
    }

    public boolean setActivatingPlayer(Player player, boolean lki) {
        boolean updated = false;
        if (player == null || player != this.activatingPlayer) {
            this.activatingPlayer = player;
            updated = true;
        }
        if (this.subAbility != null) {
            updated |= this.subAbility.setActivatingPlayer(player, lki);
        }
        for (SpellAbility spellAbility : this.additionalAbilities.values()) {
            updated |= spellAbility.setActivatingPlayer(player, lki);
        }
        for (List list : this.additionalAbilityLists.values()) {
            for (AbilitySub sa : list) {
                updated |= sa.setActivatingPlayer(player, lki);
            }
        }
        if (!lki && updated) {
            this.view.updateCanPlay(this, false);
        }
        return updated;
    }

    public Player getTargetingPlayer() {
        return this.targetingPlayer;
    }

    public void setTargetingPlayer(Player targetingPlayer0) {
        this.targetingPlayer = targetingPlayer0;
    }

    public Player getChoosingPlayer() {
        return this.choosingPlayer;
    }

    public void setChoosingPlayer(Player choosingPlayer0) {
        this.choosingPlayer = choosingPlayer0;
    }

    public Pair<Long, Player> getControlledByPlayer() {
        return this.controlledByPlayer;
    }

    public void setControlledByPlayer(long ts, Player controller) {
        this.controlledByPlayer = controller != null ? Pair.of(ts, controller) : null;
    }

    public ManaCostBeingPaid getManaCostBeingPaid() {
        return this.manaCostBeingPaid;
    }

    public void setManaCostBeingPaid(ManaCostBeingPaid costBeingPaid) {
        this.manaCostBeingPaid = costBeingPaid;
    }

    public boolean isSpell() {
        return false;
    }

    public boolean isAbility() {
        return true;
    }

    public boolean isActivatedAbility() {
        return false;
    }

    public boolean isLandAbility() {
        return false;
    }

    public boolean isTurnFaceUp() {
        return this.isMorphUp() || this.isDisguiseUp() || this.isManifestUp() || this.isCloakUp();
    }

    public boolean isMorphUp() {
        return this.hasParam("MorphUp");
    }

    public boolean isDisguiseUp() {
        return this.hasParam("DisguiseUp");
    }

    public boolean isCastFaceDown() {
        return false;
    }

    public boolean isManifestUp() {
        return this.hasParam("ManifestUp");
    }

    public boolean isCloakUp() {
        return this.hasParam("CloakUp");
    }

    public boolean isUnlock() {
        return this.hasParam("Unlock");
    }

    public boolean isCycling() {
        return this.isKeyword(Keyword.CYCLING) || this.isKeyword(Keyword.TYPECYCLING);
    }

    public boolean isBackup() {
        return this.isKeyword(Keyword.BACKUP);
    }

    public boolean isBoast() {
        return this.hasParam("Boast");
    }

    public boolean isNinjutsu() {
        return this.isKeyword(Keyword.NINJUTSU);
    }

    public boolean isCumulativeUpkeep() {
        return this.hasParam("CumulativeUpkeep");
    }

    public boolean isEpic() {
        AbilitySub sub;
        for (sub = this.getSubAbility(); sub != null && !sub.hasParam("Epic"); sub = sub.getSubAbility()) {
        }
        return sub != null && sub.hasParam("Epic");
    }

    public ApiType getApi() {
        return this.api;
    }

    public void setApi(ApiType apiType) {
        this.api = apiType;
    }

    public SpellAbility findSubAbilityByType(ApiType apiType) {
        for (AbilitySub sub = this.getSubAbility(); sub != null; sub = sub.getSubAbility()) {
            if (!apiType.equals((Object)sub.getApi())) continue;
            return sub;
        }
        return null;
    }

    public final boolean isCurse() {
        return this.hasParam("IsCurse");
    }

    public final boolean isPwAbility() {
        return this.hasParam("Planeswalker");
    }

    public Cost getPayCosts() {
        return this.payCosts;
    }

    public void setPayCosts(Cost abCost) {
        this.payCosts = abCost;
    }

    public boolean costHasX() {
        return this.getPayCosts().hasXInAnyCostPart();
    }

    public boolean costHasManaX() {
        if (this.getPayCosts().hasNoManaCost()) {
            return false;
        }
        return this.getPayCosts().getCostMana().getAmountOfX() > 0;
    }

    public SpellAbilityRestriction getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(SpellAbilityRestriction restrict) {
        this.restrictions = restrict;
    }

    public int getActivationsThisTurn() {
        return this.getHostCard().getAbilityActivatedThisTurn(this);
    }

    public int getActivationsThisGame() {
        return this.getHostCard().getAbilityActivatedThisGame(this);
    }

    public int getResolvedThisTurn() {
        return this.getHostCard().getAbilityResolvedThisTurn(this);
    }

    public SpellAbilityCondition getConditions() {
        return this.conditions;
    }

    public final void setConditions(SpellAbilityCondition condition) {
        this.conditions = condition;
    }

    public boolean metConditions() {
        return this.getConditions() != null && this.getConditions().areMet(this);
    }

    public List<Mana> getPayingMana() {
        return this.payingMana;
    }

    public void setPayingMana(List<Mana> paying) {
        this.payingMana = Lists.newArrayList(paying);
    }

    public final void clearManaPaid() {
        this.payingMana.clear();
    }

    public final int getSpendPhyrexianMana() {
        return this.spentPhyrexian;
    }

    public final void setSpendPhyrexianMana(boolean bool) {
        this.spentPhyrexian = bool ? this.spentPhyrexian + 2 : 0;
    }

    public final int getAmountLifePaid() {
        return this.paidLifeAmount;
    }

    public final void setPaidLife(int value) {
        this.paidLifeAmount = value;
    }

    public final void applyPayingManaEffects() {
        final Card host = this.getHostCard();
        for (Mana mana : this.getPayingMana()) {
            if (mana.triggersWhenSpent()) {
                mana.getManaAbility().addTriggersWhenSpent(this, host);
            }
            if (mana.addsCounters(this)) {
                mana.getManaAbility().createETBCounters(host, this.getActivatingPlayer());
            }
            if (mana.addsNoCounterMagic(this)) {
                mana.getManaAbility().addNoCounterEffect(this);
            }
            if (!this.isSpell() || host == null || !mana.addsKeywords(this) || !mana.addsKeywordsType() || !this.isValid(mana.getManaAbility().getAddsKeywordsType(), mana.getSourceCard().getController(), mana.getSourceCard(), null)) continue;
            final long timestamp = host.getGame().getNextTimestamp();
            List<String> kws = Arrays.asList(mana.getAddedKeywords().split(" & "));
            host.addChangedCardKeywords(kws, null, false, timestamp, null);
            if (!mana.addsKeywordsUntil()) continue;
            GameCommand untilEOT = new GameCommand(){
                private static final long serialVersionUID = -8285169579025607693L;

                @Override
                public void run() {
                    host.removeChangedCardKeywords(timestamp, 0L);
                    host.getGame().fireEvent(new GameEventCardStatsChanged(host));
                }
            };
            String until = mana.getManaAbility().getAddsKeywordsUntil();
            if (!"UntilEOT".equals(until)) continue;
            host.getGame().getEndOfTurn().addUntil(untilEOT);
        }
    }

    public ColorSet getPayingColors() {
        int colors = 0;
        for (Mana m4 : this.payingMana) {
            colors = (byte)(colors | m4.getColor());
        }
        return ColorSet.fromMask(colors);
    }

    public List<SpellAbility> getPayingManaAbilities() {
        return this.paidAbilities;
    }

    public TreeBasedTable<String, Boolean, CardCollection> getPaidHash() {
        return this.paidLists;
    }

    public void setPaidHash(TreeBasedTable<String, Boolean, CardCollection> hash) {
        this.paidLists = TreeBasedTable.create(hash);
    }

    public Iterable<Card> getPaidList(String str) {
        return Iterables.concat(this.paidLists.row((Object)str).values());
    }

    public CardCollection getPaidList(String str, boolean intrinsic) {
        return (CardCollection)this.paidLists.get(str, intrinsic);
    }

    public void addCostToHashList(Card c, String str, boolean intrinsic) {
        if (!this.paidLists.contains(str, intrinsic)) {
            this.paidLists.put((Object)str, (Object)intrinsic, (Object)new CardCollection());
        }
        ((CardCollection)this.paidLists.get(str, intrinsic)).add(c);
    }

    public void resetPaidHash() {
        this.paidLists.clear();
    }

    public Iterable<OptionalCost> getOptionalCosts() {
        return this.optionalCosts;
    }

    public final void addOptionalCost(OptionalCost cost) {
        this.optionalCosts = EnumSet.copyOf(this.optionalCosts);
        this.optionalCosts.add(cost);
        if (!cost.getPip().isEmpty()) {
            this.pipsToReduce.add(cost.getPip());
        }
    }

    public boolean isBargained() {
        return this.isOptionalCostPaid(OptionalCost.Bargain);
    }

    public boolean isBuyback() {
        return this.isOptionalCostPaid(OptionalCost.Buyback);
    }

    public boolean isKicked() {
        return this.isOptionalCostPaid(OptionalCost.Kicker1) || this.isOptionalCostPaid(OptionalCost.Kicker2) || this.getRootAbility().getOptionalKeywordAmount(Keyword.MULTIKICKER) > 0;
    }

    public boolean isEntwine() {
        return this.isOptionalCostPaid(OptionalCost.Entwine);
    }

    public boolean isJumpstart() {
        return this.isOptionalCostPaid(OptionalCost.Jumpstart);
    }

    public boolean isOptionalCostPaid(OptionalCost cost) {
        SpellAbility saRoot = this.getRootAbility();
        return saRoot.optionalCosts.contains((Object)cost);
    }

    public Map<AbilityKey, Object> getTriggeringObjects() {
        return this.triggeringObjects;
    }

    public void setTriggeringObjects(Map<AbilityKey, Object> triggeredObjects) {
        this.triggeringObjects = AbilityKey.newMap(triggeredObjects);
    }

    public Object getTriggeringObject(AbilityKey type) {
        return this.triggeringObjects.get((Object)type);
    }

    public void setTriggeringObject(AbilityKey type, Object o) {
        this.triggeringObjects.put(type, o);
    }

    public void setTriggeringObjectsFrom(Map<AbilityKey, Object> runParams, AbilityKey ... types) {
        for (AbilityKey type : types) {
            if (!runParams.containsKey((Object)type)) continue;
            this.triggeringObjects.put(type, runParams.get((Object)type));
        }
    }

    public boolean hasTriggeringObject(AbilityKey type) {
        return this.triggeringObjects.containsKey((Object)type);
    }

    public void resetTriggeringObjects() {
        this.triggeringObjects = AbilityKey.newMap();
    }

    @Override
    public List<Object> getTriggerRemembered() {
        return this.triggerRemembered;
    }

    public void setTriggerRemembered(List<Object> list) {
        this.triggerRemembered = list;
    }

    public void resetTriggerRemembered() {
        this.triggerRemembered = Lists.newArrayList();
    }

    public Map<AbilityKey, Object> getReplacingObjects() {
        return this.replacingObjects;
    }

    public Object getReplacingObject(AbilityKey type) {
        return this.replacingObjects.get((Object)type);
    }

    public void setReplacingObject(AbilityKey type, Object o) {
        this.replacingObjects.put(type, o);
    }

    public void setReplacingObjects(Map<AbilityKey, Object> repParams) {
        this.replacingObjects = AbilityKey.newMap(repParams);
    }

    public void setReplacingObjectsFrom(Map<AbilityKey, Object> repParams, AbilityKey ... types) {
        for (AbilityKey type : types) {
            if (!repParams.containsKey((Object)type)) continue;
            this.setReplacingObject(type, repParams.get((Object)type));
        }
    }

    public void resetOnceResolved() {
        if (!this.isEpic()) {
            this.resetTargets();
        }
        this.resetTriggeringObjects();
        this.resetTriggerRemembered();
        if (this.isActivatedAbility()) {
            this.setXManaCostPaid(null);
        }
    }

    public String yieldKey() {
        if (this.getHostCard() != null) {
            return this.getHostCard().toString() + ": " + this.toUnsuppressedString();
        }
        return this.toUnsuppressedString();
    }

    public String getStackDescription() {
        String text = this.getHostCard().getView().getText();
        if (this.stackDescription.equals(text) && !text.isEmpty()) {
            return this.getHostCard().getName() + " - " + text;
        }
        return TextUtil.fastReplace(this.stackDescription, "CARDNAME", this.getHostCard().getName());
    }

    public void setStackDescription(String s2) {
        this.stackDescription = this.originalStackDescription = s2;
        if (StringUtils.isEmpty(this.description) && StringUtils.isEmpty(this.hostCard.getView().getText())) {
            this.setDescription(s2);
        }
    }

    public String getOriginalStackDescription() {
        return this.originalStackDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s2) {
        this.description = this.originalDescription = TextUtil.fastReplace(s2, "VERT", "|");
    }

    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public String getCostDescription() {
        if (this.payCosts == null || this instanceof AbilitySub) {
            return "";
        }
        boolean equip = false;
        StringBuilder sb = new StringBuilder();
        if (this.hasParam("PrecostDesc")) {
            equip = this.getParam("PrecostDesc").startsWith("Equip");
            sb.append(this.getParam("PrecostDesc")).append(" ");
        }
        if (this.hasParam("CostDesc")) {
            sb.append(this.getParam("CostDesc")).append(" ");
        } else {
            if (this.hasParam("AlternateCost")) {
                Cost alternateCost = new Cost(this.getParam("AlternateCost"), this.payCosts.isAbility());
                boolean altOnlyMana = alternateCost.isOnlyManaCost();
                if (this.payCosts.isOnlyManaCost() && !altOnlyMana) {
                    sb.append("Pay ");
                }
                sb.append(this.payCosts.toString());
                sb.append(" or ").append(altOnlyMana ? alternateCost.toString() : StringUtils.uncapitalize(alternateCost.toString()));
                sb.append(equip && !altOnlyMana ? "." : "");
            } else {
                sb.append(this.payCosts.toString());
            }
            if (this.payCosts.isAbility() && !equip) {
                sb.append(": ");
            }
        }
        return sb.toString();
    }

    public void rebuiltDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCostDescription());
        sb.append(this.getParam("SpellDescription"));
        this.setDescription(sb.toString());
    }

    public final String toString() {
        if (this.isSuppressed()) {
            return "";
        }
        return this.toUnsuppressedString();
    }

    public String toUnsuppressedString() {
        StringBuilder sb = new StringBuilder();
        for (SpellAbility node = this; node != null; node = node.getSubAbility()) {
            if (node != this) {
                sb.append(" ");
            }
            String desc = node.getDescription();
            if (node.getHostCard() == null) continue;
            ITranslatable nameSource = this.getHostName(node);
            desc = CardTranslation.translateMultipleDescriptionText(desc, nameSource);
            String translatedName = CardTranslation.getTranslatedName(nameSource);
            desc = TextUtil.fastReplace(desc, "CARDNAME", translatedName);
            desc = TextUtil.fastReplace(desc, "NICKNAME", Lang.getInstance().getNickName(translatedName));
            if (node.getOriginalHost() != null) {
                desc = TextUtil.fastReplace(desc, "ORIGINALHOST", node.getOriginalHost().getName());
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    public AbilitySub getSubAbility() {
        return this.subAbility;
    }

    public void setSubAbility(AbilitySub subAbility0) {
        if (this.subAbility == subAbility0) {
            return;
        }
        this.subAbility = subAbility0;
        if (this.subAbility != null) {
            this.subAbility.setParent(this);
        }
        this.view.updateDescription(this);
    }

    public Map<String, SpellAbility> getAdditionalAbilities() {
        return this.additionalAbilities;
    }

    public SpellAbility getAdditionalAbility(String name) {
        if (this.hasAdditionalAbility(name)) {
            return this.additionalAbilities.get(name);
        }
        return null;
    }

    public boolean hasAdditionalAbility(String name) {
        return this.additionalAbilities.containsKey(name);
    }

    public void setAdditionalAbility(String name, SpellAbility sa) {
        if (sa == null) {
            this.additionalAbilities.remove(name);
        } else {
            if (sa instanceof AbilitySub) {
                ((AbilitySub)sa).setParent(this);
            }
            this.additionalAbilities.put(name, sa);
        }
        this.view.updateDescription(this);
    }

    public Map<String, List<AbilitySub>> getAdditionalAbilityLists() {
        return this.additionalAbilityLists;
    }

    public List<AbilitySub> getAdditionalAbilityList(String name) {
        if (this.additionalAbilityLists.containsKey(name)) {
            return this.additionalAbilityLists.get(name);
        }
        return ImmutableList.of();
    }

    public void setAdditionalAbilityList(String name, List<AbilitySub> list) {
        if (list == null || list.isEmpty()) {
            this.additionalAbilityLists.remove(name);
        } else {
            ArrayList<AbilitySub> result = Lists.newArrayList(list);
            for (AbilitySub sa : result) {
                sa.setParent(this);
            }
            this.additionalAbilityLists.put(name, result);
        }
        this.view.updateDescription(this);
    }

    public void appendSubAbility(AbilitySub toAdd) {
        SpellAbility tailend = this;
        while (tailend.getSubAbility() != null) {
            tailend = tailend.getSubAbility();
        }
        tailend.setSubAbility(toAdd);
    }

    public boolean isBasicSpell() {
        return this.basicSpell && !this.isCastFaceDown() && this.altCost == null && this.getRootAbility().optionalCosts.isEmpty();
    }

    public void setBasicSpell(boolean basicSpell0) {
        this.basicSpell = basicSpell0;
    }

    public boolean isFlashback() {
        return this.isAlternativeCost(AlternativeCost.Flashback);
    }

    public boolean isForetelling() {
        return false;
    }

    public boolean isForetold() {
        return this.isAlternativeCost(AlternativeCost.Foretold);
    }

    public boolean isPlotting() {
        return false;
    }

    public boolean isAftermath() {
        return this.aftermath;
    }

    public void setAftermath(boolean aftermath) {
        this.aftermath = aftermath;
    }

    public boolean isOutlast() {
        return this.isKeyword(Keyword.OUTLAST);
    }

    public boolean isCraft() {
        return this.isKeyword(Keyword.CRAFT);
    }

    public boolean isCrew() {
        return this.isKeyword(Keyword.CREW);
    }

    public boolean isEquip() {
        return this.isKeyword(Keyword.EQUIP);
    }

    public boolean isChapter() {
        return this.isTrigger() && this.getTrigger().isChapter();
    }

    public Integer getChapter() {
        if (!this.isTrigger()) {
            return null;
        }
        return this.getTrigger().getChapter();
    }

    public boolean isLastChapter() {
        return this.isTrigger() && this.getTrigger().isLastChapter();
    }

    public CardPlayOption getMayPlayOption() {
        return this.mayPlay;
    }

    public StaticAbility getMayPlay() {
        return this.mayPlay != null ? this.mayPlay.getAbility() : null;
    }

    public void setMayPlay(CardPlayOption sta) {
        this.mayPlay = sta;
    }

    public boolean isAdventure() {
        return this.getCardStateName() == CardStateName.Adventure;
    }

    public SpellAbility copy() {
        return this.copy(this.hostCard, false);
    }

    public SpellAbility copy(Player activ) {
        return this.copy(this.hostCard, activ, false);
    }

    public SpellAbility copy(Card host, boolean lki) {
        return this.copy(host, this.getActivatingPlayer(), lki);
    }

    public SpellAbility copy(Card host, Player activ, boolean lki) {
        return this.copy(host, activ, lki, false);
    }

    public SpellAbility copy(Card host, Player activ, boolean lki, boolean keepTextChanges) {
        SpellAbility clone = null;
        try {
            clone = (SpellAbility)this.clone();
            clone.id = lki ? this.id : SpellAbility.nextId();
            clone.view = new SpellAbilityView(clone, lki || host.getGame() == null ? null : host.getGame().getTracker());
            this.copyHelper(clone, host, lki || keepTextChanges);
            clone.mayChooseNewTargets = false;
            clone.triggeringObjects = AbilityKey.newMap(this.triggeringObjects);
            clone.setPayCosts(this.getPayCosts().copy());
            if (this.manaPart != null) {
                clone.manaPart = new AbilityManaPart(clone, (Map<String, String>)this.mapParams);
            }
            clone.optionalKeywordAmount = HashBasedTable.create(this.optionalKeywordAmount);
            if (this.damageMap != null) {
                clone.damageMap = new CardDamageMap(this.damageMap);
            }
            if (this.preventMap != null) {
                clone.preventMap = new CardDamageMap(this.preventMap);
            }
            if (this.counterTable != null) {
                clone.counterTable = new GameEntityCounterTable(this.counterTable);
            }
            if (this.changeZoneTable != null) {
                clone.changeZoneTable = new CardZoneTable(this.changeZoneTable);
            }
            clone.payingMana = Lists.newArrayList(this.payingMana);
            clone.paidAbilities = Lists.newArrayList();
            clone.setPaidHash(this.getPaidHash());
            if (this.usesTargeting()) {
                clone.targetChosen = this.getTargets().clone();
            }
            clone.additionalAbilities = Maps.newHashMap();
            clone.additionalAbilityLists = Maps.newHashMap();
            CardFactory.copySpellAbility(this, clone, host, activ, lki, keepTextChanges);
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
        }
        return clone;
    }

    public SpellAbility copyWithNoManaCost() {
        return this.copyWithNoManaCost(this.getActivatingPlayer());
    }

    public SpellAbility copyWithNoManaCost(Player active) {
        SpellAbility newSA = this.copy(active);
        if (newSA == null) {
            return null;
        }
        newSA.setPayCosts(newSA.getPayCosts().copyWithNoMana());
        if (!newSA.hasParam("WithoutManaCost")) {
            newSA.mapParams.put("WithoutManaCost", "True");
        }
        newSA.setDescription(newSA.getDescription() + " (without paying its mana cost)");
        return newSA;
    }

    public SpellAbility copyWithDefinedCost(Cost abCost) {
        SpellAbility newSA = this.copy();
        newSA.setPayCosts(abCost);
        return newSA;
    }

    public SpellAbility copyWithDefinedCost(String abCost) {
        return this.copyWithDefinedCost(new Cost(abCost, this.isAbility()));
    }

    public SpellAbility copyWithManaCostReplaced(Player active, Cost abCost) {
        SpellAbility newSA = this.copy(active);
        if (newSA == null) {
            return null;
        }
        Cost newCost = newSA.getPayCosts().copyWithNoMana();
        newCost.add(abCost);
        newSA.setPayCosts(newCost);
        return newSA;
    }

    public boolean isTrigger() {
        return this.getTrigger() != null;
    }

    public Trigger getTrigger() {
        if (this.getParent() != null) {
            return this.getParent().getTrigger();
        }
        return this.triggerObj;
    }

    public void setTrigger(Trigger t2) {
        this.triggerObj = t2;
    }

    public boolean isOptionalTrigger() {
        return this.optionalTrigger;
    }

    public void setOptionalTrigger(boolean optrigger) {
        this.optionalTrigger = optrigger;
    }

    public int getSourceTrigger() {
        return this.sourceTrigger;
    }

    public void setSourceTrigger(int id) {
        this.sourceTrigger = id;
    }

    public boolean isReplacementAbility() {
        return this.getParent() != null ? this.getParent().isReplacementAbility() : this.replacementEffect != null;
    }

    public ReplacementEffect getReplacementEffect() {
        if (this.getParent() != null) {
            return this.getParent().getReplacementEffect();
        }
        return this.replacementEffect;
    }

    public void setReplacementEffect(ReplacementEffect re) {
        this.replacementEffect = re;
    }

    public boolean isMandatory() {
        return this.isTrigger() && !this.isOptionalTrigger();
    }

    public final boolean canTarget(GameObject entity) {
        return this.canTarget(entity, false);
    }

    public final boolean canTarget(GameObject entity, boolean fizzleCheck) {
        if (entity == null) {
            return false;
        }
        SpellAbility rootAbility = this.getRootAbility();
        if (rootAbility.isSpell() && rootAbility.getHostCard() == entity) {
            return false;
        }
        if (this.usesTargeting()) {
            Object c3;
            FCollection pl;
            Card c2;
            TargetRestrictions tr = this.getTargetRestrictions();
            if (tr.isUniqueTargets() && this.getUniqueTargets().contains(entity)) {
                return false;
            }
            if (this.hasParam("TargetsWithDefinedController") && entity instanceof Card) {
                c2 = (Card)entity;
                pl = AbilityUtils.getDefinedPlayers(this.getHostCard(), this.getParam("TargetsWithDefinedController"), this);
                if (pl == null || !pl.contains(c2.getController())) {
                    return false;
                }
            }
            if (this.hasParam("TargetsWithSharedCardType") && entity instanceof Card) {
                c2 = (Card)entity;
                pl = AbilityUtils.getDefinedCards(this.getHostCard(), this.getParam("TargetsWithSharedCardType"), this);
                for (Card crd : pl) {
                    if (this.hasParam("TargetsWithSharedTypes")) {
                        boolean flag = false;
                        for (String type : this.getParam("TargetsWithSharedTypes").split(",")) {
                            if (!c2.getType().hasStringType(type) || !crd.getType().hasStringType(type)) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        return false;
                    }
                    if (c2.sharesCardTypeWith(crd)) continue;
                    return false;
                }
            }
            if (this.hasParam("TargetsWithControllerProperty") && entity instanceof Card) {
                String prop = this.getParam("TargetsWithControllerProperty");
                c3 = (Card)entity;
                if (prop.equals("cmcLECardsInGraveyard") && ((Card)c3).getCMC() > ((Card)c3).getController().getCardsIn(ZoneType.Graveyard).size()) {
                    return false;
                }
            }
            if (this.hasParam("TargetsWithRelatedProperty") && entity instanceof Card) {
                String related = this.getParam("TargetsWithRelatedProperty");
                c3 = (Card)entity;
                Card parentTarget = null;
                for (GameObject o : this.getUniqueTargets()) {
                    if (!(o instanceof Card)) continue;
                    parentTarget = (Card)o;
                    break;
                }
                if (parentTarget == null) {
                    return false;
                }
                switch (related) {
                    case "LEPower": {
                        if (((Card)c3).getNetPower() <= parentTarget.getNetPower()) break;
                        return false;
                    }
                    case "LECMC": {
                        if (((Card)c3).getCMC() <= parentTarget.getCMC()) break;
                        return false;
                    }
                }
            }
            if (this.hasParam("TargetingPlayerControls") && entity instanceof Card && !(c2 = (Card)entity).getController().equals(this.getTargetingPlayer())) {
                return false;
            }
            if (this.hasParam("MaxTotalTargetCMC") && entity instanceof Card) {
                int soFar = Aggregates.sum(this.getTargets().getTargetCards(), Card::getCMC);
                if (!this.isTargeting(entity)) {
                    c3 = (Card)entity;
                    soFar += ((Card)c3).getCMC();
                }
                if (soFar > tr.getMaxTotalCMC(this.getHostCard(), this)) {
                    return false;
                }
            }
            if (this.hasParam("MaxTotalTargetPower") && entity instanceof Card) {
                int soFar = Aggregates.sum(this.getTargets().getTargetCards(), Card::getNetPower);
                if (!this.isTargeting(entity)) {
                    c3 = (Card)entity;
                    soFar += ((Card)c3).getNetPower();
                }
                if (soFar > tr.getMaxTotalPower(this.getHostCard(), this)) {
                    return false;
                }
            }
            if (tr.isEqualToughness() && entity instanceof Card) {
                for (Object c3 : this.getTargets().getTargetCards()) {
                    if (entity == c3 || ((Card)c3).getNetToughness() == ((Card)entity).getNetToughness()) continue;
                    return false;
                }
            }
            if (tr.isSameController() && entity instanceof Card) {
                Player newController = ((Card)entity).getController();
                for (Card c4 : this.getTargets().getTargetCards()) {
                    if (entity == c4 || c4.getController().equals(newController)) continue;
                    return false;
                }
            }
            if ((tr.isDifferentControllers() || tr.isForEachPlayer() && !fizzleCheck) && entity instanceof Card) {
                Player newController = ((Card)entity).getController();
                for (Card c4 : this.getTargets().getTargetCards()) {
                    c4 = this.getHostCard().getGame().getChangeZoneLKIInfo(c4);
                    if (entity == c4 || !c4.getController().equals(newController)) continue;
                    return false;
                }
            }
            if (tr.isForEachPlayer() && fizzleCheck && entity instanceof Card && this.getTargets().forEachControllerChanged((Card)entity)) {
                return false;
            }
            if (tr.isWithoutSameCreatureType() && entity instanceof Card) {
                for (Object c3 : this.getTargets().getTargetCards()) {
                    if (entity == c3 || !((Card)c3).sharesCreatureTypeWith((Card)entity)) continue;
                    return false;
                }
            }
            if (tr.isWithSameCreatureType() && entity instanceof Card) {
                for (Object c3 : this.getTargets().getTargetCards()) {
                    if (entity == c3 || ((Card)c3).sharesCreatureTypeWith((Card)entity)) continue;
                    return false;
                }
            }
            if (tr.isWithSameCardType() && entity instanceof Card) {
                for (Object c3 : this.getTargets().getTargetCards()) {
                    if (entity == c3 || ((Card)c3).sharesCardTypeWith((Card)entity)) continue;
                    return false;
                }
            }
            if (entity instanceof GameEntity) {
                GameEntity e = (GameEntity)entity;
                if (!e.isValid(tr.getValidTgts(), this.getActivatingPlayer(), this.getHostCard(), (CardTraitBase)this)) {
                    return false;
                }
                if (this.hasParam("TargetType") && !e.isValid(this.getParam("TargetType").split(","), this.getActivatingPlayer(), this.getHostCard(), (CardTraitBase)this)) {
                    return false;
                }
            }
            if (entity instanceof Card && (c = (Card)entity).getZone() != null && !tr.getZone().contains((Object)c.getZone().getZoneType())) {
                return false;
            }
        }
        return entity.canBeTargetedBy(this);
    }

    public boolean isWrapper() {
        return false;
    }

    public final boolean isBestow() {
        return this.isAlternativeCost(AlternativeCost.Bestow);
    }

    public final boolean isBlitz() {
        return this.isAlternativeCost(AlternativeCost.Blitz);
    }

    public final boolean isDash() {
        return this.isAlternativeCost(AlternativeCost.Dash);
    }

    public final boolean isDisturb() {
        return this.isAlternativeCost(AlternativeCost.Disturb);
    }

    public final boolean isEscape() {
        return this.isAlternativeCost(AlternativeCost.Escape);
    }

    public final boolean isEvoke() {
        return this.isAlternativeCost(AlternativeCost.Evoke);
    }

    public final boolean isFreerunning() {
        return this.isAlternativeCost(AlternativeCost.Freerunning);
    }

    public final boolean isImpending() {
        return this.isAlternativeCost(AlternativeCost.Impending);
    }

    public final boolean isMadness() {
        return this.isAlternativeCost(AlternativeCost.Madness);
    }

    public final boolean isMutate() {
        return this.isAlternativeCost(AlternativeCost.Mutate);
    }

    public final boolean isProwl() {
        return this.isAlternativeCost(AlternativeCost.Prowl);
    }

    public final boolean isSurged() {
        return this.isAlternativeCost(AlternativeCost.Surge);
    }

    public final boolean isSpectacle() {
        return this.isAlternativeCost(AlternativeCost.Spectacle);
    }

    public List<String> getPipsToReduce() {
        return this.pipsToReduce;
    }

    public final void clearPipsToReduce() {
        this.pipsToReduce.clear();
    }

    public CardCollection getTappedForConvoke() {
        return this.tappedForConvoke;
    }

    public void addTappedForConvoke(Card c) {
        if (this.tappedForConvoke == null) {
            this.tappedForConvoke = new CardCollection();
        }
        this.tappedForConvoke.add(c);
    }

    public void clearTappedForConvoke() {
        if (this.tappedForConvoke != null) {
            this.tappedForConvoke.clear();
        }
    }

    public boolean isEmerge() {
        return this.isAlternativeCost(AlternativeCost.Emerge);
    }

    public Card getSacrificedAsEmerge() {
        return this.sacrificedAsEmerge;
    }

    public void setSacrificedAsEmerge(Card c) {
        this.sacrificedAsEmerge = c;
    }

    public void resetSacrificedAsEmerge() {
        this.sacrificedAsEmerge = null;
    }

    public boolean isOffering() {
        return this.isAlternativeCost(AlternativeCost.Offering);
    }

    public Card getSacrificedAsOffering() {
        return this.sacrificedAsOffering;
    }

    public void setSacrificedAsOffering(Card c) {
        this.sacrificedAsOffering = c;
    }

    public void resetSacrificedAsOffering() {
        this.sacrificedAsOffering = null;
    }

    public CardCollection getSplicedCards() {
        return this.splicedCards;
    }

    public void setSplicedCards(CardCollection splicedCards0) {
        this.splicedCards = splicedCards0;
    }

    public void addSplicedCards(Card splicedCard) {
        if (this.splicedCards == null) {
            this.splicedCards = new CardCollection();
        }
        this.splicedCards.add(splicedCard);
    }

    public CardCollection knownDetermineDefined(String defined) {
        CardCollection ret = new CardCollection();
        CardCollection list = AbilityUtils.getDefinedCards(this.getHostCard(), defined, this);
        Game game = this.getActivatingPlayer().getGame();
        for (Card c : list) {
            Card actualCard = game.getCardState(c);
            ret.add(actualCard);
        }
        return ret;
    }

    public SpellAbility getRootAbility() {
        SpellAbility parent = this;
        while (null != parent.getParent()) {
            parent = parent.getParent();
        }
        return parent;
    }

    public SpellAbility getParent() {
        return null;
    }

    @Override
    protected IHasSVars getSVarFallback() {
        return ObjectUtils.firstNonNull(this.getParent(), super.getSVarFallback());
    }

    public boolean isUndoable() {
        return this.undoable && this.payCosts.isUndoable() && this.getHostCard().isInPlay();
    }

    public boolean undo() {
        if (this.isUndoable() && this.getActivatingPlayer().getManaPool().accountFor(this.getManaPart())) {
            this.payCosts.refundPaidCost(this.hostCard);
            return true;
        }
        return false;
    }

    public void setUndoable(boolean b) {
        this.undoable = b;
    }

    public boolean isCastFromPlayEffect() {
        return this.isCastFromPlayEffect;
    }

    public void setCastFromPlayEffect(boolean b) {
        this.isCastFromPlayEffect = b;
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public void setCopied(boolean isCopied0) {
        this.isCopied = isCopied0;
        if (this.getSubAbility() != null) {
            this.getSubAbility().setCopied(isCopied0);
        }
    }

    public boolean isMayChooseNewTargets() {
        return this.mayChooseNewTargets;
    }

    public void setMayChooseNewTargets(boolean value) {
        this.mayChooseNewTargets = value;
    }

    public boolean isAnnouncing(String variable) {
        String[] announcedOnes;
        String announce = this.getParam("Announce");
        if (StringUtils.isBlank(announce)) {
            return false;
        }
        for (String a : announcedOnes = TextUtil.split(announce, ',')) {
            if (!a.trim().equalsIgnoreCase(variable)) continue;
            return true;
        }
        return false;
    }

    public void addAnnounceVar(String variable) {
        String[] announcedOnes;
        String announce = this.getParam("Announce");
        if (StringUtils.isBlank(announce)) {
            this.mapParams.put("Announce", variable);
            this.originalMapParams.put("Announce", variable);
            return;
        }
        for (String a : announcedOnes = TextUtil.split(announce, ',')) {
            if (!a.trim().equalsIgnoreCase(variable)) continue;
            return;
        }
        this.mapParams.put("Announce", announce + ";" + variable);
        this.originalMapParams.put("Announce", announce + ";" + variable);
    }

    @Override
    public boolean canBeTargetedBy(SpellAbility sa) {
        return sa.canTargetSpellAbility(this);
    }

    public boolean usesTargeting() {
        return this.targetRestrictions != null;
    }

    public TargetRestrictions getTargetRestrictions() {
        return this.targetRestrictions;
    }

    public void setTargetRestrictions(TargetRestrictions tgt) {
        this.targetRestrictions = tgt;
    }

    public TargetChoices getTargets() {
        return this.targetChosen;
    }

    public void setTargets(TargetChoices targets) {
        this.targetChosen = targets;
    }

    public void resetTargets() {
        this.targetChosen = new TargetChoices();
    }

    public boolean isDividedAsYouChoose() {
        return this.hasParam("DividedAsYouChoose");
    }

    public final void addDividedAllocation(GameObject tgt, Integer portionAllocated) {
        this.getTargets().addDividedAllocation(tgt, portionAllocated);
    }

    public Integer getDividedValue(GameObject c) {
        return this.getTargets().getDividedValue(c);
    }

    public int getTotalDividedValue() {
        return this.getTargets().getTotalDividedValue();
    }

    public Integer getDividedValue() {
        return this.dividedValue;
    }

    public int getStillToDivide() {
        if (!this.isDividedAsYouChoose() || this.dividedValue == null) {
            return 0;
        }
        return this.dividedValue - this.getTotalDividedValue();
    }

    public void resetFirstTarget(GameObject c, SpellAbility originalSA) {
        for (SpellAbility sa = this; sa != null; sa = sa.getSubAbility()) {
            if (!sa.usesTargeting()) continue;
            sa.resetTargets();
            sa.getTargets().add(c);
            if (originalSA.getTargets().getDividedValues().isEmpty()) break;
            sa.addDividedAllocation(c, Iterables.getFirst(originalSA.getTargets().getDividedValues(), null));
            break;
        }
    }

    public boolean canAddMoreTarget() {
        if (!this.usesTargeting()) {
            return false;
        }
        return this.getTargets().size() < this.getMaxTargets();
    }

    public boolean isZeroTargets() {
        return this.getMinTargets() == 0 && this.getTargets().isEmpty();
    }

    public boolean isMinTargetChosen() {
        return this.getTargetRestrictions().isMinTargetsChosen(this.hostCard, this);
    }

    public boolean isMaxTargetChosen() {
        return this.getTargetRestrictions().isMaxTargetsChosen(this.hostCard, this);
    }

    public int getMinTargets() {
        return this.getTargetRestrictions().getMinTargets(this.getHostCard(), this);
    }

    public int getMaxTargets() {
        return this.getTargetRestrictions().getMaxTargets(this.getHostCard(), this);
    }

    public boolean isTargetNumberValid() {
        if (!this.usesTargeting()) {
            return this.getTargets().isEmpty();
        }
        if (!this.isMinTargetChosen()) {
            return false;
        }
        return this.getMaxTargets() >= this.getTargets().size();
    }

    public final List<TargetChoices> getAllTargetChoices() {
        ArrayList<TargetChoices> res = Lists.newArrayList();
        for (SpellAbility sa = this.getRootAbility(); sa != null; sa = sa.getSubAbility()) {
            if (!sa.usesTargeting()) continue;
            res.add(sa.getTargets());
        }
        return res;
    }

    public Card getTargetCard() {
        return this.targetChosen.getFirstTargetedCard();
    }

    public void setTargetCard(Card card) {
        if (card == null) {
            System.out.println(this.getHostCard() + " - SpellAbility.setTargetCard() called with null for target card.");
            return;
        }
        this.resetTargets();
        this.targetChosen.add(card);
        this.setStackDescription(this.getHostCard().getName() + " - targeting " + card);
    }

    public CardCollectionView findTargetedCards() {
        if (this.getTargets().isTargetingAnyCard()) {
            return this.getTargets().getTargetCards();
        }
        if (this.getTargets().isTargetingAnySpell()) {
            CardCollection res = new CardCollection();
            for (SpellAbility ability : this.getTargets().getTargetSpells()) {
                res.add(ability.getHostCard());
            }
            return res;
        }
        SpellAbility parent = this.getParentTargetingCard();
        if (null != parent) {
            return parent.findTargetedCards();
        }
        parent = this.getParentTargetingSA();
        if (null != parent) {
            return parent.findTargetedCards();
        }
        return CardCollection.EMPTY;
    }

    public SpellAbility getSATargetingCard() {
        return this.getTargets().isTargetingAnyCard() ? this : this.getParentTargetingCard();
    }

    public SpellAbility getParentTargetingCard() {
        for (SpellAbility parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getTargets().isTargetingAnyCard()) continue;
            return parent;
        }
        return null;
    }

    public SpellAbility getSATargetingSA() {
        return this.getTargets().isTargetingAnySpell() ? this : this.getParentTargetingSA();
    }

    public SpellAbility getParentTargetingSA() {
        for (SpellAbility parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getTargets().isTargetingAnySpell()) continue;
            return parent;
        }
        return null;
    }

    public SpellAbility getSATargetingPlayer() {
        return this.getTargets().isTargetingAnyPlayer() ? this : this.getParentTargetingPlayer();
    }

    public SpellAbility getParentTargetingPlayer() {
        for (SpellAbility parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.getTargets().isTargetingAnyPlayer()) continue;
            return parent;
        }
        return null;
    }

    public final List<GameObject> getUniqueTargets() {
        ArrayList<GameObject> targets = Lists.newArrayList();
        for (SpellAbility child = this.getParent(); child != null; child = child.getParent()) {
            if (!child.usesTargeting()) continue;
            Iterables.addAll(targets, child.getTargets());
        }
        return targets;
    }

    public boolean canTargetSpellAbility(SpellAbility topSA) {
        Card host;
        String prop;
        TargetRestrictions tgt = this.getTargetRestrictions();
        if (this.equals(topSA)) {
            return false;
        }
        if (this.hasParam("TargetType") && !topSA.isValid(this.getParam("TargetType").split(","), this.getActivatingPlayer(), this.getHostCard(), (CardTraitBase)this)) {
            return false;
        }
        if (this.hasParam("TargetsWithControllerProperty") && (prop = this.getParam("TargetsWithControllerProperty")).equals("cmcLECardsInGraveyard") && topSA.getHostCard().getCMC() > topSA.getActivatingPlayer().getCardsIn(ZoneType.Graveyard).size()) {
            return false;
        }
        String splitTargetRestrictions = tgt.getSAValidTargeting();
        if (splitTargetRestrictions != null) {
            boolean result = false;
            SpellAbility subAb = topSA;
            while (subAb != null && !result) {
                if (subAb.usesTargeting()) {
                    TargetChoices matchTgt = subAb.getTargets();
                    if (matchTgt == null) continue;
                    for (GameObject o : matchTgt) {
                        if (!o.isValid(splitTargetRestrictions.split(","), this.getActivatingPlayer(), this.getHostCard(), (CardTraitBase)this)) continue;
                        result = true;
                        break;
                    }
                }
                subAb = subAb.getSubAbility();
            }
            if (!result) {
                return false;
            }
        }
        if ((host = topSA.getHostCard()).isImmutable() && !host.isEmblem()) {
            if (host.getEffectSource() != null) {
                host = host.getEffectSource();
            } else {
                return StringUtils.indexOfAny((CharSequence)"Card", tgt.getValidTgts()) != -1;
            }
        }
        return host.isValid(tgt.getValidTgts(), this.getActivatingPlayer(), this.getHostCard(), (CardTraitBase)this);
    }

    public boolean isTargeting(GameObject o) {
        if (this.getTargets().contains(o)) {
            return true;
        }
        AbilitySub p = this.getSubAbility();
        return p != null && p.isTargeting(o);
    }

    public boolean setupNewTargets(Player forceTargetingPlayer) {
        AbilitySub subAbility;
        SpellAbility currentAbility = this;
        do {
            if (currentAbility.usesTargeting()) {
                TargetChoices oldTargets = currentAbility.getTargets();
                if (forceTargetingPlayer.getController().chooseNewTargetsFor(currentAbility, null, true) == null) {
                    currentAbility.setTargets(oldTargets);
                }
            }
            if ((subAbility = currentAbility.getSubAbility()) == null) continue;
            subAbility.setParent(currentAbility);
        } while ((currentAbility = subAbility) != null);
        return true;
    }

    public boolean setupTargets() {
        AbilitySub subAbility;
        SpellAbility currentAbility = this;
        Card source = this.getHostCard();
        do {
            if (currentAbility.usesTargeting()) {
                Player targetingPlayer;
                currentAbility.clearTargets();
                if (currentAbility.hasParam("TargetingPlayer")) {
                    PlayerCollection candidates = AbilityUtils.getDefinedPlayers(source, currentAbility.getParam("TargetingPlayer"), currentAbility);
                    targetingPlayer = this.getActivatingPlayer().getController().chooseSingleEntityForEffect(candidates, currentAbility, "Choose the targeting player", null);
                } else {
                    targetingPlayer = this.getActivatingPlayer();
                }
                currentAbility.setTargetingPlayer(targetingPlayer);
                if (!targetingPlayer.getController().chooseTargetsFor(currentAbility)) {
                    return false;
                }
            }
            if ((subAbility = currentAbility.getSubAbility()) == null) continue;
            subAbility.setParent(currentAbility);
        } while ((currentAbility = subAbility) != null);
        if (!StaticAbilityMustTarget.meetsMustTargetRestriction(this)) {
            String message = Localizer.getInstance().getMessage("lblInvalidTargetSpecification", new Object[0]);
            this.getActivatingPlayer().getController().notifyOfValue(null, null, message);
            return false;
        }
        return true;
    }

    public final void clearTargets() {
        if (this.usesTargeting()) {
            this.resetTargets();
            if (this.isDividedAsYouChoose()) {
                this.dividedValue = AbilityUtils.calculateAmount(this.getHostCard(), this.getParam("DividedAsYouChoose"), this);
            }
        }
    }

    @Override
    public final boolean isValid(String restriction, Player sourceController, Card source, CardTraitBase spellAbility) {
        String[] incR = restriction.split("\\.", 2);
        SpellAbility root = this.getRootAbility();
        boolean testFailed = false;
        if (incR[0].startsWith("!")) {
            testFailed = true;
            incR[0] = incR[0].substring(1);
        }
        if (incR[0].equals("Spell")) {
            if (!root.isSpell()) {
                return testFailed;
            }
        } else if (incR[0].equals("Ability")) {
            if (!root.isAbility()) {
                return testFailed;
            }
        } else if (incR[0].equals("Instant")) {
            if (!root.getCardState().getType().isInstant()) {
                return testFailed;
            }
        } else if (incR[0].equals("Sorcery")) {
            if (!root.getCardState().getType().isSorcery()) {
                return testFailed;
            }
        } else if (incR[0].equals("Triggered")) {
            if (!root.isTrigger()) {
                return testFailed;
            }
        } else if (incR[0].equals("Activated")) {
            if (!root.isActivatedAbility()) {
                return testFailed;
            }
        } else if (incR[0].equals("Static")) {
            if (!(root instanceof AbilityStatic)) {
                return testFailed;
            }
        } else if (incR[0].contains("LandAbility")) {
            if (!root.isLandAbility()) {
                return testFailed;
            }
        } else if (!incR[0].equals("SpellAbility")) {
            return testFailed;
        }
        if (incR.length > 1) {
            String[] exR;
            String excR = incR[1];
            for (String s2 : exR = excR.split("\\+")) {
                if (this.hasProperty(s2, sourceController, source, spellAbility)) continue;
                return testFailed;
            }
        }
        return !testFailed;
    }

    @Override
    public boolean hasProperty(String property, Player sourceController, Card source, CardTraitBase spellAbility) {
        return ForgeScript.spellAbilityHasProperty(this, property, sourceController, source, spellAbility);
    }

    public boolean tracksManaSpent() {
        if (this.hostCard == null || this.hostCard.getRules() == null) {
            return false;
        }
        if (this.isSpell() && this.hostCard.hasConverge()) {
            return true;
        }
        String text = this.hostCard.getRules().getOracleText();
        if (this.isSpell() && text.contains("was spent to cast")) {
            return true;
        }
        return this.isAbility() && text.contains("mana spent to pay");
    }

    public int getTotalManaSpent() {
        return this.getPayingMana().size();
    }

    public List<AbilitySub> getChosenList() {
        return this.chosenList;
    }

    public void setChosenList(List<AbilitySub> choices) {
        this.chosenList = choices;
    }

    @Override
    public void changeText() {
        super.changeText();
        if (this.targetRestrictions != null) {
            this.targetRestrictions.applyTargetTextChanges(this);
        }
        this.getPayCosts().applyTextChangeEffects(this);
        this.stackDescription = AbilityUtils.applyDescriptionTextChangeEffects(this.originalStackDescription, this);
        this.description = AbilityUtils.applyDescriptionTextChangeEffects(this.originalDescription, this);
        if (this.subAbility != null && this.subAbility.getParent() == this) {
            this.subAbility.changeText();
        }
        for (SpellAbility spellAbility : this.additionalAbilities.values()) {
            spellAbility.changeText();
        }
        for (List list : this.additionalAbilityLists.values()) {
            for (AbilitySub sa : list) {
                sa.changeText();
            }
        }
    }

    @Override
    public void changeTextIntrinsic(Map<String, String> colorMap, Map<String, String> typeMap) {
        super.changeTextIntrinsic(colorMap, typeMap);
        if (this.subAbility != null && this.subAbility.getParent() == this) {
            this.subAbility.changeTextIntrinsic(colorMap, typeMap);
        }
        for (SpellAbility spellAbility : this.additionalAbilities.values()) {
            spellAbility.changeTextIntrinsic(colorMap, typeMap);
        }
        for (List list : this.additionalAbilityLists.values()) {
            for (AbilitySub sa : list) {
                sa.changeTextIntrinsic(colorMap, typeMap);
            }
        }
    }

    @Override
    public void setIntrinsic(boolean i) {
        super.setIntrinsic(i);
        if (this.subAbility != null) {
            this.subAbility.setIntrinsic(i);
        }
        for (SpellAbility spellAbility : this.additionalAbilities.values()) {
            if (spellAbility.isIntrinsic() == i) continue;
            spellAbility.setIntrinsic(i);
        }
        for (List list : this.additionalAbilityLists.values()) {
            for (AbilitySub sa : list) {
                if (sa.isIntrinsic() == i) continue;
                sa.setIntrinsic(i);
            }
        }
    }

    public SpellAbilityView getView() {
        this.view.updateHostCard(this);
        this.view.updateDescription(this);
        this.view.updateCanPlay(this, true);
        this.view.updatePromptIfOnlyPossibleAbility(this);
        return this.view;
    }

    @Override
    public int compareTo(SpellAbility ab) {
        if (this.isManaAbility() && ab.isManaAbility()) {
            return this.calculateScoreForManaAbility() - ab.calculateScoreForManaAbility();
        }
        return 0;
    }

    public int calculateScoreForManaAbility() {
        int score = 0;
        if (this.manaPart == null) {
            ++score;
        } else {
            String mana = this.manaPart.mana(this);
            if (!mana.equals("Any")) {
                score += mana.length();
                if (!this.canProduce("C")) {
                    ++score;
                }
            } else {
                score += 7;
            }
        }
        for (CostPart costPart : this.payCosts.getCostParts()) {
            if (!costPart.isReusable()) {
                score += 3;
            }
            if (!costPart.isRenewable()) {
                score += 3;
            }
            if (costPart instanceof CostTap && !Untap.canUntap(this.getHostCard())) {
                score += 10;
            }
            if (costPart instanceof CostSacrifice && !costPart.payCostFromSource()) {
                score += 40;
            }
            ++score;
        }
        if (!this.isUndoable()) {
            score += 50;
        }
        if (this.subAbility != null) {
            score += 2;
        }
        return score;
    }

    public CardDamageMap getDamageMap() {
        if (this.damageMap != null) {
            return this.damageMap;
        }
        if (this.getParent() != null) {
            return this.getParent().getDamageMap();
        }
        return null;
    }

    public CardDamageMap getPreventMap() {
        if (this.preventMap != null) {
            return this.preventMap;
        }
        if (this.getParent() != null) {
            return this.getParent().getPreventMap();
        }
        return null;
    }

    public GameEntityCounterTable getCounterTable() {
        if (this.counterTable != null) {
            return this.counterTable;
        }
        if (this.getParent() != null) {
            return this.getParent().getCounterTable();
        }
        return null;
    }

    public CardZoneTable getChangeZoneTable() {
        if (this.changeZoneTable != null) {
            return this.changeZoneTable;
        }
        if (this.getParent() != null) {
            return this.getParent().getChangeZoneTable();
        }
        return null;
    }

    public Map<Player, Integer> getLoseLifeMap() {
        if (this.loseLifeMap != null) {
            return this.loseLifeMap;
        }
        if (this.getParent() != null) {
            return this.getParent().getLoseLifeMap();
        }
        return null;
    }

    public void setDamageMap(CardDamageMap map) {
        this.damageMap = map;
    }

    public void setPreventMap(CardDamageMap map) {
        this.preventMap = map;
    }

    public void setCounterTable(GameEntityCounterTable table) {
        this.counterTable = table;
    }

    public void setChangeZoneTable(CardZoneTable table) {
        this.changeZoneTable = table;
    }

    public void setLoseLifeMap(Map<Player, Integer> map) {
        this.loseLifeMap = map;
    }

    public SpellAbility getOriginalAbility() {
        return this.grantorOriginal == null ? null : ObjectUtils.firstNonNull(this.grantorOriginal.getOriginalAbility(), this.grantorOriginal);
    }

    public void setOriginalAbility(SpellAbility sa) {
        this.grantorOriginal = sa;
    }

    public StaticAbility getGrantorStatic() {
        return this.grantorStatic;
    }

    public void setGrantorStatic(StaticAbility st) {
        this.grantorStatic = st;
    }

    public boolean isAlternativeCost(AlternativeCost ac) {
        if (ac.equals((Object)this.altCost)) {
            return true;
        }
        SpellAbility parent = this.getParent();
        if (parent != null) {
            return parent.isAlternativeCost(ac);
        }
        return false;
    }

    public AlternativeCost getAlternativeCost() {
        if (this.altCost != null) {
            return this.altCost;
        }
        SpellAbility parent = this.getParent();
        if (parent != null) {
            return parent.getAlternativeCost();
        }
        return null;
    }

    public void setAlternativeCost(AlternativeCost ac) {
        this.altCost = ac;
    }

    public Integer getXManaCostPaid() {
        return this.xManaCostPaid;
    }

    public void setXManaCostPaid(Integer n) {
        this.xManaCostPaid = n;
    }

    public String getXColor() {
        String[] parts;
        if (!this.hasParam("XColor")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String col : parts = this.getParam("XColor").split(",")) {
            if (col.length() > 2) {
                col = MagicColor.toShortString(col);
            }
            sb.append(col);
        }
        return sb.toString();
    }

    public boolean canCastTiming(Player activator) {
        return this.canCastTiming(this.getHostCard(), activator);
    }

    public boolean canCastTiming(Card host, Player activator) {
        if (this instanceof AbilityStatic && this.getRestrictions().isSorcerySpeed() && !activator.canCastSorcery()) {
            return false;
        }
        if (!this.isSpell() && !this.isActivatedAbility()) {
            return true;
        }
        if (activator.canCastSorcery() || this.withFlash(host, activator)) {
            return true;
        }
        if (this.isSpell()) {
            return false;
        }
        if (this.isActivatedAbility()) {
            return !this.isPwAbility() && !this.getRestrictions().isSorcerySpeed();
        }
        return true;
    }

    public boolean withFlash(Card host, Player activator) {
        if (this.getRestrictions().isInstantSpeed()) {
            return true;
        }
        if ((this.isSpell() || this.isLandAbility()) && (this.isCastFromPlayEffect() || host.isInstant() || host.hasKeyword(Keyword.FLASH))) {
            return true;
        }
        return StaticAbilityCastWithFlash.anyWithFlash(this, host, activator);
    }

    public boolean checkRestrictions(Player activator) {
        return this.checkRestrictions(this.getHostCard(), activator);
    }

    public boolean checkRestrictions(Card host, Player activator) {
        return true;
    }

    public void addRollbackEffect(Card eff) {
        this.rollbackEffects.add(eff);
    }

    public void rollback() {
        for (Card c : this.rollbackEffects) {
            c.getGame().getAction().ceaseToExist(c, true);
        }
        this.rollbackEffects.clear();
    }

    public boolean isHidden() {
        boolean hidden = this.hasParam("Hidden");
        if (!hidden && this.hasParam("Origin")) {
            hidden = ZoneType.isHidden(this.getParam("Origin"));
        }
        return hidden;
    }

    public boolean isLegalAfterStack() {
        return this.matchesValidParam("ValidAfterStack", this);
    }

    public boolean isCounterableBy(SpellAbility sa) {
        return true;
    }

    public Card getAlternateHost(Card source) {
        return null;
    }

    public boolean hasOptionalKeywordAmount(KeywordInterface kw) {
        long staticId = kw.getStatic() == null ? 0L : (long)kw.getStatic().getId();
        return this.optionalKeywordAmount.contains((Object)kw.getKeyword(), Pair.of(kw.getIdx(), staticId));
    }

    public boolean hasOptionalKeywordAmount(Keyword kw) {
        return this.optionalKeywordAmount.containsRow((Object)kw);
    }

    public Set<Keyword> getOptionalKeywords() {
        return this.optionalKeywordAmount.rowKeySet();
    }

    public int getOptionalKeywordAmount(KeywordInterface kw) {
        long staticId = kw.getStatic() == null ? 0L : (long)kw.getStatic().getId();
        return ObjectUtils.firstNonNull(this.optionalKeywordAmount.get((Object)kw.getKeyword(), Pair.of(kw.getIdx(), staticId)), 0);
    }

    public int getOptionalKeywordAmount(Keyword kw) {
        return this.optionalKeywordAmount.row(kw).values().stream().mapToInt(i -> i).sum();
    }

    public void setOptionalKeywordAmount(KeywordInterface kw, int amount) {
        long staticId = kw.getStatic() == null ? 0L : (long)kw.getStatic().getId();
        this.optionalKeywordAmount.put(kw.getKeyword(), Pair.of(kw.getIdx(), staticId), amount);
    }

    public void clearOptionalKeywordAmount() {
        this.optionalKeywordAmount.clear();
    }

    public static class EmptySa
    extends SpellAbility {
        public EmptySa(Card sourceCard) {
            super(sourceCard, Cost.Zero);
            this.setActivatingPlayer(sourceCard.getController());
        }

        public EmptySa(ApiType api0, Card sourceCard) {
            super(sourceCard, Cost.Zero);
            this.setActivatingPlayer(sourceCard.getController());
            this.api = api0;
        }

        public EmptySa(Card sourceCard, Player activator) {
            super(sourceCard, Cost.Zero);
            this.setActivatingPlayer(activator);
        }

        public EmptySa(ApiType api0, Card sourceCard, Player activator) {
            super(sourceCard, Cost.Zero);
            this.setActivatingPlayer(activator);
            this.api = api0;
        }

        @Override
        public void resolve() {
        }

        @Override
        public boolean canPlay() {
            return false;
        }
    }
}

