/*
 * Decompiled with CFR 0.152.
 */
package forge.game.spellability;

import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import java.io.Serializable;
import java.util.Map;

public final class AbilitySub
extends SpellAbility
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4650634415821733134L;
    private SpellAbility parent;
    private final SpellAbilityEffect effect;

    public void setParent(SpellAbility parent) {
        this.parent = parent;
    }

    @Override
    public SpellAbility getParent() {
        return this.parent;
    }

    @Override
    public boolean canPlay() {
        return false;
    }

    public AbilitySub(ApiType api0, Card ca, TargetRestrictions tgt, Map<String, String> params0) {
        super(ca, Cost.Zero);
        this.setTargetRestrictions(tgt);
        this.api = api0;
        if (params0 != null) {
            this.originalMapParams.putAll(params0);
            this.mapParams.putAll(params0);
        }
        this.effect = this.api.getSpellEffect();
        if (this.api.equals((Object)ApiType.Mana) || this.api.equals((Object)ApiType.ManaReflected)) {
            this.setManaPart(new AbilityManaPart(this, (Map<String, String>)this.mapParams));
        }
        if (this.api.equals((Object)ApiType.ChangeZone) || this.api.equals((Object)ApiType.ChangeZoneAll)) {
            AbilityFactory.adjustChangeZoneTarget(this.mapParams, this);
        }
    }

    @Override
    public String getStackDescription() {
        return this.effect.getStackDescriptionWithSubs(this.mapParams, this);
    }

    @Override
    public void resolve() {
        this.effect.resolve(this);
    }

    @Override
    protected IHasSVars getSVarFallback() {
        if (this.getRootAbility().getCardState() != this.getCardState()) {
            return this.getCardState();
        }
        return super.getSVarFallback();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception ex) {
            throw new RuntimeException("AbilitySub : clone() error, " + ex);
        }
    }
}

