/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardDamageMap;
import forge.game.card.CardState;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import forge.util.TextUtil;
import forge.util.Visitor;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ReplacementHandler {
    private final Game game;
    private Set<ReplacementEffect> hasRun = Sets.newHashSet();
    private final List<Map<ReplacementEffect, List<Map<AbilityKey, Object>>>> replaceDamageList = new ArrayList<Map<ReplacementEffect, List<Map<AbilityKey, Object>>>>();

    public ReplacementHandler(Game gameState) {
        this.game = gameState;
    }

    public List<ReplacementEffect> getReplacementList(final ReplacementType event, final Map<AbilityKey, Object> runParams, final ReplacementLayer layer) {
        final CardCollection preList = new CardCollection();
        boolean checkAgain = false;
        Card affectedLKI = null;
        Card affectedCard = null;
        if (ReplacementType.Moved.equals((Object)event) && ZoneType.Battlefield.equals(runParams.get((Object)AbilityKey.Destination))) {
            ReplacementEffect causeRE = (ReplacementEffect)runParams.get((Object)AbilityKey.ReplacementEffect);
            if (causeRE != null && ReplacementType.Moved.equals((Object)causeRE.getMode()) && layer.equals((Object)causeRE.getLayer()) && !causeRE.getOtherChoices().isEmpty()) {
                return causeRE.getOtherChoices();
            }
            affectedCard = (Card)runParams.get((Object)AbilityKey.Affected);
            affectedLKI = CardCopyService.getLKICopy(affectedCard);
            affectedLKI.setLastKnownZone(affectedCard.getController().getZone(ZoneType.Battlefield));
            Map etbCounters = (Map)runParams.get((Object)AbilityKey.CounterMap);
            affectedLKI.putEtbCounters(etbCounters);
            preList.add(affectedLKI);
            this.game.getAction().checkStaticAbilities(false, Sets.newHashSet(affectedLKI), preList);
            checkAgain = true;
            runParams.put(AbilityKey.Affected, affectedLKI);
        }
        final ArrayList<ReplacementEffect> possibleReplacers = Lists.newArrayList();
        this.game.forEachCardInGame(new Visitor<Card>(){

            @Override
            public boolean visit(Card crd) {
                boolean noLKIstate;
                Card c = preList.get(crd);
                Zone cardZone = ReplacementHandler.this.game.getZoneOf(c);
                boolean bl = noLKIstate = c != crd || event != ReplacementType.Moved || c.isImmutable() || runParams.get((Object)AbilityKey.LastStateBattlefield) == null;
                if (!noLKIstate) {
                    Card lastState = ((CardCollectionView)runParams.get((Object)AbilityKey.LastStateBattlefield)).get(c);
                    if (lastState != c) {
                        c = lastState;
                        cardZone = lastState.getLastKnownZone();
                    } else if (cardZone != null && cardZone.is(ZoneType.Battlefield)) {
                        return true;
                    }
                }
                for (ReplacementEffect replacementEffect : c.getReplacementEffects()) {
                    if (replacementEffect.hasRun() || ReplacementHandler.this.hasRun.contains(replacementEffect) || layer != null && replacementEffect.getLayer() != layer || !replacementEffect.modeCheck(event, runParams) || possibleReplacers.contains(replacementEffect) || !replacementEffect.zonesCheck(cardZone) || !replacementEffect.requirementsCheck(ReplacementHandler.this.game) || !replacementEffect.canReplace(runParams)) continue;
                    possibleReplacers.add(replacementEffect);
                }
                return true;
            }
        }, affectedCard != null && affectedCard.isInZone(ZoneType.Sideboard));
        if (checkAgain) {
            if (affectedLKI != null && affectedCard != null) {
                for (ReplacementEffect re : affectedLKI.getReplacementEffects()) {
                    re.setHostCard(affectedCard);
                }
                affectedCard.setStoredKeywords(affectedLKI.getStoredKeywords(), true);
                affectedCard.setStoredReplacements(affectedLKI.getStoredReplacements());
                if (affectedCard.getCastSA() != null && affectedCard.getCastSA().getKeyword() != null) {
                    affectedCard.addKeywordForStaticAbility(affectedCard.getCastSA().getKeyword());
                }
                runParams.put(AbilityKey.Affected, affectedCard);
                runParams.put(AbilityKey.NewCard, CardCopyService.getLKICopy(affectedLKI));
            }
            this.game.getAction().checkStaticAbilities(false);
        }
        return possibleReplacers;
    }

    public boolean cantHappenCheck(ReplacementType event, Map<AbilityKey, Object> runParams) {
        return !this.getReplacementList(event, runParams, ReplacementLayer.CantHappen).isEmpty();
    }

    public ReplacementResult run(ReplacementType event, Map<AbilityKey, Object> runParams) {
        Object affected = runParams.get((Object)AbilityKey.Affected);
        Player decider = null;
        decider = affected instanceof Player ? (Player)affected : ((Card)affected).getController();
        for (ReplacementLayer layer : ReplacementLayer.values()) {
            ReplacementResult res = this.run(event, runParams, layer, decider);
            if (res == ReplacementResult.NotReplaced) continue;
            return res;
        }
        return ReplacementResult.NotReplaced;
    }

    private ReplacementResult run(ReplacementType event, Map<AbilityKey, Object> runParams, ReplacementLayer layer, Player decider) {
        List<ReplacementEffect> possibleReplacers = this.getReplacementList(event, runParams, layer);
        if (possibleReplacers.isEmpty()) {
            return ReplacementResult.NotReplaced;
        }
        ReplacementEffect chosenRE = layer == ReplacementLayer.CantHappen ? possibleReplacers.get(0) : decider.getController().chooseSingleReplacementEffect(possibleReplacers);
        possibleReplacers.remove(chosenRE);
        chosenRE.setHasRun(true);
        this.hasRun.add(chosenRE);
        chosenRE.setOtherChoices(possibleReplacers);
        ReplacementResult res = this.executeReplacement(runParams, chosenRE, decider);
        if (res == ReplacementResult.NotReplaced) {
            if (!possibleReplacers.isEmpty()) {
                res = this.run(event, runParams);
            }
            chosenRE.setHasRun(false);
            this.hasRun.remove(chosenRE);
            chosenRE.setOtherChoices(null);
            return res;
        }
        String message = chosenRE.getDescription();
        if (!StringUtils.isEmpty(message)) {
            this.game.getGameLog().add(GameLogEntryType.EFFECT_REPLACED, message);
        }
        if (res == ReplacementResult.Updated) {
            EnumMap<AbilityKey, Object> params = AbilityKey.newMap(runParams);
            if (params.containsKey((Object)AbilityKey.EffectOnly)) {
                params.put(AbilityKey.EffectOnly, (Object)true);
            }
            ReplacementResult result = this.run(event, params);
            switch (result) {
                case NotReplaced: 
                case Updated: {
                    runParams.putAll(params);
                    runParams.put(AbilityKey.ReplacementResult, (Object)ReplacementResult.Updated);
                    break;
                }
                default: {
                    res = result;
                    runParams.put(AbilityKey.ReplacementResult, (Object)result);
                }
            }
        }
        chosenRE.setHasRun(false);
        this.hasRun.remove(chosenRE);
        chosenRE.setOtherChoices(null);
        return res;
    }

    private ReplacementResult executeReplacement(Map<AbilityKey, Object> runParams, ReplacementEffect replacementEffect, Player decider) {
        boolean isPrevent;
        SpellAbility effectSA = null;
        Card host = replacementEffect.getHostCard();
        if (host.hasAlternateState() || host.isFaceDown()) {
            host = this.game.getCardState(host);
        }
        if (replacementEffect.getOverridingAbility() == null && replacementEffect.hasParam("ReplaceWith")) {
            effectSA = AbilityFactory.getAbility(host, replacementEffect.getParam("ReplaceWith"), (IHasSVars)replacementEffect);
        } else if (replacementEffect.getOverridingAbility() != null) {
            effectSA = replacementEffect.getOverridingAbility();
        }
        if (effectSA != null) {
            SpellAbility tailend = effectSA;
            do {
                replacementEffect.setReplacingObjects(runParams, tailend);
                tailend.setReplacingObject(AbilityKey.OriginalParams, runParams);
                tailend.setReplacingObjectsFrom(runParams, AbilityKey.InternalTriggerTable, AbilityKey.SimultaneousETB);
            } while ((tailend = tailend.getSubAbility()) != null);
            effectSA.setLastStateBattlefield((CardCollectionView)ObjectUtils.firstNonNull(runParams.get((Object)AbilityKey.LastStateBattlefield), this.game.getLastStateBattlefield()));
            effectSA.setLastStateGraveyard((CardCollectionView)ObjectUtils.firstNonNull(runParams.get((Object)AbilityKey.LastStateGraveyard), this.game.getLastStateGraveyard()));
            if (replacementEffect.isIntrinsic()) {
                effectSA.setIntrinsic(true);
                effectSA.changeText();
            }
            effectSA.setReplacementEffect(replacementEffect);
        }
        if (replacementEffect.hasParam("Optional")) {
            Player optDecider = decider;
            if (replacementEffect.hasParam("OptionalDecider") && effectSA != null) {
                effectSA.setActivatingPlayer(host.getController());
                optDecider = (Player)AbilityUtils.getDefinedPlayers(host, replacementEffect.getParam("OptionalDecider"), effectSA).get(false);
            }
            String name = CardTranslation.getTranslatedName(MoreObjects.firstNonNull(host.getCardForUi(), host).getName());
            String effectDesc = TextUtil.fastReplace(replacementEffect.getDescription(), "CARDNAME", name);
            String question = runParams.containsKey((Object)AbilityKey.Card) ? Localizer.getInstance().getMessage("lblApplyCardReplacementEffectToCardConfirm", name, runParams.get((Object)AbilityKey.Card).toString(), effectDesc) : Localizer.getInstance().getMessage("lblApplyReplacementEffectOfCardConfirm", name, effectDesc);
            GameEntity affected = (GameEntity)runParams.get((Object)AbilityKey.Affected);
            boolean confirmed = optDecider.getController().confirmReplacementEffect(replacementEffect, effectSA, affected, question);
            if (!confirmed) {
                return ReplacementResult.NotReplaced;
            }
        }
        if ((isPrevent = "True".equals(replacementEffect.getParam("Prevent"))) || replacementEffect.hasParam("PreventionEffect")) {
            if (Boolean.TRUE.equals(runParams.get((Object)AbilityKey.NoPreventDamage))) {
                if (replacementEffect.hasParam("AlwaysReplace")) {
                    runParams.put(AbilityKey.PreventedAmount, runParams.get((Object)AbilityKey.DamageAmount));
                } else {
                    runParams.put(AbilityKey.PreventedAmount, 0);
                }
                return ReplacementResult.NotReplaced;
            }
            if (isPrevent) {
                return ReplacementResult.Prevented;
            }
        }
        if ("True".equals(replacementEffect.getParam("Skip"))) {
            return ReplacementResult.Skipped;
        }
        Player player = host.getController();
        if (effectSA != null) {
            ApiType apiType = effectSA.getApi();
            if (replacementEffect.getMode() != ReplacementType.DamageDone || apiType == ApiType.ReplaceDamage || apiType == ApiType.ReplaceSplitDamage || apiType == ApiType.ReplaceEffect) {
                player.getController().playSpellAbilityNoStack(effectSA, true);
            } else {
                runParams.put(AbilityKey.ReplacementResult, (Object)ReplacementResult.Replaced);
            }
            if (apiType == ApiType.ReplaceToken || apiType == ApiType.ReplaceEffect || apiType == ApiType.ReplaceMana) {
                runParams.put(AbilityKey.ReplacementResult, (Object)ReplacementResult.Updated);
            }
        }
        if (replacementEffect.hasParam("ReplacementResult")) {
            return ReplacementResult.valueOf(replacementEffect.getParam("ReplacementResult"));
        }
        if (runParams.containsKey((Object)AbilityKey.ReplacementResult)) {
            return (ReplacementResult)((Object)runParams.get((Object)AbilityKey.ReplacementResult));
        }
        return ReplacementResult.Replaced;
    }

    private void getPossibleReplaceDamageList(PlayerCollection players, boolean isCombat, CardDamageMap damageMap, SpellAbility cause) {
        for (Map.Entry et : damageMap.columnMap().entrySet()) {
            int playerIndex;
            GameEntity target = (GameEntity)et.getKey();
            int n = playerIndex = target instanceof Player ? players.indexOf((Player)target) : players.indexOf(((Card)target).getController());
            if (playerIndex == -1) continue;
            Map<ReplacementEffect, List<Map<AbilityKey, Object>>> replaceCandidateMap = this.replaceDamageList.get(playerIndex);
            for (Map.Entry e : et.getValue().entrySet()) {
                Card source = (Card)e.getKey();
                Integer damage = (Integer)e.getValue();
                if (damage <= 0) continue;
                boolean prevention = source.canDamagePrevented(isCombat) && (cause == null || !cause.hasParam("NoPrevention"));
                Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(target);
                repParams.put(AbilityKey.DamageSource, source);
                repParams.put(AbilityKey.DamageAmount, damage);
                repParams.put(AbilityKey.IsCombat, isCombat);
                repParams.put(AbilityKey.NoPreventDamage, !prevention);
                if (cause != null) {
                    repParams.put(AbilityKey.Cause, cause);
                }
                List<ReplacementEffect> reList = this.getReplacementList(ReplacementType.DamageDone, repParams, ReplacementLayer.Other);
                for (ReplacementEffect re : reList) {
                    if (!replaceCandidateMap.containsKey(re)) {
                        replaceCandidateMap.put(re, new ArrayList());
                    }
                    List<Map<AbilityKey, Object>> runParamList = replaceCandidateMap.get(re);
                    runParamList.add(repParams);
                }
            }
        }
    }

    private void runSingleReplaceDamageEffect(ReplacementEffect re, Map<AbilityKey, Object> runParams, Map<ReplacementEffect, List<Map<AbilityKey, Object>>> replaceCandidateMap, Map<ReplacementEffect, List<Map<AbilityKey, Object>>> executedDamageMap, Player decider, CardDamageMap damageMap, CardDamageMap preventMap) {
        String message;
        List<Map<AbilityKey, Object>> executedParamList = executedDamageMap.get(re);
        ApiType apiType = re.getOverridingAbility() != null ? re.getOverridingAbility().getApi() : null;
        Card source = (Card)runParams.get((Object)AbilityKey.DamageSource);
        GameEntity target = (GameEntity)runParams.get((Object)AbilityKey.Affected);
        int damage = (Integer)runParams.get((Object)AbilityKey.DamageAmount);
        Map<String, String> mapParams = re.getMapParams();
        ReplacementResult res = this.executeReplacement(runParams, re, decider);
        GameEntity newTarget = (GameEntity)runParams.get((Object)AbilityKey.Affected);
        int newDamage = (Integer)runParams.get((Object)AbilityKey.DamageAmount);
        EnumMap<AbilityKey, Object> oldParams = null;
        if (res != ReplacementResult.NotReplaced) {
            Iterator<Map.Entry<ReplacementEffect, List<Map<AbilityKey, Object>>>> itr = replaceCandidateMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<ReplacementEffect, List<Map<AbilityKey, Object>>> entry = itr.next();
                if (entry.getKey() == re || !entry.getValue().contains(runParams)) continue;
                entry.getValue().remove(runParams);
                if (!entry.getValue().isEmpty()) continue;
                itr.remove();
            }
            if (res == ReplacementResult.Updated || apiType == ApiType.ReplaceSplitDamage) {
                Map<ReplacementEffect, List<Map<AbilityKey, Object>>> newReplaceCandidateMap = replaceCandidateMap;
                if (!target.equals(newTarget)) {
                    PlayerCollection players = this.game.getPlayersInTurnOrder();
                    int playerIndex = newTarget instanceof Player ? players.indexOf((Player)newTarget) : players.indexOf(((Card)newTarget).getController());
                    newReplaceCandidateMap = this.replaceDamageList.get(playerIndex);
                }
                List<ReplacementEffect> reList = this.getReplacementList(ReplacementType.DamageDone, runParams, ReplacementLayer.Other);
                for (ReplacementEffect newRE : reList) {
                    if (executedDamageMap.containsKey(newRE) && executedDamageMap.get(newRE).contains(runParams)) continue;
                    if (!newReplaceCandidateMap.containsKey(newRE)) {
                        newReplaceCandidateMap.put(newRE, new ArrayList());
                    }
                    List<Map<AbilityKey, Object>> runParamList = newReplaceCandidateMap.get(newRE);
                    runParamList.add(runParams);
                }
            }
            if (apiType == ApiType.ReplaceSplitDamage && res == ReplacementResult.Updated) {
                oldParams = AbilityKey.newMap(runParams);
                oldParams.put(AbilityKey.Affected, (Object)target);
                oldParams.put(AbilityKey.DamageAmount, (Object)(damage - newDamage));
                List<ReplacementEffect> reList = this.getReplacementList(ReplacementType.DamageDone, oldParams, ReplacementLayer.Other);
                for (ReplacementEffect newRE : reList) {
                    if (!replaceCandidateMap.containsKey(newRE)) {
                        replaceCandidateMap.put(newRE, new ArrayList());
                    }
                    List<Map<AbilityKey, Object>> runParamList = replaceCandidateMap.get(newRE);
                    runParamList.add(oldParams);
                }
            }
        }
        Map resultMap = (Map)runParams.get((Object)AbilityKey.ReplacementResultMap);
        resultMap.put(re, res);
        switch (res) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                if (target.equals(newTarget)) {
                    damageMap.put(source, target, newDamage - damage);
                } else if (apiType == ApiType.ReplaceSplitDamage) {
                    damageMap.put(source, target, -newDamage);
                }
                if (!target.equals(newTarget)) {
                    if (apiType != ApiType.ReplaceSplitDamage) {
                        damageMap.remove(source, target);
                    }
                    damageMap.put(source, newTarget, newDamage);
                }
                if (apiType != ApiType.ReplaceDamage) break;
                preventMap.put(source, target, damage - newDamage);
                runParams.put(AbilityKey.PreventedAmount, damage - newDamage);
                break;
            }
            default: {
                damageMap.remove(source, target);
                if (apiType == ApiType.ReplaceDamage || mapParams.containsKey("Prevent") && mapParams.get("Prevent").equals("True") || mapParams.containsKey("PreventionEffect")) {
                    preventMap.put(source, target, damage);
                    runParams.put(AbilityKey.PreventedAmount, damage);
                }
                if (apiType != ApiType.ReplaceSplitDamage) break;
                damageMap.put(source, newTarget, newDamage);
            }
        }
        executedParamList.add(runParams);
        if (apiType == ApiType.ReplaceSplitDamage) {
            executedParamList.add(oldParams);
        }
        if (res != ReplacementResult.NotReplaced && !StringUtils.isEmpty(message = re.getDescription())) {
            this.game.getGameLog().add(GameLogEntryType.EFFECT_REPLACED, message);
        }
    }

    private void executeReplaceDamageBufferedSA(Map<ReplacementEffect, List<Map<AbilityKey, Object>>> executedDamageMap) {
        for (Map.Entry<ReplacementEffect, List<Map<AbilityKey, Object>>> entry : executedDamageMap.entrySet()) {
            boolean executePerTarget;
            List<Map<AbilityKey, Object>> executedParamList;
            SpellAbility bufferedSA;
            ApiType apiType;
            ReplacementEffect re = entry.getKey();
            if (re.getOverridingAbility() == null || ((apiType = (bufferedSA = re.getOverridingAbility()).getApi()) == ApiType.ReplaceDamage || apiType == ApiType.ReplaceSplitDamage || apiType == ApiType.ReplaceEffect) && (bufferedSA = bufferedSA.getSubAbility()) == null || (executedParamList = entry.getValue()).isEmpty()) continue;
            Map<String, String> mapParams = re.getMapParams();
            boolean isPrevention = mapParams.containsKey("Prevent") && mapParams.get("Prevent").equals("True") || mapParams.containsKey("PreventionEffect");
            boolean executePerSource = mapParams.containsKey("ExecuteMode") && mapParams.get("ExecuteMode").equals("PerSource");
            boolean bl = executePerTarget = mapParams.containsKey("ExecuteMode") && mapParams.get("ExecuteMode").equals("PerTarget");
            while (!executedParamList.isEmpty()) {
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                ArrayList<Card> damageSourceList = new ArrayList<Card>();
                ArrayList<GameEntity> affectedList = new ArrayList<GameEntity>();
                int damageSum = 0;
                Iterator<Map<AbilityKey, Object>> itr = executedParamList.iterator();
                while (itr.hasNext()) {
                    Map<AbilityKey, Object> executedParams = itr.next();
                    Map resultMap = (Map)executedParams.get((Object)AbilityKey.ReplacementResultMap);
                    ReplacementResult res = (ReplacementResult)((Object)resultMap.get(re));
                    if (res == ReplacementResult.NotReplaced && (!isPrevention || Boolean.FALSE.equals(executedParams.get((Object)AbilityKey.NoPreventDamage)))) {
                        itr.remove();
                        continue;
                    }
                    Card source = (Card)executedParams.get((Object)AbilityKey.DamageSource);
                    if (executePerSource && !damageSourceList.isEmpty() && !damageSourceList.contains(source)) continue;
                    GameEntity target = (GameEntity)executedParams.get((Object)AbilityKey.Affected);
                    if (executePerTarget && !affectedList.isEmpty() && !affectedList.contains(target)) continue;
                    itr.remove();
                    int damage = (Integer)executedParams.get((Object)(isPrevention ? AbilityKey.PreventedAmount : AbilityKey.DamageAmount));
                    if (!damageSourceList.contains(source)) {
                        damageSourceList.add(source);
                    }
                    if (!affectedList.contains(target)) {
                        affectedList.add(target);
                    }
                    damageSum += damage;
                }
                if (damageSum <= 0) continue;
                runParams.put(AbilityKey.DamageSource, damageSourceList.size() > 1 ? damageSourceList : damageSourceList.get(0));
                runParams.put(AbilityKey.Affected, affectedList.size() > 1 ? affectedList : affectedList.get(0));
                runParams.put(AbilityKey.DamageAmount, Integer.valueOf(damageSum));
                re.setReplacingObjects(runParams, re.getOverridingAbility());
                bufferedSA.setActivatingPlayer(re.getHostCard().getController());
                AbilityUtils.resolve(bufferedSA);
            }
        }
    }

    public void runReplaceDamage(boolean isCombat, CardDamageMap damageMap, CardDamageMap preventMap, GameEntityCounterTable counterTable, SpellAbility cause) {
        PlayerCollection players = this.game.getPlayersInTurnOrder();
        for (int i = 0; i < players.size(); ++i) {
            this.replaceDamageList.add(new HashMap());
        }
        HashMap<ReplacementEffect, List<Map<AbilityKey, Object>>> executedDamageMap = new HashMap<ReplacementEffect, List<Map<AbilityKey, Object>>>();
        this.getPossibleReplaceDamageList(players, isCombat, damageMap, cause);
        while (true) {
            Player decider = null;
            Map<ReplacementEffect, List<Map<AbilityKey, Object>>> replaceCandidateMap = null;
            for (int i = 0; i < players.size(); ++i) {
                if (this.replaceDamageList.get(i).isEmpty()) continue;
                decider = (Player)players.get(i);
                replaceCandidateMap = this.replaceDamageList.get(i);
                break;
            }
            if (replaceCandidateMap == null) break;
            ArrayList<ReplacementEffect> possibleReplacers = new ArrayList<ReplacementEffect>(replaceCandidateMap.keySet());
            ReplacementEffect chosenRE = decider.getController().chooseSingleReplacementEffect(possibleReplacers);
            List runParamList = (List)replaceCandidateMap.get(chosenRE);
            if (!executedDamageMap.containsKey(chosenRE)) {
                executedDamageMap.put(chosenRE, new ArrayList());
            }
            chosenRE.setHasRun(true);
            SpellAbility effectSA = chosenRE.getOverridingAbility();
            ApiType apiType = null;
            SpellAbility bufferedSA = effectSA;
            boolean needRestoreSubSA = false;
            boolean needDivideShield = false;
            boolean needChooseSource = false;
            int shieldAmount = 0;
            if (effectSA != null) {
                Map<String, String> mapParams;
                apiType = effectSA.getApi();
                if ((apiType == ApiType.ReplaceDamage || apiType == ApiType.ReplaceSplitDamage || apiType == ApiType.ReplaceEffect) && (bufferedSA = effectSA.getSubAbility()) != null) {
                    needRestoreSubSA = true;
                    effectSA.setSubAbility(null);
                }
                if ((mapParams = chosenRE.getMapParams()).containsKey("PreventionEffect") && mapParams.get("PreventionEffect").equals("NextN") || apiType == ApiType.ReplaceSplitDamage) {
                    if (apiType == ApiType.ReplaceDamage) {
                        shieldAmount = AbilityUtils.calculateAmount(effectSA.getHostCard(), effectSA.getParamOrDefault("Amount", "1"), effectSA);
                    } else if (apiType == ApiType.ReplaceSplitDamage) {
                        shieldAmount = AbilityUtils.calculateAmount(effectSA.getHostCard(), effectSA.getParamOrDefault("VarName", "1"), effectSA);
                    }
                    int damageAmount = 0;
                    boolean hasMultipleSource = false;
                    boolean hasMultipleTarget = false;
                    Card firstSource = null;
                    GameEntity firstTarget = null;
                    for (Map runParams : runParamList) {
                        if (apiType == ApiType.ReplaceDamage && Boolean.TRUE.equals(runParams.get((Object)AbilityKey.NoPreventDamage))) continue;
                        damageAmount += ((Integer)runParams.get((Object)AbilityKey.DamageAmount)).intValue();
                        if (firstSource == null) {
                            firstSource = (Card)runParams.get((Object)AbilityKey.DamageSource);
                        } else if (!firstSource.equals(runParams.get((Object)AbilityKey.DamageSource))) {
                            hasMultipleSource = true;
                        }
                        if (firstTarget == null) {
                            firstTarget = (GameEntity)runParams.get((Object)AbilityKey.Affected);
                            continue;
                        }
                        if (firstTarget.equals(runParams.get((Object)AbilityKey.Affected))) continue;
                        hasMultipleTarget = true;
                    }
                    if (damageAmount > shieldAmount && runParamList.size() > 1) {
                        if (hasMultipleSource) {
                            needChooseSource = true;
                        }
                        if (effectSA.hasParam("DivideShield") && hasMultipleTarget) {
                            needDivideShield = true;
                        }
                    }
                }
            }
            Map<GameEntity, Integer> shieldMap = null;
            if (needDivideShield) {
                HashMap<GameEntity, Integer> affected = new HashMap<GameEntity, Integer>();
                for (Map runParams : runParamList) {
                    GameEntity target = (GameEntity)runParams.get((Object)AbilityKey.Affected);
                    Integer damage = (Integer)runParams.get((Object)AbilityKey.DamageAmount);
                    if (!affected.containsKey(target)) {
                        affected.put(target, damage);
                        continue;
                    }
                    affected.put(target, damage + (Integer)affected.get(target));
                }
                shieldMap = decider.getController().divideShield(chosenRE.getHostCard(), affected, shieldAmount);
            }
            if (needChooseSource) {
                CardCollection sourcesToChooseFrom = new CardCollection();
                for (Map runParams : runParamList) {
                    if (apiType == ApiType.ReplaceDamage && Boolean.TRUE.equals(runParams.get((Object)AbilityKey.NoPreventDamage))) continue;
                    sourcesToChooseFrom.add((Card)runParams.get((Object)AbilityKey.DamageSource));
                }
                String choiceTitle = Localizer.getInstance().getMessage("lblChooseSource", new Object[0]) + " ";
                while (shieldAmount > 0 && !sourcesToChooseFrom.isEmpty()) {
                    Card source = decider.getController().chooseSingleEntityForEffect(sourcesToChooseFrom, effectSA, choiceTitle, null);
                    sourcesToChooseFrom.remove(source);
                    Iterator itr = runParamList.iterator();
                    while (itr.hasNext()) {
                        Map runParams = (Map)itr.next();
                        if (!source.equals(runParams.get((Object)AbilityKey.DamageSource))) continue;
                        itr.remove();
                        if (shieldMap != null) {
                            GameEntity target = (GameEntity)runParams.get((Object)AbilityKey.Affected);
                            if (!shieldMap.containsKey(target) || shieldMap.get(target) <= 0) continue;
                            Integer dividedShieldAmount = shieldMap.get(target);
                            runParams.put(AbilityKey.DividedShieldAmount, dividedShieldAmount);
                            shieldAmount -= dividedShieldAmount.intValue();
                        } else {
                            shieldAmount -= ((Integer)runParams.get((Object)AbilityKey.DamageAmount)).intValue();
                        }
                        if (!runParams.containsKey((Object)AbilityKey.ReplacementResultMap)) {
                            HashMap resultMap = new HashMap();
                            runParams.put(AbilityKey.ReplacementResultMap, resultMap);
                        }
                        this.runSingleReplaceDamageEffect(chosenRE, runParams, replaceCandidateMap, executedDamageMap, decider, damageMap, preventMap);
                    }
                }
            } else {
                for (Map runParams : runParamList) {
                    if (shieldMap != null) {
                        GameEntity target = (GameEntity)runParams.get((Object)AbilityKey.Affected);
                        if (!shieldMap.containsKey(target) || shieldMap.get(target) <= 0) continue;
                        Integer dividedShieldAmount = shieldMap.get(target);
                        runParams.put(AbilityKey.DividedShieldAmount, dividedShieldAmount);
                    }
                    if (!runParams.containsKey((Object)AbilityKey.ReplacementResultMap)) {
                        HashMap resultMap = new HashMap();
                        runParams.put(AbilityKey.ReplacementResultMap, resultMap);
                    }
                    this.runSingleReplaceDamageEffect(chosenRE, runParams, replaceCandidateMap, executedDamageMap, decider, damageMap, preventMap);
                }
            }
            if (needRestoreSubSA) {
                effectSA.setSubAbility((AbilitySub)bufferedSA);
            }
            chosenRE.setHasRun(false);
            replaceCandidateMap.remove(chosenRE);
        }
        this.replaceDamageList.clear();
        this.executeReplaceDamageBufferedSA(executedDamageMap);
    }

    public static ReplacementEffect parseReplacement(String repParse, Card host, boolean intrinsic) {
        return ReplacementHandler.parseReplacement(repParse, host, intrinsic, (IHasSVars)host);
    }

    public static ReplacementEffect parseReplacement(String repParse, Card host, boolean intrinsic, IHasSVars sVarHolder) {
        return ReplacementHandler.parseReplacement(AbilityFactory.getMapParams(repParse), host, intrinsic, sVarHolder);
    }

    private static ReplacementEffect parseReplacement(Map<String, String> mapParams, Card host, boolean intrinsic, IHasSVars sVarHolder) {
        ReplacementType rt = ReplacementType.smartValueOf(mapParams.get("Event"));
        ReplacementEffect ret = rt.createReplacement(mapParams, host, intrinsic);
        String activeZones = mapParams.get("ActiveZones");
        if (null != activeZones) {
            ret.setActiveZone(EnumSet.copyOf(ZoneType.listValueOf(activeZones)));
        }
        if (mapParams.containsKey("ReplaceWith") && sVarHolder != null) {
            ret.setOverridingAbility(AbilityFactory.getAbility(host, mapParams.get("ReplaceWith"), sVarHolder));
        }
        if (sVarHolder instanceof CardState) {
            ret.setCardState((CardState)sVarHolder);
        } else if (sVarHolder instanceof CardTraitBase) {
            ret.setCardState(((CardTraitBase)sVarHolder).getCardState());
        }
        return ret;
    }

    public boolean wouldPhaseBeSkipped(Player player, String phase) {
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(player);
        repParams.put(AbilityKey.Phase, phase);
        List<ReplacementEffect> list = this.getReplacementList(ReplacementType.BeginPhase, repParams, ReplacementLayer.Control);
        return !list.isEmpty();
    }

    public boolean wouldExtraTurnBeSkipped(Player player) {
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(player);
        repParams.put(AbilityKey.ExtraTurn, true);
        List<ReplacementEffect> list = this.getReplacementList(ReplacementType.BeginTurn, repParams, ReplacementLayer.Other);
        return !list.isEmpty();
    }

    public int getTotalPreventionShieldAmount(final GameEntity o) {
        final ArrayList<ReplacementEffect> list = Lists.newArrayList();
        this.game.forEachCardInGame(new Visitor<Card>(){

            @Override
            public boolean visit(Card c) {
                for (ReplacementEffect re : c.getReplacementEffects()) {
                    if (re.getMode() != ReplacementType.DamageDone || re.getLayer() != ReplacementLayer.Other || !re.hasParam("PreventionEffect") || !re.zonesCheck(ReplacementHandler.this.game.getZoneOf(c)) || re.getOverridingAbility() == null || re.getOverridingAbility().getApi() != ApiType.ReplaceDamage || !re.matchesValidParam("ValidTarget", o)) continue;
                    list.add(re);
                }
                return true;
            }
        });
        int totalAmount = 0;
        for (ReplacementEffect re : list) {
            SpellAbility sa = re.getOverridingAbility();
            if (!sa.hasParam("Amount")) continue;
            String varValue = sa.getParam("Amount");
            if (StringUtils.isNumeric(varValue)) {
                totalAmount += Integer.parseInt(varValue);
                continue;
            }
            if (!(varValue = sa.getSVar(varValue)).startsWith("Number$")) continue;
            totalAmount += Integer.parseInt(varValue.substring(7));
        }
        return totalAmount;
    }

    public final boolean isPreventCombatDamageThisTurn() {
        final ArrayList list = Lists.newArrayList();
        this.game.forEachCardInGame(new Visitor<Card>(){

            @Override
            public boolean visit(Card c) {
                for (ReplacementEffect re : c.getReplacementEffects()) {
                    if (re.getMode() != ReplacementType.DamageDone || re.getLayer() != ReplacementLayer.Other || !re.hasParam("Prevent") || !re.getParam("Prevent").equals("True") || !re.hasParam("IsCombat") || !re.getParam("IsCombat").equals("True") || re.hasParam("ValidSource") || re.hasParam("ValidTarget") || !re.zonesCheck(ReplacementHandler.this.game.getZoneOf(c))) continue;
                    list.add(re);
                }
                return true;
            }
        });
        return !list.isEmpty();
    }

    public boolean isReplacing() {
        return !this.hasRun.isEmpty();
    }
}

