/*
 * Decompiled with CFR 0.152.
 */
package forge.game.replacement;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.SpellAbility;
import java.util.Map;

public class ReplaceUntap
extends ReplacementEffect {
    public ReplaceUntap(Map<String, String> params, Card host, boolean intrinsic) {
        super(params, host, intrinsic);
    }

    @Override
    public boolean canReplace(Map<AbilityKey, Object> runParams) {
        if (!this.matchesValidParam("ValidCard", runParams.get((Object)AbilityKey.Affected))) {
            return false;
        }
        if (this.hasParam("UntapStep")) {
            Object o = runParams.get((Object)AbilityKey.Affected);
            if (!(o instanceof Card)) {
                return false;
            }
            Card card = (Card)o;
            Player player = card.getController();
            if (!player.getGame().getPhaseHandler().is(PhaseType.UNTAP, player)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setReplacingObjects(Map<AbilityKey, Object> runParams, SpellAbility sa) {
        sa.setReplacingObject(AbilityKey.Card, runParams.get((Object)AbilityKey.Affected));
    }
}

