/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.LobbyPlayer;
import forge.card.mana.ManaAtom;
import forge.game.GameEntityView;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.trackable.TrackableCollection;
import forge.trackable.TrackableProperty;
import forge.trackable.Tracker;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PlayerView
extends GameEntityView {
    private static final long serialVersionUID = 7005892740909549086L;

    public static PlayerView get(Player p) {
        return p == null ? null : p.getView();
    }

    public static TrackableCollection<PlayerView> getCollection(Iterable<Player> players) {
        if (players == null) {
            return null;
        }
        TrackableCollection<PlayerView> collection = new TrackableCollection<PlayerView>();
        for (Player p : players) {
            collection.add(p.getView());
        }
        return collection;
    }

    public PlayerView(int id0, Tracker tracker) {
        super(id0, tracker);
        this.set(TrackableProperty.Mana, Maps.newHashMapWithExpectedSize(6));
    }

    public boolean isAI() {
        return (Boolean)this.get(TrackableProperty.IsAI);
    }

    void updateIsAI(Player p) {
        this.set(TrackableProperty.IsAI, p.getController().isAI());
    }

    public String getLobbyPlayerName() {
        return (String)this.get(TrackableProperty.LobbyPlayerName);
    }

    void updateLobbyPlayerName(Player p) {
        this.set(TrackableProperty.LobbyPlayerName, p.getLobbyPlayer().getName());
    }

    public boolean isLobbyPlayer(LobbyPlayer p) {
        return this.getLobbyPlayerName().equals(p.getName());
    }

    public int getAvatarIndex() {
        return (Integer)this.get(TrackableProperty.AvatarIndex);
    }

    void updateAvatarIndex(Player p) {
        this.set(TrackableProperty.AvatarIndex, p.getLobbyPlayer().getAvatarIndex());
    }

    public String getAvatarCardImageKey() {
        return (String)this.get(TrackableProperty.AvatarCardImageKey);
    }

    void updateAvatarCardImageKey(Player p) {
        this.set(TrackableProperty.AvatarCardImageKey, p.getLobbyPlayer().getAvatarCardImageKey());
    }

    public int getSleeveIndex() {
        return (Integer)this.get(TrackableProperty.SleeveIndex);
    }

    void updateSleeveIndex(Player p) {
        this.set(TrackableProperty.SleeveIndex, p.getLobbyPlayer().getSleeveIndex());
    }

    public String getCurrentPlaneName() {
        return (String)this.get(TrackableProperty.CurrentPlane);
    }

    void updateCurrentPlaneName(String plane) {
        this.set(TrackableProperty.CurrentPlane, plane);
    }

    public FCollectionView<PlayerView> getOpponents() {
        return MoreObjects.firstNonNull((FCollectionView)this.get(TrackableProperty.Opponents), new FCollection());
    }

    void updateOpponents(Player p) {
        this.set(TrackableProperty.Opponents, PlayerView.getCollection(p.getOpponents()));
    }

    public boolean isOpponentOf(PlayerView other) {
        return this.getOpponents().contains(other);
    }

    public final String getCommanderInfo(CardView v) {
        if (v == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Localizer.getInstance().getMessage("lblCommanderCastCard", String.valueOf(this.getCommanderCast(v))));
        sb.append("\n");
        for (PlayerView p : Iterables.concat(Collections.singleton(this), this.getOpponents())) {
            int damage = p.getCommanderDamage(v);
            if (damage <= 0) continue;
            sb.append(Localizer.getInstance().getMessage("lblCommanderDealNDamageToPlayer", p.toString(), CardTranslation.getTranslatedName(v.getName()), String.valueOf(damage)));
            sb.append("\n");
        }
        return sb.toString();
    }

    public final List<String> getPlayerCommanderInfo() {
        List<CardView> commanders = this.getCommanders();
        if (commanders == null || commanders.isEmpty()) {
            return Collections.emptyList();
        }
        FCollectionView<PlayerView> opponents = this.getOpponents();
        for (PlayerView opponent : opponents) {
            if (opponent.getCommanders() != null) continue;
            return Collections.emptyList();
        }
        ArrayList<String> info = Lists.newArrayListWithExpectedSize(opponents.size());
        info.add("Commanders:");
        for (CardView v : commanders) {
            info.add(Localizer.getInstance().getMessage("lblCommanderCastPlayer", CardTranslation.getTranslatedName(v.getName()), String.valueOf(this.getCommanderCast(v))));
        }
        for (CardView v : commanders) {
            int damage = this.getCommanderDamage(v);
            if (damage <= 0) continue;
            info.add(Localizer.getInstance().getMessage("lblNCommanderDamageFromOwnCommander", CardTranslation.getTranslatedName(v.getName()), String.valueOf(damage)));
        }
        for (PlayerView p : opponents) {
            for (CardView v : p.getCommanders()) {
                int damage = this.getCommanderDamage(v);
                if (damage <= 0) continue;
                info.add(Localizer.getInstance().getMessage("lblNCommanderDamageFromPlayerCommander", p.toString(), CardTranslation.getTranslatedName(v.getName()), String.valueOf(damage)));
            }
        }
        return info;
    }

    public String toString() {
        return this.getName();
    }

    public int getLife() {
        return (Integer)this.get(TrackableProperty.Life);
    }

    void updateLife(Player p) {
        this.set(TrackableProperty.Life, p.getLife());
    }

    public Map<CounterType, Integer> getCounters() {
        return (Map)this.get(TrackableProperty.Counters);
    }

    public int getCounters(CounterType counterType) {
        Integer count;
        Map<CounterType, Integer> counters = this.getCounters();
        if (counters != null && (count = counters.get(counterType)) != null) {
            return count;
        }
        return 0;
    }

    public int getCounters(CounterEnumType counterType) {
        return this.getCounters(CounterType.get(counterType));
    }

    void updateCounters(Player p) {
        this.set(TrackableProperty.Counters, p.getCounters());
    }

    public boolean getIsExtraTurn() {
        return (Boolean)this.get(TrackableProperty.IsExtraTurn);
    }

    public void setIsExtraTurn(boolean val) {
        this.set(TrackableProperty.IsExtraTurn, val);
    }

    public boolean getHasLost() {
        if (this.get(TrackableProperty.HasLost) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.HasLost);
    }

    public void setHasLost(boolean val) {
        this.set(TrackableProperty.HasLost, val);
    }

    public int getAvatarLifeDifference() {
        return (Integer)this.get(TrackableProperty.AvatarLifeDifference);
    }

    public boolean wasAvatarLifeChanged() {
        if ((Integer)this.get(TrackableProperty.AvatarLifeDifference) == 0) {
            return false;
        }
        return (Integer)this.get(TrackableProperty.AvatarLifeDifference) != 0;
    }

    public void setAvatarLifeDifference(int val) {
        this.set(TrackableProperty.AvatarLifeDifference, val);
    }

    public int getExtraTurnCount() {
        return (Integer)this.get(TrackableProperty.ExtraTurnCount);
    }

    public void setExtraTurnCount(int val) {
        this.set(TrackableProperty.ExtraTurnCount, val);
    }

    public boolean getHasPriority() {
        return (Boolean)this.get(TrackableProperty.HasPriority);
    }

    public void setHasPriority(boolean val) {
        this.set(TrackableProperty.HasPriority, val);
    }

    public int getMaxHandSize() {
        return (Integer)this.get(TrackableProperty.MaxHandSize);
    }

    void updateMaxHandSize(Player p) {
        this.set(TrackableProperty.MaxHandSize, p.getMaxHandSize());
    }

    public boolean hasUnlimitedHandSize() {
        return (Boolean)this.get(TrackableProperty.HasUnlimitedHandSize);
    }

    void updateUnlimitedHandSize(Player p) {
        this.set(TrackableProperty.HasUnlimitedHandSize, p.isUnlimitedHandSize());
    }

    public String getMaxHandString() {
        return this.hasUnlimitedHandSize() ? Localizer.getInstance().getMessage("lblUnlimited", new Object[0]) : String.valueOf(this.getMaxHandSize());
    }

    public int getMaxLandPlay() {
        return (Integer)this.get(TrackableProperty.MaxLandPlay);
    }

    void updateMaxLandPlay(Player p) {
        this.set(TrackableProperty.MaxLandPlay, p.getMaxLandPlays());
    }

    public boolean hasUnlimitedLandPlay() {
        return (Boolean)this.get(TrackableProperty.HasUnlimitedLandPlay);
    }

    void updateUnlimitedLandPlay(Player p) {
        this.set(TrackableProperty.HasUnlimitedLandPlay, p.getMaxLandPlaysInfinite());
    }

    public String getMaxLandString() {
        return this.hasUnlimitedLandPlay() ? "unlimited" : String.valueOf(this.getMaxLandPlay());
    }

    public int getNumLandThisTurn() {
        return (Integer)this.get(TrackableProperty.NumLandThisTurn);
    }

    void updateNumLandThisTurn(Player p) {
        this.set(TrackableProperty.NumLandThisTurn, p.getLandsPlayedThisTurn());
    }

    public int getNumManaShards() {
        return (Integer)this.get(TrackableProperty.NumManaShards);
    }

    void updateNumManaShards(Player p) {
        this.set(TrackableProperty.NumManaShards, p.getNumManaShards());
    }

    public Map<String, String> getDraftNotes() {
        return (Map)this.get(TrackableProperty.DraftNotes);
    }

    public void setDraftNotes(Map<String, String> draftNotes) {
        this.set(TrackableProperty.DraftNotes, draftNotes);
    }

    public int getNumDrawnThisTurn() {
        return (Integer)this.get(TrackableProperty.NumDrawnThisTurn);
    }

    void updateNumDrawnThisTurn(Player p) {
        this.set(TrackableProperty.NumDrawnThisTurn, p.getNumDrawnThisTurn());
    }

    public int getAdditionalVote() {
        return (Integer)this.get(TrackableProperty.AdditionalVote);
    }

    public void updateAdditionalVote(Player p) {
        this.set(TrackableProperty.AdditionalVote, p.getAdditionalVotesAmount());
    }

    public int getOptionalAdditionalVote() {
        return (Integer)this.get(TrackableProperty.OptionalAdditionalVote);
    }

    public void updateOptionalAdditionalVote(Player p) {
        this.set(TrackableProperty.OptionalAdditionalVote, p.getAdditionalOptionalVotesAmount());
    }

    public boolean getControlVote() {
        return (Boolean)this.get(TrackableProperty.ControlVotes);
    }

    public void updateControlVote(boolean val) {
        this.set(TrackableProperty.ControlVotes, val);
    }

    public int getAdditionalVillainousChoices() {
        return (Integer)this.get(TrackableProperty.AdditionalVillainousChoices);
    }

    public void updateAdditionalVillainousChoices(Player p) {
        this.set(TrackableProperty.AdditionalVillainousChoices, p.getAdditionalVotesAmount());
    }

    public ImmutableMultiset<String> getKeywords() {
        return (ImmutableMultiset)this.get(TrackableProperty.Keywords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDisplayableKeywords() {
        ArrayList<String> allKws;
        ImmutableMultiset<String> kws;
        ImmutableMultiset<String> immutableMultiset = kws = this.getKeywords();
        synchronized (immutableMultiset) {
            allKws = Lists.newArrayList(kws.elementSet());
        }
        return allKws;
    }

    public boolean hasKeyword(String keyword) {
        return this.getKeywords().contains(keyword);
    }

    void updateKeywords(Player p) {
        this.set(TrackableProperty.Keywords, ImmutableMultiset.copyOf(p.getKeywords().asStringList()));
    }

    public List<CardView> getCommanders() {
        return (List)this.get(TrackableProperty.Commander);
    }

    void updateCommander(Player p) {
        this.set(TrackableProperty.Commander, CardView.getCollection(p.getCommanders()));
    }

    public int getCommanderDamage(CardView commander) {
        Map map = (Map)this.get(TrackableProperty.CommanderDamage);
        if (map == null) {
            return 0;
        }
        Integer damage = (Integer)map.get(commander.getId());
        return damage == null ? 0 : damage;
    }

    void updateCommanderDamage(Player p) {
        HashMap<Integer, Integer> map = Maps.newHashMap();
        for (Map.Entry<Card, Integer> entry : p.getCommanderDamage()) {
            map.put(entry.getKey().getId(), entry.getValue());
        }
        this.set(TrackableProperty.CommanderDamage, map);
    }

    void updateMergedCommanderDamage(Card card, Card commander) {
        for (PlayerView p : Iterables.concat(Collections.singleton(this), this.getOpponents())) {
            Map map = (Map)p.get(TrackableProperty.CommanderDamage);
            if (map == null) continue;
            Integer damage = (Integer)map.get(commander.getId());
            map.put(card.getId(), damage);
        }
    }

    public int getCommanderCast(CardView commander) {
        Map map = (Map)this.get(TrackableProperty.CommanderCast);
        if (map == null) {
            return 0;
        }
        Integer damage = (Integer)map.get(commander.getId());
        return damage == null ? 0 : damage;
    }

    void updateCommanderCast(Player p, Card c) {
        HashMap<Integer, Integer> map = (HashMap<Integer, Integer>)this.get(TrackableProperty.CommanderCast);
        if (map == null) {
            map = Maps.newHashMap();
        }
        map.put(c.getId(), p.getCommanderCast(c));
        this.set(TrackableProperty.CommanderCast, map);
    }

    void updateMergedCommanderCast(Player p, Card target, Card commander) {
        HashMap<Integer, Integer> map = (HashMap<Integer, Integer>)this.get(TrackableProperty.CommanderCast);
        if (map == null) {
            map = Maps.newHashMap();
        }
        map.put(target.getId(), p.getCommanderCast(commander));
        this.set(TrackableProperty.CommanderCast, map);
    }

    public PlayerView getMindSlaveMaster() {
        return (PlayerView)this.get(TrackableProperty.MindSlaveMaster);
    }

    void updateMindSlaveMaster(Player p) {
        this.set(TrackableProperty.MindSlaveMaster, PlayerView.get(p.getControllingPlayer()));
    }

    public FCollectionView<CardView> getAnte() {
        return (FCollectionView)this.get(TrackableProperty.Ante);
    }

    public int getAnteSize() {
        return this.getZoneSize(TrackableProperty.Ante);
    }

    public FCollectionView<CardView> getBattlefield() {
        return (FCollectionView)this.get(TrackableProperty.Battlefield);
    }

    public int getBattlefieldSize() {
        return this.getZoneSize(TrackableProperty.Battlefield);
    }

    public FCollectionView<CardView> getCommand() {
        return (FCollectionView)this.get(TrackableProperty.Command);
    }

    public int getCommandSize() {
        return this.getZoneSize(TrackableProperty.Command);
    }

    public FCollectionView<CardView> getExile() {
        return (FCollectionView)this.get(TrackableProperty.Exile);
    }

    public int getExileSize() {
        return this.getZoneSize(TrackableProperty.Exile);
    }

    public FCollectionView<CardView> getFlashback() {
        return (FCollectionView)this.get(TrackableProperty.Flashback);
    }

    public int getFlashbackSize() {
        return this.getZoneSize(TrackableProperty.Flashback);
    }

    public FCollectionView<CardView> getGraveyard() {
        return (FCollectionView)this.get(TrackableProperty.Graveyard);
    }

    public int getGraveyardSize() {
        return this.getZoneSize(TrackableProperty.Graveyard);
    }

    public FCollectionView<CardView> getHand() {
        return (FCollectionView)this.get(TrackableProperty.Hand);
    }

    public int getHandSize() {
        return this.getZoneSize(TrackableProperty.Hand);
    }

    public FCollectionView<CardView> getLibrary() {
        return (FCollectionView)this.get(TrackableProperty.Library);
    }

    public int getLibrarySize() {
        return this.getZoneSize(TrackableProperty.Library);
    }

    public FCollectionView<CardView> getSideboard() {
        return (FCollectionView)this.get(TrackableProperty.Sideboard);
    }

    public int getSideboardSize() {
        return this.getZoneSize(TrackableProperty.Sideboard);
    }

    public FCollectionView<CardView> getCards(ZoneType zone) {
        TrackableProperty prop = PlayerView.getZoneProp(zone);
        if (prop != null) {
            return (FCollectionView)this.get(prop);
        }
        return null;
    }

    private int getZoneSize(TrackableProperty zoneProp) {
        TrackableCollection cards = (TrackableCollection)this.get(zoneProp);
        return cards == null ? 0 : cards.size();
    }

    public int getZoneTypes(TrackableProperty zoneProp) {
        TrackableCollection cards = (TrackableCollection)this.get(zoneProp);
        HashSet types = new HashSet();
        if (cards == null) {
            return 0;
        }
        for (CardView c : cards) {
            types.addAll((Collection)c.getCurrentState().getType().getCoreTypes());
        }
        return types.size();
    }

    public boolean hasDelirium() {
        if (this.get(TrackableProperty.HasDelirium) == null) {
            return false;
        }
        return (Boolean)this.get(TrackableProperty.HasDelirium);
    }

    private static TrackableProperty getZoneProp(ZoneType zone) {
        switch (zone) {
            case Ante: {
                return TrackableProperty.Ante;
            }
            case Battlefield: {
                return TrackableProperty.Battlefield;
            }
            case Command: {
                return TrackableProperty.Command;
            }
            case Exile: {
                return TrackableProperty.Exile;
            }
            case Graveyard: {
                return TrackableProperty.Graveyard;
            }
            case Hand: {
                return TrackableProperty.Hand;
            }
            case Library: {
                return TrackableProperty.Library;
            }
            case Flashback: {
                return TrackableProperty.Flashback;
            }
            case Sideboard: {
                return TrackableProperty.Sideboard;
            }
        }
        return null;
    }

    void updateZone(PlayerZone zone) {
        TrackableProperty prop = PlayerView.getZoneProp(zone.getZoneType());
        if (prop == null) {
            return;
        }
        this.set(prop, CardView.getCollection(zone.getCards(false)));
        if (ZoneType.Graveyard == zone.getZoneType()) {
            this.set(TrackableProperty.HasDelirium, this.getZoneTypes(TrackableProperty.Graveyard) >= 4);
        }
        switch (zone.getZoneType()) {
            case Command: 
            case Exile: 
            case Graveyard: 
            case Library: {
                this.set(TrackableProperty.Flashback, CardView.getCollection(zone.getPlayer().getCardsIn(ZoneType.Flashback)));
                break;
            }
        }
    }

    void updateFlashbackForPlayer(Player p) {
        this.set(TrackableProperty.Flashback, CardView.getCollection(p.getCardsIn(ZoneType.Flashback)));
    }

    public int getMana(byte color) {
        Integer count = null;
        try {
            count = this.getMana().get(color);
        }
        catch (Exception e) {
            e.printStackTrace();
            count = null;
        }
        return count != null ? count : 0;
    }

    private Map<Byte, Integer> getMana() {
        return (Map)this.get(TrackableProperty.Mana);
    }

    void updateMana(Player p) {
        HashMap<Byte, Integer> mana = new HashMap<Byte, Integer>();
        for (byte b : ManaAtom.MANATYPES) {
            mana.put(b, p.getManaPool().getAmountOfColor(b));
        }
        this.set(TrackableProperty.Mana, mana);
    }

    private List<String> getDetailsList() {
        FCollectionView<CardView> ante;
        ArrayList<String> details = Lists.newArrayListWithCapacity(8);
        details.add(Localizer.getInstance().getMessage("lblLifeHas", String.valueOf(this.getLife())));
        Map<CounterType, Integer> counters = this.getCounters();
        if (counters != null) {
            for (Map.Entry<CounterType, Integer> p : counters.entrySet()) {
                if (p.getValue() <= 0) continue;
                details.add(Localizer.getInstance().getMessage("lblTypeCounterHas", p.getKey().getName(), String.valueOf(p.getValue())));
            }
        }
        details.add(Localizer.getInstance().getMessage("lblCardInHandHas", String.valueOf(this.getHandSize()), this.getMaxHandString()));
        details.add(Localizer.getInstance().getMessage("lblLandsPlayed", String.valueOf(this.getNumLandThisTurn()), this.getMaxLandString()));
        details.add(Localizer.getInstance().getMessage("lblCardDrawnThisTurnHas", String.valueOf(this.getNumDrawnThisTurn())));
        details.add(Localizer.getInstance().getMessage("lblDamagepreventionHas", String.valueOf(this.getPreventNextDamage())));
        int v = this.getAdditionalVote();
        if (v > 0) {
            details.add(Localizer.getInstance().getMessage("lblAdditionalVotes", String.valueOf(v)));
        }
        if ((v = this.getOptionalAdditionalVote()) > 0) {
            details.add(Localizer.getInstance().getMessage("lblOptionalAdditionalVotes", String.valueOf(v)));
        }
        if (this.getControlVote()) {
            details.add(Localizer.getInstance().getMessage("lblControlsVote", new Object[0]));
        }
        if (this.getIsExtraTurn()) {
            details.add(Localizer.getInstance().getMessage("lblIsExtraTurn", new Object[0]));
        }
        details.add(Localizer.getInstance().getMessage("lblExtraTurnCountHas", String.valueOf(this.getExtraTurnCount())));
        String keywords = Lang.joinHomogenous(this.getDisplayableKeywords());
        if (!keywords.isEmpty()) {
            details.add(keywords);
        }
        if ((ante = this.getAnte()) != null && !ante.isEmpty()) {
            details.add(Localizer.getInstance().getMessage("lblAntedHas", Lang.joinHomogenous(ante)));
        }
        details.addAll(this.getPlayerCommanderInfo());
        return details;
    }

    public String getDetails() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append('\n');
        for (String detailsPart : this.getDetailsList()) {
            builder.append(detailsPart);
            builder.append('\n');
        }
        return builder.toString();
    }

    public String getDetailsHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append(this.getName());
        builder.append("<hr/>");
        for (String line : this.getDetailsList()) {
            builder.append(line);
            builder.append("<br/>");
        }
        builder.append("</html>");
        return builder.toString();
    }
}

