/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import forge.game.player.GameLossReason;
import forge.util.Localizer;

public class PlayerOutcome {
    public final String altWinSourceName;
    public final GameLossReason lossState;
    public final String loseConditionSpell;

    private PlayerOutcome(String altWinSourceName, GameLossReason lossState, String loseConditionSpell) {
        this.altWinSourceName = altWinSourceName;
        this.loseConditionSpell = loseConditionSpell;
        this.lossState = lossState;
    }

    public static PlayerOutcome win() {
        return new PlayerOutcome(null, null, null);
    }

    public static PlayerOutcome draw() {
        return new PlayerOutcome(null, GameLossReason.IntentionalDraw, null);
    }

    public static PlayerOutcome altWin(String sourceName) {
        return new PlayerOutcome(sourceName, null, null);
    }

    public static PlayerOutcome loss(GameLossReason state, String spellName) {
        return new PlayerOutcome(null, state, spellName);
    }

    public static PlayerOutcome concede() {
        return new PlayerOutcome(null, GameLossReason.Conceded, null);
    }

    public boolean hasWon() {
        return this.lossState == null;
    }

    public String toString() {
        Localizer localizer = Localizer.getInstance();
        if (this.lossState == null) {
            if (this.altWinSourceName == null) {
                return localizer.getMessage("lblWonBecauseAllOpponentsHaveLost", new Object[0]);
            }
            return localizer.getMessage("lblWonDueToEffectOf", new Object[0]).replace("%s", this.altWinSourceName);
        }
        switch (this.lossState) {
            case Conceded: {
                return localizer.getMessage("lblConceded", new Object[0]);
            }
            case Milled: {
                return localizer.getMessage("lblLostTryingToDrawCardsFromEmptyLibrary", new Object[0]);
            }
            case LifeReachedZero: {
                return localizer.getMessage("lblLostBecauseLifeTotalReachedZero", new Object[0]);
            }
            case Poisoned: {
                return localizer.getMessage("lblLostBecauseOfObtainingTenPoisonCounters", new Object[0]);
            }
            case OpponentWon: {
                return localizer.getMessage("lblLostBecauseAnOpponentHasWonBySpell", new Object[0]).replace("%s", this.loseConditionSpell);
            }
            case SpellEffect: {
                return localizer.getMessage("lblLostDueToEffectOfSpell", new Object[0]).replace("%s", this.loseConditionSpell);
            }
            case CommanderDamage: {
                return localizer.getMessage("lblLostDueToAccumulationOf21DamageFromGenerals", new Object[0]);
            }
            case IntentionalDraw: {
                return localizer.getMessage("lblAcceptedThatTheGameIsADraw", new Object[0]);
            }
        }
        return localizer.getMessage("lblLostForUnknownReasonBug", new Object[0]);
    }
}

