/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import forge.game.IHasSVars;
import forge.game.card.Card;
import forge.game.card.CardFactoryUtil;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.staticability.StaticAbility;

public class PlayerFactoryUtil {
    public static void addStaticAbility(KeywordInterface inst, Player player) {
        String keyword = inst.getOriginal();
        if (keyword.startsWith("Hexproof")) {
            StringBuilder sbDesc = new StringBuilder("Hexproof");
            StringBuilder sbValid = new StringBuilder();
            if (!keyword.equals("Hexproof")) {
                String[] k = keyword.split(":");
                sbDesc.append(" from ").append(k[2]);
                sbValid.append("| ValidSource$ ").append(k[1]);
            }
            String effect = "Mode$ CantTarget | ValidPlayer$ Player.You | Secondary$ True " + sbValid.toString() + " | Activator$ Opponent | EffectZone$ Command | Description$ " + sbDesc.toString() + " (" + inst.getReminderText() + ")";
            Card card = player.getKeywordCard();
            inst.addStaticAbility(StaticAbility.create(effect, card, card.getCurrentState(), false));
        } else if (keyword.equals("Shroud")) {
            String effect = "Mode$ CantTarget | ValidPlayer$ Player.You | Secondary$ True | EffectZone$ Command | Description$ Shroud (" + inst.getReminderText() + ")";
            Card card = player.getKeywordCard();
            inst.addStaticAbility(StaticAbility.create(effect, card, card.getCurrentState(), false));
        } else if (keyword.startsWith("Protection")) {
            String[] kws;
            String valid = CardFactoryUtil.getProtectionValid(keyword, false);
            String effect = "Mode$ CantTarget | Protection$ True | ValidPlayer$ Player.You | EffectZone$ Command | Secondary$ True ";
            if (!valid.isEmpty()) {
                effect = effect + "| ValidSource$ " + valid;
            }
            Card card = player.getKeywordCard();
            inst.addStaticAbility(StaticAbility.create(effect, card, card.getCurrentState(), false));
            effect = "Mode$ CantAttach | Protection$ True | Target$ Player.You | EffectZone$ Command | Secondary$ True ";
            if (!valid.isEmpty()) {
                effect = effect + "| ValidCard$ " + valid;
            }
            if (keyword.startsWith("Protection:") && (kws = keyword.split(":")).length > 3) {
                effect = effect + " | Exceptions$ " + kws[3];
            }
            inst.addStaticAbility(StaticAbility.create(effect, card, card.getCurrentState(), false));
        }
    }

    public static void addTriggerAbility(KeywordInterface inst, Player player) {
    }

    public static void addReplacementEffect(KeywordInterface inst, Player player) {
        String keyword = inst.getOriginal();
        String effect = null;
        if (keyword.startsWith("Protection")) {
            String validSource = CardFactoryUtil.getProtectionValid(keyword, true);
            effect = "Event$ DamageDone | Prevent$ True | ActiveZones$ Command | ValidTarget$ You";
            if (!validSource.isEmpty()) {
                effect = effect + " | ValidSource$ " + validSource;
            }
            effect = effect + " | Secondary$ True | Description$ " + keyword;
        }
        if (effect != null) {
            Card card = player.getKeywordCard();
            ReplacementEffect re = ReplacementHandler.parseReplacement(effect, card, false, (IHasSVars)card.getCurrentState());
            inst.addReplacement(re);
        }
    }

    public static void addSpellAbility(KeywordInterface inst, Player player) {
    }
}

