/*
 * Decompiled with CFR 0.152.
 */
package forge.game.player;

import com.google.common.base.Predicate;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import forge.LobbyPlayer;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostShard;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.GameOutcome;
import forge.game.GameType;
import forge.game.GameView;
import forge.game.Match;
import forge.game.PlanarDice;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardState;
import forge.game.card.CardView;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.Mana;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.DelayedReveal;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerView;
import forge.game.replacement.ReplacementEffect;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.TargetChoices;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.ITriggerEvent;
import forge.util.collect.FCollectionView;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public abstract class PlayerController {
    protected final GameView gameView;
    protected final Player player;
    protected final LobbyPlayer lobbyPlayer;

    public PlayerController(Game game0, Player p, LobbyPlayer lp) {
        this.gameView = game0.getView();
        this.player = p;
        this.lobbyPlayer = lp;
    }

    public boolean isAI() {
        return false;
    }

    public Game getGame() {
        return this.gameView.getGame();
    }

    public Match getMatch() {
        return this.gameView.getMatch();
    }

    public Player getPlayer() {
        return this.player;
    }

    public LobbyPlayer getLobbyPlayer() {
        return this.lobbyPlayer;
    }

    public void tempShowCards(Iterable<Card> cards) {
    }

    public void endTempShowCards() {
    }

    public final SpellAbility getAbilityToPlay(Card hostCard, List<SpellAbility> abilities) {
        return this.getAbilityToPlay(hostCard, abilities, null);
    }

    public abstract SpellAbility getAbilityToPlay(Card var1, List<SpellAbility> var2, ITriggerEvent var3);

    @Deprecated
    public abstract void playSpellAbilityForFree(SpellAbility var1, boolean var2);

    public abstract void playSpellAbilityNoStack(SpellAbility var1, boolean var2);

    public abstract List<PaperCard> sideboard(Deck var1, GameType var2, String var3);

    public abstract List<PaperCard> chooseCardsYouWonToAddToDeck(List<PaperCard> var1);

    public abstract Map<Card, Integer> assignCombatDamage(Card var1, CardCollectionView var2, CardCollectionView var3, int var4, GameEntity var5, boolean var6);

    public abstract Map<GameEntity, Integer> divideShield(Card var1, Map<GameEntity, Integer> var2, int var3);

    public abstract Map<Byte, Integer> specifyManaCombo(SpellAbility var1, ColorSet var2, int var3, boolean var4);

    public abstract Integer announceRequirements(SpellAbility var1, String var2);

    public abstract CardCollectionView choosePermanentsToSacrifice(SpellAbility var1, int var2, int var3, CardCollectionView var4, String var5);

    public abstract CardCollectionView choosePermanentsToDestroy(SpellAbility var1, int var2, int var3, CardCollectionView var4, String var5);

    public abstract TargetChoices chooseNewTargetsFor(SpellAbility var1, Predicate<GameObject> var2, boolean var3);

    public abstract boolean chooseTargetsFor(SpellAbility var1);

    public abstract Pair<SpellAbilityStackInstance, GameObject> chooseTarget(SpellAbility var1, List<Pair<SpellAbilityStackInstance, GameObject>> var2);

    public abstract CardCollectionView chooseCardsForEffect(CardCollectionView var1, SpellAbility var2, String var3, int var4, int var5, boolean var6, Map<String, Object> var7);

    public abstract boolean helpPayForAssistSpell(ManaCostBeingPaid var1, SpellAbility var2, int var3, int var4);

    public abstract Player choosePlayerToAssistPayment(FCollectionView<Player> var1, SpellAbility var2, String var3, int var4);

    public final <T extends GameEntity> T chooseSingleEntityForEffect(FCollectionView<T> optionList, SpellAbility sa, String title, Map<String, Object> params) {
        return this.chooseSingleEntityForEffect(optionList, null, sa, title, false, null, params);
    }

    public final <T extends GameEntity> T chooseSingleEntityForEffect(FCollectionView<T> optionList, SpellAbility sa, String title, boolean isOptional, Map<String, Object> params) {
        return this.chooseSingleEntityForEffect(optionList, null, sa, title, isOptional, null, params);
    }

    public abstract <T extends GameEntity> T chooseSingleEntityForEffect(FCollectionView<T> var1, DelayedReveal var2, SpellAbility var3, String var4, boolean var5, Player var6, Map<String, Object> var7);

    public abstract List<SpellAbility> chooseSpellAbilitiesForEffect(List<SpellAbility> var1, SpellAbility var2, String var3, int var4, Map<String, Object> var5);

    public abstract SpellAbility chooseSingleSpellForEffect(List<SpellAbility> var1, SpellAbility var2, String var3, Map<String, Object> var4);

    public abstract <T extends GameEntity> List<T> chooseEntitiesForEffect(FCollectionView<T> var1, int var2, int var3, DelayedReveal var4, SpellAbility var5, String var6, Player var7, Map<String, Object> var8);

    public final boolean confirmAction(SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return this.confirmAction(sa, mode, message, Lists.newArrayList(), null, params);
    }

    public final boolean confirmAction(SpellAbility sa, PlayerActionConfirmMode mode, String message, Card cardToShow, Map<String, Object> params) {
        return this.confirmAction(sa, mode, message, Lists.newArrayList(), cardToShow, params);
    }

    public abstract boolean confirmAction(SpellAbility var1, PlayerActionConfirmMode var2, String var3, List<String> var4, Card var5, Map<String, Object> var6);

    public abstract boolean confirmBidAction(SpellAbility var1, PlayerActionConfirmMode var2, String var3, int var4, Player var5);

    public abstract boolean confirmReplacementEffect(ReplacementEffect var1, SpellAbility var2, GameEntity var3, String var4);

    public abstract boolean confirmStaticApplication(Card var1, PlayerActionConfirmMode var2, String var3, String var4);

    public abstract boolean confirmTrigger(WrappedAbility var1);

    public abstract Player chooseStartingPlayer(boolean var1);

    public abstract CardCollection orderBlockers(Card var1, CardCollection var2);

    public abstract List<Card> exertAttackers(List<Card> var1);

    public abstract List<Card> enlistAttackers(List<Card> var1);

    public abstract CardCollection orderBlocker(Card var1, Card var2, CardCollection var3);

    public abstract CardCollection orderAttackers(Card var1, CardCollection var2);

    public final void reveal(CardCollectionView cards, ZoneType zone, Player owner) {
        this.reveal(cards, zone, owner, null);
    }

    public final void reveal(CardCollectionView cards, ZoneType zone, Player owner, String messagePrefix) {
        this.reveal(cards, zone, owner, null, true);
    }

    public abstract void reveal(CardCollectionView var1, ZoneType var2, Player var3, String var4, boolean var5);

    public final void reveal(List<CardView> cards, ZoneType zone, PlayerView owner, String messagePrefix) {
        this.reveal(cards, zone, owner, null, true);
    }

    public abstract void reveal(List<CardView> var1, ZoneType var2, PlayerView var3, String var4, boolean var5);

    public abstract void notifyOfValue(SpellAbility var1, GameObject var2, String var3);

    public abstract ImmutablePair<CardCollection, CardCollection> arrangeForScry(CardCollection var1);

    public abstract ImmutablePair<CardCollection, CardCollection> arrangeForSurveil(CardCollection var1);

    public abstract boolean willPutCardOnTop(Card var1);

    public abstract CardCollectionView orderMoveToZoneList(CardCollectionView var1, ZoneType var2, SpellAbility var3);

    public abstract CardCollectionView chooseCardsToDiscardFrom(Player var1, SpellAbility var2, CardCollection var3, int var4, int var5);

    public abstract CardCollectionView chooseCardsToDiscardUnlessType(int var1, CardCollectionView var2, String var3, SpellAbility var4);

    public abstract CardCollection chooseCardsToDiscardToMaximumHandSize(int var1);

    public abstract CardCollectionView chooseCardsToDelve(int var1, CardCollection var2);

    public abstract CardCollectionView chooseCardsToRevealFromHand(int var1, int var2, CardCollectionView var3);

    public abstract List<SpellAbility> chooseSaToActivateFromOpeningHand(List<SpellAbility> var1);

    public abstract PlayerZone chooseStartingHand(List<PlayerZone> var1);

    public abstract Mana chooseManaFromPool(List<Mana> var1);

    public abstract String chooseSomeType(String var1, SpellAbility var2, Collection<String> var3, List<String> var4, boolean var5);

    public final String chooseSomeType(String kindOfType, SpellAbility sa, Collection<String> validTypes, List<String> invalidTypes) {
        return this.chooseSomeType(kindOfType, sa, validTypes, invalidTypes, false);
    }

    public abstract String chooseSector(Card var1, String var2, List<String> var3);

    public final String chooseSector(Card assignee, String ai) {
        List<String> sectors = Arrays.asList("Alpha", "Beta", "Gamma");
        return this.chooseSector(assignee, ai, sectors);
    }

    public abstract PlanarDice choosePDRollToIgnore(List<PlanarDice> var1);

    public abstract Integer chooseRollToIgnore(List<Integer> var1);

    public abstract Object vote(SpellAbility var1, String var2, List<Object> var3, ListMultimap<Object, Player> var4, Player var5, boolean var6);

    public abstract boolean mulliganKeepHand(Player var1, int var2);

    public abstract CardCollectionView londonMulliganReturnCards(Player var1, int var2);

    public abstract void declareAttackers(Player var1, Combat var2);

    public abstract void declareBlockers(Player var1, Combat var2);

    public abstract List<SpellAbility> chooseSpellAbilityToPlay();

    public abstract boolean playChosenSpellAbility(SpellAbility var1);

    public abstract boolean payManaOptional(Card var1, Cost var2, SpellAbility var3, String var4, ManaPaymentPurpose var5);

    public abstract int chooseNumberForCostReduction(SpellAbility var1, int var2, int var3);

    public abstract int chooseNumberForKeywordCost(SpellAbility var1, Cost var2, KeywordInterface var3, String var4, int var5);

    public boolean addKeywordCost(SpellAbility sa, Cost cost, KeywordInterface keyword, String prompt) {
        return this.chooseNumberForKeywordCost(sa, cost, keyword, prompt, 1) == 1;
    }

    public abstract int chooseNumber(SpellAbility var1, String var2, int var3, int var4);

    public abstract int chooseNumber(SpellAbility var1, String var2, List<Integer> var3, Player var4);

    public int chooseNumber(SpellAbility sa, String string, int min2, int max, Map<String, Object> params) {
        return this.chooseNumber(sa, string, min2, max);
    }

    public final boolean chooseBinary(SpellAbility sa, String question, BinaryChoiceType kindOfChoice) {
        return this.chooseBinary(sa, question, kindOfChoice, (Boolean)null);
    }

    public abstract boolean chooseBinary(SpellAbility var1, String var2, BinaryChoiceType var3, Boolean var4);

    public boolean chooseBinary(SpellAbility sa, String question, BinaryChoiceType kindOfChoice, Map<String, Object> params) {
        return this.chooseBinary(sa, question, kindOfChoice);
    }

    public abstract boolean chooseFlipResult(SpellAbility var1, Player var2, boolean[] var3, boolean var4);

    public abstract List<AbilitySub> chooseModeForAbility(SpellAbility var1, List<AbilitySub> var2, int var3, int var4, boolean var5);

    public abstract byte chooseColor(String var1, SpellAbility var2, ColorSet var3);

    public abstract byte chooseColorAllowColorless(String var1, Card var2, ColorSet var3);

    public abstract ICardFace chooseSingleCardFace(SpellAbility var1, String var2, Predicate<ICardFace> var3, String var4);

    public abstract ICardFace chooseSingleCardFace(SpellAbility var1, List<ICardFace> var2, String var3);

    public abstract CardState chooseSingleCardState(SpellAbility var1, List<CardState> var2, String var3, Map<String, Object> var4);

    public abstract List<String> chooseColors(String var1, SpellAbility var2, int var3, int var4, List<String> var5);

    public abstract CounterType chooseCounterType(List<CounterType> var1, SpellAbility var2, String var3, Map<String, Object> var4);

    public abstract String chooseKeywordForPump(List<String> var1, SpellAbility var2, String var3, Card var4);

    public abstract boolean confirmPayment(CostPart var1, String var2, SpellAbility var3);

    public abstract ReplacementEffect chooseSingleReplacementEffect(List<ReplacementEffect> var1);

    public abstract StaticAbility chooseSingleStaticAbility(String var1, List<StaticAbility> var2);

    public abstract String chooseProtectionType(String var1, SpellAbility var2, List<String> var3);

    public abstract boolean payCostToPreventEffect(Cost var1, SpellAbility var2, boolean var3, FCollectionView<Player> var4);

    public abstract void orderAndPlaySimultaneousSa(List<SpellAbility> var1);

    public abstract boolean playTrigger(Card var1, WrappedAbility var2, boolean var3);

    public abstract boolean playSaFromPlayEffect(SpellAbility var1);

    public abstract boolean chooseCardsPile(SpellAbility var1, CardCollectionView var2, CardCollectionView var3, String var4);

    public abstract void revealAnte(String var1, Multimap<Player, PaperCard> var2);

    public abstract void revealAISkipCards(String var1, Map<Player, Map<DeckSection, List<? extends PaperCard>>> var2);

    public CardCollectionView cheatShuffle(CardCollectionView list) {
        return list;
    }

    public Map<DeckSection, List<? extends PaperCard>> complainCardsCantPlayWell(Deck myDeck) {
        return null;
    }

    public abstract void resetAtEndOfTurn();

    public final boolean payManaCost(CostPartMana costPartMana, SpellAbility sa, String prompt, ManaConversionMatrix matrix, boolean effect) {
        return this.payManaCost(costPartMana.getManaCostFor(sa), costPartMana, sa, prompt, matrix, effect);
    }

    public abstract boolean payManaCost(ManaCost var1, CostPartMana var2, SpellAbility var3, String var4, ManaConversionMatrix var5, boolean var6);

    public abstract Map<Card, ManaCostShard> chooseCardsForConvokeOrImprovise(SpellAbility var1, ManaCost var2, CardCollectionView var3, boolean var4);

    public abstract List<Card> chooseCardsForSplice(SpellAbility var1, List<Card> var2);

    public abstract String chooseCardName(SpellAbility var1, Predicate<ICardFace> var2, String var3, String var4);

    public abstract String chooseCardName(SpellAbility var1, List<ICardFace> var2, String var3);

    public abstract Card chooseDungeon(Player var1, List<PaperCard> var2, String var3);

    public abstract Card chooseSingleCardForZoneChange(ZoneType var1, List<ZoneType> var2, SpellAbility var3, CardCollection var4, DelayedReveal var5, String var6, boolean var7, Player var8);

    public abstract List<Card> chooseCardsForZoneChange(ZoneType var1, List<ZoneType> var2, SpellAbility var3, CardCollection var4, int var5, int var6, DelayedReveal var7, String var8, Player var9);

    public boolean isFullControl() {
        return false;
    }

    public void setFullControl(boolean full) {
    }

    public abstract void autoPassCancel();

    public abstract void awaitNextInput();

    public abstract void cancelAwaitNextInput();

    public void resetInputs() {
    }

    public boolean isGuiPlayer() {
        return false;
    }

    public boolean canPlayUnlimitedLands() {
        return false;
    }

    public GameOutcome.AnteResult getAnteResult() {
        return this.gameView.getAnteResult(this.player.getView());
    }

    public abstract List<OptionalCostValue> chooseOptionalCosts(SpellAbility var1, List<OptionalCostValue> var2);

    public abstract boolean confirmMulliganScry(Player var1);

    public abstract CardCollection chooseCardsForEffectMultiple(Map<String, CardCollection> var1, SpellAbility var2, String var3, boolean var4);

    public static enum BinaryChoiceType {
        HeadsOrTails,
        TapOrUntap,
        PlayOrDraw,
        OddsOrEvens,
        UntapOrLeaveTapped,
        UntapTimeVault,
        LeftOrRight,
        AddOrRemove;

    }

    public static enum ManaPaymentPurpose {
        DeclareAttacker,
        DeclareBlocker,
        Echo,
        Multikicker,
        CumulativeUpkeep;

    }
}

