/*
 * Decompiled with CFR 0.152.
 */
package forge.game.phase;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameStage;
import forge.game.GameType;
import forge.game.ability.AbilityKey;
import forge.game.ability.effects.AddTurnEffect;
import forge.game.ability.effects.SkipPhaseEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.CostEnlist;
import forge.game.cost.CostExert;
import forge.game.event.GameEventAttackersDeclared;
import forge.game.event.GameEventBlockersDeclared;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.event.GameEventCombatChanged;
import forge.game.event.GameEventCombatEnded;
import forge.game.event.GameEventGameRestarted;
import forge.game.event.GameEventPlayerPriority;
import forge.game.event.GameEventPlayerStatsChanged;
import forge.game.event.GameEventTokenStateUpdate;
import forge.game.event.GameEventTurnBegan;
import forge.game.event.GameEventTurnEnded;
import forge.game.event.GameEventTurnPhase;
import forge.game.phase.ExtraPhase;
import forge.game.phase.ExtraTurn;
import forge.game.phase.PhaseType;
import forge.game.phase.Untap;
import forge.game.player.Player;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.CollectionSuppliers;
import forge.util.maps.HashMapOfLists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.StopWatch;

public class PhaseHandler
implements Serializable {
    private static final long serialVersionUID = 5207222278370963197L;
    private PhaseType phase = null;
    private int turn = 0;
    private final transient Stack<ExtraTurn> extraTurns = new Stack();
    private final transient Map<PhaseType, Stack<ExtraPhase>> extraPhases = Maps.newEnumMap(PhaseType.class);
    private int nUpkeepsThisTurn = 0;
    private int nUpkeepsThisGame = 0;
    private int nCombatsThisTurn = 0;
    private int nMainsThisTurn = 0;
    private int planarDiceSpecialActionThisTurn = 0;
    private transient Player playerTurn = null;
    private transient Player playerPreviousTurn = null;
    private transient Player pPlayerPriority = null;
    private transient Player pFirstPriority = null;
    private transient Combat combat = null;
    private boolean skipDamageSteps = false;
    private boolean bRepeatCleanup = false;
    private boolean givePriorityToPlayer = false;
    private final transient Game game;
    private static final boolean DEBUG_PHASES = false;

    public PhaseHandler(Game game0) {
        this.game = game0;
    }

    public final PhaseType getPhase() {
        return this.phase;
    }

    private void setPhase(PhaseType phase0) {
        if (this.phase == phase0) {
            return;
        }
        this.phase = phase0;
        this.game.updatePhaseForView();
    }

    public final int getTurn() {
        return this.turn;
    }

    public final boolean isPlayerTurn(Player player) {
        return player.equals(this.playerTurn);
    }

    public final Player getPlayerTurn() {
        return this.playerTurn;
    }

    public final void setPlayerTurn(Player playerTurn0) {
        if (this.playerTurn == playerTurn0) {
            return;
        }
        this.playerTurn = playerTurn0;
        this.game.updatePlayerTurnForView();
        this.setPriority(this.playerTurn);
    }

    public final Player getPreviousPlayerTurn() {
        return this.playerPreviousTurn;
    }

    public final Player getPriorityPlayer() {
        return this.pPlayerPriority;
    }

    public final void setPriority(Player p) {
        this.pFirstPriority = p;
        this.pPlayerPriority = p;
    }

    public final void resetPriority() {
        this.setPriority(this.playerTurn);
    }

    public final boolean inCombat() {
        return this.combat != null;
    }

    public final Combat getCombat() {
        return this.combat;
    }

    private void advanceToNextPhase() {
        PhaseType oldPhase = this.phase;
        boolean isTopsy = this.playerTurn.getAmountOfKeyword("The phases of your turn are reversed.") % 2 == 1;
        boolean turnEnded = false;
        this.game.getStack().clearUndoStack();
        if (this.bRepeatCleanup) {
            this.bRepeatCleanup = false;
        } else {
            ExtraPhase extraPhase = null;
            if (this.extraPhases.containsKey((Object)this.phase)) {
                extraPhase = this.extraPhases.get((Object)this.phase).pop();
                PhaseType nextPhase = extraPhase.getPhase();
                if (this.extraPhases.get((Object)this.phase).isEmpty()) {
                    this.extraPhases.remove((Object)this.phase);
                }
                this.setPhase(nextPhase);
            } else {
                turnEnded = PhaseType.isLast(this.phase, isTopsy);
                this.setPhase(PhaseType.getNext(this.phase, isTopsy));
            }
            if (turnEnded) {
                ++this.turn;
                this.extraPhases.clear();
                this.game.updateTurnForView();
                this.game.fireEvent(new GameEventTurnBegan(this.playerTurn, this.turn));
                for (Card c : this.playerTurn.getCardsIn(ZoneType.Battlefield, false)) {
                    if (this.playerTurn.getTurn() <= 0 && c.isStartsGameInPlay()) continue;
                    c.setSickness(false);
                }
                this.playerTurn.incrementTurn();
                this.game.getAction().resetActivationsPerTurn();
                int lands = CardLists.count(this.playerTurn.getLandsInPlay(), CardPredicates.Presets.UNTAPPED);
                this.playerTurn.setNumPowerSurgeLands(lands);
            }
            this.game.fireEvent(new GameEventTokenStateUpdate(this.playerTurn.getTokensInPlay()));
            Map<AbilityKey, Object> repRunParams = AbilityKey.mapFromAffected(this.playerTurn);
            repRunParams.put(AbilityKey.Phase, this.phase.nameForScripts);
            ReplacementResult repres = this.game.getReplacementHandler().run(ReplacementType.BeginPhase, repRunParams);
            if (repres != ReplacementResult.NotReplaced) {
                if (this.phase == PhaseType.COMBAT_BEGIN) {
                    this.setPhase(PhaseType.COMBAT_END);
                }
                this.advanceToNextPhase();
                return;
            }
            if (extraPhase != null) {
                for (Trigger deltrig : extraPhase.getDelayedTriggers()) {
                    this.game.getTriggerHandler().registerThisTurnDelayedTrigger(deltrig);
                }
            }
        }
        String phaseType = oldPhase == this.phase ? "Repeat" : (this.phase == PhaseType.getNext(oldPhase, isTopsy) ? "" : "Additional");
        this.game.fireEvent(new GameEventTurnPhase(this.playerTurn, this.phase, phaseType));
    }

    private boolean isSkippingPhase(PhaseType phase) {
        switch (phase) {
            case DRAW: {
                return this.turn == 1 && this.game.getPlayers().size() == 2;
            }
            case COMBAT_BEGIN: 
            case COMBAT_DECLARE_ATTACKERS: {
                return this.playerTurn.isSkippingCombat();
            }
            case COMBAT_DECLARE_BLOCKERS: {
                this.skipDamageSteps = !this.inCombat() || this.combat.getAttackers().isEmpty();
            }
            case COMBAT_FIRST_STRIKE_DAMAGE: 
            case COMBAT_DAMAGE: {
                return this.skipDamageSteps;
            }
        }
        return false;
    }

    private void onPhaseBegin() {
        boolean skipped = false;
        this.game.getTriggerHandler().resetActiveTriggers();
        if (this.isSkippingPhase(this.phase)) {
            skipped = true;
            this.givePriorityToPlayer = false;
        } else {
            switch (this.phase) {
                case UNTAP: {
                    this.givePriorityToPlayer = false;
                    this.game.getUntap().executeUntil(this.playerTurn);
                    this.game.getUntap().executeAt();
                    break;
                }
                case UPKEEP: {
                    ++this.nUpkeepsThisTurn;
                    ++this.nUpkeepsThisGame;
                    this.game.getUpkeep().executeUntil(this.playerTurn);
                    this.game.getUpkeep().executeAt();
                    break;
                }
                case DRAW: {
                    for (Player p : this.game.getPlayers()) {
                        p.resetNumDrawnThisDrawStep();
                    }
                    this.playerTurn.drawCard();
                    break;
                }
                case MAIN1: {
                    ++this.nMainsThisTurn;
                    if (this.playerTurn.isArchenemy()) {
                        this.playerTurn.setSchemeInMotion(null);
                    }
                    GameEntityCounterTable table = new GameEntityCounterTable();
                    for (Card c : this.playerTurn.getCardsIn(ZoneType.Battlefield)) {
                        if (!c.isSaga()) continue;
                        c.addCounter(CounterEnumType.LORE, 1, this.playerTurn, table);
                    }
                    table.replaceCounterEffect(this.game, null, false);
                    if (!Iterables.any(this.playerTurn.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.ATTRACTIONS)) break;
                    this.playerTurn.rollToVisitAttractions();
                    break;
                }
                case COMBAT_BEGIN: {
                    ++this.nCombatsThisTurn;
                    this.combat = new Combat(this.playerTurn);
                    break;
                }
                case COMBAT_DECLARE_ATTACKERS: {
                    this.combat.initConstraints();
                    this.game.getStack().freezeStack(null);
                    this.declareAttackersTurnBasedAction();
                    this.game.getStack().unfreezeStack();
                    this.givePriorityToPlayer = this.inCombat();
                    break;
                }
                case COMBAT_DECLARE_BLOCKERS: {
                    this.combat.removeAbsentCombatants();
                    this.game.getStack().freezeStack(null);
                    this.declareBlockersTurnBasedAction();
                    this.game.getStack().unfreezeStack();
                    break;
                }
                case COMBAT_FIRST_STRIKE_DAMAGE: {
                    if (this.combat.removeAbsentCombatants()) {
                        this.game.updateCombatForView();
                    }
                    if (!this.combat.assignCombatDamage(true)) {
                        this.givePriorityToPlayer = false;
                        break;
                    }
                    this.combat.dealAssignedDamage();
                    break;
                }
                case COMBAT_DAMAGE: {
                    if (this.combat.removeAbsentCombatants()) {
                        this.game.updateCombatForView();
                    }
                    if (!this.combat.assignCombatDamage(false)) {
                        this.givePriorityToPlayer = false;
                        break;
                    }
                    this.combat.dealAssignedDamage();
                    break;
                }
                case COMBAT_END: {
                    for (Card c : this.game.getCardsIn(ZoneType.Battlefield)) {
                        c.onEndOfCombat(this.playerTurn);
                    }
                    this.game.getEndOfCombat().executeAt();
                    break;
                }
                case MAIN2: {
                    ++this.nMainsThisTurn;
                    break;
                }
                case END_OF_TURN: {
                    this.game.getEndOfTurn().executeUntil(this.playerTurn);
                    if (this.playerTurn.getController().isAI()) {
                        this.playerTurn.getController().resetAtEndOfTurn();
                    }
                    this.game.getEndOfTurn().executeAt();
                    break;
                }
                case CLEANUP: {
                    int numDiscard;
                    int handSize = this.playerTurn.getZone(ZoneType.Hand).size();
                    int max = this.playerTurn.getMaxHandSize();
                    int n = numDiscard = this.playerTurn.isUnlimitedHandSize() || handSize <= max || handSize == 0 ? 0 : handSize - max;
                    if (numDiscard > 0) {
                        CardZoneTable zoneMovements = new CardZoneTable(this.game.getLastStateBattlefield(), this.game.getLastStateGraveyard());
                        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                        AbilityKey.addCardZoneTableParams(moveParams, zoneMovements);
                        CardCollection discarded = new CardCollection();
                        ArrayList<Card> discardedBefore = Lists.newArrayList(this.playerTurn.getDiscardedThisTurn());
                        for (Card c : this.playerTurn.getController().chooseCardsToDiscardToMaximumHandSize(numDiscard)) {
                            Card moved = this.playerTurn.discard(c, null, false, moveParams);
                            if (moved == null) continue;
                            discarded.add(moved);
                        }
                        zoneMovements.triggerChangesZoneAll(this.game, null);
                        if (!discarded.isEmpty()) {
                            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this.playerTurn);
                            runParams.put(AbilityKey.Cards, discarded);
                            runParams.put(AbilityKey.Cause, null);
                            runParams.put(AbilityKey.DiscardedBefore, discardedBefore);
                            this.game.getTriggerHandler().runTrigger(TriggerType.DiscardedAll, runParams, false);
                        }
                    }
                    for (Card c : this.game.getCardsIncludePhasingIn(ZoneType.Battlefield)) {
                        c.onCleanupPhase(this.playerTurn);
                    }
                    this.game.getEndOfTurn().executeUntil();
                    this.game.getEndOfTurn().executeUntilEndOfPhase(this.playerTurn);
                    this.game.getEndOfTurn().registerUntilEndCommand(this.playerTurn);
                    this.game.getEndOfCombat().registerUntilEndCommand(this.playerTurn);
                    for (Player player : this.game.getPlayers()) {
                        player.getController().autoPassCancel();
                    }
                    this.nUpkeepsThisTurn = 0;
                    this.nCombatsThisTurn = 0;
                    this.nMainsThisTurn = 0;
                    this.game.getStack().resetMaxDistinctSources();
                    this.givePriorityToPlayer = false;
                    if (!this.game.getAction().checkStateEffects(true)) break;
                    this.bRepeatCleanup = true;
                    this.givePriorityToPlayer = true;
                    break;
                }
            }
        }
        if (!skipped) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this.playerTurn);
            runParams.put(AbilityKey.Phase, this.phase.nameForScripts);
            this.game.getTriggerHandler().runTrigger(TriggerType.Phase, runParams, false);
        }
        this.game.getStack().unfreezeStack();
        if (this.phase == PhaseType.CLEANUP && (!this.game.getStack().isEmpty() || this.game.getStack().hasSimultaneousStackEntries())) {
            this.bRepeatCleanup = true;
            this.givePriorityToPlayer = true;
        }
    }

    private void onPhaseEnd() {
        if (!this.game.getStack().isEmpty()) {
            throw new IllegalStateException("Phase.nextPhase() is called, but Stack isn't empty.");
        }
        HashMap<Player, Integer> lossMap = Maps.newHashMap();
        for (Player p : this.game.getPlayers()) {
            int lost;
            int burn = p.getManaPool().clearPool(true).size();
            if (!p.getManaPool().hasBurn() || (lost = p.loseLife(burn, false, true)) <= 0) continue;
            lossMap.put(p, lost);
        }
        if (!lossMap.isEmpty()) {
            Map<AbilityKey, Object> runLifeLostParams = AbilityKey.mapFromPIMap(lossMap);
            this.game.getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runLifeLostParams, false);
        }
        switch (this.phase) {
            case UPKEEP: {
                for (Card c : this.game.getCardsIncludePhasingIn(ZoneType.Battlefield)) {
                    c.getDamageHistory().setNotAttackedSinceLastUpkeepOf(this.playerTurn);
                    c.getDamageHistory().setNotBlockedSinceLastUpkeepOf(this.playerTurn);
                    c.getDamageHistory().setNotBeenBlockedSinceLastUpkeepOf(this.playerTurn);
                    if (!this.playerTurn.equals(c.getController()) || c.getTurnInZone() >= this.game.getPhaseHandler().getTurn()) continue;
                    c.setCameUnderControlSinceLastUpkeep(false);
                }
                this.game.getUpkeep().executeUntilEndOfPhase(this.playerTurn);
                this.game.getUpkeep().registerUntilEndCommand(this.playerTurn);
                break;
            }
            case COMBAT_END: {
                GameEventCombatEnded eventEndCombat = null;
                if (this.inCombat()) {
                    CardCollection attackers = this.combat.getAttackers();
                    CardCollection blockers = this.combat.getAllBlockers();
                    eventEndCombat = new GameEventCombatEnded(attackers, blockers);
                }
                this.endCombat();
                if (eventEndCombat == null) break;
                this.game.fireEvent(eventEndCombat);
                break;
            }
            case CLEANUP: {
                if (!this.bRepeatCleanup) {
                    this.game.onCleanupPhase();
                    this.playerPreviousTurn = this.getPlayerTurn();
                    this.setPlayerTurn(this.handleNextTurn());
                    this.game.getCleanup().executeUntil();
                    this.game.getCleanup().executeUntil(this.playerTurn);
                    this.handleMultiplayerEffects();
                    Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(this.playerTurn);
                    this.game.getTriggerHandler().runTrigger(TriggerType.TurnBegin, runParams, false);
                }
                this.planarDiceSpecialActionThisTurn = 0;
                this.game.fireEvent(new GameEventTurnEnded());
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void declareAttackersTurnBasedAction() {
        Player whoDeclares = ObjectUtils.firstNonNull(this.playerTurn.getDeclaresAttackers(), this.playerTurn);
        if (CombatUtil.canAttack(this.playerTurn)) {
            boolean success = false;
            block0: do {
                void var4_5;
                List<Card> possibleEnlisters;
                if (this.game.isGameOver()) {
                    return;
                }
                whoDeclares.getController().declareAttackers(this.playerTurn, this.combat);
                this.combat.removeAbsentCombatants();
                success = CombatUtil.validateAttackers(this.combat);
                if (!success) {
                    whoDeclares.getController().notifyOfValue(null, null, "Attack declaration invalid");
                    continue;
                }
                CardCollection untapFromCancel = new CardCollection();
                for (Card attacker : this.combat.getAttackers()) {
                    if (attacker.attackVigilance()) continue;
                    attacker.setTapped(true);
                    untapFromCancel.add(attacker);
                }
                CardCollection cardCollection = CombatUtil.getOptionalAttackCostCreatures(this.combat.getAttackers(), CostExert.class);
                if (!cardCollection.isEmpty()) {
                    List<Card> list = whoDeclares.getController().exertAttackers(cardCollection);
                }
                if (!(possibleEnlisters = CombatUtil.getOptionalAttackCostCreatures(this.combat.getAttackers(), CostEnlist.class)).isEmpty()) {
                    possibleEnlisters = whoDeclares.getController().enlistAttackers(possibleEnlisters);
                    var4_5.addAll(possibleEnlisters);
                }
                for (Card attacker : this.combat.getAttackers()) {
                    boolean canAttack = CombatUtil.checkPropagandaEffects(this.game, attacker, this.combat, (List<Card>)var4_5);
                    if (canAttack) continue;
                    this.combat.removeFromCombat(attacker);
                    if (untapFromCancel.contains(attacker)) {
                        attacker.setTapped(false);
                    }
                    if (success = CombatUtil.validateAttackers(this.combat)) continue;
                    for (Card c : untapFromCancel) {
                        c.setTapped(false);
                    }
                    this.combat.removeAbsentCombatants();
                    this.combat.initConstraints();
                    continue block0;
                }
            } while (!success);
            CardCollection tapped = new CardCollection();
            for (Card attacker : this.combat.getAttackers()) {
                if (attacker.attackVigilance()) continue;
                attacker.setTapped(false);
                if (!attacker.tap(true, true, null, null)) continue;
                tapped.add(attacker);
            }
            if (!tapped.isEmpty()) {
                EnumMap<AbilityKey, Object> enumMap = AbilityKey.newMap();
                enumMap.put(AbilityKey.Cards, tapped);
                whoDeclares.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, enumMap, false);
            }
        }
        if (this.game.isGameOver()) {
            return;
        }
        this.game.getTriggerHandler().resetActiveTriggers();
        ArrayListMultimap<GameEntity, Card> attackersMap = ArrayListMultimap.create();
        for (GameEntity gameEntity : this.combat.getDefenders()) {
            attackersMap.putAll(gameEntity, (Iterable<Card>)this.combat.getAttackersOf(gameEntity));
        }
        this.game.fireEvent(new GameEventAttackersDeclared(this.playerTurn, attackersMap));
        if (!this.combat.getAttackers().isEmpty()) {
            ArrayList<GameEntity> attackedTarget = new ArrayList<GameEntity>();
            for (GameEntity ge : this.combat.getDefenders()) {
                if (this.combat.getAttackersOf(ge).isEmpty()) continue;
                EnumMap<AbilityKey, Object> runParams2 = AbilityKey.newMap();
                runParams2.put(AbilityKey.Attackers, this.combat.getAttackersOf(ge));
                runParams2.put(AbilityKey.AttackingPlayer, this.combat.getAttackingPlayer());
                runParams2.put(AbilityKey.AttackedTarget, Collections.singletonList(ge));
                attackedTarget.add(ge);
                this.game.getTriggerHandler().runTrigger(TriggerType.AttackersDeclaredOneTarget, runParams2, false);
            }
            EnumMap<AbilityKey, Object> enumMap = AbilityKey.newMap();
            enumMap.put(AbilityKey.Attackers, this.combat.getAttackers());
            enumMap.put(AbilityKey.AttackingPlayer, this.combat.getAttackingPlayer());
            enumMap.put(AbilityKey.AttackedTarget, attackedTarget);
            this.game.getTriggerHandler().runTrigger(TriggerType.AttackersDeclared, enumMap, false);
        }
        for (Card card : this.combat.getAttackers()) {
            CombatUtil.checkDeclaredAttacker(this.game, card, this.combat, true);
        }
        this.game.getTriggerHandler().resetActiveTriggers();
        this.game.updateCombatForView();
        this.game.fireEvent(new GameEventCombatChanged());
    }

    private void declareBlockersTurnBasedAction() {
        EnumMap<AbilityKey, Object> runParams;
        Player p = this.playerTurn;
        do {
            boolean reachedSteadyState;
            p = this.game.getNextPlayerAfter(p);
            Player whoDeclaresBlockers = ObjectUtils.firstNonNull(p.getDeclaresBlockers(), p);
            if (!this.combat.isPlayerAttacked(p)) continue;
            if (CombatUtil.canBlock(p, this.combat)) {
                Map<AbilityKey, Object> repRunParams = AbilityKey.mapFromAffected(p);
                repRunParams.put(AbilityKey.Player, whoDeclaresBlockers);
                ReplacementResult repres = this.game.getReplacementHandler().run(ReplacementType.DeclareBlocker, repRunParams);
                if (repres == ReplacementResult.NotReplaced) {
                    whoDeclaresBlockers.getController().declareBlockers(p, this.combat);
                }
            }
            if (this.game.isGameOver()) {
                return;
            }
            for (Card blocker : CardLists.filterControlledBy((Iterable<Card>)this.combat.getAllBlockers(), p)) {
                Iterator<GameEntity> attackers = this.combat.getAttackersBlockedBy(blocker);
                Iterator iterator = attackers.iterator();
                while (iterator.hasNext()) {
                    Card attacker = (Card)iterator.next();
                    boolean hasPaid = CombatUtil.payRequiredBlockCosts(this.game, blocker, attacker);
                    if (hasPaid) continue;
                    this.combat.removeBlockAssignment(attacker, blocker);
                }
            }
            do {
                reachedSteadyState = true;
                CardCollection remainingBlockers = CardLists.filterControlledBy((Iterable<Card>)this.combat.getAllBlockers(), p);
                for (Card card : remainingBlockers) {
                    boolean cantBlockAlone;
                    boolean removeBlocker = false;
                    boolean bl = cantBlockAlone = card.hasKeyword("CARDNAME can't attack or block alone.") || card.hasKeyword("CARDNAME can't block alone.");
                    if (remainingBlockers.size() < 2 && cantBlockAlone) {
                        removeBlocker = true;
                    } else if (remainingBlockers.size() < 3 && card.hasKeyword("CARDNAME can't block unless at least two other creatures block.")) {
                        removeBlocker = true;
                    } else if (card.hasKeyword("CARDNAME can't block unless a creature with greater power also blocks.")) {
                        removeBlocker = true;
                        int power = card.getNetPower();
                        for (Card c2 : remainingBlockers) {
                            if (c2.getNetPower() <= power) continue;
                            removeBlocker = false;
                            break;
                        }
                    }
                    if (!removeBlocker) continue;
                    this.combat.undoBlockingAssignment(card);
                    reachedSteadyState = false;
                }
            } while (!reachedSteadyState);
            HashMap blockers = Maps.newHashMap();
            for (GameEntity gameEntity : this.combat.getDefendersControlledBy(p)) {
                HashMapOfLists protectThisDefender = new HashMapOfLists(CollectionSuppliers.arrayLists());
                for (Card att : this.combat.getAttackersOf(gameEntity)) {
                    protectThisDefender.addAll(att, this.combat.getBlockers(att));
                }
                blockers.put(gameEntity, protectThisDefender);
            }
            this.game.fireEvent(new GameEventBlockersDeclared(p, blockers));
        } while (p != this.playerTurn);
        this.combat.orderBlockersForDamageAssignment();
        this.combat.orderAttackersForDamageAssignment();
        this.combat.removeAbsentCombatants();
        this.combat.fireTriggersForUnblockedAttackers(this.game);
        CardCollection declaredBlockers = this.combat.getAllBlockers();
        if (!declaredBlockers.isEmpty()) {
            ArrayList<Card> blockedAttackers = Lists.newArrayList();
            for (Card blocker : declaredBlockers) {
                for (Card blockedAttacker : this.combat.getAttackersBlockedBy(blocker)) {
                    if (blockedAttackers.contains(blockedAttacker)) continue;
                    blockedAttackers.add(blockedAttacker);
                }
            }
            EnumMap<AbilityKey, Object> bdRunParams = AbilityKey.newMap();
            bdRunParams.put(AbilityKey.Blockers, declaredBlockers);
            bdRunParams.put(AbilityKey.Attackers, blockedAttackers);
            this.game.getTriggerHandler().runTrigger(TriggerType.BlockersDeclared, bdRunParams, false);
        }
        for (Card c1 : this.combat.getAllBlockers()) {
            if (c1.getDamageHistory().getCreatureBlockedThisCombat()) continue;
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Blocker, c1);
            runParams.put(AbilityKey.Attackers, this.combat.getAttackersBlockedBy(c1));
            this.game.getTriggerHandler().runTrigger(TriggerType.Blocks, runParams, false);
            c1.getDamageHistory().setCreatureBlockedThisCombat(true);
            c1.getDamageHistory().clearNotBlockedSinceLastUpkeepOf();
        }
        ArrayList<Card> blocked = Lists.newArrayList();
        HashMap<Integer, Card> lkiCache = Maps.newHashMap();
        for (Card card : this.combat.getAttackers()) {
            CardCollection blockers;
            if (this.combat.isBlocked(card)) {
                card.getDamageHistory().clearNotBeenBlockedSinceLastUpkeepOf();
            }
            if ((blockers = this.combat.getBlockers(card)).isEmpty()) continue;
            blocked.add(card);
            EnumMap<AbilityKey, Object> runParams2 = AbilityKey.newMap();
            runParams2.put(AbilityKey.Attacker, card);
            runParams2.put(AbilityKey.Blockers, blockers);
            runParams2.put(AbilityKey.Defender, this.combat.getDefenderByAttacker(card));
            runParams2.put(AbilityKey.DefendingPlayer, this.combat.getDefenderPlayerByAttacker(card));
            this.game.getTriggerHandler().runTrigger(TriggerType.AttackerBlocked, runParams2, false);
            for (Card b : blockers) {
                b.addBlockedThisTurn(CardCopyService.getLKICopy(card, lkiCache));
                card.addBlockedByThisTurn(CardCopyService.getLKICopy(b, lkiCache));
                EnumMap<AbilityKey, Object> runParams3 = AbilityKey.newMap();
                runParams3.put(AbilityKey.Attacker, card);
                runParams3.put(AbilityKey.Blocker, b);
                this.game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedByCreature, runParams3, false);
            }
            card.getDamageHistory().setCreatureGotBlockedThisCombat(true);
        }
        if (!blocked.isEmpty()) {
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attackers, blocked);
            this.game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedOnce, runParams, false);
        }
        this.game.updateCombatForView();
        this.game.fireEvent(new GameEventCombatChanged());
    }

    public void restart() {
        this.extraPhases.clear();
        this.extraTurns.clear();
        this.turn = 0;
    }

    private Player handleNextTurn() {
        this.game.getStack().onNextTurn();
        this.game.getTriggerHandler().clearThisTurnDelayedTrigger();
        Player next = this.getNextActivePlayer();
        while (next.hasLost()) {
            next = this.getNextActivePlayer();
        }
        this.game.getTriggerHandler().handlePlayerDefinedDelTriggers(next);
        for (Card c : this.game.getCardsIncludePhasingIn(ZoneType.Battlefield)) {
            c.setStartedTheTurnUntapped(c.isUntapped());
        }
        this.game.setMonarchBeginTurn(this.game.getMonarch());
        if (this.game.getRules().hasAppliedVariant(GameType.Planechase)) {
            for (Card p : this.game.getActivePlanes()) {
                if (p == null) continue;
                p.setController(next, 0L);
                this.game.getAction().controllerChangeZoneCorrection(p);
            }
        }
        return next;
    }

    private Player getNextActivePlayer() {
        ExtraTurn extraTurn = !this.extraTurns.isEmpty() ? this.extraTurns.pop() : null;
        Player nextPlayer = extraTurn != null ? extraTurn.getPlayer() : this.game.getNextPlayerAfter(this.playerTurn);
        boolean isExtraTurn = !this.extraTurns.isEmpty();
        nextPlayer.setExtraTurnCount(this.getExtraTurnForPlayer(nextPlayer));
        Map<AbilityKey, Object> repRunParams = AbilityKey.mapFromAffected(nextPlayer);
        repRunParams.put(AbilityKey.ExtraTurn, isExtraTurn);
        ReplacementResult repres = this.game.getReplacementHandler().run(ReplacementType.BeginTurn, repRunParams);
        if (repres != ReplacementResult.NotReplaced) {
            if (extraTurn == null) {
                this.setPlayerTurn(nextPlayer);
            }
            return this.getNextActivePlayer();
        }
        nextPlayer.setExtraTurn(isExtraTurn);
        if (extraTurn != null) {
            for (Trigger deltrig : extraTurn.getDelayedTriggers()) {
                this.game.getTriggerHandler().registerThisTurnDelayedTrigger(deltrig);
            }
            if (extraTurn.isSkipUntap()) {
                SkipPhaseEffect.createSkipPhaseEffect(extraTurn.getSkipUntapSA(), nextPlayer, null, null, "Untap");
            }
            if (extraTurn.isCantSetSchemesInMotion()) {
                AddTurnEffect.createCantSetSchemesInMotionEffect(extraTurn.getCantSetSchemesInMotionSA());
            }
        }
        return nextPlayer;
    }

    public final synchronized boolean is(PhaseType phase0, Player player0) {
        return this.phase == phase0 && this.playerTurn.equals(player0);
    }

    public final synchronized boolean is(PhaseType phase0) {
        return this.phase == phase0;
    }

    public final Player getNextTurn() {
        if (this.extraTurns.isEmpty()) {
            return this.game.getNextPlayerAfter(this.playerTurn);
        }
        return this.extraTurns.peek().getPlayer();
    }

    public final ExtraTurn addExtraTurn(Player player) {
        Player previous = null;
        if (this.extraTurns.isEmpty()) {
            this.extraTurns.push(new ExtraTurn(this.game.getNextPlayerAfter(this.playerTurn)));
        } else {
            previous = this.extraTurns.peek().getPlayer();
        }
        ExtraTurn result = this.extraTurns.push(new ExtraTurn(player));
        for (Player p : this.game.getPlayers()) {
            p.setExtraTurnCount(this.getExtraTurnForPlayer(p));
        }
        ArrayList<Player> toUpdate = Lists.newArrayList(player);
        if (previous != null) {
            toUpdate.add(previous);
        }
        this.game.fireEvent(new GameEventPlayerStatsChanged(toUpdate, false));
        return result;
    }

    public final ExtraPhase addExtraPhase(PhaseType afterPhase, List<PhaseType> extraPhaseList, PhaseType nextPhase) {
        for (int i = 0; i < extraPhaseList.size(); ++i) {
            PhaseType extra = extraPhaseList.get(i);
            if (!this.extraPhases.containsKey((Object)extra)) {
                this.extraPhases.put(extra, new Stack());
            }
            if (i < extraPhaseList.size() - 1) {
                this.extraPhases.get((Object)extra).push(new ExtraPhase(extraPhaseList.get(i + 1)));
                continue;
            }
            if (this.extraPhases.containsKey((Object)afterPhase) && !this.extraPhases.get((Object)afterPhase).isEmpty()) {
                this.extraPhases.get((Object)extra).push(this.extraPhases.get((Object)afterPhase).pop());
                continue;
            }
            this.extraPhases.get((Object)extra).push(new ExtraPhase(nextPhase));
        }
        if (!this.extraPhases.containsKey((Object)afterPhase)) {
            this.extraPhases.put(afterPhase, new Stack());
        }
        return this.extraPhases.get((Object)afterPhase).push(new ExtraPhase(extraPhaseList.get(0)));
    }

    public final boolean isFirstCombat() {
        return this.nCombatsThisTurn == 1;
    }

    public final int getNumCombat() {
        return this.nCombatsThisTurn;
    }

    public final int getNumUpkeep() {
        return this.nUpkeepsThisTurn;
    }

    public final boolean isFirstUpkeep() {
        return this.is(PhaseType.UPKEEP) && this.nUpkeepsThisTurn == 0;
    }

    public final boolean isFirstUpkeepThisGame() {
        return this.is(PhaseType.UPKEEP) && this.nUpkeepsThisGame == 0;
    }

    public final int getNumMain() {
        return this.nMainsThisTurn;
    }

    public final boolean beforeFirstPostCombatMainEnd() {
        return this.nMainsThisTurn <= (this.is(PhaseType.MAIN2) ? 2 : 1);
    }

    public final boolean skippedDeclareBlockers() {
        return this.skipDamageSteps;
    }

    public void startFirstTurn(Player goesFirst) {
        this.startFirstTurn(goesFirst, null);
    }

    public void startFirstTurn(Player goesFirst, Runnable startGameHook) {
        StopWatch sw = new StopWatch();
        if (this.phase != null) {
            throw new IllegalStateException("Turns already started, call this only once per game");
        }
        this.setPlayerTurn(goesFirst);
        this.advanceToNextPhase();
        this.onPhaseBegin();
        this.givePriorityToPlayer = false;
        if (startGameHook != null) {
            startGameHook.run();
            this.givePriorityToPlayer = true;
        }
        while (!this.game.isGameOver()) {
            if (this.givePriorityToPlayer) {
                this.game.fireEvent(new GameEventPlayerPriority(this.playerTurn, this.phase, this.getPriorityPlayer()));
                List<SpellAbility> chosenSa = null;
                int loopCount = 0;
                do {
                    if (this.checkStateBasedEffects()) {
                        return;
                    }
                    this.game.stashGameState();
                    chosenSa = this.pPlayerPriority.getController().chooseSpellAbilityToPlay();
                    if (this.playerTurn.hasLost() && this.pPlayerPriority.equals(this.playerTurn) && this.pFirstPriority.equals(this.playerTurn)) {
                        System.out.println("Active player is no longer in the game...");
                        this.pFirstPriority = this.pPlayerPriority = this.game.getNextPlayerAfter(this.getPriorityPlayer());
                    }
                    if (chosenSa == null) break;
                    boolean rollback = false;
                    for (SpellAbility sa : chosenSa) {
                        Zone currentZone;
                        Card saHost = sa.getHostCard();
                        Zone originZone = saHost.getZone();
                        CardZoneTable triggerList = new CardZoneTable(this.game.getLastStateBattlefield(), this.game.getLastStateGraveyard());
                        if (this.pPlayerPriority.getController().playChosenSpellAbility(sa)) {
                            this.pFirstPriority = this.pPlayerPriority;
                        } else if (this.game.EXPERIMENTAL_RESTORE_SNAPSHOT) {
                            rollback = true;
                        }
                        if ((currentZone = (saHost = this.game.getCardState(saHost)).getZone()) == null || originZone == null || currentZone.equals(originZone) || !sa.isSpell() && !sa.isLandAbility()) continue;
                        triggerList.put(originZone.getZoneType(), currentZone.getZoneType(), saHost);
                        triggerList.triggerChangesZoneAll(this.game, sa);
                    }
                    if (rollback) continue;
                    this.game.copyLastState();
                } while (++loopCount < 999 || !this.pPlayerPriority.getController().isAI());
                if (loopCount >= 999 && this.pPlayerPriority.getController().isAI()) {
                    System.out.print("AI looped too much with: " + chosenSa);
                }
            }
            Player nextPlayer = this.game.getNextPlayerAfter(this.getPriorityPlayer());
            if (this.game.isGameOver() || nextPlayer == null) {
                return;
            }
            if (this.pFirstPriority == nextPlayer) {
                if (this.game.getStack().isEmpty()) {
                    if (this.playerTurn.hasLost()) {
                        this.setPriority(this.game.getNextPlayerAfter(this.playerTurn));
                    } else {
                        this.setPriority(this.playerTurn);
                    }
                    this.givePriorityToPlayer = true;
                    this.onPhaseEnd();
                    this.advanceToNextPhase();
                    this.onPhaseBegin();
                } else if (!this.game.getStack().hasSimultaneousStackEntries()) {
                    this.game.getStack().resolveStack();
                }
            } else {
                this.pPlayerPriority = nextPlayer;
            }
            if (this.game.getAge() == GameStage.RestartedByKarn) {
                this.setPhase(null);
                this.game.updatePhaseForView();
                this.game.fireEvent(new GameEventGameRestarted(this.playerTurn));
                return;
            }
            for (Player p : this.game.getPlayers()) {
                p.setHasPriority(this.getPriorityPlayer() == p);
            }
        }
    }

    private boolean checkStateBasedEffects() {
        HashSet<Card> allAffectedCards = new HashSet<Card>();
        do {
            this.game.getAction().checkStateEffects(false, allAffectedCards);
            if (!this.game.isGameOver()) continue;
            return true;
        } while (this.game.getStack().addAllTriggeredAbilitiesToStack());
        if (!allAffectedCards.isEmpty()) {
            this.game.fireEvent(new GameEventCardStatsChanged(allAffectedCards));
            allAffectedCards.clear();
        }
        return false;
    }

    public final boolean devAdvanceToPhase(PhaseType targetPhase) {
        return this.devAdvanceToPhase(targetPhase, null);
    }

    public final boolean devAdvanceToPhase(PhaseType targetPhase, Runnable resolver) {
        boolean isTopsy;
        boolean bl = isTopsy = this.playerTurn.getAmountOfKeyword("The phases of your turn are reversed.") % 2 == 1;
        while (this.phase.isBefore(targetPhase, isTopsy)) {
            if (this.checkStateBasedEffects()) {
                return false;
            }
            if (resolver != null) {
                resolver.run();
            }
            this.onPhaseEnd();
            this.advanceToNextPhase();
            this.onPhaseBegin();
        }
        this.checkStateBasedEffects();
        return true;
    }

    public final void devModeSet(PhaseType phase0, Player player0, boolean endCombat, int cturn) {
        if (phase0 != null) {
            this.setPhase(phase0);
        }
        if (player0 != null) {
            this.setPlayerTurn(player0);
        }
        this.turn = cturn;
        this.game.fireEvent(new GameEventTurnPhase(this.playerTurn, this.phase, "dev"));
        if (endCombat) {
            this.endCombat();
        }
    }

    public final void devModeSet(PhaseType phase0, Player player0) {
        this.devModeSet(phase0, player0, true, 1);
    }

    public final void devModeSet(PhaseType phase0, Player player0, int cturn) {
        this.devModeSet(phase0, player0, true, cturn);
    }

    public final void devModeSet(PhaseType phase0, Player player0, boolean endCombat) {
        this.devModeSet(phase0, player0, endCombat, 0);
    }

    public final void endCombatPhaseByEffect() {
        this.endCombat();
        this.game.getAction().checkStateEffects(true);
        this.setPhase(PhaseType.COMBAT_END);
        this.advanceToNextPhase();
    }

    public final void endTurnByEffect() {
        this.extraPhases.clear();
        this.setPhase(PhaseType.CLEANUP);
        this.game.fireEvent(new GameEventTurnPhase(this.playerTurn, this.phase, ""));
        this.onPhaseBegin();
    }

    public int getPlanarDiceSpecialActionThisTurn() {
        return this.planarDiceSpecialActionThisTurn;
    }

    public void incPlanarDiceSpecialActionThisTurn() {
        ++this.planarDiceSpecialActionThisTurn;
    }

    public String debugPrintState(boolean hasPriority) {
        return String.format("%s's %s [%sP] %s", this.playerTurn, this.phase.nameForUi, hasPriority ? "+" : "-", this.getPriorityPlayer());
    }

    public void onStackResolved() {
        this.givePriorityToPlayer = true;
    }

    public void endCombat() {
        this.game.getEndOfCombat().executeUntil();
        this.game.getEndOfCombat().executeUntilEndOfPhase(this.playerTurn);
        if (this.inCombat()) {
            this.combat.endCombat();
            this.combat = null;
        }
        this.game.updateCombatForView();
    }

    public void setCombat(Combat combat) {
        this.combat = combat;
    }

    public int getExtraTurnForPlayer(Player p) {
        ExtraTurn et;
        if (this.extraTurns.isEmpty() || this.extraTurns.size() < 2) {
            return 0;
        }
        int count = 0;
        Iterator iterator = this.extraTurns.subList(1, this.extraTurns.size()).iterator();
        while (iterator.hasNext() && (et = (ExtraTurn)iterator.next()).getPlayer().equals(p)) {
            ++count;
        }
        return count;
    }

    private void handleMultiplayerEffects() {
        int oldPlayerIdx = this.game.getRegisteredPlayers().indexOf(this.playerPreviousTurn);
        int playerIdx = this.game.getRegisteredPlayers().indexOf(this.playerTurn);
        int direction = this.game.getTurnOrder().getShift();
        while (oldPlayerIdx != playerIdx) {
            Player p;
            if ((oldPlayerIdx += direction) < 0) {
                oldPlayerIdx = this.game.getRegisteredPlayers().size() - 1;
            } else if (oldPlayerIdx > this.game.getRegisteredPlayers().size() - 1) {
                oldPlayerIdx = 0;
            }
            if (!(p = (Player)this.game.getRegisteredPlayers().get(oldPlayerIdx)).hasLost()) continue;
            Untap.doPhasing(p);
            this.game.getUntap().executeUntil(p);
            this.game.getUpkeep().executeUntil(p);
            this.game.getUpkeep().executeUntilEndOfPhase(p);
            this.game.getEndOfCombat().executeUntilEndOfPhase(p);
            this.game.getEndOfTurn().executeUntil(p);
            this.game.getEndOfTurn().executeUntilEndOfPhase(p);
            this.game.getCleanup().executeUntil(p);
        }
    }
}

