/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mulligan;

import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.mulligan.AbstractMulligan;
import forge.game.player.Player;
import forge.game.zone.ZoneType;

public class OriginalMulligan
extends AbstractMulligan {
    public OriginalMulligan(Player p, boolean firstMullFree) {
        super(p, firstMullFree);
    }

    @Override
    public boolean canMulligan() {
        if (this.timesMulliganed > 0) {
            return false;
        }
        int totalCards = 0;
        int lands = 0;
        for (Card c : this.player.getCardsIn(ZoneType.Hand)) {
            if (c.isLand()) {
                ++lands;
            }
            ++totalCards;
        }
        return lands == 0 || lands == totalCards;
    }

    @Override
    public void revealPreMulligan(CardCollection toMulligan) {
    }

    @Override
    public void mulliganDraw() {
        this.player.drawCards(this.handSizeAfterNextMulligan());
    }

    @Override
    public int handSizeAfterNextMulligan() {
        return this.player.getMaxHandSize();
    }
}

