/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mulligan;

import com.google.common.collect.Lists;
import forge.MulliganDefs;
import forge.StaticData;
import forge.game.Game;
import forge.game.GameType;
import forge.game.mulligan.AbstractMulligan;
import forge.game.mulligan.LondonMulligan;
import forge.game.mulligan.OriginalMulligan;
import forge.game.mulligan.ParisMulligan;
import forge.game.mulligan.VancouverMulligan;
import forge.game.player.Player;
import java.util.ArrayList;
import java.util.List;

public class MulliganService {
    Player firstPlayer;
    Game game;
    List<AbstractMulligan> mulligans = Lists.newArrayList();

    public MulliganService(Player player) {
        this.firstPlayer = player;
        this.game = this.firstPlayer.getGame();
    }

    public void perform() {
        this.initializeMulligans();
        this.runPlayerMulligans();
    }

    private void initializeMulligans() {
        ArrayList<Player> whoCanMulligan = Lists.newArrayList(this.game.getPlayers());
        int offset = whoCanMulligan.indexOf(this.firstPlayer);
        for (int i = 0; i < offset; ++i) {
            whoCanMulligan.add((Player)whoCanMulligan.remove(0));
        }
        boolean firstMullFree = this.game.getPlayers().size() > 2 || this.game.getRules().hasAppliedVariant(GameType.Brawl);
        block7: for (Player player : whoCanMulligan) {
            MulliganDefs.MulliganRule rule = StaticData.instance().getMulliganRule();
            switch (rule) {
                case Original: {
                    this.mulligans.add(new OriginalMulligan(player, firstMullFree));
                    continue block7;
                }
                case Paris: {
                    this.mulligans.add(new ParisMulligan(player, firstMullFree));
                    continue block7;
                }
                case Vancouver: {
                    this.mulligans.add(new VancouverMulligan(player, firstMullFree));
                    continue block7;
                }
                case London: {
                    this.mulligans.add(new LondonMulligan(player, firstMullFree));
                    continue block7;
                }
            }
            this.mulligans.add(new VancouverMulligan(player, firstMullFree));
        }
    }

    private void runPlayerMulligans() {
        boolean allKept;
        do {
            allKept = true;
            for (AbstractMulligan mulligan : this.mulligans) {
                boolean keep;
                if (mulligan.hasKept()) continue;
                Player p = mulligan.getPlayer();
                boolean bl = keep = !mulligan.canMulligan() || p.getController().mulliganKeepHand(this.firstPlayer, mulligan.tuckCardsAfterKeepHand());
                if (this.game.isGameOver()) {
                    return;
                }
                if (keep) {
                    mulligan.keep();
                    continue;
                }
                allKept = false;
                mulligan.mulligan();
            }
        } while (!allKept);
        for (AbstractMulligan mulligan : this.mulligans) {
            mulligan.afterMulligan();
        }
    }
}

