/*
 * Decompiled with CFR 0.152.
 */
package forge.game.mulligan;

import forge.game.GameLogEntryType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.util.Localizer;

public abstract class AbstractMulligan {
    Player player;
    int timesMulliganed = 0;
    boolean firstMulliganFree = false;
    boolean kept = false;

    public AbstractMulligan(Player p, boolean firstMullFree) {
        this.player = p;
        this.firstMulliganFree = firstMullFree;
    }

    public Player getPlayer() {
        return this.player;
    }

    public abstract boolean canMulligan();

    public abstract int handSizeAfterNextMulligan();

    public int tuckCardsAfterKeepHand() {
        return 0;
    }

    public void mulligan() {
        CardCollection toMulligan = new CardCollection(this.player.getCardsIn(ZoneType.Hand));
        if (toMulligan.isEmpty()) {
            return;
        }
        this.revealPreMulligan(toMulligan);
        for (Card c : toMulligan) {
            this.player.getGame().getAction().moveToLibrary(c, null);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.player.shuffle(null);
        ++this.timesMulliganed;
        this.mulliganDraw();
        this.player.onMulliganned();
    }

    public void keep() {
        this.kept = true;
    }

    public boolean hasKept() {
        return this.kept;
    }

    public void revealPreMulligan(CardCollection toMulligan) {
    }

    public void mulliganDraw() {
        this.player.drawCards(this.handSizeAfterNextMulligan());
    }

    public void afterMulligan() {
        this.player.getGame().getGameLog().add(GameLogEntryType.MULLIGAN, Localizer.getInstance().getMessage("lblPlayerKeepNCardsHand", this.player.getName(), String.valueOf(this.player.getZone(ZoneType.Hand).size())));
    }
}

