/*
 * Decompiled with CFR 0.152.
 */
package forge.game.keyword;

import forge.game.cost.Cost;
import forge.game.keyword.KeywordInstance;

public class KeywordWithCostAndAmount
extends KeywordInstance<KeywordWithCostAndAmount> {
    private Cost cost;
    private boolean withX;
    private int amount;

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    protected void parse(String details) {
        String[] k = details.split(":");
        if (k[0].startsWith("X")) {
            this.withX = true;
        } else {
            this.amount = Integer.parseInt(k[0]);
        }
        this.cost = new Cost(k[1].split("\\|", 2)[0].trim(), false);
    }

    @Override
    protected String formatReminderText(String reminderText) {
        String formatStr = reminderText;
        if (this.withX) {
            formatStr = reminderText.replaceAll("\\%(\\d+\\$)?d", "%$1s");
        }
        return String.format(formatStr, this.cost.toSimpleString(), this.withX ? "X" : Integer.valueOf(this.amount));
    }
}

