/*
 * Decompiled with CFR 0.152.
 */
package forge.game.extrahands;

import com.google.common.collect.Lists;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import java.util.List;

public class BackupPlanService {
    private final Player player;
    private boolean multipleHands = false;
    List<PlayerZone> hands = Lists.newArrayList();
    private PlayerZone hand;

    public BackupPlanService(Player p1) {
        this.player = p1;
    }

    public boolean initializeExtraHands() {
        this.hand = this.player.getZone(ZoneType.Hand);
        this.hands.add(this.hand);
        if (this.player.getExtraZones() == null) {
            return this.multipleHands;
        }
        for (PlayerZone extraHand : this.player.getExtraZones()) {
            if (extraHand.getZoneType() != ZoneType.ExtraHand) continue;
            this.player.drawCards(7, extraHand);
            this.multipleHands = true;
            this.hands.add(extraHand);
        }
        this.player.updateZoneForView(this.hand);
        return this.multipleHands;
    }

    public void chooseHand() {
        if (!this.multipleHands) {
            return;
        }
        PlayerZone library = this.player.getZone(ZoneType.Library);
        PlayerZone startingHand = this.player.getController().chooseStartingHand(this.hands);
        if (startingHand == this.hand) {
            for (PlayerZone extraHand : this.player.getExtraZones()) {
                if (extraHand.getZoneType() != ZoneType.ExtraHand) continue;
                for (Card c : Lists.newArrayList(extraHand.getCards().iterator())) {
                    this.player.getGame().getAction().moveTo(library, c, null);
                }
            }
        } else {
            for (Card c : Lists.newArrayList(this.hand.getCards().iterator())) {
                this.player.getGame().getAction().moveTo(library, c, null);
            }
            for (PlayerZone extraHand : this.player.getExtraZones()) {
                boolean starting = startingHand.equals(extraHand);
                for (Card c : Lists.newArrayList(extraHand.getCards().iterator())) {
                    if (starting) {
                        this.player.getGame().getAction().moveTo(this.hand, c, null);
                        continue;
                    }
                    this.player.getGame().getAction().moveTo(library, c, null);
                }
            }
        }
        this.player.resetExtraZones(ZoneType.ExtraHand);
        this.player.updateZoneForView(this.player.getZone(ZoneType.Hand));
    }
}

