/*
 * Decompiled with CFR 0.152.
 */
package forge.game.event;

import forge.game.card.Card;
import forge.game.event.EventValueChangeType;
import forge.game.event.GameEvent;
import forge.game.event.IGameEventVisitor;
import forge.game.player.Player;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.TextUtil;

public class GameEventZone
extends GameEvent {
    public final ZoneType zoneType;
    public final Player player;
    public final EventValueChangeType mode;
    public final Card card;

    public GameEventZone(ZoneType zoneType, Player player, EventValueChangeType added, Card c) {
        this.zoneType = zoneType;
        this.player = player;
        this.mode = added;
        this.card = c;
    }

    @Override
    public <T> T visit(IGameEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        String owners = this.player == null ? "Game" : Lang.getInstance().getPossesive(this.player.getName());
        return this.card == null ? TextUtil.concatWithSpace(owners, this.zoneType.toString(), ":", this.mode.toString()) : TextUtil.concatWithSpace(owners, this.zoneType.toString(), ":", this.mode.toString(), this.card.toString());
    }
}

