/*
 * Decompiled with CFR 0.152.
 */
package forge.game.event;

import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.event.GameEvent;
import forge.game.event.IGameEventVisitor;
import forge.game.player.Player;
import forge.util.Lang;
import forge.util.TextUtil;
import forge.util.maps.MapOfLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class GameEventBlockersDeclared
extends GameEvent {
    public final Map<GameEntity, MapOfLists<Card, Card>> blockers;
    public final Player defendingPlayer;

    public GameEventBlockersDeclared(Player who, Map<GameEntity, MapOfLists<Card, Card>> blockers) {
        this.blockers = blockers;
        this.defendingPlayer = who;
    }

    @Override
    public <T> T visit(IGameEventVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        ArrayList blockerCards = new ArrayList();
        for (MapOfLists<Card, Card> vv : this.blockers.values()) {
            for (Collection cc : vv.values()) {
                blockerCards.addAll(cc);
            }
        }
        return TextUtil.concatWithSpace(this.defendingPlayer.getName(), "declared", String.valueOf(blockerCards.size()), "blockers:", Lang.joinHomogenous(blockerCards));
    }
}

