/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import forge.card.CardType;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import java.util.EnumMap;
import java.util.HashSet;

public class CostSacrifice
extends CostPartWithList {
    private static final long serialVersionUID = 1L;

    public CostSacrifice(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 15;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        String type = this.getType();
        boolean differentNames = false;
        if (type.contains("+WithDifferentNames")) {
            type = type.replace("+WithDifferentNames", "");
            differentNames = true;
        }
        CardCollectionView typeList = payer.getCardsIn(ZoneType.Battlefield);
        typeList = CardLists.getValidCards((Iterable<Card>)typeList, type.split(";"), payer, source, (CardTraitBase)ability);
        typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.canBeSacrificedBy(ability, effect));
        if (differentNames) {
            HashSet<String> crdname = Sets.newHashSet();
            for (Card card : typeList) {
                String name = card.getName();
                if (card.hasNoName()) continue;
                crdname.add(name);
            }
            return crdname.size();
        }
        return typeList.size();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getAmount().equals("X")) {
            sb.append("You may sacrifice ");
        } else {
            sb.append("Sacrifice ");
        }
        if (this.payCostFromSource()) {
            sb.append(this.getTypeDescription() == null || !this.getTypeDescription().startsWith("this") ? this.getType() : this.getTypeDescription());
        } else if (this.getAmount().equals("X")) {
            String typeDesc = this.getType().toLowerCase().replace(";", "s and/or ");
            sb.append("any number of ").append(typeDesc).append("s");
        } else {
            String typeS;
            String desc = this.getTypeDescription() == null ? ((typeS = this.getType()).equals("Permanent") || CardType.CoreType.isValidEnum(typeS) ? typeS.toLowerCase() : typeS) : this.getTypeDescription();
            if (desc.startsWith("another")) {
                sb.append(desc);
            } else {
                sb.append(this.convertAmount() == null ? Lang.nounWithNumeralExceptOne(this.getAmount(), desc) : Lang.nounWithNumeralExceptOne(this.convertAmount(), desc));
            }
        }
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player activator, boolean effect) {
        Card source = ability.getHostCard();
        if (this.getType().equals("OriginalHost")) {
            Card originalEquipment = ability.getOriginalHost();
            return originalEquipment.isEquipping() && originalEquipment.canBeSacrificedBy(ability, effect);
        }
        if (this.payCostFromSource()) {
            return source.canBeSacrificedBy(ability, effect);
        }
        if ("All".equalsIgnoreCase(this.getAmount())) {
            CardCollectionView typeList = activator.getCardsIn(ZoneType.Battlefield);
            typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), activator, source, (CardTraitBase)ability);
            return Iterables.all(typeList, CardPredicates.canBeSacrificedBy(ability, effect));
        }
        int amount = this.getAbilityAmount(ability);
        return this.getMaxAmountX(ability, activator, effect) >= amount;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        return null;
    }

    @Override
    protected boolean canPayListAtOnce() {
        return true;
    }

    @Override
    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        Game game = ability.getHostCard().getGame();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(moveParams, this.table);
        return game.getAction().sacrifice(targetCards, ability, effect, moveParams);
    }

    @Override
    public String getHashForLKIList() {
        return "Sacrificed";
    }

    @Override
    public String getHashForCardList() {
        return "SacrificedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

