/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.GameLogEntryType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Arrays;
import java.util.List;

public class CostReveal
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    private List<ZoneType> revealFrom = Arrays.asList(ZoneType.Hand);

    public CostReveal(String amount, String type, String description) {
        super(amount, type, description);
    }

    public CostReveal(String amount, String type, String description, String zoneType) {
        super(amount, type, description);
        this.revealFrom = ZoneType.listValueOf(zoneType);
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public boolean isRenewable() {
        return true;
    }

    public List<ZoneType> getRevealFrom() {
        return this.revealFrom;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollectionView handList = payer.getCardsIn(this.revealFrom);
        if (ability.isSpell()) {
            CardCollection modifiedHand = new CardCollection(handList);
            modifiedHand.remove(source);
            handList = modifiedHand;
        }
        handList = CardLists.getValidCards((Iterable<Card>)handList, this.getType(), payer, source, (CardTraitBase)ability);
        return handList.size();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollectionView handList = payer.getCardsIn(this.revealFrom);
        int amount = this.getAbilityAmount(ability);
        if (this.payCostFromSource()) {
            return this.revealFrom.contains((Object)source.getLastKnownZone().getZoneType());
        }
        if (this.getType().equals("Hand")) {
            return true;
        }
        if (this.getType().equals("SameColor")) {
            for (Card card : handList) {
                if (CardLists.count(handList, CardPredicates.sharesColorWith(card)) < amount) continue;
                return true;
            }
            return false;
        }
        return amount <= this.getMaxAmountX(ability, payer, effect);
    }

    @Override
    public final String toString() {
        StringBuilder desc;
        StringBuilder sb = new StringBuilder();
        sb.append("Reveal ");
        Integer i = this.convertAmount();
        if (this.payCostFromSource()) {
            sb.append(this.getType());
        } else {
            if (this.getType().equals("Hand")) {
                return "Reveal your hand";
            }
            if (this.getType().equals("SameColor")) {
                return "Reveal " + i + " cards from your hand that share a color";
            }
            desc = new StringBuilder();
            if (this.getType().equals("Card")) {
                desc.append("Card");
            } else {
                desc.append(this.getTypeDescription() == null ? this.getType() : this.getTypeDescription()).append(" card");
            }
            sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), desc.toString()));
        }
        sb.append(" from your ");
        sb.append(this.revealFrom.get(0).getTranslatedName());
        if (this.revealFrom.size() > 1) {
            desc = new StringBuilder();
            desc.append(this.getTypeDescription() == null ? this.getType() : this.getTypeDescription());
            sb.append(" or choose ");
            sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), desc.toString()));
            sb.append(" you control");
        }
        return sb.toString();
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        targetCard.getGame().getAction().reveal(new CardCollection(targetCard), payer);
        StringBuilder sb = new StringBuilder();
        sb.append(ability.getActivatingPlayer());
        if (targetCard.isInZone(ZoneType.Hand)) {
            sb.append(" reveals ");
        } else {
            sb.append(" chooses ");
        }
        sb.append(targetCard).append(" to pay a cost for ");
        sb.append(ability);
        targetCard.getGame().getGameLog().add(GameLogEntryType.INFORMATION, sb.toString());
        return targetCard;
    }

    @Override
    protected boolean canPayListAtOnce() {
        return true;
    }

    @Override
    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        ability.getActivatingPlayer().getGame().getAction().reveal(targetCards, payer);
        return targetCards;
    }

    @Override
    public String getHashForLKIList() {
        return "Revealed";
    }

    @Override
    public String getHashForCardList() {
        return "RevealedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public int paymentOrder() {
        if (!this.revealFrom.get(0).equals((Object)ZoneType.Hand)) {
            return -1;
        }
        return 5;
    }
}

