/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.base.Optional;
import forge.game.CardTraitBase;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class CostRemoveAnyCounter
extends CostPart {
    private static final long serialVersionUID = 1L;
    public final CounterType counter;
    public final Boolean oneOrMore;

    public CostRemoveAnyCounter(String amount, CounterType counter, String type, String description, boolean oneOrMore) {
        super(amount, type, description);
        this.counter = counter;
        this.oneOrMore = oneOrMore;
    }

    @Override
    public int paymentOrder() {
        return 8;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollection validCards = CardLists.getValidCards((Iterable<Card>)payer.getCardsIn(ZoneType.Battlefield), this.getType().split(";"), payer, source, (CardTraitBase)ability);
        int allCounters = 0;
        for (Card c : validCards) {
            if (this.counter != null) {
                if (!c.canRemoveCounters(this.counter)) continue;
                allCounters += c.getCounters(this.counter);
                continue;
            }
            for (Map.Entry<CounterType, Integer> entry : c.getCounters().entrySet()) {
                if (!c.canRemoveCounters(entry.getKey())) continue;
                allCounters += entry.getValue().intValue();
            }
        }
        return allCounters;
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return AbilityUtils.calculateAmount(ability.getHostCard(), this.getAmount(), ability) <= this.getMaxAmountX(ability, payer, effect);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        String counters = this.counter == null ? "counter" : this.counter.getName().toLowerCase() + " counter";
        String desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
        sb.append("Remove ");
        if (this.oneOrMore.booleanValue()) {
            sb.append("one or more ").append(counters).append("s");
        } else {
            sb.append(Cost.convertAmountTypeToWords(this.convertAmount(), this.getAmount(), counters));
            sb.append(this.getAmount().equals("1") ? "" : "s");
        }
        sb.append(" from ").append(desc).append(" you control");
        return sb.toString();
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        int removed = 0;
        for (Map.Entry e : decision.counterTable.row(Optional.absent()).entrySet()) {
            for (Map.Entry v : ((Map)e.getValue()).entrySet()) {
                removed += ((Integer)v.getValue()).intValue();
                ((GameEntity)e.getKey()).subtractCounter((CounterType)v.getKey(), (int)((Integer)v.getValue()), ai);
            }
            if (!(e.getKey() instanceof Card)) continue;
            ((GameEntity)e.getKey()).getGame().updateLastStateForCard((Card)e.getKey());
        }
        ability.setSVar("CostCountersRemoved", Integer.toString(removed));
        return true;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

