/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Sets;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class CostPutCounter
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    private final CounterType counter;
    private int lastPaidAmount = 0;
    private final GameEntityCounterTable counterTable = new GameEntityCounterTable();

    public final CounterType getCounter() {
        return this.counter;
    }

    public final void setLastPaidAmount(int paidAmount) {
        this.lastPaidAmount = paidAmount;
    }

    public CostPutCounter(String amount, CounterType cntr, String type, String description) {
        super(amount, type, description);
        this.counter = cntr;
    }

    @Override
    public int paymentOrder() {
        return 6;
    }

    @Override
    public boolean isReusable() {
        return !this.counter.is(CounterEnumType.M1M1);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.counter.is(CounterEnumType.LOYALTY)) {
            if (this.getAmount().equals("0")) {
                sb.append("0");
            } else {
                sb.append("+").append(this.getAmount());
            }
        } else {
            sb.append("Put ");
            Integer i = this.convertAmount();
            sb.append(Cost.convertAmountTypeToWords(i, this.getAmount(), this.counter.getName() + " counter"));
            sb.append(" on ");
            if (this.payCostFromSource()) {
                sb.append(this.getType());
            } else {
                String desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
                sb.append(desc);
            }
        }
        return sb.toString();
    }

    @Override
    public final void refund(Card source) {
        if (this.payCostFromSource()) {
            source.subtractCounter(this.counter, this.lastPaidAmount, null);
        } else {
            Integer i = this.convertAmount();
            for (Card c : this.getCardList()) {
                c.subtractCounter(this.counter, (int)i, null);
            }
        }
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        Game game = source.getGame();
        if (this.payCostFromSource()) {
            if (this.isETBReplacement(ability, effect)) {
                Card copy = CardCopyService.getLKICopy(source);
                copy.setLastKnownZone(payer.getZone(ZoneType.Battlefield));
                CardCollection preList = new CardCollection(copy);
                game.getAction().checkStaticAbilities(false, Sets.newHashSet(copy), preList);
                game.getAction().checkStaticAbilities(false);
                if (copy.canReceiveCounters(this.getCounter())) {
                    return true;
                }
            } else {
                if (!source.isInPlay()) {
                    return false;
                }
                if (source.canReceiveCounters(this.getCounter())) {
                    return true;
                }
            }
            return this.getAbilityAmount(ability) == 0;
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)source.getGame().getCardsIn(ZoneType.Battlefield), this.getType().split(";"), payer, source, (CardTraitBase)ability);
        return !(typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.canReceiveCounters(this.getCounter()))).isEmpty();
    }

    @Override
    public boolean payAsDecided(Player payer, PaymentDecision decision, SpellAbility ability, boolean effect) {
        if (this.payCostFromSource()) {
            this.executePayment(payer, ability, ability.getHostCard(), effect);
        } else {
            this.executePayment(payer, ability, decision.cards, effect);
        }
        this.triggerCounterPutAll(ability, effect);
        return true;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        int i = this.getAbilityAmount(ability);
        if (this.isETBReplacement(ability, effect)) {
            GameEntityCounterTable etbTable = (GameEntityCounterTable)ability.getReplacingObject(AbilityKey.CounterTable);
            etbTable.put(payer, targetCard, this.getCounter(), i);
        } else {
            targetCard.addCounter(this.getCounter(), i, payer, this.counterTable);
        }
        return targetCard;
    }

    @Override
    public String getHashForLKIList() {
        return "CounterPut";
    }

    @Override
    public String getHashForCardList() {
        return "CounterPutCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }

    protected void triggerCounterPutAll(SpellAbility ability, boolean effect) {
        if (this.counterTable.isEmpty()) {
            return;
        }
        GameEntityCounterTable tempTable = new GameEntityCounterTable(this.counterTable);
        tempTable.replaceCounterEffect(ability.getHostCard().getGame(), ability, effect);
    }

    @Override
    public void resetLists() {
        super.resetLists();
        this.counterTable.clear();
    }

    protected boolean isETBReplacement(SpellAbility ability, boolean effect) {
        if (!effect) {
            return false;
        }
        if (!this.payCostFromSource()) {
            return false;
        }
        if (ability == null) {
            return false;
        }
        if (!ability.isReplacementAbility()) {
            return false;
        }
        ReplacementEffect re = ability.getReplacementEffect();
        if (re.getMode() != ReplacementType.Moved) {
            return false;
        }
        return ability.getHostCard().equals(ability.getReplacingObject(AbilityKey.Card));
    }
}

