/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.MagicColor;
import forge.card.mana.ManaCostShard;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardZoneTable;
import forge.game.cost.Cost;
import forge.game.cost.CostAdjustment;
import forge.game.cost.CostDecisionMakerBase;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartWithList;
import forge.game.cost.PaymentDecision;
import forge.game.mana.Mana;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.mana.ManaPool;
import forge.game.mana.ManaRefundService;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CostPayment
extends ManaConversionMatrix {
    private final Cost cost;
    private Cost adjustedCost;
    private final SpellAbility ability;
    private final List<CostPart> paidCostParts = Lists.newArrayList();

    public final Cost getCost() {
        return this.cost;
    }

    public final SpellAbility getAbility() {
        return this.ability;
    }

    public CostPayment(Cost cost, SpellAbility abil) {
        this.cost = cost;
        this.adjustedCost = cost;
        this.ability = abil;
        this.restoreColorReplacements();
    }

    public static boolean canPayAdditionalCosts(Cost cost, SpellAbility ability, boolean effect) {
        if (cost == null) {
            return true;
        }
        cost = CostAdjustment.adjust(cost, ability);
        return cost.canPay(ability, effect);
    }

    public final boolean isFullyPaid() {
        for (CostPart part : this.adjustedCost.getCostParts()) {
            if (this.paidCostParts.contains(part)) continue;
            return false;
        }
        return true;
    }

    public final void refundPayment() {
        Card sourceCard = this.ability.getHostCard();
        for (CostPart part : this.paidCostParts) {
            if (!part.isUndoable()) continue;
            part.refund(sourceCard);
        }
        new ManaRefundService(this.ability).refundManaPaid();
    }

    public boolean payCost(CostDecisionMakerBase decisionMaker) {
        this.adjustedCost = CostAdjustment.adjust(this.cost, this.ability);
        List<CostPart> costParts = this.adjustedCost.getCostPartsWithZeroMana();
        Game game = decisionMaker.getPlayer().getGame();
        for (CostPart part : costParts) {
            game.costPaymentStack.push(part, this);
            PaymentDecision pd = part.accept(decisionMaker);
            if (pd != null) {
                pd.matrix = this;
            }
            if (pd == null || !part.payAsDecided(decisionMaker.getPlayer(), pd, this.ability, decisionMaker.isEffect())) {
                game.costPaymentStack.pop();
                return false;
            }
            this.paidCostParts.add(part);
            game.costPaymentStack.pop();
        }
        for (CostPart part1 : this.paidCostParts) {
            if (!(part1 instanceof CostPartWithList)) continue;
            ((CostPartWithList)part1).resetLists();
        }
        return true;
    }

    public final boolean payComputerCosts(CostDecisionMakerBase decisionMaker) {
        if (this.ability.getActivatingPlayer() == null) {
            this.ability.setActivatingPlayer(decisionMaker.getPlayer());
        }
        HashMap<CostPart, PaymentDecision> decisions = Maps.newHashMap();
        List<CostPart> parts = CostAdjustment.adjust(this.cost, this.ability).getCostPartsWithZeroMana();
        Game game = decisionMaker.getPlayer().getGame();
        for (CostPart part : parts) {
            PaymentDecision decision = part.accept(decisionMaker);
            if (null == decision) {
                return false;
            }
            game.costPaymentStack.push(part, this);
            if (decisionMaker.paysRightAfterDecision() && !part.payAsDecided(decisionMaker.getPlayer(), decision, this.ability, decisionMaker.isEffect())) {
                game.costPaymentStack.pop();
                return false;
            }
            game.costPaymentStack.pop();
            decisions.put(part, decision);
        }
        for (CostPart part : parts) {
            game.costPaymentStack.push(part, this);
            if (!part.payAsDecided(decisionMaker.getPlayer(), (PaymentDecision)decisions.get(part), this.ability, decisionMaker.isEffect())) {
                game.costPaymentStack.pop();
                return false;
            }
            if (part instanceof CostPartWithList) {
                ((CostPartWithList)part).resetLists();
            }
            game.costPaymentStack.pop();
        }
        return true;
    }

    public static Mana getMana(Player player, ManaCostShard shard, SpellAbility saBeingPaidFor, byte colorsPaid, Map<String, Integer> xManaCostPaidByColor) {
        List<Pair<Mana, Integer>> weightedOptions = CostPayment.selectManaToPayFor(player.getManaPool(), shard, saBeingPaidFor, colorsPaid, xManaCostPaidByColor);
        if (weightedOptions.isEmpty()) {
            return null;
        }
        ArrayList<Mana> manaChoices = new ArrayList<Mana>();
        int bestWeight = Integer.MIN_VALUE;
        for (Pair<Mana, Integer> option : weightedOptions) {
            int thisWeight = option.getRight();
            Mana thisMana = option.getLeft();
            if (thisWeight > bestWeight) {
                manaChoices.clear();
                bestWeight = thisWeight;
            }
            if (thisWeight != bestWeight) continue;
            boolean haveDuplicate = false;
            for (Mana m4 : manaChoices) {
                if (!m4.equals(thisMana)) continue;
                haveDuplicate = true;
                break;
            }
            if (haveDuplicate) continue;
            manaChoices.add(thisMana);
        }
        if (manaChoices.size() == 1) {
            return (Mana)manaChoices.get(0);
        }
        if (!player.getController().isAI()) {
            return (Mana)manaChoices.get(0);
        }
        return player.getController().chooseManaFromPool(manaChoices);
    }

    private static List<Pair<Mana, Integer>> selectManaToPayFor(ManaPool manapool, ManaCostShard shard, SpellAbility saBeingPaidFor, byte colorsPaid, Map<String, Integer> xManaCostPaidByColor) {
        ArrayList<Pair<Mana, Integer>> weightedOptions = new ArrayList<Pair<Mana, Integer>>();
        for (Mana thisMana : manapool) {
            if (shard == ManaCostShard.COLORED_X && !ManaCostBeingPaid.canColoredXShardBePaidByColor(MagicColor.toShortString(thisMana.getColor()), xManaCostPaidByColor) || !manapool.canPayForShardWithColor(shard, thisMana.getColor()) || shard.isSnow() && !thisMana.isSnow() || thisMana.getManaAbility() != null && !thisMana.getManaAbility().meetsSpellAndShardRestrictions(saBeingPaidFor, shard, thisMana.getColor()) || !saBeingPaidFor.allowsPayingWithShard(thisMana.getSourceCard(), thisMana.getColor())) continue;
            int weight = 0;
            weight = colorsPaid == -1 ? (weight += thisMana.isColorless() ? 5 : 0) : (weight += (thisMana.getColor() | colorsPaid) != colorsPaid ? 5 : 0);
            if (thisMana.isRestricted()) {
                weight += 2;
            }
            if (!thisMana.isSnow()) {
                ++weight;
            }
            weightedOptions.add(Pair.of(thisMana, weight));
        }
        return weightedOptions;
    }

    public static boolean handleOfferings(SpellAbility sa, boolean test, boolean costIsPaid) {
        Game game = sa.getHostCard().getGame();
        CardZoneTable table = new CardZoneTable(game.getLastStateBattlefield(), game.getLastStateGraveyard());
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(params, table);
        if (sa.isOffering()) {
            if (sa.getSacrificedAsOffering() == null) {
                return false;
            }
            Card offering = sa.getSacrificedAsOffering();
            offering.setUsedToPay(false);
            if (test) {
                sa.resetSacrificedAsOffering();
            } else if (costIsPaid) {
                game.getAction().sacrifice(new CardCollection(offering), sa, false, params);
            }
        }
        if (sa.isEmerge()) {
            if (sa.getSacrificedAsEmerge() == null) {
                return false;
            }
            Card emerge = sa.getSacrificedAsEmerge();
            emerge.setUsedToPay(false);
            if (test) {
                sa.resetSacrificedAsEmerge();
            } else if (costIsPaid) {
                game.getAction().sacrifice(new CardCollection(emerge), sa, false, params);
                sa.setSacrificedAsEmerge(game.getChangeZoneLKIInfo(emerge));
            }
        }
        if (!table.isEmpty()) {
            table.triggerChangesZoneAll(sa.getHostCard().getGame(), sa);
        }
        return true;
    }
}

