/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.base.Strings;
import forge.game.card.Card;
import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostPayShards
extends CostPart {
    private static final long serialVersionUID = 1L;
    int paidAmount = 0;

    public CostPayShards(String amount) {
        this.setAmount(amount);
    }

    @Override
    public int paymentOrder() {
        return 7;
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        return payer.getNumManaShards();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pay ");
        sb.append(Strings.repeat("{M}", Integer.parseInt(this.getAmount())));
        return sb.toString();
    }

    @Override
    public final void refund(Card source) {
        source.getController().loseShards(this.paidAmount * -1);
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return payer.getNumManaShards() >= this.getAbilityAmount(ability);
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        this.paidAmount = decision.c;
        return ai.payShards(this.paidAmount, null);
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

