/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.cost.CostPart;
import forge.game.cost.ICostVisitor;
import forge.game.cost.PaymentDecision;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CostPayLife
extends CostPart {
    private static final long serialVersionUID = 1L;

    public CostPayLife(String amount, String description) {
        super(amount, "card", description);
    }

    @Override
    public int paymentOrder() {
        return 7;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pay ");
        String desc = this.getTypeDescription();
        if (desc != null) {
            sb.append(desc);
        } else {
            sb.append(this.getAmount()).append(" life");
        }
        return sb.toString();
    }

    @Override
    public Integer getMaxAmountX(SpellAbility ability, Player payer, boolean effect) {
        if (!payer.canPayLife(1, effect, ability)) {
            return 0;
        }
        return payer.getLife();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return payer.canPayLife(this.getAbilityAmount(ability), effect, ability);
    }

    @Override
    public boolean payAsDecided(Player ai, PaymentDecision decision, SpellAbility ability, boolean effect) {
        return ai.payLife(decision.c, ability, effect);
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

