/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;

public class CostGainControl
extends CostPartWithList {
    private static final long serialVersionUID = 1L;

    public CostGainControl(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public int paymentOrder() {
        return 8;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        String desc = this.getTypeDescription() == null ? this.getType() : this.getTypeDescription();
        sb.append("Gain control of ").append(Cost.convertAmountTypeToWords(this.getAmount(), desc));
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        Card source = ability.getHostCard();
        CardCollectionView typeList = payer.getGame().getCardsIn(ZoneType.Battlefield);
        typeList = CardLists.getValidCards((Iterable<Card>)typeList, this.getType().split(";"), payer, source, (CardTraitBase)ability);
        return (typeList = CardLists.filter((Iterable<Card>)typeList, c -> c.canBeControlledBy(payer))).size() >= this.getAbilityAmount(ability);
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        targetCard.addTempController(payer, payer.getGame().getNextTimestamp());
        return targetCard;
    }

    @Override
    public String getHashForLKIList() {
        return "ControllGained";
    }

    @Override
    public String getHashForCardList() {
        return "ControlGainedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

