/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;
import java.util.Map;

public class CostForage
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    public static final String HashLKIListKey = "Foraged";
    public static final String HashCardListKey = "ForagedCards";

    @Override
    public boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        CardCollection graveyard = CardLists.filter((Iterable<Card>)payer.getCardsIn(ZoneType.Graveyard), CardPredicates.canExiledBy(ability, effect));
        if (graveyard.size() >= 3) {
            return true;
        }
        CardCollection food = CardLists.filter(payer.getCardsIn(ZoneType.Battlefield), CardPredicates.isType("Food"), CardPredicates.canBeSacrificedBy(ability, effect));
        return !food.isEmpty();
    }

    @Override
    public String toString() {
        return "Forage";
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        return null;
    }

    @Override
    protected boolean canPayListAtOnce() {
        return true;
    }

    @Override
    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        Game game = payer.getGame();
        if (targetCards.size() == 3) {
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            AbilityKey.addCardZoneTableParams(moveParams, this.table);
            CardCollection result = new CardCollection();
            for (Card targetCard : targetCards) {
                Card newCard = game.getAction().exile(targetCard, null, moveParams);
                result.add(newCard);
                SpellAbilityEffect.handleExiledWith(newCard, ability);
            }
            this.triggerForage(payer);
            return result;
        }
        if (targetCards.size() == 1) {
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            AbilityKey.addCardZoneTableParams(moveParams, this.table);
            CardCollection result = game.getAction().sacrifice(targetCards, ability, effect, moveParams);
            this.triggerForage(payer);
            return result;
        }
        return null;
    }

    protected void triggerForage(Player payer) {
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(payer);
        payer.getGame().getTriggerHandler().runTrigger(TriggerType.Forage, runParams, false);
    }

    @Override
    public String getHashForLKIList() {
        return HashLKIListKey;
    }

    @Override
    public String getHashForCardList() {
        return HashCardListKey;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

