/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.cost.CostPartWithTrigger;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.Map;

public class CostEnlist
extends CostPartWithTrigger {
    private static final long serialVersionUID = 1L;

    public CostEnlist(String amount, String type, String description) {
        super(amount, type, description);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Enlist " + this.getType());
        return sb.toString();
    }

    @Override
    public final boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        return !CostEnlist.getCardsForEnlisting(payer).isEmpty();
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        Map<AbilityKey, Object> runParams;
        if (targetCard.tap(true, ability, payer)) {
            ability.getHostCard().setEnlistedThisCombat(true);
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, new CardCollection(targetCard));
            payer.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
        this.payTrig.addRemembered(targetCard);
        runParams = AbilityKey.mapFromCard(this.payTrig.getHostCard());
        runParams.put(AbilityKey.Enlisted, targetCard);
        targetCard.getGame().getTriggerHandler().runTrigger(TriggerType.Enlisted, runParams, false);
        return targetCard;
    }

    @Override
    public String getHashForLKIList() {
        return "Enlisted";
    }

    @Override
    public String getHashForCardList() {
        return "EnlistedCards";
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static CardCollection getCardsForEnlisting(Player active) {
        return CardLists.filter((Iterable<Card>)active.getCreaturesInPlay(), c -> c.canTap() && !c.isSick() && !c.isAttacking());
    }
}

