/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.cost.CostPartWithList;
import forge.game.cost.ICostVisitor;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CostCollectEvidence
extends CostPartWithList {
    private static final long serialVersionUID = 1L;
    public static final String HashLKIListKey = "Collected";
    public static final String HashCardListKey = "CollectedCards";

    public CostCollectEvidence(String amount) {
        this.setAmount(amount);
    }

    @Override
    public String getHashForLKIList() {
        return HashLKIListKey;
    }

    @Override
    public String getHashForCardList() {
        return HashCardListKey;
    }

    @Override
    public int paymentOrder() {
        return 15;
    }

    @Override
    public boolean canPay(SpellAbility ability, Player payer, boolean effect) {
        int amount = this.getAbilityAmount(ability);
        return CardLists.getTotalCMC(CardLists.filter((Iterable<Card>)payer.getCardsIn(ZoneType.Graveyard), CardPredicates.canExiledBy(ability, effect))) >= amount;
    }

    @Override
    public <T> T accept(ICostVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Collect evidence ");
        sb.append(this.getAmount());
        return sb.toString();
    }

    @Override
    protected boolean canPayListAtOnce() {
        return true;
    }

    @Override
    protected Card doPayment(Player payer, SpellAbility ability, Card targetCard, boolean effect) {
        return null;
    }

    @Override
    protected CardCollectionView doListPayment(Player payer, SpellAbility ability, CardCollectionView targetCards, boolean effect) {
        Game game = payer.getGame();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        AbilityKey.addCardZoneTableParams(moveParams, this.table);
        CardCollection moved = game.getAction().exile(new CardCollection(targetCards), ability, moveParams);
        SpellAbilityEffect.handleExiledWith(moved, ability);
        game.getTriggerHandler().runTrigger(TriggerType.CollectEvidence, AbilityKey.mapFromPlayer(payer), false);
        return moved;
    }
}

