/*
 * Decompiled with CFR 0.152.
 */
package forge.game.cost;

import com.google.common.collect.Lists;
import forge.card.CardType;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.CostAddMana;
import forge.game.cost.CostChooseColor;
import forge.game.cost.CostChooseCreatureType;
import forge.game.cost.CostCollectEvidence;
import forge.game.cost.CostDamage;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostDraw;
import forge.game.cost.CostEnlist;
import forge.game.cost.CostExert;
import forge.game.cost.CostExile;
import forge.game.cost.CostExileFromStack;
import forge.game.cost.CostExiledMoveToGrave;
import forge.game.cost.CostFlipCoin;
import forge.game.cost.CostForage;
import forge.game.cost.CostGainControl;
import forge.game.cost.CostGainLife;
import forge.game.cost.CostMill;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.cost.CostPartWithList;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostPayShards;
import forge.game.cost.CostPromiseGift;
import forge.game.cost.CostPutCardToLib;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveAnyCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostReturn;
import forge.game.cost.CostReveal;
import forge.game.cost.CostRevealChosen;
import forge.game.cost.CostRollDice;
import forge.game.cost.CostSacrifice;
import forge.game.cost.CostTap;
import forge.game.cost.CostTapType;
import forge.game.cost.CostUnattach;
import forge.game.cost.CostUntap;
import forge.game.cost.CostUntapType;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Cost
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isAbility = true;
    private final List<CostPart> costParts = Lists.newArrayList();
    private boolean isMandatory = false;
    private boolean tapCost = false;
    private static final String[] NUM_NAMES = new String[]{"zero", "a", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
    public static final Cost Zero = new Cost(0);

    public final boolean hasTapCost() {
        return this.tapCost;
    }

    private void cacheTapCost() {
        this.tapCost = this.hasSpecificCostType(CostTap.class);
    }

    public final boolean hasNoManaCost() {
        return this.getCostMana() == null;
    }

    public final boolean hasManaCost() {
        return !this.hasNoManaCost();
    }

    public final boolean hasSpecificCostType(Class<? extends CostPart> costType) {
        for (CostPart p : this.getCostParts()) {
            if (!costType.isInstance(p)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasOnlySpecificCostType(Class<? extends CostPart> costType) {
        for (CostPart p : this.getCostParts()) {
            if (costType.isInstance(p)) continue;
            return false;
        }
        return true;
    }

    public <T extends CostPart> T getCostPartByType(Class<T> costType) {
        for (CostPart p : this.getCostParts()) {
            if (!costType.isInstance(p)) continue;
            return (T)p;
        }
        return null;
    }

    public final List<CostPart> getCostParts() {
        return this.costParts;
    }

    public void sort() {
        this.costParts.sort((o1, o2) -> ObjectUtils.compare(o1.paymentOrder(), o2.paymentOrder()));
    }

    public final List<CostPart> getCostPartsWithZeroMana() {
        if (this.hasManaCost()) {
            return this.costParts;
        }
        ArrayList<CostPart> newCostParts = Lists.newArrayListWithCapacity(this.costParts.size() + 1);
        newCostParts.addAll(this.costParts);
        newCostParts.add(new CostPartMana(ManaCost.ZERO, null));
        return newCostParts;
    }

    public final boolean isOnlyManaCost() {
        for (CostPart part : this.costParts) {
            if (part instanceof CostPartMana) continue;
            return false;
        }
        return true;
    }

    public final ManaCost getTotalMana() {
        CostPartMana manapart = this.getCostMana();
        return manapart == null ? ManaCost.ZERO : manapart.getMana();
    }

    public final boolean isMandatory() {
        return this.isMandatory;
    }

    public final void setMandatory(boolean b) {
        this.isMandatory = b;
    }

    public final boolean isAbility() {
        return this.isAbility;
    }

    private Cost() {
    }

    private Cost(int genericMana) {
        this.costParts.add(new CostPartMana(ManaCost.get(genericMana), null));
    }

    public Cost(ManaCost cost, boolean bAbility) {
        this.isAbility = bAbility;
        this.costParts.add(new CostPartMana(cost, null));
    }

    public Cost(String parse, boolean bAbility) {
        this(parse, bAbility, true);
    }

    public Cost(String parse, boolean bAbility, boolean intrinsic) {
        String[] parts;
        this.isAbility = bAbility;
        String xMin = "";
        boolean untapCost = false;
        StringBuilder manaParts = new StringBuilder();
        for (String part : parts = TextUtil.splitWithParenthesis(parse, ' ', '<', '>')) {
            if (part.equals("T") || part.equals("Tap")) {
                this.tapCost = true;
            }
            if (!part.equals("Q") && !part.equals("Untap")) continue;
            untapCost = true;
        }
        CostPartMana parsedMana = null;
        for (String part : parts) {
            if (part.startsWith("XMin")) {
                xMin = part;
                continue;
            }
            if ("Mandatory".equals(part)) {
                this.isMandatory = true;
                continue;
            }
            CostPart cp = Cost.parseCostPart(part, this.tapCost, untapCost);
            if (null != cp) {
                if (cp instanceof CostPartMana) {
                    parsedMana = (CostPartMana)cp;
                    continue;
                }
                if (cp instanceof CostPartWithList) {
                    ((CostPartWithList)cp).setIntrinsic(intrinsic);
                }
                this.costParts.add(cp);
                continue;
            }
            manaParts.append(part).append(" ");
        }
        if (!(parsedMana != null || manaParts.length() <= 0 && xMin.isEmpty())) {
            parsedMana = new CostPartMana(new ManaCost(new ManaCostParser(manaParts.toString())), xMin.isEmpty() ? null : xMin);
        }
        if (parsedMana != null) {
            this.costParts.add(parsedMana);
        }
        this.sort();
    }

    private static CostPart parseCostPart(String parse, boolean tapCost, boolean untapCost) {
        if (parse.startsWith("Mana<")) {
            String[] splitStr = TextUtil.split(Cost.abCostParse(parse, 1)[0], '\\');
            String restriction = splitStr.length > 1 ? splitStr[1] : null;
            return new CostPartMana(new ManaCost(new ManaCostParser(splitStr[0])), restriction);
        }
        if (parse.startsWith("tapXType<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostTapType(splitStr[0], splitStr[1], description, tapCost);
        }
        if (parse.startsWith("untapYType<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostUntapType(splitStr[0], splitStr[1], description, untapCost);
        }
        if (parse.startsWith("SubCounter<")) {
            String[] splitStr = Cost.abCostParse(parse, 5);
            String type = splitStr.length > 2 ? splitStr[2] : "CARDNAME";
            String description = splitStr.length > 3 ? splitStr[3] : null;
            List<ZoneType> zone = splitStr.length > 4 ? ZoneType.listValueOf(splitStr[4]) : Lists.newArrayList(ZoneType.Battlefield);
            boolean oneOrMore = false;
            if (splitStr[0].equals("X1+")) {
                oneOrMore = true;
                splitStr[0] = "X";
            }
            return new CostRemoveCounter(splitStr[0], CounterType.getType(splitStr[1]), type, description, zone, oneOrMore);
        }
        if (parse.startsWith("AddCounter<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String target = splitStr.length > 2 ? splitStr[2] : "CARDNAME";
            String description = splitStr.length > 3 ? splitStr[3] : null;
            return new CostPutCounter(splitStr[0], CounterType.getType(splitStr[1]), target, description);
        }
        if (parse.startsWith("PayLife<")) {
            String[] splitStr = Cost.abCostParse(parse, 2);
            String description = splitStr.length > 1 ? splitStr[1] : null;
            return new CostPayLife(splitStr[0], description);
        }
        if (parse.startsWith("PayEnergy<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostPayEnergy(splitStr[0]);
        }
        if (parse.startsWith("PayShards<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostPayShards(splitStr[0]);
        }
        if (parse.startsWith("GainLife<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            int cnt = splitStr.length > 2 ? ("*".equals(splitStr[2]) ? Integer.MAX_VALUE : Integer.parseInt(splitStr[2])) : 1;
            return new CostGainLife(splitStr[0], splitStr[1], cnt);
        }
        if (parse.startsWith("GainControl<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostGainControl(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("Unattach<")) {
            String[] splitStr = Cost.abCostParse(parse, 2);
            String description = splitStr.length > 1 ? splitStr[1] : null;
            return new CostUnattach(splitStr[0], description);
        }
        if (parse.startsWith("ChooseColor<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostChooseColor(splitStr[0]);
        }
        if (parse.startsWith("ChooseCreatureType<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostChooseCreatureType(splitStr[0]);
        }
        if (parse.startsWith("DamageYou<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostDamage(splitStr[0]);
        }
        if (parse.startsWith("Mill<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostMill(splitStr[0]);
        }
        if (parse.startsWith("FlipCoin<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostFlipCoin(splitStr[0]);
        }
        if (parse.startsWith("RollDice<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String description = splitStr.length > 3 ? splitStr[3] : null;
            return new CostRollDice(splitStr[0], splitStr[1], splitStr[2], description);
        }
        if (parse.startsWith("Discard<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostDiscard(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("AddMana<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostAddMana(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("Sac<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostSacrifice(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("RemoveAnyCounter<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String description = splitStr.length > 3 ? splitStr[3] : null;
            boolean oneOrMore = false;
            if (splitStr[0].equals("X1+")) {
                oneOrMore = true;
                splitStr[0] = "X";
            }
            return new CostRemoveAnyCounter(splitStr[0], CounterType.getType(splitStr[1]), splitStr[2], description, oneOrMore);
        }
        if (parse.startsWith("Exile<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, ZoneType.Battlefield);
        }
        if (parse.startsWith("ExileFromHand<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, ZoneType.Hand);
        }
        if (parse.startsWith("ExileFromGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, ZoneType.Graveyard);
        }
        if (parse.startsWith("ExileFromStack<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExileFromStack(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("ExileFromTop<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, ZoneType.Library);
        }
        if (parse.startsWith("ExileAnyGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, ZoneType.Graveyard, -1);
        }
        if (parse.startsWith("ExileSameGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, ZoneType.Graveyard, 0);
        }
        if (parse.startsWith("ExileCtrlOrGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExile(splitStr[0], splitStr[1], description, new ArrayList<ZoneType>(Arrays.asList(ZoneType.Battlefield, ZoneType.Graveyard)));
        }
        if (parse.startsWith("PromiseGift")) {
            return new CostPromiseGift();
        }
        if (parse.startsWith("Return<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostReturn(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("Reveal<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostReveal(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("RevealFromExile<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostReveal(splitStr[0], splitStr[1], description, "Exile");
        }
        if (parse.startsWith("RevealOrChoose<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostReveal(splitStr[0], splitStr[1], description, "Hand,Battlefield");
        }
        if (parse.startsWith("ExiledMoveToGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExiledMoveToGrave(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("Draw<")) {
            String[] splitStr = Cost.abCostParse(parse, 2);
            return new CostDraw(splitStr[0], splitStr[1]);
        }
        if (parse.startsWith("PutCardToLibFromHand<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String description = splitStr.length > 3 ? splitStr[3] : null;
            return new CostPutCardToLib(splitStr[0], splitStr[1], splitStr[2], description, ZoneType.Hand);
        }
        if (parse.startsWith("PutCardToLibFromGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String description = splitStr.length > 3 ? splitStr[3] : null;
            return new CostPutCardToLib(splitStr[0], splitStr[1], splitStr[2], description, ZoneType.Graveyard);
        }
        if (parse.startsWith("PutCardToLibFromSameGrave<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String description = splitStr.length > 3 ? splitStr[3] : null;
            return new CostPutCardToLib(splitStr[0], splitStr[1], splitStr[2], description, ZoneType.Graveyard, true);
        }
        if (parse.startsWith("PutCardToLibFromBattlefield<")) {
            String[] splitStr = Cost.abCostParse(parse, 4);
            String description = splitStr.length > 3 ? splitStr[3] : null;
            return new CostPutCardToLib(splitStr[0], splitStr[1], splitStr[2], description, ZoneType.Battlefield);
        }
        if (parse.startsWith("Exert<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostExert(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("Enlist<")) {
            String[] splitStr = Cost.abCostParse(parse, 3);
            String description = splitStr.length > 2 ? splitStr[2] : null;
            return new CostEnlist(splitStr[0], splitStr[1], description);
        }
        if (parse.startsWith("CollectEvidence<")) {
            String[] splitStr = Cost.abCostParse(parse, 1);
            return new CostCollectEvidence(splitStr[0]);
        }
        if (parse.startsWith("RevealChosen<")) {
            String[] splitStr = Cost.abCostParse(parse, 2);
            return new CostRevealChosen(splitStr[0], splitStr.length > 1 ? splitStr[1] : null);
        }
        if (parse.equals("Forage")) {
            return new CostForage();
        }
        if (parse.equals("Untap") || parse.equals("Q")) {
            return new CostUntap();
        }
        if (parse.equals("T")) {
            return new CostTap();
        }
        return null;
    }

    private static String[] abCostParse(String parse, int numParse) {
        int startPos = 1 + parse.indexOf("<");
        int endPos = parse.indexOf(">", startPos);
        String str = parse.substring(startPos, endPos);
        String[] splitStr = TextUtil.split(str, '/', numParse);
        return splitStr;
    }

    public final Cost copy() {
        Cost toRet = new Cost();
        toRet.isAbility = this.isAbility;
        toRet.isMandatory = this.isMandatory;
        for (CostPart cp : this.costParts) {
            toRet.costParts.add(cp.copy());
        }
        toRet.cacheTapCost();
        return toRet;
    }

    public final Cost copyWithNoMana() {
        Cost toRet = new Cost(0);
        toRet.isAbility = this.isAbility;
        for (CostPart cp : this.costParts) {
            if (cp instanceof CostPartMana) continue;
            toRet.costParts.add(cp.copy());
        }
        toRet.cacheTapCost();
        return toRet;
    }

    public final Cost copyWithDefinedMana(String manaCost) {
        Cost toRet = this.copyWithNoMana();
        toRet.costParts.add(new CostPartMana(new ManaCost(new ManaCostParser(manaCost)), null));
        toRet.cacheTapCost();
        return toRet;
    }

    public final CostPartMana getCostMana() {
        for (CostPart part : this.costParts) {
            if (!(part instanceof CostPartMana)) continue;
            return (CostPartMana)part;
        }
        return null;
    }

    public final CostPayEnergy getCostEnergy() {
        for (CostPart part : this.costParts) {
            if (!(part instanceof CostPayEnergy)) continue;
            return (CostPayEnergy)part;
        }
        return null;
    }

    public final void refundPaidCost(Card source) {
        for (CostPart part : this.costParts) {
            part.refund(source);
        }
    }

    public final boolean isUndoable() {
        for (CostPart part : this.costParts) {
            if (part.isUndoable()) continue;
            return false;
        }
        return true;
    }

    public final boolean isReusuableResource() {
        for (CostPart part : this.costParts) {
            if (part.isReusable()) continue;
            return false;
        }
        return this.isAbility;
    }

    public final boolean isRenewableResource() {
        for (CostPart part : this.costParts) {
            if (part.isRenewable()) continue;
            return false;
        }
        return this.isAbility;
    }

    public final String toString() {
        if (this.isAbility) {
            return this.abilityToString();
        }
        return this.spellToString(true);
    }

    public final String toStringAlt() {
        return this.spellToString(false);
    }

    public final String toSimpleString() {
        StringBuilder cost = new StringBuilder();
        boolean first = true;
        for (CostPart part : this.costParts) {
            if (!first) {
                cost.append(", ");
            }
            cost.append(part.toString());
            first = false;
        }
        return cost.toString();
    }

    private String spellToString(boolean bFlag) {
        StringBuilder cost = new StringBuilder();
        boolean first = true;
        if (bFlag) {
            cost.append("As an additional cost to cast this spell, ");
        }
        for (CostPart part : this.costParts) {
            if (part instanceof CostPartMana) continue;
            if (!first) {
                cost.append(" and ");
            }
            if (bFlag) {
                cost.append(StringUtils.uncapitalize(part.toString()));
            } else {
                cost.append(part.toString());
            }
            first = false;
        }
        if (first) {
            return "";
        }
        if (bFlag) {
            cost.append(".").append("\n");
        }
        return cost.toString();
    }

    private String abilityToString() {
        StringBuilder cost = new StringBuilder();
        boolean first = true;
        for (CostPart part : this.costParts) {
            boolean append = true;
            if (!first) {
                if (part instanceof CostPartMana) {
                    cost.insert(0, ", ").insert(0, part.toString());
                    append = false;
                } else {
                    cost.append(", ");
                }
            }
            if (append) {
                cost.append(part.toString());
            }
            first = false;
        }
        if (first) {
            cost.append("0");
        }
        return cost.toString();
    }

    public static String convertAmountTypeToWords(Integer i, String amount, String type) {
        if (i == null) {
            return Cost.convertAmountTypeToWords(amount, type);
        }
        return Cost.convertIntAndTypeToWords(i, type);
    }

    public static String convertIntAndTypeToWords(int i, String type) {
        if (i == 1 && type.startsWith("another")) {
            return type;
        }
        StringBuilder sb = new StringBuilder();
        if (i >= NUM_NAMES.length) {
            sb.append(i);
        } else if (i == 1 && Lang.startsWithVowel(type)) {
            sb.append("an");
        } else {
            sb.append(NUM_NAMES[i]);
        }
        sb.append(" ");
        if (1 != i) {
            String[] typewords = type.split(" ");
            String lastWord = typewords[typewords.length - 1];
            sb.append(CardType.isASubType(lastWord) ? type.replace(lastWord, CardType.getPluralType(lastWord)) : type + "s");
        } else {
            sb.append(type);
        }
        return sb.toString();
    }

    public static String convertAmountTypeToWords(String amount, String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(amount);
        sb.append(" ");
        sb.append(type);
        return sb.toString();
    }

    public void mergeTo(Cost source, int amt, SpellAbility sa) {
        if (amt > 1) {
            Cost sourceCpy = source.copy();
            for (int i = 1; i < amt; ++i) {
                source.add(sourceCpy);
            }
        }
        this.add(source, false, sa);
    }

    public Cost add(Cost cost1) {
        return this.add(cost1, true);
    }

    public Cost add(Cost cost1, boolean mergeAdditional) {
        return this.add(cost1, mergeAdditional, null);
    }

    public Cost add(Cost cost, boolean mergeAdditional, SpellAbility sa) {
        CostPartMana mPartOld = this.getCostMana();
        ArrayList<CostPart> toRemove = Lists.newArrayList();
        for (CostPart part : cost.getCostParts()) {
            if (part instanceof CostPartMana && ((CostPartMana)part).getMana().isZero()) continue;
            if (part instanceof CostPartMana && mPartOld != null) {
                CostPartMana mPart = (CostPartMana)part;
                ManaCostBeingPaid manaCost = new ManaCostBeingPaid(mPart.getMana());
                this.costParts.remove(mPartOld);
                int xMin = Math.max(mPart.getXMin(), mPartOld.getXMin());
                manaCost.addManaCost(mPartOld.getMana());
                if (mPartOld.isExiledCreatureCost() || mPartOld.isEnchantedCreatureCost() || xMin > 0) {
                    this.costParts.add(0, new CostPartMana(manaCost.toManaCost(), mPartOld.isExiledCreatureCost(), mPartOld.isEnchantedCreatureCost(), xMin));
                    continue;
                }
                this.costParts.add(0, new CostPartMana(manaCost.toManaCost(), null));
                continue;
            }
            if (part instanceof CostPutCounter || mergeAdditional && (part instanceof CostDiscard || part instanceof CostDraw || part instanceof CostAddMana || part instanceof CostPayLife || part instanceof CostSacrifice || part instanceof CostTapType || part instanceof CostExile)) {
                boolean alreadyAdded = false;
                for (CostPart other : this.costParts) {
                    Integer otherAmount = other.convertAmount();
                    if (otherAmount == null && sa != null && sa.isPwAbility()) {
                        otherAmount = other.getAbilityAmount(sa);
                    }
                    if (!other.getClass().equals(part.getClass()) && (!(part instanceof CostPutCounter) || !((CostPutCounter)part).getCounter().is(CounterEnumType.LOYALTY)) || !part.getType().equals(other.getType()) || !StringUtils.isNumeric(part.getAmount()) || otherAmount == null) continue;
                    String amount = String.valueOf(part.convertAmount() + otherAmount);
                    if (part instanceof CostPutCounter) {
                        if (other instanceof CostPutCounter && ((CostPutCounter)other).getCounter().equals(((CostPutCounter)part).getCounter())) {
                            this.costParts.add(new CostPutCounter(amount, ((CostPutCounter)part).getCounter(), part.getType(), part.getTypeDescription()));
                        } else {
                            if (!(other instanceof CostRemoveCounter) || !((CostRemoveCounter)other).counter.is(CounterEnumType.LOYALTY)) continue;
                            Integer counters = otherAmount - part.convertAmount();
                            if (counters < 0) {
                                this.costParts.add(new CostPutCounter(String.valueOf(counters * -1), CounterType.get(CounterEnumType.LOYALTY), part.getType(), part.getTypeDescription()));
                            } else {
                                this.costParts.add(new CostRemoveCounter(String.valueOf(counters), CounterType.get(CounterEnumType.LOYALTY), part.getType(), part.getTypeDescription(), Lists.newArrayList(ZoneType.Battlefield), false));
                            }
                        }
                    } else if (part instanceof CostSacrifice) {
                        this.costParts.add(new CostSacrifice(amount, part.getType(), part.getTypeDescription()));
                    } else if (part instanceof CostDiscard) {
                        this.costParts.add(new CostDiscard(amount, part.getType(), part.getTypeDescription()));
                    } else if (part instanceof CostDraw) {
                        this.costParts.add(new CostDraw(amount, part.getType()));
                    } else if (part instanceof CostTapType) {
                        CostTapType tappart = (CostTapType)part;
                        this.costParts.add(new CostTapType(amount, part.getType(), part.getTypeDescription(), !tappart.canTapSource));
                    } else if (part instanceof CostAddMana) {
                        this.costParts.add(new CostAddMana(amount, part.getType(), part.getTypeDescription()));
                    } else if (part instanceof CostPayLife) {
                        this.costParts.add(new CostPayLife(amount, part.getTypeDescription()));
                    } else if (part instanceof CostExile) {
                        this.costParts.add(new CostExile(amount, part.getType(), part.getTypeDescription(), ((CostExile)part).getFrom()));
                    }
                    toRemove.add(other);
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                this.costParts.add(part);
                continue;
            }
            this.costParts.add(part);
        }
        this.costParts.removeAll(toRemove);
        this.sort();
        return this;
    }

    public final void applyTextChangeEffects(CardTraitBase trait) {
        for (CostPart part : this.getCostParts()) {
            part.applyTextChangeEffects(trait);
        }
    }

    public boolean canPay(SpellAbility sa, boolean effect) {
        return this.canPay(sa, sa.getActivatingPlayer(), effect);
    }

    public boolean canPay(SpellAbility sa, Player payer, boolean effect) {
        for (CostPart part : this.getCostParts()) {
            if (part.canPay(sa, payer, effect)) continue;
            return false;
        }
        return true;
    }

    public boolean hasXInAnyCostPart() {
        boolean xCost = false;
        for (CostPart p : this.getCostParts()) {
            if (p instanceof CostPartMana) {
                if (((CostPartMana)p).getAmountOfX() <= 0) continue;
                xCost = true;
                break;
            }
            if (!p.getAmount().equals("X")) continue;
            xCost = true;
            break;
        }
        return xCost;
    }

    public Integer getMaxForNonManaX(SpellAbility ability, Player payer, boolean effect) {
        Integer val = null;
        for (CostPart p : this.getCostParts()) {
            if (!p.getAmount().equals("X")) continue;
            val = (Integer)ObjectUtils.min((Comparable[])new Integer[]{val, p.getMaxAmountX(ability, payer, effect)});
        }
        if (val != null && val <= 0 && this.hasManaCost() && this.getCostMana().getXMin() > 0) {
            val = null;
        }
        return val;
    }
}

