/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.AttackConstraints;
import forge.game.combat.Combat;
import forge.game.cost.Cost;
import forge.game.cost.CostPart;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityBlockRestrict;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.staticability.StaticAbilityMustBlock;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class CombatUtil {
    public static FCollectionView<GameEntity> getAllPossibleDefenders(Player playerWhoAttacks) {
        FCollection<GameEntity> defenders = new FCollection<GameEntity>();
        for (Player defender : playerWhoAttacks.getOpponents()) {
            defenders.add(defender);
            defenders.addAll(defender.getPlaneswalkersInPlay());
        }
        Game game = playerWhoAttacks.getGame();
        CardCollection battles = CardLists.filter((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.BATTLES);
        for (Card battle : battles) {
            if (!battle.getType().hasSubtype("Siege") || !battle.getProtectingPlayer().isOpponentOf(playerWhoAttacks)) continue;
            defenders.add(battle);
        }
        return defenders;
    }

    public static boolean validateAttackers(Combat combat) {
        AttackConstraints constraints = combat.getAttackConstraints();
        int myViolations = constraints.countViolations(combat.getAttackersAndDefenders());
        if (myViolations == -1) {
            return false;
        }
        Pair<Map<Card, GameEntity>, Integer> bestAttack = constraints.getLegalAttackers();
        return myViolations <= bestAttack.getRight();
    }

    public static boolean couldAttackButNotAttacking(Combat combat, Card attacker) {
        if (combat == null) {
            combat = new Combat(attacker.getController());
        } else if (combat.isAttacking(attacker)) {
            return false;
        }
        AttackConstraints constraints = combat.getAttackConstraints();
        Pair<Map<Card, GameEntity>, Integer> bestAttack = constraints.getLegalAttackers();
        HashMap<Card, GameEntity> attackers = new HashMap<Card, GameEntity>(combat.getAttackersAndDefenders());
        Game game = attacker.getGame();
        return Iterables.any(CombatUtil.getAllPossibleDefenders(attacker.getController()), defender -> {
            if (!CombatUtil.canAttack(attacker, defender) || CombatUtil.getAttackCost(game, attacker, defender) != null) {
                return false;
            }
            attackers.put(attacker, (GameEntity)defender);
            int myViolations = constraints.countViolations(attackers);
            if (myViolations == -1) {
                return false;
            }
            return myViolations <= (Integer)bestAttack.getRight();
        });
    }

    public static boolean canAttack(Player p) {
        CardCollection possibleAttackers = CombatUtil.getPossibleAttackers(p);
        return !possibleAttackers.isEmpty();
    }

    public static CardCollection getPossibleAttackers(Player p) {
        return CardLists.filter((Iterable<Card>)p.getCreaturesInPlay(), CombatUtil::canAttack);
    }

    public static boolean canAttack(Card attacker) {
        return Iterables.any(CombatUtil.getAllPossibleDefenders(attacker.getController()), defender -> CombatUtil.canAttack(attacker, defender));
    }

    public static boolean canAttack(Card attacker, GameEntity defender) {
        return CombatUtil.canAttack(attacker, defender, false);
    }

    public static boolean canAttackNextTurn(Card attacker, GameEntity defender) {
        return CombatUtil.canAttack(attacker, defender, true);
    }

    private static boolean canAttack(Card attacker, GameEntity defender, boolean forNextTurn) {
        Game game = attacker.getGame();
        if (!forNextTurn && (!attacker.isCreature() || attacker.isTapped() || attacker.isPhasedOut() || CombatUtil.isAttackerSick(attacker, defender) || game.getPhaseHandler().getPhase().isAfter(PhaseType.COMBAT_DECLARE_ATTACKERS))) {
            return false;
        }
        if (attacker.isGoaded()) {
            boolean goadedByDefender;
            boolean bl = goadedByDefender = defender instanceof Player && attacker.isGoadedBy((Player)defender);
            if (goadedByDefender || !(defender instanceof Player)) {
                for (GameEntity ge : CombatUtil.getAllPossibleDefenders(attacker.getController())) {
                    if (ge.equals(defender) || !(ge instanceof Player) || attacker.isGoadedBy((Player)ge) || ge.hasKeyword("Creatures your opponents control attack a player other than you if able.") || !CombatUtil.canAttack(attacker, ge)) continue;
                    return false;
                }
            }
        }
        if (defender != null && defender.hasKeyword("Creatures your opponents control attack a player other than you if able.")) {
            for (GameEntity ge : CombatUtil.getAllPossibleDefenders(attacker.getController())) {
                if (ge.equals(defender) || !(ge instanceof Player) || ge.hasKeyword("Creatures your opponents control attack a player other than you if able.") || !CombatUtil.canAttack(attacker, ge)) continue;
                return false;
            }
        }
        return !StaticAbilityCantAttackBlock.cantAttack(attacker, defender);
    }

    public static boolean isAttackerSick(Card attacker, GameEntity defender) {
        return !StaticAbilityCantAttackBlock.canAttackHaste(attacker, defender);
    }

    public static boolean checkPropagandaEffects(Game game, Card attacker, Combat combat, List<Card> attackersWithOptionalCost) {
        Cost attackCost = CombatUtil.getAttackCost(game, attacker, combat.getDefenderByAttacker(attacker), attackersWithOptionalCost);
        if (attackCost == null) {
            return true;
        }
        SpellAbility.EmptySa fakeSA = new SpellAbility.EmptySa(attacker, attacker.getController());
        fakeSA.setCardState(attacker.getCurrentState());
        fakeSA.setPayCosts(attackCost);
        fakeSA.setSVar("X", "0");
        return attacker.getController().getController().payManaOptional(attacker, attackCost, fakeSA, "Pay additional cost to declare " + attacker + " an attacker", PlayerController.ManaPaymentPurpose.DeclareAttacker);
    }

    public static Cost getAttackCost(Game game, Card attacker, GameEntity defender) {
        return CombatUtil.getAttackCost(game, attacker, defender, ImmutableList.of());
    }

    public static Cost getAttackCost(Game game, Card attacker, GameEntity defender, List<Card> attackersWithOptionalCost) {
        Cost attackCost = new Cost(ManaCost.ZERO, true);
        boolean hasCost = false;
        for (Card card : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : card.getStaticAbilities()) {
                Cost additionalCost = stAb.getAttackCost(attacker, defender, attackersWithOptionalCost);
                if (null == additionalCost) continue;
                attackCost.add(additionalCost);
                hasCost = true;
            }
        }
        if (!hasCost) {
            return null;
        }
        return attackCost;
    }

    public static CardCollection getOptionalAttackCostCreatures(CardCollection attackers, Class<? extends CostPart> costType) {
        CardCollection attackersWithCost = new CardCollection();
        for (Card card : attackers) {
            for (StaticAbility stAb : card.getStaticAbilities()) {
                if (!stAb.hasAttackCost(card, costType)) continue;
                attackersWithCost.add(card);
            }
        }
        return attackersWithCost;
    }

    public static boolean payRequiredBlockCosts(Game game, Card blocker, Card attacker) {
        Cost blockCost = CombatUtil.getBlockCost(game, blocker, attacker);
        if (blockCost == null) {
            return true;
        }
        SpellAbility.EmptySa fakeSA = new SpellAbility.EmptySa(blocker, blocker.getController());
        fakeSA.setCardState(blocker.getCurrentState());
        fakeSA.setPayCosts(blockCost);
        fakeSA.setSVar("X", "0");
        return blocker.getController().getController().payManaOptional(blocker, blockCost, fakeSA, "Pay cost to declare " + blocker + " a blocker. ", PlayerController.ManaPaymentPurpose.DeclareBlocker);
    }

    public static Cost getBlockCost(Game game, Card blocker, Card attacker) {
        Cost blockCost = new Cost(ManaCost.ZERO, true);
        boolean noCost = true;
        for (Card card : game.getCardsIn(ZoneType.STATIC_ABILITIES_SOURCE_ZONES)) {
            for (StaticAbility stAb : card.getStaticAbilities()) {
                Cost c1 = stAb.getBlockCost(blocker, attacker);
                if (c1 == null) continue;
                blockCost.add(c1);
                noCost = false;
            }
        }
        if (noCost) {
            return null;
        }
        return blockCost;
    }

    public static void checkDeclaredAttacker(Game game, Card c, Combat combat, boolean triggers) {
        GameEntity defender = combat.getDefenderByAttacker(c);
        CardCollection otherAttackers = combat.getAttackers();
        if (triggers) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attacker, c);
            otherAttackers.remove(c);
            runParams.put(AbilityKey.OtherAttackers, otherAttackers);
            runParams.put(AbilityKey.Attacked, defender);
            runParams.put(AbilityKey.DefendingPlayer, combat.getDefenderPlayerByAttacker(c));
            FCollection<GameEntity> defenders = new FCollection<GameEntity>();
            for (GameEntity e : combat.getDefenders()) {
                if (combat.getAttackersOf(e).isEmpty()) continue;
                defenders.add(e);
            }
            runParams.put(AbilityKey.Defenders, defenders);
            game.getTriggerHandler().runTrigger(TriggerType.Attacks, runParams, false);
        }
        c.getDamageHistory().setCreatureAttackedThisCombat(defender, otherAttackers.size());
        c.getDamageHistory().clearNotAttackedSinceLastUpkeepOf();
        c.getController().addCreaturesAttackedThisTurn(CardCopyService.getLKICopy(c), defender);
    }

    public static AttackConstraints getAllRequirements(Combat combat) {
        return new AttackConstraints(combat);
    }

    public static boolean canBlock(Card blocker, Combat combat) {
        if (blocker == null) {
            return false;
        }
        if (combat == null) {
            return CombatUtil.canBlock(blocker);
        }
        if (!CombatUtil.canBlockMoreCreatures(blocker, combat.getAttackersBlockedBy(blocker))) {
            return false;
        }
        CardCollection allOtherBlockers = combat.getAllBlockers();
        allOtherBlockers.remove(blocker);
        int blockersFromOnePlayer = CardLists.count(allOtherBlockers, CardPredicates.isController(blocker.getController()));
        if (blockersFromOnePlayer >= StaticAbilityBlockRestrict.blockRestrictNum(blocker.getController())) {
            return false;
        }
        return CombatUtil.canBlock(blocker);
    }

    public static boolean canBlock(Card blocker) {
        return CombatUtil.canBlock(blocker, false);
    }

    public static boolean canBlock(Card blocker, boolean nextTurn) {
        if (blocker == null) {
            return false;
        }
        if (!nextTurn && blocker.isTapped() && !blocker.hasKeyword("CARDNAME can block as though it were untapped.")) {
            return false;
        }
        if (blocker.hasKeyword("CARDNAME can't block.") || blocker.hasKeyword("CARDNAME can't attack or block.") || blocker.isPhasedOut()) {
            return false;
        }
        boolean cantBlockAlone = blocker.hasKeyword("CARDNAME can't attack or block alone.") || blocker.hasKeyword("CARDNAME can't block alone.");
        CardCollection list = blocker.getController().getCreaturesInPlay();
        return list.size() >= 2 || !cantBlockAlone;
    }

    public static boolean canBlockMoreCreatures(Card blocker, CardCollectionView blockedBy) {
        if (blockedBy.isEmpty() || blocker.canBlockAny()) {
            return true;
        }
        int canBlockMore = blocker.canBlockAdditional();
        return canBlockMore >= blockedBy.size();
    }

    public static boolean canBeBlocked(Card attacker, Combat combat, Player defendingPlayer) {
        if (attacker == null) {
            return true;
        }
        if (combat != null) {
            if (StaticAbilityCantAttackBlock.getMinMaxBlocker(attacker, defendingPlayer).getRight().intValue() == combat.getBlockers(attacker).size()) {
                return false;
            }
            Player attacked = combat.getDefendingPlayerRelatedTo(attacker);
            if (attacked != null && attacked != defendingPlayer) {
                return false;
            }
        }
        return !StaticAbilityCantAttackBlock.cantBlockBy(attacker, null);
    }

    public static boolean canBlockAtLeastOne(Card blocker, Iterable<Card> attackers) {
        for (Card attacker : attackers) {
            if (!CombatUtil.canBlock(attacker, blocker)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeBlocked(Card attacker, List<Card> blockers, Combat combat) {
        int blocks = 0;
        for (Card blocker : blockers) {
            if (!CombatUtil.canBlock(attacker, blocker)) continue;
            ++blocks;
        }
        return CombatUtil.canAttackerBeBlockedWithAmount(attacker, blocks, combat);
    }

    public static List<Card> getPotentialBestBlockers(Card attacker, List<Card> blockers, Combat combat) {
        ArrayList<Card> potentialBlockers = Lists.newArrayList();
        if (blockers.isEmpty() || attacker == null) {
            return potentialBlockers;
        }
        for (Card blocker : blockers) {
            if (!CombatUtil.canBlock(attacker, blocker)) continue;
            potentialBlockers.add(blocker);
        }
        int minBlockers = CombatUtil.getMinNumBlockersForAttacker(attacker, blockers.get(0).getController());
        CardLists.sortByPowerDesc(potentialBlockers);
        ArrayList<Card> minBlockerList = Lists.newArrayList();
        for (int i = 0; i < minBlockers && i < potentialBlockers.size(); ++i) {
            minBlockerList.add((Card)potentialBlockers.get(i));
        }
        return minBlockerList;
    }

    public static List<Card> findFreeBlockers(List<Card> defendersArmy, Combat combat) {
        CardCollection freeBlockers = new CardCollection();
        for (Card blocker : defendersArmy) {
            if (!CombatUtil.canBlock(blocker) || CombatUtil.mustBlockAnAttacker(blocker, combat, null)) continue;
            CardCollection blockedAttackers = combat.getAttackersBlockedBy(blocker);
            boolean blockChange = blockedAttackers.isEmpty();
            for (Card attacker : blockedAttackers) {
                CardCollection blockersReduced = combat.getBlockers(attacker);
                blockersReduced.remove(blocker);
                if (!CombatUtil.canBlockMoreCreatures(blocker, blockedAttackers) && !CombatUtil.canBeBlocked(attacker, blockersReduced, combat)) continue;
                blockChange = true;
                break;
            }
            if (!blockChange) continue;
            freeBlockers.add(blocker);
        }
        return freeBlockers;
    }

    public static String validateBlocks(Combat combat, Player defending) {
        CardCollection defendersArmy = defending.getCreaturesInPlay();
        CardCollection attackers = combat.getAttackers();
        CardCollection blockers = CardLists.filterControlledBy((Iterable<Card>)combat.getAllBlockers(), defending);
        List<Card> freeBlockers = CombatUtil.findFreeBlockers(defendersArmy, combat);
        for (Card blocker : defendersArmy) {
            if (!blocker.getMustBlockCards().isEmpty()) {
                CardCollection blockedSoFar = combat.getAttackersBlockedBy(blocker);
                for (Card cardToBeBlocked : blocker.getMustBlockCards()) {
                    if (CombatUtil.getBlockCost(blocker.getGame(), blocker, cardToBeBlocked) != null) continue;
                    int additionalBlockers = CombatUtil.getMinNumBlockersForAttacker(cardToBeBlocked, defending) - 1;
                    int potentialBlockers = 0;
                    for (int i = 0; i < additionalBlockers; ++i) {
                        for (Card freeBlocker : new CardCollection((Iterable<Card>)freeBlockers)) {
                            if (freeBlocker == blocker || !CombatUtil.canBlock(cardToBeBlocked, freeBlocker)) continue;
                            freeBlockers.remove(freeBlocker);
                            ++potentialBlockers;
                        }
                    }
                    if (potentialBlockers < additionalBlockers || blockedSoFar.contains(cardToBeBlocked) || !CombatUtil.canBlockMoreCreatures(blocker, blockedSoFar) && !freeBlockers.contains(blocker) || !combat.isAttacking(cardToBeBlocked) || !CombatUtil.canBlock(cardToBeBlocked, blocker)) continue;
                    return TextUtil.concatWithSpace(blocker.toString(), "must still block", TextUtil.addSuffix(cardToBeBlocked.toString(), "."));
                }
            }
            if (CombatUtil.mustBlockAnAttacker(blocker, combat, freeBlockers)) {
                return TextUtil.concatWithSpace(blocker.toString(), "must block an attacker, but has not been assigned to block", blockers.contains(blocker) ? "the right ones." : "any.");
            }
            if (blockers.contains(blocker) || !StaticAbilityMustBlock.blocksEachCombatIfAble(blocker)) continue;
            for (Card attacker : attackers) {
                if (CombatUtil.getBlockCost(blocker.getGame(), blocker, attacker) != null || !CombatUtil.canBlock(attacker, blocker, combat)) continue;
                boolean must = true;
                if (CombatUtil.getMinNumBlockersForAttacker(attacker, defending) > 1) {
                    ArrayList<Card> possibleBlockers = Lists.newArrayList(freeBlockers);
                    possibleBlockers.addAll(combat.getBlockers(attacker));
                    if (!CombatUtil.canBeBlocked(attacker, possibleBlockers, combat)) {
                        must = false;
                    }
                }
                if (!must) continue;
                return TextUtil.concatWithSpace(blocker.toString(), "must block each combat but was not assigned to block any attacker now.");
            }
        }
        for (Card blocker : blockers) {
            boolean cantBlockAlone;
            boolean bl = cantBlockAlone = blocker.hasKeyword("CARDNAME can't attack or block alone.") || blocker.hasKeyword("CARDNAME can't block alone.");
            if (blockers.size() < 2 && cantBlockAlone) {
                return TextUtil.concatWithSpace(blocker.toString(), "can't block alone.");
            }
            if (blockers.size() < 3 && blocker.hasKeyword("CARDNAME can't block unless at least two other creatures block.")) {
                return TextUtil.concatWithSpace(blocker.toString(), "can't block unless at least two other creatures block.");
            }
            if (!blocker.hasKeyword("CARDNAME can't block unless a creature with greater power also blocks.")) continue;
            boolean found = false;
            int power = blocker.getNetPower();
            for (Card blocker2 : blockers) {
                if (blocker2.getNetPower() <= power) continue;
                found = true;
                break;
            }
            if (found) continue;
            return TextUtil.concatWithSpace(blocker.toString(), "can't block unless a creature with greater power also blocks.");
        }
        for (Card attacker : attackers) {
            int cntBlockers = combat.getBlockers(attacker).size();
            if (cntBlockers <= 0 || CombatUtil.canAttackerBeBlockedWithAmount(attacker, cntBlockers, combat)) continue;
            return TextUtil.concatWithSpace(attacker.toString(), "cannot be blocked with", String.valueOf(cntBlockers), "creatures you've assigned");
        }
        return null;
    }

    public static boolean mustBlockAnAttacker(Card blocker, Combat combat, List<Card> freeBlockers) {
        CardCollection blockers;
        Player defendingPlayer;
        boolean canBe;
        if (blocker == null || combat == null) {
            return false;
        }
        CardCollection attackers = combat.getAttackers();
        CardCollection requirementCards = new CardCollection();
        Player defender = blocker.getController();
        for (Card attacker : attackers) {
            if (CombatUtil.getBlockCost(blocker.getGame(), blocker, attacker) != null || CombatUtil.attackerLureSatisfied(attacker, blocker, combat.getBlockers(attacker)) || !CombatUtil.canBeBlocked(attacker, combat, defender) || !CombatUtil.canBlock(attacker, blocker)) continue;
            canBe = true;
            defendingPlayer = combat.getDefenderPlayerByAttacker(attacker);
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, defendingPlayer) > 1) {
                blockers = defendingPlayer.getCreaturesInPlay();
                blockers.remove(blocker);
                if (!CombatUtil.canBeBlocked(attacker, blockers, combat)) {
                    canBe = false;
                }
            }
            if (!canBe) continue;
            requirementCards.add(attacker);
        }
        for (Card attacker : blocker.getMustBlockCards()) {
            if (CombatUtil.getBlockCost(blocker.getGame(), blocker, attacker) != null || !CombatUtil.canBeBlocked(attacker, combat, defender) || !CombatUtil.canBlock(attacker, blocker) || !combat.isAttacking(attacker)) continue;
            canBe = true;
            defendingPlayer = combat.getDefenderPlayerByAttacker(attacker);
            if (CombatUtil.getMinNumBlockersForAttacker(attacker, defendingPlayer) > 1) {
                blockers = freeBlockers != null ? new CardCollection((Iterable<Card>)freeBlockers) : defendingPlayer.getCreaturesInPlay();
                blockers.remove(blocker);
                if (!CombatUtil.canBeBlocked(attacker, blockers, combat)) {
                    canBe = false;
                }
            }
            if (!canBe) continue;
            requirementCards.add(attacker);
        }
        if (requirementCards.isEmpty()) {
            return false;
        }
        if (combat.getAttackersBlockedBy(blocker).containsAll(requirementCards)) {
            return false;
        }
        if (!CombatUtil.canBlock(blocker, combat)) {
            for (Card attacker : attackers) {
                boolean requirementSatisfied = CombatUtil.attackerLureSatisfied(attacker, blocker, combat.getBlockers(attacker));
                CardCollection reducedBlockers = combat.getBlockers(attacker);
                if (!requirementSatisfied || !reducedBlockers.contains(blocker)) continue;
                reducedBlockers.remove(blocker);
                if (CombatUtil.attackerLureSatisfied(attacker, blocker, reducedBlockers)) continue;
                return false;
            }
        }
        return Collections.disjoint(combat.getAttackersBlockedBy(blocker), requirementCards);
    }

    private static boolean attackerLureSatisfied(Card attacker, Card blocker, CardCollection blockers) {
        if (attacker.hasStartOfKeyword("All creatures able to block CARDNAME do so.") || attacker.hasStartOfKeyword("CARDNAME must be blocked if able.") && blockers.isEmpty() || attacker.hasStartOfKeyword("CARDNAME must be blocked by exactly one creature if able.") && blockers.size() != 1 || attacker.hasStartOfKeyword("CARDNAME must be blocked by two or more creatures if able.") && blockers.size() < 2) {
            return false;
        }
        for (KeywordInterface inst : attacker.getKeywords()) {
            String valid;
            String keyword = inst.getOriginal();
            if (keyword.startsWith("MustBeBlockedBy ") && blocker.isValid(valid = keyword.substring("MustBeBlockedBy ".length()), null, null, null) && CardLists.getValidCardCount(blockers, valid, null, null, null) == 0) {
                return false;
            }
            if (!keyword.startsWith("MustBeBlockedByAll") || !blocker.isValid(valid = keyword.split(":")[1], null, null, null)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBlock(Player p, Combat combat) {
        CardCollection creatures = p.getCreaturesInPlay();
        if (creatures.isEmpty()) {
            return false;
        }
        CardCollection attackers = combat.getAttackers();
        if (attackers.isEmpty()) {
            return false;
        }
        for (Card c : creatures) {
            for (Card a : attackers) {
                if (!CombatUtil.canBlock(a, c, combat)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBlock(Card attacker, Card blocker, Combat combat) {
        if (attacker == null || blocker == null) {
            return false;
        }
        if (!CombatUtil.canBlock(blocker, combat)) {
            return false;
        }
        if (!CombatUtil.canBeBlocked(attacker, combat, blocker.getController())) {
            return false;
        }
        if (combat != null && combat.isBlocking(blocker, attacker)) {
            return false;
        }
        boolean mustBeBlockedBy = false;
        for (KeywordInterface inst : attacker.getKeywords()) {
            String valid;
            String keyword = inst.getOriginal();
            if (keyword.startsWith("MustBeBlockedBy ") && blocker.isValid(valid = keyword.substring("MustBeBlockedBy ".length()), null, null, null) && CardLists.getValidCardCount(combat.getBlockers(attacker), valid, null, null, null) == 0) {
                mustBeBlockedBy = true;
                break;
            }
            if (!keyword.startsWith("MustBeBlockedByAll") || !blocker.isValid(valid = keyword.split(":")[1], null, null, null)) continue;
            mustBeBlockedBy = true;
            break;
        }
        if (!(attacker.hasKeyword("All creatures able to block CARDNAME do so.") || attacker.hasKeyword("CARDNAME must be blocked if able.") && combat.getBlockers(attacker).isEmpty() || attacker.hasKeyword("CARDNAME must be blocked by exactly one creature if able.") && combat.getBlockers(attacker).size() != 1 || attacker.hasKeyword("CARDNAME must be blocked by two or more creatures if able.") && combat.getBlockers(attacker).size() < 2 || blocker.getMustBlockCards().contains(attacker) || mustBeBlockedBy || !CombatUtil.mustBlockAnAttacker(blocker, combat, null))) {
            return false;
        }
        return CombatUtil.canBlock(attacker, blocker);
    }

    public static boolean canBlock(Card attacker, Card blocker) {
        return CombatUtil.canBlock(attacker, blocker, false);
    }

    public static boolean canBlock(Card attacker, Card blocker, boolean nextTurn) {
        if (attacker == null || blocker == null) {
            return false;
        }
        if (!CombatUtil.canBlock(blocker, nextTurn)) {
            return false;
        }
        if (blocker.hasKeyword(Keyword.SHADOW) && blocker.hasKeyword("CARDNAME can block creatures with shadow as though they didn't have shadow.")) {
            return false;
        }
        if (attacker.hasKeyword(Keyword.SHADOW) && !blocker.hasKeyword(Keyword.SHADOW) && !blocker.hasKeyword("CARDNAME can block creatures with shadow as though they didn't have shadow.")) {
            return false;
        }
        if (!attacker.hasKeyword(Keyword.SHADOW) && blocker.hasKeyword(Keyword.SHADOW)) {
            return false;
        }
        return !StaticAbilityCantAttackBlock.cantBlockBy(attacker, blocker);
    }

    public static boolean canAttackerBeBlockedWithAmount(Card attacker, int amount, Combat combat) {
        return CombatUtil.canAttackerBeBlockedWithAmount(attacker, amount, combat != null ? combat.getDefenderPlayerByAttacker(attacker) : null);
    }

    public static boolean canAttackerBeBlockedWithAmount(Card attacker, int amount, Player defender) {
        if (amount == 0) {
            return false;
        }
        Pair<Integer, Integer> minMaxBlock = StaticAbilityCantAttackBlock.getMinMaxBlocker(attacker, defender);
        return minMaxBlock.getLeft() <= amount && minMaxBlock.getRight() >= amount;
    }

    public static int getMinNumBlockersForAttacker(Card attacker, Player defender) {
        return StaticAbilityCantAttackBlock.getMinMaxBlocker(attacker, defender).getLeft();
    }
}

