/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Table;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.IEntityMap;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardDamageMap;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.combat.AttackConstraints;
import forge.game.combat.AttackingBand;
import forge.game.combat.CombatLki;
import forge.game.combat.CombatUtil;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.staticability.StaticAbilityAssignCombatDamageAsUnblocked;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class Combat {
    private final Player playerWhoAttacks;
    private AttackConstraints attackConstraints;
    private final FCollection<GameEntity> attackableEntries = new FCollection();
    private final Multimap<GameEntity, AttackingBand> attackedByBands = Multimaps.synchronizedMultimap(ArrayListMultimap.create());
    private final Multimap<AttackingBand, Card> blockedBands = Multimaps.synchronizedMultimap(ArrayListMultimap.create());
    private Map<Card, CardCollection> attackersOrderedForDamageAssignment = Maps.newHashMap();
    private Map<Card, CardCollection> blockersOrderedForDamageAssignment = Maps.newHashMap();
    private CardCollection lkiCache = new CardCollection();
    private CardDamageMap damageMap = new CardDamageMap();
    private CardCollection combatantsThatDealtFirstStrikeDamage = new CardCollection();

    public Combat(Player attacker) {
        this.playerWhoAttacks = attacker;
        this.initConstraints();
    }

    public Combat(Combat combat, IEntityMap map) {
        this.playerWhoAttacks = map.map(combat.playerWhoAttacks);
        for (GameEntity entry : combat.attackableEntries) {
            this.attackableEntries.add(map.map(entry));
        }
        HashMap<AttackingBand, AttackingBand> bandsMap = new HashMap<AttackingBand, AttackingBand>();
        for (Map.Entry<GameEntity, AttackingBand> entry : combat.attackedByBands.entries()) {
            AttackingBand origBand = entry.getValue();
            ArrayList<Card> attackers = new ArrayList<Card>();
            for (Card c : origBand.getAttackers()) {
                attackers.add(map.map(c));
            }
            AttackingBand newBand = new AttackingBand(attackers);
            Boolean blocked = entry.getValue().isBlocked();
            if (blocked != null) {
                newBand.setBlocked(blocked);
            }
            bandsMap.put(origBand, newBand);
            this.attackedByBands.put(map.map(entry.getKey()), newBand);
        }
        for (Map.Entry<Object, Object> entry : combat.blockedBands.entries()) {
            this.blockedBands.put((AttackingBand)bandsMap.get(entry.getKey()), map.map((Card)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : combat.attackersOrderedForDamageAssignment.entrySet()) {
            this.attackersOrderedForDamageAssignment.put(map.map((Card)entry.getKey()), map.mapCollection((CardCollectionView)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : combat.blockersOrderedForDamageAssignment.entrySet()) {
            this.blockersOrderedForDamageAssignment.put(map.map((Card)entry.getKey()), map.mapCollection((CardCollectionView)entry.getValue()));
        }
        for (Table.Cell cell : combat.damageMap.cellSet()) {
            this.damageMap.put(map.map((Card)cell.getRowKey()), map.map((GameEntity)cell.getColumnKey()), (Integer)cell.getValue());
        }
        this.attackConstraints = new AttackConstraints(this);
    }

    public void initConstraints() {
        this.attackableEntries.clear();
        this.attackableEntries.addAll(CombatUtil.getAllPossibleDefenders(this.playerWhoAttacks));
        this.attackConstraints = new AttackConstraints(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (GameEntity defender : this.attackableEntries) {
            CardCollection attackers = this.getAttackersOf(defender);
            if (attackers.isEmpty()) continue;
            sb.append(defender);
            sb.append(" is being attacked by:\n");
            for (Card attacker : attackers) {
                sb.append("  ").append(attacker).append("\n");
                for (Card blocker : this.getBlockers(attacker)) {
                    sb.append("  ... blocked by: ").append(blocker).append("\n");
                }
            }
        }
        if (sb.length() == 0) {
            return "<no attacks>";
        }
        return sb.toString();
    }

    public void endCombat() {
        CardCollection attackers = this.getAttackers();
        CardCollection blockers = this.getAllBlockers();
        this.attackableEntries.clear();
        this.attackedByBands.clear();
        this.blockedBands.clear();
        this.attackersOrderedForDamageAssignment.clear();
        this.blockersOrderedForDamageAssignment.clear();
        this.lkiCache.clear();
        this.combatantsThatDealtFirstStrikeDamage.clear();
        Game game = this.playerWhoAttacks.getGame();
        for (Card c : game.getCardsIncludePhasingIn(ZoneType.Battlefield)) {
            c.getDamageHistory().endCombat();
        }
        this.playerWhoAttacks.clearAttackedPlayersMyCombat();
        for (Card c : attackers) {
            c.updateAttackingForView();
        }
        for (Card c : blockers) {
            c.updateBlockingForView();
        }
    }

    public final void clearAttackers() {
        for (Card attacker : this.getAttackers()) {
            this.removeFromCombat(attacker);
        }
    }

    public final Player getAttackingPlayer() {
        return this.playerWhoAttacks;
    }

    public final AttackConstraints getAttackConstraints() {
        return this.attackConstraints;
    }

    public final FCollectionView<GameEntity> getDefenders() {
        return this.attackableEntries;
    }

    public final FCollection<Player> getAttackedOpponents(Player atk) {
        FCollection<Player> attackedOpps = new FCollection<Player>();
        if (atk == this.playerWhoAttacks) {
            for (Player defender : this.getDefendingPlayers()) {
                if (this.getAttackersOf(defender).isEmpty()) continue;
                attackedOpps.add(defender);
            }
        }
        return attackedOpps;
    }

    public final FCollection<GameEntity> getDefendersControlledBy(Player who) {
        FCollection<GameEntity> res = new FCollection<GameEntity>();
        for (GameEntity ge : this.attackableEntries) {
            if (ge != who && (!(ge instanceof Card) || ((Card)ge).getController() != who)) continue;
            res.add(ge);
        }
        return res;
    }

    public final FCollectionView<Player> getDefendingPlayers() {
        return new FCollection<Player>(Iterables.filter(this.attackableEntries, Player.class));
    }

    public final CardCollection getDefendingPlaneswalkers() {
        return CardLists.filter(Iterables.filter(this.attackableEntries, Card.class), CardPredicates.isType("Planeswalker"));
    }

    public final CardCollection getDefendingBattles() {
        return CardLists.filter(Iterables.filter(this.attackableEntries, Card.class), CardPredicates.isType("Battle"));
    }

    public final Map<Card, GameEntity> getAttackersAndDefenders() {
        return Maps.asMap(this.getAttackers().asSet(), this::getDefenderByAttacker);
    }

    public final List<AttackingBand> getAttackingBandsOf(GameEntity defender) {
        return Lists.newArrayList(this.attackedByBands.get(defender));
    }

    public final CardCollection getAttackersOf(GameEntity defender) {
        CardCollection result = new CardCollection();
        if (!this.attackedByBands.containsKey(defender)) {
            return result;
        }
        for (AttackingBand v : this.attackedByBands.get(defender)) {
            result.addAll(v.getAttackers());
        }
        return result;
    }

    public final void addAttacker(Card c, GameEntity defender) {
        this.addAttacker(c, defender, null);
    }

    public final void addAttacker(Card c, GameEntity defender, AttackingBand band) {
        Collection<AttackingBand> attackersOfDefender = this.attackedByBands.get(defender);
        if (attackersOfDefender == null) {
            System.out.println("Trying to add Attacker " + c + " to missing defender " + defender);
            return;
        }
        AttackingBand existingBand = this.getBandOfAttacker(c);
        if (existingBand != null) {
            existingBand.removeAttacker(c);
        }
        if (band == null || !attackersOfDefender.contains(band)) {
            band = new AttackingBand(c);
            attackersOfDefender.add(band);
        } else {
            band.addAttacker(c);
        }
        c.updateAttackingForView();
    }

    public final GameEntity getDefenderByAttacker(Card c) {
        return this.getDefenderByAttacker(this.getBandOfAttacker(c));
    }

    public final GameEntity getDefenderByAttacker(AttackingBand c) {
        for (Map.Entry<GameEntity, AttackingBand> e : this.attackedByBands.entries()) {
            if (e.getValue() != c) continue;
            return e.getKey();
        }
        return null;
    }

    public final Player getDefenderPlayerByAttacker(Card c) {
        GameEntity defender = this.getDefenderByAttacker(c);
        if (defender instanceof Player) {
            return (Player)defender;
        }
        if (defender instanceof Card) {
            Card def = (Card)defender;
            if (def.isBattle()) {
                return def.getProtectingPlayer();
            }
            return def.getController();
        }
        return null;
    }

    public final AttackingBand getBandOfAttacker(Card c) {
        if (c == null) {
            return null;
        }
        for (AttackingBand ab : this.attackedByBands.values()) {
            if (!ab.contains(c)) continue;
            return ab;
        }
        CombatLki lki = this.lkiCache.get(c).getCombatLKI();
        return lki == null || !lki.isAttacker ? null : lki.getFirstBand();
    }

    public final AttackingBand getBandOfAttackerNotNull(Card c) {
        AttackingBand band = this.getBandOfAttacker(c);
        if (band == null) {
            throw new NullPointerException("No band for attacker " + c);
        }
        return band;
    }

    public final List<AttackingBand> getAttackingBands() {
        return Lists.newArrayList(this.attackedByBands.values());
    }

    public boolean isAttacking(Card card, GameEntity defender) {
        AttackingBand ab = this.getBandOfAttacker(card);
        for (Map.Entry<GameEntity, AttackingBand> ee : this.attackedByBands.entries()) {
            if (ee.getValue() != ab) continue;
            return ee.getKey() == defender;
        }
        return false;
    }

    public final boolean isAttacking(Card card) {
        for (AttackingBand ab : this.attackedByBands.values()) {
            if (!ab.contains(card)) continue;
            return true;
        }
        return false;
    }

    public final CardCollection getAttackers() {
        CardCollection result = new CardCollection();
        for (AttackingBand ab : this.attackedByBands.values()) {
            result.addAll(ab.getAttackers());
        }
        return result;
    }

    public final boolean isBlocked(Card attacker) {
        AttackingBand band = this.getBandOfAttacker(attacker);
        return band != null && Boolean.TRUE.equals(band.isBlocked());
    }

    public final void setBlocked(Card attacker, boolean value) {
        this.getBandOfAttackerNotNull(attacker).setBlocked(value);
    }

    public final void addBlocker(Card attacker, Card blocker) {
        AttackingBand band = this.getBandOfAttackerNotNull(attacker);
        this.blockedBands.put(band, blocker);
        if (this.blockersOrderedForDamageAssignment.containsKey(attacker)) {
            this.addBlockerToDamageAssignmentOrder(attacker, blocker);
        }
        blocker.updateBlockingForView();
    }

    public final void removeBlockAssignment(Card attacker, Card blocker) {
        AttackingBand band = this.getBandOfAttackerNotNull(attacker);
        Collection<Card> cc = this.blockedBands.get(band);
        if (cc != null) {
            cc.remove(blocker);
        }
        blocker.updateBlockingForView();
    }

    public final void undoBlockingAssignment(Card blocker) {
        CardCollection toRemove = new CardCollection(blocker);
        this.blockedBands.values().removeAll(toRemove);
        blocker.updateBlockingForView();
    }

    public final CardCollection getAllBlockers() {
        CardCollection result = new CardCollection();
        for (Card blocker : this.blockedBands.values()) {
            if (result.contains(blocker)) continue;
            result.add(blocker);
        }
        return result;
    }

    public final CardCollection getDefendersCreatures() {
        CardCollection result = new CardCollection();
        for (Card attacker : this.getAttackers()) {
            CardCollection cc = this.getDefenderPlayerByAttacker(attacker).getCreaturesInPlay();
            result.addAll(cc);
        }
        return result;
    }

    public final CardCollection getBlockers(Card card) {
        return this.getBlockers(this.getBandOfAttacker(card));
    }

    public final CardCollection getBlockers(AttackingBand band) {
        Collection<Card> blockers = this.blockedBands.get(band);
        return blockers == null ? new CardCollection() : new CardCollection((Iterable<Card>)blockers);
    }

    public final CardCollection getAttackersBlockedBy(Card blocker) {
        CardCollection blocked = new CardCollection();
        for (Map.Entry<AttackingBand, Card> s2 : this.blockedBands.entries()) {
            if (!s2.getValue().equals(blocker)) continue;
            blocked.addAll(s2.getKey().getAttackers());
        }
        return blocked;
    }

    public final FCollectionView<AttackingBand> getAttackingBandsBlockedBy(Card blocker) {
        FCollection<AttackingBand> bands = new FCollection<AttackingBand>();
        for (Map.Entry<AttackingBand, Card> kv : this.blockedBands.entries()) {
            if (!kv.getValue().equals(blocker)) continue;
            bands.add(kv.getKey());
        }
        return bands;
    }

    public Player getDefendingPlayerRelatedTo(Card source) {
        Card attacker = source;
        if (source.isAura() || source.isFortification()) {
            attacker = source.getEnchantingCard();
        } else if (source.isEquipment()) {
            attacker = source.getEquipping();
        }
        return this.getDefenderPlayerByAttacker(attacker);
    }

    public void orderBlockersForDamageAssignment() {
        ArrayList<Pair<Card, CardCollection>> blockersNeedManualOrdering = new ArrayList<Pair<Card, CardCollection>>();
        for (AttackingBand attackingBand : this.attackedByBands.values()) {
            Collection<Card> blockers;
            if (attackingBand.isEmpty() || (blockers = this.blockedBands.get(attackingBand)) == null || blockers.isEmpty()) continue;
            for (Card attacker : attackingBand.getAttackers()) {
                if (blockers.size() <= 1) {
                    this.orderBlockersForDamageAssignment(attacker, new CardCollection((Iterable<Card>)blockers));
                    continue;
                }
                blockersNeedManualOrdering.add(Pair.of(attacker, new CardCollection((Iterable<Card>)blockers)));
            }
        }
        for (Pair pair : blockersNeedManualOrdering) {
            this.orderBlockersForDamageAssignment((Card)pair.getLeft(), (CardCollection)pair.getRight());
        }
    }

    public void orderBlockersForDamageAssignment(Card attacker, CardCollection blockers) {
        if (blockers.size() <= 1) {
            this.blockersOrderedForDamageAssignment.put(attacker, new CardCollection(blockers));
            return;
        }
        CardCollection orderedBlockers = this.playerWhoAttacks.getController().orderBlockers(attacker, blockers);
        this.blockersOrderedForDamageAssignment.put(attacker, orderedBlockers);
        StringBuilder sb = new StringBuilder();
        sb.append(this.playerWhoAttacks.getName());
        sb.append(" has ordered blockers for ");
        sb.append(attacker);
        sb.append(": ");
        for (int i = 0; i < orderedBlockers.size(); ++i) {
            sb.append((Object)orderedBlockers.get(i));
            if (i == orderedBlockers.size() - 1) continue;
            sb.append(", ");
        }
        this.playerWhoAttacks.getGame().getGameLog().add(GameLogEntryType.COMBAT, sb.toString());
    }

    public void addBlockerToDamageAssignmentOrder(Card attacker, Card blocker) {
        CardCollection oldBlockers = this.blockersOrderedForDamageAssignment.get(attacker);
        if (oldBlockers == null || oldBlockers.isEmpty()) {
            this.blockersOrderedForDamageAssignment.put(attacker, new CardCollection(blocker));
        } else {
            CardCollection orderedBlockers = this.playerWhoAttacks.getController().orderBlocker(attacker, blocker, oldBlockers);
            this.blockersOrderedForDamageAssignment.put(attacker, orderedBlockers);
        }
    }

    public void orderAttackersForDamageAssignment() {
        for (Card blocker : this.getAllBlockers()) {
            this.orderAttackersForDamageAssignment(blocker);
        }
    }

    public void orderAttackersForDamageAssignment(Card blocker) {
        CardCollection attackers = this.getAttackersBlockedBy(blocker);
        Player blockerCtrl = blocker.getController();
        CardCollection orderedAttacker = attackers.size() <= 1 ? attackers : blockerCtrl.getController().orderAttackers(blocker, attackers);
        this.attackersOrderedForDamageAssignment.put(blocker, orderedAttacker);
    }

    public void unregisterAttacker(Card c, AttackingBand ab) {
        this.blockersOrderedForDamageAssignment.remove(c);
        Collection<Card> blockers = this.blockedBands.get(ab);
        if (blockers != null) {
            for (Card b : blockers) {
                if (!this.attackersOrderedForDamageAssignment.containsKey(b)) continue;
                this.attackersOrderedForDamageAssignment.get(b).remove(c);
            }
        }
        Game game = c.getGame();
        for (SpellAbilityStackInstance si : game.getStack()) {
            GameEntity origDefender;
            if (!si.isTrigger() || !c.equals(si.getSourceCard()) || (origDefender = (GameEntity)si.getTriggeringObject(AbilityKey.OriginalDefender)) == null) continue;
            si.updateTriggeringObject(AbilityKey.Defender, origDefender);
            if (origDefender instanceof Player) {
                si.updateTriggeringObject(AbilityKey.DefendingPlayer, origDefender);
                continue;
            }
            if (!(origDefender instanceof Card)) continue;
            si.updateTriggeringObject(AbilityKey.DefendingPlayer, ((Card)origDefender).getController());
        }
    }

    public void unregisterDefender(Card c, AttackingBand bandBeingBlocked) {
        this.attackersOrderedForDamageAssignment.remove(c);
        for (Card atk : bandBeingBlocked.getAttackers()) {
            if (!this.blockersOrderedForDamageAssignment.containsKey(atk)) continue;
            this.blockersOrderedForDamageAssignment.get(atk).remove(c);
        }
    }

    public final void removeFromCombat(Card c) {
        AttackingBand ab = this.getBandOfAttacker(c);
        if (ab != null) {
            this.unregisterAttacker(c, ab);
            ab.removeAttacker(c);
            c.updateAttackingForView();
            return;
        }
        for (Map.Entry<AttackingBand, Card> be : this.blockedBands.entries()) {
            if (!be.getValue().equals(c)) continue;
            this.unregisterDefender(c, be.getKey());
        }
        for (Card battleOrPW : Iterables.filter(this.attackableEntries, Card.class)) {
            if (!battleOrPW.equals(c)) continue;
            ArrayListMultimap<Card, AttackingBand> attackerBuffer = ArrayListMultimap.create();
            Collection<AttackingBand> bands = this.attackedByBands.get(c);
            for (AttackingBand abDef : bands) {
                this.unregisterDefender(c, abDef);
                Card fake = new Card(-1, c.getGame());
                fake.setName("<Nothing>");
                fake.setController(c.getController(), 0L);
                attackerBuffer.put(fake, abDef);
            }
            bands.clear();
            this.attackedByBands.putAll(attackerBuffer);
            break;
        }
        while (this.blockedBands.values().remove(c)) {
        }
        c.updateBlockingForView();
    }

    public final boolean removeAbsentCombatants() {
        CardCollection missingCombatants = new CardCollection();
        for (Map.Entry<GameEntity, AttackingBand> entry : this.attackedByBands.entries()) {
            Card c;
            for (Card c2 : entry.getValue().getAttackers()) {
                if (c2.isInPlay() && c2.isCreature()) continue;
                missingCombatants.add(c2);
            }
            if (!(entry.getKey() instanceof Card) || (c = (Card)entry.getKey()).isBattle() || c.isPlaneswalker()) continue;
            missingCombatants.add(c);
        }
        for (Map.Entry<Object, Object> entry : this.blockedBands.entries()) {
            Card blocker = (Card)entry.getValue();
            if (blocker.isInPlay() && blocker.isCreature()) continue;
            missingCombatants.add(blocker);
        }
        if (missingCombatants.isEmpty()) {
            return false;
        }
        for (Card card : missingCombatants) {
            this.removeFromCombat(card);
        }
        return true;
    }

    public final void fireTriggersForUnblockedAttackers(Game game) {
        boolean bFlag = false;
        ArrayList<GameEntity> defenders = Lists.newArrayList();
        for (AttackingBand ab : this.attackedByBands.values()) {
            Collection<Card> blockers = this.blockedBands.get(ab);
            boolean isBlocked = blockers != null && !blockers.isEmpty();
            ab.setBlocked(isBlocked);
            if (isBlocked) continue;
            bFlag = true;
            defenders.add(this.getDefenderByAttacker(ab));
            for (Card attacker : ab.getAttackers()) {
                EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
                runParams.put(AbilityKey.Attacker, attacker);
                runParams.put(AbilityKey.Defender, this.getDefenderByAttacker(attacker));
                runParams.put(AbilityKey.DefendingPlayer, this.getDefenderPlayerByAttacker(attacker));
                game.getTriggerHandler().runTrigger(TriggerType.AttackerUnblocked, runParams, false);
            }
        }
        if (bFlag) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.AttackingPlayer, this.getAttackingPlayer());
            runParams.put(AbilityKey.Defenders, defenders);
            game.getTriggerHandler().runTrigger(TriggerType.AttackerUnblockedOnce, runParams, false);
        }
    }

    private boolean assignBlockersDamage(boolean firstStrikeDamage) {
        CardCollection blockers = this.getAllBlockers();
        boolean assignedDamage = false;
        for (Card blocker : blockers) {
            boolean divideCombatDamageAsChoose;
            if (!this.dealDamageThisPhase(blocker, firstStrikeDamage)) continue;
            if (firstStrikeDamage) {
                this.combatantsThatDealtFirstStrikeDamage.add(blocker);
            }
            blocker.getGame().getReplacementHandler().run(ReplacementType.AssignDealDamage, AbilityKey.mapFromAffected(blocker));
            CardCollection attackers = this.attackersOrderedForDamageAssignment.get(blocker);
            int damage = blocker.getNetCombatDamage();
            if (attackers.isEmpty()) continue;
            Player attackingPlayer = this.getAttackingPlayer();
            Player assigningPlayer = blocker.getController();
            Player defender = null;
            boolean bl = divideCombatDamageAsChoose = blocker.hasKeyword("You may assign CARDNAME's combat damage divided as you choose among defending player and/or any number of creatures they control.") && blocker.getController().getController().confirmStaticApplication(blocker, PlayerActionConfirmMode.AlternativeDamageAssignment, Localizer.getInstance().getMessage("lblAssignCombatDamageAsChoose", CardTranslation.getTranslatedName(blocker.getName())), null);
            if (divideCombatDamageAsChoose) {
                defender = blocker.getController().getController().chooseSingleEntityForEffect(attackingPlayer.getOpponents(), null, Localizer.getInstance().getMessage("lblChoosePlayer", new Object[0]), null);
                attackers = defender.getCreaturesInPlay();
            }
            if (AttackingBand.isValidBand(attackers, true)) {
                assigningPlayer = attackingPlayer;
            }
            assignedDamage = true;
            Map<Card, Integer> map = assigningPlayer.getController().assignCombatDamage(blocker, attackers, null, damage, defender, divideCombatDamageAsChoose || assigningPlayer != blocker.getController());
            for (Map.Entry<Card, Integer> dt : map.entrySet()) {
                if (dt.getKey() == null && dt.getValue() > 0) {
                    this.damageMap.put(blocker, defender, dt.getValue());
                    continue;
                }
                dt.getKey().addAssignedDamage(dt.getValue(), blocker);
                this.damageMap.put(blocker, dt.getKey(), dt.getValue());
            }
        }
        return assignedDamage;
    }

    private boolean assignAttackersDamage(boolean firstStrikeDamage) {
        CardCollection orderedBlockers = null;
        CardCollection attackers = this.getAttackers();
        boolean assignedDamage = false;
        while (!attackers.isEmpty()) {
            Card attacker = (Card)attackers.getFirst();
            if (!this.dealDamageThisPhase(attacker, firstStrikeDamage)) {
                attackers.remove(attacker);
                continue;
            }
            if (firstStrikeDamage) {
                this.combatantsThatDealtFirstStrikeDamage.add(attacker);
            }
            attacker.getGame().getReplacementHandler().run(ReplacementType.AssignDealDamage, AbilityKey.mapFromAffected(attacker));
            int damageDealt = attacker.getNetCombatDamage();
            if (damageDealt <= 0) {
                attackers.remove(attacker);
                continue;
            }
            AttackingBand band = this.getBandOfAttacker(attacker);
            if (band == null) {
                attackers.remove(attacker);
                continue;
            }
            GameEntity defender = this.getDefenderByAttacker(band);
            Player assigningPlayer = this.getAttackingPlayer();
            orderedBlockers = this.blockersOrderedForDamageAssignment.get(attacker);
            if (defender instanceof Player && defender.hasKeyword("You assign combat damage of each creature attacking you.")) {
                assigningPlayer = (Player)defender;
            } else if (orderedBlockers != null && AttackingBand.isValidBand(orderedBlockers, true)) {
                assigningPlayer = ((Card)orderedBlockers.get(false)).getController();
            }
            boolean assignToPlayer = false;
            if (StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker, false)) {
                assignToPlayer = true;
            }
            if (!assignToPlayer && attacker.getGame().getCombat().isBlocked(attacker) && StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(attacker)) {
                assignToPlayer = assigningPlayer.getController().confirmStaticApplication(attacker, PlayerActionConfirmMode.AlternativeDamageAssignment, Localizer.getInstance().getMessage("lblAssignCombatDamageWerentBlocked", CardTranslation.getTranslatedName(attacker.getName())), null);
            }
            boolean divideCombatDamageAsChoose = false;
            boolean assignCombatDamageToCreature = false;
            boolean trampler = attacker.hasKeyword(Keyword.TRAMPLE);
            if (!assignToPlayer) {
                boolean bl = divideCombatDamageAsChoose = this.getDefendersCreatures().size() > 0 && attacker.hasKeyword("You may assign CARDNAME's combat damage divided as you choose among defending player and/or any number of creatures they control.") && assigningPlayer.getController().confirmStaticApplication(attacker, PlayerActionConfirmMode.AlternativeDamageAssignment, Localizer.getInstance().getMessage("lblAssignCombatDamageAsChoose", CardTranslation.getTranslatedName(attacker.getName())), null);
                if (defender instanceof Card && divideCombatDamageAsChoose) {
                    defender = this.getDefenderPlayerByAttacker(attacker);
                }
                boolean bl2 = assignCombatDamageToCreature = !attacker.getGame().getCombat().isBlocked(attacker) && this.getDefendersCreatures().size() > 0 && attacker.hasKeyword("If CARDNAME is unblocked, you may have it assign its combat damage to a creature defending player controls.") && assigningPlayer.getController().confirmStaticApplication(attacker, PlayerActionConfirmMode.AlternativeDamageAssignment, Localizer.getInstance().getMessage("lblAssignCombatDamageToCreature", CardTranslation.getTranslatedName(attacker.getName())), null);
                if (divideCombatDamageAsChoose) {
                    if (orderedBlockers == null || orderedBlockers.isEmpty()) {
                        orderedBlockers = this.getDefendersCreatures();
                    } else {
                        for (Card c : this.getDefendersCreatures()) {
                            if (orderedBlockers.contains(c)) continue;
                            orderedBlockers.add(c);
                        }
                    }
                }
            }
            assignedDamage = true;
            if (defender instanceof Card && !((Card)defender).isBattle() && attacker.hasKeyword("Trample:Planeswalker")) {
                if (orderedBlockers == null || orderedBlockers.isEmpty()) {
                    orderedBlockers = new CardCollection((Card)defender);
                } else {
                    orderedBlockers.add((Card)defender);
                }
                defender = this.getDefenderPlayerByAttacker(attacker);
            }
            if (assignToPlayer) {
                attackers.remove(attacker);
                this.damageMap.put(attacker, defender, damageDealt);
                continue;
            }
            if (orderedBlockers == null || orderedBlockers.isEmpty()) {
                attackers.remove(attacker);
                if (assignCombatDamageToCreature) {
                    SpellAbility.EmptySa emptySA = new SpellAbility.EmptySa(ApiType.Cleanup, attacker);
                    Card chosen = (Card)attacker.getController().getController().chooseCardsForEffect(this.getDefendersCreatures(), emptySA, Localizer.getInstance().getMessage("lblChooseCreature", new Object[0]), 1, 1, false, null).get(false);
                    this.damageMap.put(attacker, chosen, damageDealt);
                    continue;
                }
                if (!trampler && band.isBlocked().booleanValue()) continue;
                this.damageMap.put(attacker, defender, damageDealt);
                continue;
            }
            Map<Card, Integer> map = assigningPlayer.getController().assignCombatDamage(attacker, orderedBlockers, attackers, damageDealt, defender, divideCombatDamageAsChoose || this.getAttackingPlayer() != assigningPlayer);
            attackers.remove(attacker);
            if (map == null) {
                attackers.add(attacker);
                continue;
            }
            for (Map.Entry<Card, Integer> dt : map.entrySet()) {
                if (dt.getKey() == null) {
                    if (dt.getValue() <= 0) continue;
                    if (defender instanceof Card) {
                        ((Card)defender).addAssignedDamage(dt.getValue(), attacker);
                    }
                    this.damageMap.put(attacker, defender, dt.getValue());
                    continue;
                }
                dt.getKey().addAssignedDamage(dt.getValue(), attacker);
                this.damageMap.put(attacker, dt.getKey(), dt.getValue());
            }
        }
        return assignedDamage;
    }

    private boolean dealDamageThisPhase(Card combatant, boolean firstStrikeDamage) {
        if (combatant.hasDoubleStrike()) {
            return true;
        }
        if (firstStrikeDamage && combatant.hasFirstStrike()) {
            return true;
        }
        return !firstStrikeDamage && !this.combatantsThatDealtFirstStrikeDamage.contains(combatant);
    }

    public final boolean assignCombatDamage(boolean firstStrikeDamage) {
        boolean assignedDamage = this.assignAttackersDamage(firstStrikeDamage);
        assignedDamage |= this.assignBlockersDamage(firstStrikeDamage);
        if (!firstStrikeDamage) {
            this.combatantsThatDealtFirstStrikeDamage.clear();
        }
        return assignedDamage;
    }

    public void dealAssignedDamage() {
        Game game = this.playerWhoAttacks.getGame();
        game.copyLastState();
        CardDamageMap preventMap = new CardDamageMap();
        GameEntityCounterTable counterTable = new GameEntityCounterTable();
        game.getAction().dealDamage(true, this.damageMap, preventMap, counterTable, null);
        game.copyLastState();
    }

    public final boolean isUnblocked(Card att) {
        AttackingBand band = this.getBandOfAttacker(att);
        return band != null && Boolean.FALSE.equals(band.isBlocked());
    }

    public final CardCollection getUnblockedAttackers() {
        CardCollection unblocked = new CardCollection();
        for (AttackingBand ab : this.attackedByBands.values()) {
            if (!Boolean.FALSE.equals(ab.isBlocked())) continue;
            unblocked.addAll(ab.getAttackers());
        }
        return unblocked;
    }

    public boolean isPlayerAttacked(Player who) {
        for (GameEntity defender : this.attackedByBands.keySet()) {
            Card defenderAsCard;
            Card card = defenderAsCard = defender instanceof Card ? (Card)defender : null;
            if (null != defenderAsCard && defenderAsCard.getController() != who && defenderAsCard.getProtectingPlayer() != who || null == defenderAsCard && defender != who) continue;
            for (AttackingBand ab : this.attackedByBands.get(defender)) {
                if (ab.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBlocking(Card blocker) {
        if (this.blockedBands.containsValue(blocker)) {
            return true;
        }
        if (!blocker.isLKI()) {
            return false;
        }
        CombatLki lki = this.lkiCache.get(blocker).getCombatLKI();
        return null != lki && !lki.isAttacker;
    }

    public boolean isBlocking(Card blocker, Card attacker) {
        AttackingBand ab = this.getBandOfAttacker(attacker);
        Collection<Card> blockers = this.blockedBands.get(ab);
        if (blockers != null && blockers.contains(blocker)) {
            return true;
        }
        if (!blocker.isLKI()) {
            return false;
        }
        CombatLki lki = this.lkiCache.get(blocker).getCombatLKI();
        return null != lki && !lki.isAttacker && lki.relatedBands.contains(ab);
    }

    public CombatLki saveLKI(Card lki) {
        boolean isAttacker;
        if (!lki.isLKI()) {
            lki = CardCopyService.getLKICopy(lki);
        }
        FCollection<AttackingBand> attackersBlocked = null;
        AttackingBand attackingBand = this.getBandOfAttacker(lki);
        boolean bl = isAttacker = attackingBand != null;
        if (isAttacker) {
            boolean found = false;
            for (AttackingBand ab : this.attackedByBands.values()) {
                if (!ab.contains(lki)) continue;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        } else {
            attackersBlocked = this.getAttackingBandsBlockedBy(lki);
            if (attackersBlocked.isEmpty()) {
                return null;
            }
        }
        this.lkiCache.add(lki);
        FCollection<AttackingBand> relatedBands = isAttacker ? new FCollection<AttackingBand>(attackingBand) : attackersBlocked;
        return new CombatLki(isAttacker, relatedBands);
    }
}

