/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.game.card.Card;
import forge.game.card.CardPredicates;

public enum AttackRestrictionType {
    ONLY_ALONE,
    NEED_GREATER_POWER,
    NEED_BLACK_OR_GREEN,
    NOT_ALONE,
    NEED_TWO_OTHERS,
    NEVER;


    public Predicate<Card> getPredicate(Card attacker) {
        switch (this) {
            case NEED_GREATER_POWER: {
                return CardPredicates.hasGreaterPowerThan(attacker.getNetPower());
            }
            case NEED_BLACK_OR_GREEN: {
                return Predicates.and(CardPredicates.isColor((byte)20), Predicates.not(Predicates.equalTo(attacker)));
            }
            case NOT_ALONE: {
                return Predicates.alwaysTrue();
            }
        }
        return null;
    }
}

