/*
 * Decompiled with CFR 0.152.
 */
package forge.game.combat;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.AttackRequirement;
import forge.game.combat.AttackRestriction;
import forge.game.combat.AttackRestrictionType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.combat.GlobalAttackRestrictions;
import forge.game.staticability.StaticAbilityMustAttack;
import forge.game.zone.ZoneType;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import forge.util.maps.LinkedHashMapToAmount;
import forge.util.maps.MapToAmountUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class AttackConstraints {
    private final CardCollection possibleAttackers;
    private final FCollectionView<GameEntity> possibleDefenders;
    private final GlobalAttackRestrictions globalRestrictions;
    private final Map<Card, AttackRestriction> restrictions = Maps.newHashMap();
    private final Map<Card, AttackRequirement> requirements = Maps.newHashMap();
    private final List<Set<GameEntity>> playerRequirements;

    public AttackConstraints(Combat combat) {
        Game game = combat.getAttackingPlayer().getGame();
        this.possibleAttackers = combat.getAttackingPlayer().getCreaturesInPlay();
        this.possibleDefenders = combat.getDefenders();
        this.globalRestrictions = GlobalAttackRestrictions.getGlobalRestrictions(combat.getAttackingPlayer(), this.possibleDefenders);
        this.playerRequirements = StaticAbilityMustAttack.mustAttackSpecific(combat.getAttackingPlayer(), this.possibleDefenders);
        int nMagnetRequirements = 0;
        CardCollection magnetAttackers = CardLists.filter((Iterable<Card>)this.possibleAttackers, CardPredicates.hasCounter(CounterEnumType.MAGNET));
        if (!magnetAttackers.isEmpty()) {
            nMagnetRequirements = CardLists.getAmountOfKeyword((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), "If a creature with a magnet counter on it attacks, all creatures with magnet counters on them attack if able.");
        }
        LinkedHashMapToAmount attacksIfOtherAttacks = new LinkedHashMapToAmount();
        for (Card possibleAttacker : this.possibleAttackers) {
            attacksIfOtherAttacks.add(possibleAttacker, possibleAttacker.getAmountOfKeyword("If a creature you control attacks, CARDNAME also attacks if able."));
        }
        for (Card possibleAttacker : this.possibleAttackers) {
            this.restrictions.put(possibleAttacker, new AttackRestriction(possibleAttacker, this.possibleDefenders));
            LinkedHashMapToAmount<Card> causesToAttack = new LinkedHashMapToAmount<Card>();
            for (Map.Entry entry : attacksIfOtherAttacks.entrySet()) {
                if (entry.getKey() == possibleAttacker) continue;
                causesToAttack.add((Card)entry.getKey(), (int)((Integer)entry.getValue()));
            }
            int nAllMustAttack = possibleAttacker.getAmountOfKeyword("If CARDNAME attacks, all creatures you control attack if able.");
            for (Card c : this.possibleAttackers) {
                if (c == possibleAttacker) continue;
                causesToAttack.add(c, nAllMustAttack);
            }
            if (possibleAttacker.getCounters(CounterEnumType.MAGNET) > 0) {
                for (Card c : magnetAttackers) {
                    if (c == possibleAttacker) continue;
                    causesToAttack.add(c, nMagnetRequirements);
                }
            }
            AttackRequirement attackRequirement = new AttackRequirement(possibleAttacker, causesToAttack, this.possibleDefenders);
            this.requirements.put(possibleAttacker, attackRequirement);
        }
    }

    public Map<Card, AttackRestriction> getRestrictions() {
        return this.restrictions;
    }

    public Map<Card, AttackRequirement> getRequirements() {
        return this.requirements;
    }

    public Pair<Map<Card, GameEntity>, Integer> getLegalAttackers() {
        Set<AttackRestrictionType> types;
        int globalMax = this.globalRestrictions.getMax();
        int myMax = Ints.min(globalMax == -1 ? Integer.MAX_VALUE : globalMax, this.possibleAttackers.size());
        if (myMax == 0) {
            return Pair.of(Collections.emptyMap(), 0);
        }
        LinkedHashMapToAmount possible = new LinkedHashMapToAmount();
        List<Attack> reqs = this.getSortedFilteredRequirements();
        CardCollection myPossibleAttackers = new CardCollection(this.possibleAttackers);
        CardCollection attackersToRemove = new CardCollection();
        for (Card attacker : myPossibleAttackers) {
            types = this.restrictions.get(attacker).getTypes();
            if (!(types.contains((Object)AttackRestrictionType.NEED_TWO_OTHERS) && myMax <= 2 || types.contains((Object)AttackRestrictionType.NOT_ALONE) && myMax <= 1 || types.contains((Object)AttackRestrictionType.NEED_BLACK_OR_GREEN) && myMax <= 1) && (!types.contains((Object)AttackRestrictionType.NEED_GREATER_POWER) || myMax > 1)) continue;
            reqs.removeAll(AttackConstraints.findAll(reqs, attacker));
            attackersToRemove.add(attacker);
        }
        myPossibleAttackers.removeAll(attackersToRemove);
        attackersToRemove.clear();
        for (Card attacker : myPossibleAttackers) {
            types = this.restrictions.get(attacker).getTypes();
            if (types.contains((Object)AttackRestrictionType.NEED_BLACK_OR_GREEN)) {
                if (Iterables.any(myPossibleAttackers, AttackRestrictionType.NEED_BLACK_OR_GREEN.getPredicate(attacker))) continue;
                attackersToRemove.add(attacker);
                continue;
            }
            if (!types.contains((Object)AttackRestrictionType.NEED_GREATER_POWER) || Iterables.any(myPossibleAttackers, AttackRestrictionType.NEED_GREATER_POWER.getPredicate(attacker))) continue;
            attackersToRemove.add(attacker);
        }
        myPossibleAttackers.removeAll(attackersToRemove);
        for (Card toRemove : attackersToRemove) {
            reqs.removeAll(AttackConstraints.findAll(reqs, toRemove));
        }
        for (Card attacker : myPossibleAttackers) {
            Attack attack;
            if (!this.restrictions.get(attacker).getTypes().contains((Object)AttackRestrictionType.ONLY_ALONE) || (attack = AttackConstraints.findFirst(reqs, attacker)) == null) continue;
            ImmutableMap<Card, GameEntity> attackMap = ImmutableMap.of(attack.attacker, attack.defender);
            int violations = this.countViolations(attackMap);
            if (violations != -1) {
                possible.put(attackMap, violations);
            }
            reqs.removeAll(AttackConstraints.findAll(reqs, attacker));
        }
        FCollection<Map<Card, GameEntity>> legalAttackers = this.collectLegalAttackers(reqs, myMax);
        possible.putAll(Maps.asMap(legalAttackers.asSet(), this::countViolations));
        int empty = this.countViolations(Collections.emptyMap());
        if (empty != -1) {
            possible.put(Collections.emptyMap(), empty);
        }
        return MapToAmountUtil.min(possible);
    }

    private FCollection<Map<Card, GameEntity>> collectLegalAttackers(List<Attack> reqs, int maximum) {
        return new FCollection<Map<Card, GameEntity>>(this.collectLegalAttackers(Collections.emptyMap(), AttackConstraints.deepClone(reqs), new CardCollection(), maximum));
    }

    private List<Map<Card, GameEntity>> collectLegalAttackers(Map<Card, GameEntity> attackers, List<Attack> reqs, CardCollection reserved, int maximum) {
        LinkedList<Map<Card, GameEntity>> result = Lists.newLinkedList();
        int localMaximum = maximum;
        boolean isLimited = this.globalRestrictions.getMax() != -1;
        HashMap<Card, GameEntity> myAttackers = Maps.newHashMap(attackers);
        LinkedHashMapToAmount toDefender = new LinkedHashMapToAmount();
        int attackersNeeded = 0;
        block0: while (!reqs.isEmpty()) {
            Integer defMax;
            Iterator<Attack> iterator = reqs.iterator();
            Attack req = iterator.next();
            boolean isReserved = reserved.contains(req.attacker);
            boolean skip = false;
            if (!isReserved) {
                if (localMaximum <= 0) {
                    skip = true;
                } else if (req.requirements == 0 && attackersNeeded == 0 && reserved.isEmpty()) {
                    skip = true;
                }
            }
            if ((defMax = (Integer)this.globalRestrictions.getDefenderMax().get(req.defender)) != null && toDefender.count(req.defender) >= defMax) {
                skip = true;
            } else if (null != CombatUtil.getAttackCost(req.attacker.getGame(), req.attacker, req.defender)) {
                skip = true;
            }
            if (skip) {
                iterator.remove();
                continue;
            }
            boolean haveTriedWithout = false;
            AttackRestriction restriction = this.restrictions.get(req.attacker);
            AttackRequirement requirement = this.requirements.get(req.attacker);
            LinkedList<Predicate<Card>> predicateRestrictions = Lists.newLinkedList();
            for (AttackRestrictionType attackRestrictionType : restriction.getTypes()) {
                Predicate<Card> predicate = attackRestrictionType.getPredicate(req.attacker);
                if (predicate == null) continue;
                predicateRestrictions.add(predicate);
            }
            if (!requirement.getCausesToAttack().isEmpty()) {
                List<Attack> clonedReqs = AttackConstraints.deepClone(reqs);
                for (Map.Entry causesToAttack : requirement.getCausesToAttack().entrySet()) {
                    for (Attack a : AttackConstraints.findAll(reqs, (Card)causesToAttack.getKey())) {
                        a.requirements += (Integer)causesToAttack.getValue();
                    }
                }
                if (isLimited) {
                    clonedReqs.removeAll(AttackConstraints.findAll(clonedReqs, req.attacker));
                    CardCollection cardCollection = new CardCollection(reserved);
                    result.addAll(this.collectLegalAttackers(myAttackers, clonedReqs, cardCollection, localMaximum));
                    haveTriedWithout = true;
                }
            }
            for (Predicate predicate : predicateRestrictions) {
                if (Iterables.any(Sets.union(myAttackers.keySet(), reserved.asSet()), predicate)) continue;
                Attack match = AttackConstraints.findFirst(reqs, predicate);
                if (match == null) {
                    reqs.removeAll(AttackConstraints.findAll(reqs, req.attacker));
                    continue block0;
                }
                reserved.add(match.attacker);
                --localMaximum;
                if (haveTriedWithout || !isLimited) continue;
                List<Attack> clonedReqs = AttackConstraints.deepClone(reqs);
                clonedReqs.removeAll(AttackConstraints.findAll(clonedReqs, req.attacker));
                CardCollection clonedReserved = new CardCollection(reserved);
                result.addAll(this.collectLegalAttackers(myAttackers, clonedReqs, clonedReserved, localMaximum));
                haveTriedWithout = true;
            }
            myAttackers.put(req.attacker, req.defender);
            toDefender.add(req.defender);
            reqs.removeAll(AttackConstraints.findAll(reqs, req.attacker));
            reserved.remove(req.attacker);
            --localMaximum;
            if (this.restrictions.get(req.attacker).getTypes().contains((Object)AttackRestrictionType.NEED_TWO_OTHERS)) {
                int previousNeeded = attackersNeeded;
                attackersNeeded = Ints.max(3 - (myAttackers.size() + reserved.size()), 0);
                localMaximum -= Ints.max(attackersNeeded - previousNeeded, 0);
                continue;
            }
            if (!this.restrictions.get(req.attacker).getTypes().contains((Object)AttackRestrictionType.NOT_ALONE)) continue;
            attackersNeeded = Ints.max(2 - (myAttackers.size() + reserved.size()), 0);
        }
        if (reserved.isEmpty() && attackersNeeded == 0) {
            result.add(myAttackers);
        }
        return result;
    }

    private List<Attack> getSortedFilteredRequirements() {
        ArrayList<Attack> result = Lists.newArrayList();
        Map sortedRequirements = Maps.transformValues(this.requirements, AttackRequirement::getSortedRequirements);
        for (Map.Entry reqList : sortedRequirements.entrySet()) {
            AttackRestriction restriction = this.restrictions.get(reqList.getKey());
            List list = (List)reqList.getValue();
            for (Pair attackReq : list) {
                if (!restriction.canAttack((GameEntity)attackReq.getLeft())) continue;
                result.add(new Attack(reqList.getKey(), (GameEntity)attackReq.getLeft(), (Integer)attackReq.getRight()));
            }
        }
        Collections.sort(result);
        ArrayList<Set<GameEntity>> playerReqs = Lists.newArrayList(this.playerRequirements);
        CardCollection usedAttackers = new CardCollection();
        FCollection<GameEntity> excludedDefenders = new FCollection<GameEntity>();
        LinkedHashMapToAmount sortedPlayerReqs = new LinkedHashMapToAmount();
        sortedPlayerReqs.addAll(Iterables.concat(playerReqs));
        while (!sortedPlayerReqs.isEmpty()) {
            Pair playerReq = MapToAmountUtil.max(sortedPlayerReqs);
            Attack bestMatch = Iterables.getLast(Iterables.filter(result, att -> !usedAttackers.contains(((Attack)att).attacker) && ((Attack)att).defender.equals(playerReq.getLeft())), null);
            if (bestMatch != null) {
                bestMatch.requirements += playerReq.getRight();
                usedAttackers.add(bestMatch.attacker);
                playerReqs.removeIf(s2 -> s2.contains(playerReq.getLeft()));
                sortedPlayerReqs.clear();
                sortedPlayerReqs.addAll(Iterables.concat(playerReqs));
            } else {
                excludedDefenders.add((GameEntity)playerReq.getLeft());
            }
            sortedPlayerReqs.keySet().removeAll(excludedDefenders);
        }
        if (!usedAttackers.isEmpty()) {
            Collections.sort(result);
        }
        return Lists.reverse(result);
    }

    private static List<Attack> deepClone(List<Attack> original) {
        LinkedList<Attack> newList = Lists.newLinkedList();
        for (Attack attack : original) {
            newList.add(new Attack(attack));
        }
        return newList;
    }

    private static Attack findFirst(List<Attack> reqs, Predicate<Card> predicate) {
        for (Attack req : reqs) {
            if (!predicate.apply(req.attacker)) continue;
            return req;
        }
        return null;
    }

    private static Attack findFirst(List<Attack> reqs, Card attacker) {
        return AttackConstraints.findFirst(reqs, Predicates.equalTo(attacker));
    }

    private static Collection<Attack> findAll(List<Attack> reqs, Card attacker) {
        return Collections2.filter(reqs, input -> ((Attack)input).attacker.equals(attacker));
    }

    public final int countViolations(Map<Card, GameEntity> attackers) {
        if (!this.globalRestrictions.isLegal(attackers)) {
            return -1;
        }
        for (Map.Entry<Card, GameEntity> attacker : attackers.entrySet()) {
            AttackRestriction attackRestriction = this.restrictions.get(attacker.getKey());
            if (attackRestriction == null || attackRestriction.canAttack(attacker.getKey(), attackers)) continue;
            return -1;
        }
        int violations = 0;
        for (Card card : this.possibleAttackers) {
            AttackRequirement requirement = this.requirements.get(card);
            if (requirement == null) continue;
            violations += requirement.countViolations(attackers.get(card), attackers);
        }
        for (Set set : this.playerRequirements) {
            if (!Collections.disjoint(set, attackers.values())) continue;
            ++violations;
        }
        return violations;
    }

    private static final class Attack
    implements Comparable<Attack> {
        private final Card attacker;
        private final GameEntity defender;
        private int requirements;

        private Attack(Attack other) {
            this(other.attacker, other.defender, other.requirements);
        }

        private Attack(Card attacker, GameEntity defender, int requirements) {
            this.attacker = attacker;
            this.defender = defender;
            this.requirements = requirements;
        }

        @Override
        public int compareTo(Attack other) {
            return Integer.compare(this.requirements, other.requirements);
        }

        public String toString() {
            return "[" + this.requirements + "] " + this.attacker + " to " + this.defender;
        }
    }
}

