/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import forge.game.CardTraitBase;
import forge.game.GameObject;
import forge.game.GameObjectPredicates;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.player.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class TokenCreateTable
extends ForwardingTable<Player, Card, Integer> {
    Table<Player, Card, Integer> dataMap = HashBasedTable.create();

    @Override
    protected Table<Player, Card, Integer> delegate() {
        return this.dataMap;
    }

    public int add(Player p, Card c, int i) {
        int old = ObjectUtils.defaultIfNull((Integer)this.get(p, c), 0);
        int newValue = old + i;
        this.put(p, c, newValue);
        return newValue;
    }

    public int getFilterAmount(String validOwner, String validToken, CardTraitBase ctb) {
        Card host = ctb.getHostCard();
        int result = 0;
        List<Card> filteredCards = null;
        ArrayList<GameObject> filteredPlayer = null;
        if (validOwner == null && validToken == null) {
            for (Integer i : this.values()) {
                result += i.intValue();
            }
            return result;
        }
        if (validOwner != null && (filteredPlayer = Lists.newArrayList(Iterables.filter(this.rowKeySet(), GameObjectPredicates.restriction(validOwner.split(","), host.getController(), host, ctb)))).isEmpty()) {
            return 0;
        }
        if (validToken != null && (filteredCards = CardLists.getValidCardsAsList(this.columnKeySet(), validToken, host.getController(), host, ctb)).isEmpty()) {
            return 0;
        }
        if (filteredPlayer == null) {
            for (Map.Entry e : this.columnMap().entrySet()) {
                for (Integer i : e.getValue().values()) {
                    result += i.intValue();
                }
            }
            return result;
        }
        if (filteredCards == null) {
            for (Map.Entry e : this.rowMap().entrySet()) {
                for (Integer i : e.getValue().values()) {
                    result += i.intValue();
                }
            }
            return result;
        }
        for (Table.Cell c : this.cellSet()) {
            if (!filteredPlayer.contains(c.getRowKey()) || !filteredCards.contains(c.getColumnKey())) continue;
            result += ((Integer)c.getValue()).intValue();
        }
        return result;
    }
}

