/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameAction;
import forge.game.ability.AbilityKey;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class CardZoneTable
extends ForwardingTable<ZoneType, ZoneType, CardCollection> {
    private Table<ZoneType, ZoneType, CardCollection> dataMap = HashBasedTable.create();
    private CardCollection createdTokens = new CardCollection();
    private PlayerCollection firstTimeTokenCreators = new PlayerCollection();
    private CardCollectionView lastStateBattlefield;
    private CardCollectionView lastStateGraveyard;

    public CardZoneTable() {
        this(null, null);
    }

    public CardZoneTable(CardCollectionView lastStateBattlefield, CardCollectionView lastStateGraveyard) {
        this.setLastStateBattlefield(lastStateBattlefield);
        this.setLastStateGraveyard(lastStateGraveyard);
    }

    public CardZoneTable(CardZoneTable cardZoneTable) {
        this.putAll(cardZoneTable);
        this.lastStateBattlefield = cardZoneTable.getLastStateBattlefield();
        this.lastStateGraveyard = cardZoneTable.getLastStateGraveyard();
    }

    public static CardZoneTable getSimultaneousInstance(SpellAbility sa) {
        if (sa.isReplacementAbility() && sa.getReplacementEffect().getMode() == ReplacementType.Moved && sa.getReplacingObject(AbilityKey.InternalTriggerTable) != null) {
            return (CardZoneTable)sa.getReplacingObject(AbilityKey.InternalTriggerTable);
        }
        GameAction ga = sa.getHostCard().getGame().getAction();
        return new CardZoneTable(ga.getLastState(AbilityKey.LastStateBattlefield, sa, null, true), ga.getLastState(AbilityKey.LastStateGraveyard, sa, null, true));
    }

    public CardCollectionView getLastStateBattlefield() {
        return this.lastStateBattlefield;
    }

    public CardCollectionView getLastStateGraveyard() {
        return this.lastStateGraveyard;
    }

    public void setLastStateBattlefield(CardCollectionView lastState) {
        this.lastStateBattlefield = lastState == null ? CardCollection.EMPTY : new CardCollection(lastState);
    }

    public void setLastStateGraveyard(CardCollectionView lastState) {
        this.lastStateGraveyard = lastState == null ? CardCollection.EMPTY : new CardCollection(lastState);
    }

    @Override
    public CardCollection put(ZoneType rowKey, ZoneType columnKey, Card value) {
        CardCollection old;
        if (rowKey == null) {
            rowKey = ZoneType.None;
        }
        if (columnKey == null) {
            columnKey = ZoneType.None;
        }
        if (this.contains((Object)rowKey, (Object)columnKey)) {
            old = (CardCollection)this.get((Object)rowKey, (Object)columnKey);
            old.add(value);
        } else {
            old = new CardCollection(value);
            this.delegate().put(rowKey, columnKey, old);
        }
        return old;
    }

    @Override
    protected Table<ZoneType, ZoneType, CardCollection> delegate() {
        return this.dataMap;
    }

    public void triggerChangesZoneAll(Game game, SpellAbility cause) {
        CardZoneTable untilTable;
        this.triggerTokenCreatedOnce(game);
        if (cause != null && cause.getReplacingObject(AbilityKey.InternalTriggerTable) == this) {
            return;
        }
        if (!this.isEmpty()) {
            if (this.lastStateBattlefield != CardCollection.EMPTY) {
                game.getTriggerHandler().resetActiveTriggers(false);
                for (Card lki : this.lastStateBattlefield) {
                    game.getTriggerHandler().registerActiveLTBTrigger(lki);
                }
            }
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, new CardZoneTable(this));
            runParams.put(AbilityKey.Cause, cause);
            game.getTriggerHandler().runTrigger(TriggerType.ChangesZoneAll, runParams, false);
        }
        if (this != (untilTable = game.getUntilHostLeavesPlayTriggerList())) {
            untilTable.triggerChangesZoneAll(game, null);
            untilTable.clear();
        }
    }

    private void triggerTokenCreatedOnce(Game game) {
        if (!this.createdTokens.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, this.createdTokens);
            runParams.put(AbilityKey.FirstTime, this.firstTimeTokenCreators);
            game.getTriggerHandler().runTrigger(TriggerType.TokenCreatedOnce, runParams, false);
        }
    }

    public CardCollection filterCards(Iterable<ZoneType> origin, Iterable<ZoneType> destination, String valid, Card host, CardTraitBase sa) {
        CardCollection allCards = new CardCollection();
        if (destination != null && !Iterables.any(destination, d -> this.columnKeySet().contains(d))) {
            return allCards;
        }
        if (origin != null) {
            for (ZoneType z : origin) {
                if (!this.containsRow((Object)z)) continue;
                CardCollectionView lkiLookup = CardCollection.EMPTY;
                if (z == ZoneType.Battlefield) {
                    lkiLookup = this.lastStateBattlefield;
                }
                if (z == ZoneType.Graveyard && destination == null) {
                    lkiLookup = this.lastStateGraveyard;
                }
                if (destination != null) {
                    for (ZoneType zt : destination) {
                        if (!this.row(z).containsKey((Object)zt)) continue;
                        for (Card c : (CardCollection)this.row(z).get((Object)zt)) {
                            if (lkiLookup != CardCollection.EMPTY && !lkiLookup.contains(c)) continue;
                            allCards.add(lkiLookup.get(c));
                        }
                    }
                    continue;
                }
                for (CardCollection cc : this.row(z).values()) {
                    for (Card c : cc) {
                        if (lkiLookup != CardCollection.EMPTY && !lkiLookup.contains(c)) continue;
                        allCards.add(lkiLookup.get(c));
                    }
                }
            }
        } else if (destination != null) {
            for (ZoneType zt : destination) {
                for (CardCollection c : this.column(zt).values()) {
                    allCards.addAll(c);
                }
            }
        } else {
            for (CardCollection c : this.values()) {
                allCards.addAll(c);
            }
        }
        if (valid != null) {
            allCards = CardLists.getValidCards((Iterable<Card>)allCards, valid, host.getController(), host, sa);
        }
        return allCards;
    }

    public Iterable<Card> allCards() {
        return Iterables.concat(this.values());
    }

    public void addToken(Card c, boolean firstTime) {
        this.createdTokens.add(c);
        if (firstTime) {
            this.firstTimeTokenCreators.add(c.getOwner());
        }
    }
}

