/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.ImageKeys;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardState;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CardUtil {
    public static final List<String> NON_STACKING_LIST = Lists.newArrayList();
    public static final ImmutableList<String> modifiableKeywords = ((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"Enchant", "Protection", "Cumulative upkeep", "Equip", "Buyback", "Cycling", "Echo", "Kicker", "Flashback", "Madness", "Morph", "Affinity", "Entwine", "Splice", "Ninjutsu", "Transmute", "Replicate", "Recover", "Squad", "Suspend", "Aura swap", "Fortify", "Transfigure", "Champion", "Evoke", "Prowl", "Freerunning", "Reinforce", "Unearth", "Level up", "Miracle", "Overload", "Cleave", "Scavenge", "Encore", "Bestow", "Outlast", "Dash", "Surge", "Emerge", "Hexproof:", "Bands with other", "etbCounter", "Reflect", "Ward"})).build();
    public static final ImmutableList<String> modifiableKeywordEndings = ((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"walk", "cycling", "offering"})).build();

    private CardUtil() {
    }

    public static boolean isKeywordModifiable(String kw) {
        for (String modKw : modifiableKeywords) {
            if (!kw.startsWith(modKw)) continue;
            return true;
        }
        for (String end : modifiableKeywordEndings) {
            if (!kw.endsWith(end)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStackingKeyword(String keyword) {
        String kw = keyword;
        if (kw.startsWith("HIDDEN")) {
            kw = kw.substring(7);
        }
        return !kw.startsWith("Protection") && !NON_STACKING_LIST.contains(kw);
    }

    public static List<Card> getThisTurnEntered(ZoneType to, ZoneType from, String valid, Card src, CardTraitBase ctb, Player controller) {
        ArrayList<Card> res = Lists.newArrayList();
        Game game = src.getGame();
        if (to != ZoneType.Stack) {
            for (Player p : game.getRegisteredPlayers()) {
                res.addAll(p.getZone(to).getCardsAddedThisTurn(from));
            }
        } else {
            res.addAll(game.getStackZone().getCardsAddedThisTurn(from));
        }
        return CardLists.getValidCardsAsList(res, valid, controller, src, ctb);
    }

    public static List<Card> getLastTurnEntered(ZoneType to, ZoneType from, String valid, Card src, CardTraitBase ctb, Player controller) {
        ArrayList<Card> res = Lists.newArrayList();
        Game game = src.getGame();
        if (to != ZoneType.Stack) {
            for (Player p : game.getPlayers()) {
                res.addAll(p.getZone(to).getCardsAddedLastTurn(from));
            }
        } else {
            res.addAll(game.getStackZone().getCardsAddedLastTurn(from));
        }
        return CardLists.getValidCardsAsList(res, valid, controller, src, ctb);
    }

    public static List<Card> getThisTurnCast(String valid, Card src, CardTraitBase ctb, Player controller) {
        return CardLists.getValidCardsAsList(src.getGame().getStack().getSpellsCastThisTurn(), valid, controller, src, ctb);
    }

    public static List<Card> getLastTurnCast(String valid, Card src, CardTraitBase ctb, Player controller) {
        return CardLists.getValidCardsAsList(src.getGame().getStack().getSpellsCastLastTurn(), valid, controller, src, ctb);
    }

    public static List<SpellAbility> getThisTurnActivated(String valid, Card src, CardTraitBase ctb, Player controller) {
        return Lists.newArrayList(Iterables.filter(src.getGame().getStack().getAbilityActivatedThisTurn(), SpellAbilityPredicates.isValid(valid.split(","), controller, src, ctb)));
    }

    public static List<Card> getCastSinceBeginningOfYourLastTurn(String valid, Card src, CardTraitBase ctb, Player controller) {
        return CardLists.getValidCardsAsList(controller.getSpellsCastSinceBegOfYourLastTurn(), valid, controller, src, ctb);
    }

    public static CardCollection getRadiance(SpellAbility sa) {
        SpellAbility targetSA = sa.getSATargetingCard();
        if (targetSA == null || !targetSA.usesTargeting() || !targetSA.hasParam("Radiance")) {
            return new CardCollection();
        }
        Card source = targetSA.getHostCard();
        Game game = source.getGame();
        CardCollection res = new CardCollection();
        String[] valid = targetSA.getParam("ValidTgts").split(",");
        CardCollectionView tgts = targetSA.getTargets().getTargetCards();
        byte combinedColor = 0;
        for (Card tgt : tgts) {
            ColorSet cs = tgt.getColor();
            for (byte color : MagicColor.WUBRG) {
                if (!cs.hasAnyColor(color)) continue;
                combinedColor = (byte)(combinedColor | color);
            }
        }
        for (Object color : (Object)MagicColor.WUBRG) {
            if ((combinedColor & color) == 0) continue;
            for (Card c : game.getColoredCardsInPlay(MagicColor.toLongString((byte)color))) {
                if (res.contains(c) || tgts.contains(c) || !c.isValid(valid, source.getController(), source, (CardTraitBase)targetSA)) continue;
                res.add(c);
            }
        }
        return res;
    }

    public static ColorSet getColorsFromCards(Iterable<Card> list) {
        int b = 0;
        for (Card c : list) {
            b = (byte)(b | c.getColor().getColor());
        }
        return ColorSet.fromMask(b);
    }

    public static CardState getFaceDownCharacteristic(Card c) {
        return CardUtil.getFaceDownCharacteristic(c, CardStateName.FaceDown);
    }

    public static CardState getFaceDownCharacteristic(Card c, CardStateName state) {
        CardType type = new CardType(false);
        type.add("Creature");
        CardState ret = new CardState(c, state);
        ret.setBasePower(2);
        ret.setBaseToughness(2);
        ret.setName("");
        ret.setType(type);
        if (state == CardStateName.FaceDown) {
            ret.setImageKey(ImageKeys.getTokenKey("hidden"));
        } else {
            ret.setImageKey(c.getImageKey());
        }
        return ret;
    }

    public static CardState getEmptyRoomCharacteristic(Card c) {
        return CardUtil.getEmptyRoomCharacteristic(c, CardStateName.EmptyRoom);
    }

    public static CardState getEmptyRoomCharacteristic(Card c, CardStateName state) {
        CardType type = new CardType(false);
        type.add("Enchantment");
        type.add("Room");
        CardState ret = new CardState(c, state);
        ret.setName("");
        ret.setType(type);
        ret.setImageKey(c.getImageKey());
        return ret;
    }

    public static Set<String> getReflectableManaColors(SpellAbility sa) {
        return CardUtil.getReflectableManaColors(sa, sa, Sets.newHashSet(), new CardCollection());
    }

    private static Set<String> getReflectableManaColors(SpellAbility abMana, SpellAbility sa, Set<String> colors, CardCollection parents) {
        block17: {
            CardCollection cards;
            int maxChoices;
            String reflectProperty;
            block19: {
                block18: {
                    Card card = abMana.getHostCard();
                    if (abMana.getApi() != ApiType.ManaReflected) {
                        return colors;
                    }
                    String colorOrType = sa.getParam("ColorOrType");
                    reflectProperty = sa.getParam("ReflectProperty");
                    maxChoices = 5;
                    if (colorOrType.equals("Type")) {
                        ++maxChoices;
                    }
                    if (sa.hasParam("Valid")) {
                        String validCard = sa.getParam("Valid");
                        if (validCard.startsWith("Defined.")) {
                            cards = AbilityUtils.getDefinedCards(card, TextUtil.fastReplace(validCard, "Defined.", ""), abMana);
                        } else {
                            if (sa.getActivatingPlayer() == null) {
                                sa.setActivatingPlayer(sa.getHostCard().getController());
                            }
                            Player activator = sa.getActivatingPlayer();
                            cards = CardLists.getValidCards((Iterable<Card>)activator.getGame().getCardsIn(ZoneType.Battlefield), validCard, activator, card, (CardTraitBase)sa);
                        }
                        cards.removeAll(parents);
                        if (cards.isEmpty()) {
                            return colors;
                        }
                    } else {
                        cards = new CardCollection();
                    }
                    if (!reflectProperty.equals("Is")) break block18;
                    block0: for (Iterator card1 : cards) {
                        for (String col : MagicColor.Constant.ONLY_COLORS) {
                            if (!((Card)((Object)card1)).isOfColor(col)) continue;
                            colors.add(col);
                            if (colors.size() != maxChoices) continue;
                            continue block0;
                        }
                    }
                    break block17;
                }
                if (!reflectProperty.equals("Produced")) break block19;
                String producedColors = (String)abMana.getRootAbility().getTriggeringObject(AbilityKey.Produced);
                for (String col : MagicColor.Constant.ONLY_COLORS) {
                    String s2 = MagicColor.toShortString(col);
                    if (!producedColors.contains(s2)) continue;
                    colors.add(col);
                }
                if (maxChoices != 6 || !producedColors.contains("1") && !producedColors.contains("C")) break block17;
                colors.add("colorless");
                break block17;
            }
            if (reflectProperty.equals("Produce")) {
                FCollection<SpellAbility> abilities = new FCollection<SpellAbility>();
                for (Card c : cards) {
                    abilities.addAll(c.getManaAbilities());
                }
                ArrayList<SpellAbility> reflectAbilities = Lists.newArrayList();
                for (SpellAbility ab : abilities) {
                    if (maxChoices == colors.size()) break;
                    if (ab.getApi() == ApiType.ManaReflected) {
                        if (parents.contains(ab.getHostCard())) continue;
                        ab.setActivatingPlayer(ab.getHostCard().getController());
                        reflectAbilities.add(ab);
                        parents.add(ab.getHostCard());
                        continue;
                    }
                    colors = CardUtil.canProduce(maxChoices, ab, colors);
                    if (parents.contains(ab.getHostCard())) continue;
                    parents.add(ab.getHostCard());
                }
                for (SpellAbility ab : reflectAbilities) {
                    if (maxChoices != colors.size()) {
                        colors = CardUtil.getReflectableManaColors(sa, ab, colors, parents);
                        continue;
                    }
                    break;
                }
            }
        }
        return colors;
    }

    public static Set<String> canProduce(int maxChoices, SpellAbility sa, Set<String> colors) {
        if (sa == null) {
            return colors;
        }
        for (String col : MagicColor.Constant.ONLY_COLORS) {
            if (!sa.canProduce(MagicColor.toShortString(col))) continue;
            colors.add(col);
        }
        if (maxChoices == 6 && sa.canProduce("C")) {
            colors.add("colorless");
        }
        return colors;
    }

    public static List<Card> getValidCardsToTarget(SpellAbility ability) {
        TargetRestrictions tgt = ability.getTargetRestrictions();
        Card activatingCard = ability.getHostCard();
        Game game = ability.getActivatingPlayer().getGame();
        List<ZoneType> zone = tgt.getZone();
        CardCollection validCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(zone), tgt.getValidTgts(), ability.getActivatingPlayer(), activatingCard, (CardTraitBase)ability);
        CardCollection choices = CardLists.getTargetableCards(validCards, ability);
        boolean canTgtStack = zone.contains((Object)ZoneType.Stack);
        if (canTgtStack && activatingCard.isInZone(ZoneType.Stack)) {
            choices.remove(activatingCard);
        }
        ArrayList<Card> targeted = Lists.newArrayList(ability.getTargets().getTargetCards());
        choices.removeAll((Collection<?>)targeted);
        return choices;
    }
}

