/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardPredicates;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbilityCrewValue;
import forge.util.MyRandom;
import forge.util.collect.FCollectionView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CardLists {
    public static final Comparator<Card> ToughnessComparator = Comparator.comparingInt(Card::getNetToughness);
    public static final Comparator<Card> ToughnessComparatorInv = Comparator.comparingInt(Card::getNetToughness).reversed();
    public static final Comparator<Card> PowerComparator = Comparator.comparingInt(Card::getNetCombatDamage);
    public static final Comparator<Card> CmcComparatorInv = Comparator.comparingInt(Card::getCMC).reversed();
    public static final Comparator<Card> TextLenComparator = Comparator.comparingInt(a -> a.getView().getText().length());

    public static CardCollection filterToughness(Iterable<Card> in, int atLeastToughness) {
        return CardLists.filter(in, c -> c.getNetToughness() <= atLeastToughness);
    }

    public static CardCollection filterPower(Iterable<Card> in, int atLeastPower) {
        return CardLists.filter(in, c -> c.getNetPower() >= atLeastPower);
    }

    public static CardCollection filterLEPower(Iterable<Card> in, int lessthanPower) {
        return CardLists.filter(in, c -> c.getNetPower() <= lessthanPower);
    }

    public static void sortByCmcDesc(List<Card> list) {
        list.sort(CmcComparatorInv);
    }

    public static void sortByToughnessAsc(List<Card> list) {
        list.sort(ToughnessComparator);
    }

    public static void sortByToughnessDesc(List<Card> list) {
        list.sort(ToughnessComparatorInv);
    }

    public static void sortByPowerAsc(List<Card> list) {
        list.sort(PowerComparator);
    }

    public static void sortByPowerDesc(List<Card> list) {
        list.sort(Collections.reverseOrder(PowerComparator));
    }

    public static CardCollection getRandomSubList(List<Card> c, int amount) {
        if (c.size() < amount) {
            return null;
        }
        CardCollection cs = new CardCollection((Iterable<Card>)c);
        CardCollection subList = new CardCollection();
        while (subList.size() < amount) {
            CardLists.shuffle(cs);
            subList.add((Card)cs.remove(0));
        }
        return subList;
    }

    public static void shuffle(List<Card> list) {
        Collections.shuffle(list, MyRandom.getRandom());
    }

    public static CardCollection filterControlledBy(Iterable<Card> cardList, Player player) {
        return CardLists.filter(cardList, CardPredicates.isController(player));
    }

    public static CardCollection filterControlledBy(Iterable<Card> cardList, FCollectionView<Player> player) {
        return CardLists.filter(cardList, CardPredicates.isControlledByAnyOf(player));
    }

    public static List<Card> filterControlledByAsList(Iterable<Card> cardList, Player player) {
        return CardLists.filterAsList(cardList, CardPredicates.isController(player));
    }

    public static List<Card> filterControlledByAsList(Iterable<Card> cardList, FCollectionView<Player> player) {
        return CardLists.filterAsList(cardList, CardPredicates.isControlledByAnyOf(player));
    }

    public static CardCollection getValidCards(Iterable<Card> cardList, String[] restrictions, Player sourceController, Card source, CardTraitBase spellAbility) {
        return CardLists.filter(cardList, CardPredicates.restriction(restrictions, sourceController, source, spellAbility));
    }

    public static CardCollection getValidCards(Iterable<Card> cardList, String restriction, Player sourceController, Card source, CardTraitBase sa) {
        return CardLists.filter(cardList, CardPredicates.restriction(restriction.split(","), sourceController, source, sa));
    }

    public static List<Card> getValidCardsAsList(Iterable<Card> cardList, String restriction, Player sourceController, Card source, CardTraitBase sa) {
        return CardLists.filterAsList(cardList, CardPredicates.restriction(restriction.split(","), sourceController, source, sa));
    }

    public static int getValidCardCount(Iterable<Card> cardList, String restriction, Player sourceController, Card source, CardTraitBase sa) {
        return CardLists.count(cardList, CardPredicates.restriction(restriction.split(","), sourceController, source, sa));
    }

    public static CardCollection getTargetableCards(Iterable<Card> cardList, SpellAbility source) {
        CardCollection result = CardLists.filter(cardList, CardPredicates.isTargetableBy(source));
        if (source.getTargets().isEmpty() && source.usesTargeting() && source.getMinTargets() >= 2) {
            CardCollection removeList = new CardCollection();
            TargetRestrictions tr = source.getTargetRestrictions();
            for (Card card : result) {
                boolean found;
                if (tr.isSameController()) {
                    found = false;
                    for (Card card2 : result) {
                        if (card == card2 || card.getController() != card2.getController()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        removeList.add(card);
                    }
                }
                if (tr.isWithoutSameCreatureType()) {
                    found = false;
                    for (Card card2 : result) {
                        if (card == card2 || card.sharesCreatureTypeWith(card2)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        removeList.add(card);
                    }
                }
                if (tr.isWithSameCreatureType()) {
                    found = false;
                    for (Card card2 : result) {
                        if (card == card2 || !card.sharesCreatureTypeWith(card2)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        removeList.add(card);
                    }
                }
                if (!tr.isWithSameCardType()) continue;
                found = false;
                for (Card card2 : result) {
                    if (card == card2 || !card.sharesCardTypeWith(card2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removeList.add(card);
            }
            result.removeAll(removeList);
        }
        return result;
    }

    public static CardCollection getKeyword(Iterable<Card> cardList, String keyword) {
        return CardLists.filter(cardList, CardPredicates.hasKeyword(keyword));
    }

    public static CardCollection getKeyword(Iterable<Card> cardList, Keyword keyword) {
        return CardLists.filter(cardList, CardPredicates.hasKeyword(keyword));
    }

    public static CardCollection getNotKeyword(Iterable<Card> cardList, String keyword) {
        return CardLists.filter(cardList, Predicates.not(CardPredicates.hasKeyword(keyword)));
    }

    public static CardCollection getNotKeyword(Iterable<Card> cardList, Keyword keyword) {
        return CardLists.filter(cardList, Predicates.not(CardPredicates.hasKeyword(keyword)));
    }

    public static int getAmountOfKeyword(Iterable<Card> cardList, String keyword) {
        int nKeyword = 0;
        for (Card c : cardList) {
            nKeyword += c.getAmountOfKeyword(keyword);
        }
        return nKeyword;
    }

    public static int getAmountOfKeyword(Iterable<Card> cardList, Keyword keyword) {
        int nKeyword = 0;
        for (Card c : cardList) {
            nKeyword += c.getAmountOfKeyword(keyword);
        }
        return nKeyword;
    }

    public static CardCollection getNotType(Iterable<Card> cardList, String cardType) {
        return CardLists.filter(cardList, Predicates.not(CardPredicates.isType(cardType)));
    }

    public static CardCollection getType(Iterable<Card> cardList, String cardType) {
        return CardLists.filter(cardList, CardPredicates.isType(cardType));
    }

    public static CardCollection getNotColor(Iterable<Card> cardList, byte color) {
        return CardLists.filter(cardList, Predicates.not(CardPredicates.isColor(color)));
    }

    public static CardCollection getColor(Iterable<Card> cardList, byte color) {
        return CardLists.filter(cardList, CardPredicates.isColor(color));
    }

    public static CardCollection filter(Iterable<Card> cardList, Predicate<Card> filt) {
        return new CardCollection(Iterables.filter(cardList, filt));
    }

    public static CardCollection filter(Iterable<Card> cardList, Predicate<Card> f1, Predicate<Card> f2) {
        return new CardCollection(Iterables.filter(cardList, Predicates.and(f1, f2)));
    }

    public static CardCollection filter(Iterable<Card> cardList, Iterable<Predicate<Card>> filt) {
        return new CardCollection(Iterables.filter(cardList, Predicates.and(filt)));
    }

    public static List<Card> filterAsList(Iterable<Card> cardList, Predicate<Card> filt) {
        return Lists.newArrayList(Iterables.filter(cardList, filt));
    }

    public static List<Card> filterAsList(Iterable<Card> cardList, Predicate<Card> f1, Predicate<Card> f2) {
        return Lists.newArrayList(Iterables.filter(cardList, Predicates.and(f1, f2)));
    }

    public static List<Card> filterAsList(Iterable<Card> cardList, Iterable<Predicate<Card>> filt) {
        return Lists.newArrayList(Iterables.filter(cardList, Predicates.and(filt)));
    }

    public static int count(Iterable<Card> cardList, Predicate<Card> filt) {
        if (cardList == null) {
            return 0;
        }
        int count = 0;
        for (Card c : cardList) {
            if (!filt.apply(c)) continue;
            ++count;
        }
        return count;
    }

    public static CardCollection getCardsWithHighestCMC(Iterable<Card> cardList) {
        CardCollection tiedForHighest = new CardCollection();
        int highest = 0;
        for (Card crd : cardList) {
            int curCmc = crd.getCMC();
            if (curCmc > highest) {
                highest = curCmc;
                tiedForHighest.clear();
            }
            if (curCmc < highest) continue;
            tiedForHighest.add(crd);
        }
        return tiedForHighest;
    }

    public static CardCollection getCardsWithLowestCMC(Iterable<Card> cardList) {
        CardCollection tiedForLowest = new CardCollection();
        int lowest = 25;
        for (Card crd : cardList) {
            int curCmc = crd.getCMC();
            if (curCmc < lowest) {
                lowest = curCmc;
                tiedForLowest.clear();
            }
            if (curCmc > lowest) continue;
            tiedForLowest.add(crd);
        }
        return tiedForLowest;
    }

    public static int getTotalPower(Iterable<Card> cardList, boolean ignoreNegativePower, boolean crew) {
        int total = 0;
        for (Card crd : cardList) {
            if (crew) {
                if (StaticAbilityCrewValue.crewsWithToughness(crd)) {
                    total += ignoreNegativePower ? Math.max(0, crd.getNetToughness()) : crd.getNetToughness();
                    continue;
                }
                int m4 = StaticAbilityCrewValue.getCrewMod(crd);
                total += ignoreNegativePower ? Math.max(0, crd.getNetPower() + m4) : crd.getNetPower() + m4;
                continue;
            }
            total += ignoreNegativePower ? Math.max(0, crd.getNetPower()) : crd.getNetPower();
        }
        return total;
    }

    public static int getTotalCMC(Iterable<Card> cardList) {
        int total = 0;
        for (Card crd : cardList) {
            total += Math.max(0, crd.getCMC());
        }
        return total;
    }

    public static boolean cmcCanSumTo(int sum, Iterable<Card> cardList) {
        ArrayList<Integer> numList = Lists.newArrayList();
        for (Card c : cardList) {
            int num = c.getCMC();
            if (num == sum) {
                return true;
            }
            if (num >= sum) continue;
            numList.add(num);
        }
        if (numList.isEmpty()) {
            return false;
        }
        numList.sort(null);
        return CardLists.isSubsetSum(numList, sum);
    }

    public static boolean isSubsetSum(List<Integer> numList, int sum) {
        if (sum == 0) {
            return true;
        }
        int size = numList.size();
        if (size == 0) {
            return false;
        }
        Integer last = numList.get(size - 1);
        numList.remove(last);
        if (last > sum) {
            return CardLists.isSubsetSum(numList, sum);
        }
        return CardLists.isSubsetSum(numList, sum) || CardLists.isSubsetSum(numList, sum - last);
    }
}

