/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import forge.GameCommand;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.CardTypeView;
import forge.card.ColorSet;
import forge.card.ICardFace;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.IHasSVars;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardState;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.cost.CostCollectEvidence;
import forge.game.cost.CostExile;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.event.GameEventCardForetold;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.AbilityStatic;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.AlternativeCost;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.spellability.SpellPermanent;
import forge.game.spellability.TargetRestrictions;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityCantBeCast;
import forge.game.staticability.StaticAbilityPlotZone;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class CardFactoryUtil {
    public static SpellAbility abilityCastFaceDown(CardState cardState, boolean intrinsic, String key) {
        Spell morphDown = new Spell(cardState.getCard(), new Cost(ManaCost.THREE, false)){
            private static final long serialVersionUID = -1438810964807867610L;

            @Override
            public void resolve() {
                if (!this.hostCard.isCopiedSpell() && !this.hostCard.isFaceDown()) {
                    this.hostCard.setOriginalStateAsFaceDown();
                }
                Game game = this.hostCard.getGame();
                EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
                CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(params, this);
                this.hostCard.getGame().getAction().moveToPlay(this.hostCard, this, params);
                zoneMovements.triggerChangesZoneAll(game, this);
            }

            @Override
            public boolean canPlay() {
                if (this.hostCard.isInPlay()) {
                    return false;
                }
                CardStateName stateBackup = this.hostCard.getCurrentStateName();
                boolean face = this.hostCard.isFaceDown();
                this.hostCard.turnFaceDownNoUpdate();
                boolean success = super.canPlay();
                this.hostCard.setState(stateBackup, false);
                this.hostCard.setFaceDown(face);
                return success;
            }
        };
        morphDown.setCardState(cardState);
        morphDown.setDescription("(You may cast this card face down as a 2/2 creature for {3}.)");
        morphDown.setStackDescription(key + " - Creature 2/2");
        morphDown.setCastFaceDown(true);
        morphDown.setIntrinsic(intrinsic);
        return morphDown;
    }

    public static SpellAbility abilityUnlockRoom(CardState cardState) {
        String unlockStr = "ST$ UnlockDoor | Cost$ " + cardState.getManaCost().getShortString() + " | Unlock$ True | SpellDescription$ Unlock " + cardState.getName();
        return AbilityFactory.getAbility(unlockStr, cardState);
    }

    public static SpellAbility abilityMorphUp(CardState cardState, String costStr, boolean mega, boolean intrinsic) {
        Cost cost = new Cost(costStr, true);
        StringBuilder sbCost = new StringBuilder(mega ? "Megamorph" : "Morph");
        sbCost.append(" ");
        if (!cost.isOnlyManaCost()) {
            sbCost.append("\u2014 ");
        }
        sbCost.append(cost.toString());
        StringBuilder sb = new StringBuilder();
        sb.append("ST$ SetState | Cost$ ").append(costStr).append(" | CostDesc$ ").append((CharSequence)sbCost);
        sb.append(" | MorphUp$ True | Secondary$ True | IsPresent$ Card.Self+faceDown");
        if (mega) {
            sb.append(" | Mega$ True");
        }
        sb.append(" | Mode$ TurnFaceUp | SpellDescription$ (Turn this face up any time for its morph cost.)");
        SpellAbility morphUp = AbilityFactory.getAbility(sb.toString(), cardState);
        if (cost.hasXInAnyCostPart() && cardState.hasSVar("X")) {
            morphUp.setSVar("X", cardState.getSVar("X"));
        }
        StringBuilder sbStack = new StringBuilder();
        sbStack.append(cardState.getName()).append(" - turn this card face up.");
        morphUp.setStackDescription(sbStack.toString());
        morphUp.setIntrinsic(intrinsic);
        return morphUp;
    }

    public static SpellAbility abilityDisguiseUp(CardState cardState, String costStr, boolean intrinsic) {
        Cost cost = new Cost(costStr, true);
        StringBuilder sbCost = new StringBuilder("Disguise");
        sbCost.append(" ");
        if (!cost.isOnlyManaCost()) {
            sbCost.append("\u2014 ");
        }
        sbCost.append(cost.toString());
        StringBuilder sb = new StringBuilder();
        sb.append("ST$ SetState | Cost$ ").append(costStr).append(" | CostDesc$ ").append((CharSequence)sbCost);
        sb.append(" | DisguiseUp$ True | Secondary$ True | IsPresent$ Card.Self+faceDown");
        sb.append(" | Mode$ TurnFaceUp | SpellDescription$ (Turn this face up any time for its disguise cost.)");
        SpellAbility morphUp = AbilityFactory.getAbility(sb.toString(), cardState);
        if (cost.hasXInAnyCostPart() && cardState.hasSVar("X")) {
            morphUp.setSVar("X", cardState.getSVar("X"));
        }
        StringBuilder sbStack = new StringBuilder();
        sbStack.append(cardState.getName()).append(" - turn this card face up.");
        morphUp.setStackDescription(sbStack.toString());
        morphUp.setIntrinsic(intrinsic);
        return morphUp;
    }

    public static SpellAbility abilityTurnFaceUp(CardState sourceCard, String key, String desc) {
        ManaCost manaCost = sourceCard.getManaCost();
        String costDesc = manaCost.toString();
        StringBuilder sb = new StringBuilder();
        sb.append("ST$ SetState | Cost$ 0 | ").append("PrecostDesc$ ").append(desc).append(" | CostDesc$ ").append(costDesc);
        sb.append(" | ").append(key).append("$ True | Secondary$ True | Mode$ TurnFaceUp | SpellDescription$ (Turn this face up any time for its mana cost.)");
        SpellAbility manifestUp = AbilityFactory.getAbility(sb.toString(), sourceCard);
        manifestUp.setPayCosts(new Cost(manaCost, true));
        manifestUp.rebuiltDescription();
        StringBuilder sbStack = new StringBuilder();
        sbStack.append(sourceCard.getName()).append(" - turn this card face up.");
        manifestUp.setStackDescription(sbStack.toString());
        return manifestUp;
    }

    public static boolean handleHiddenAgenda(Player player, Card card) {
        SpellAbility.EmptySa sa = new SpellAbility.EmptySa(card);
        sa.putParam("AILogic", card.getSVar("AgendaLogic"));
        Predicate<ICardFace> cpp = Predicates.alwaysTrue();
        String name = player.getController().chooseCardName(sa, cpp, "Card", "Name a card for " + card.getName());
        if (name == null || name.isEmpty()) {
            return false;
        }
        card.addNamedCard(name);
        if (card.hasKeyword("Double agenda")) {
            String name2 = player.getController().chooseCardName(sa, cpp, "Card.!NamedCard", "Name a second card for " + card.getName());
            if (name2 == null || name2.isEmpty()) {
                return false;
            }
            card.addNamedCard(name2);
        }
        card.turnFaceDown();
        card.addMayLookAt(player.getGame().getNextTimestamp(), ImmutableList.of(player));
        card.addSpellAbility(CardFactoryUtil.abilityRevealHiddenAgenda(card));
        return true;
    }

    private static SpellAbility abilityRevealHiddenAgenda(Card sourceCard) {
        String ab = "ST$ SetState | Cost$ 0 | ConditionDefined$ Self | ConditionPresent$ Card.faceDown+inZoneCommand | HiddenAgenda$ True | Mode$ TurnFaceUp | SpellDescription$ Reveal this Hidden Agenda at any time.";
        return AbilityFactory.getAbility(ab, sourceCard);
    }

    public static String extractOperators(String expression) {
        String[] l = expression.split("/");
        return l.length > 1 ? l[1] : null;
    }

    public static byte getMostProminentColors(Iterable<Card> list) {
        int cntColors = MagicColor.WUBRG.length;
        Object[] map = new Integer[cntColors];
        Arrays.fill(map, (Object)0);
        for (Card crd : list) {
            ColorSet color = crd.getColor();
            for (int i = 0; i < cntColors; ++i) {
                if (!color.hasAnyColor(MagicColor.WUBRG[i])) continue;
                int n = i;
                Object object = map[n];
                map[n] = (Integer)map[n] + 1;
                Integer n2 = map[n];
            }
        }
        byte mask = 0;
        int nMax = -1;
        for (int i = 0; i < cntColors; ++i) {
            if ((Integer)map[i] > nMax) {
                mask = MagicColor.WUBRG[i];
            } else {
                if ((Integer)map[i] != nMax) continue;
                mask = (byte)(mask | MagicColor.WUBRG[i]);
            }
            nMax = (Integer)map[i];
        }
        return mask;
    }

    public static int[] SortColorsFromList(CardCollection list) {
        int cntColors = MagicColor.WUBRG.length;
        int[] map = new int[cntColors];
        for (Card crd : list) {
            ColorSet color = crd.getColor();
            for (int i = 0; i < cntColors; ++i) {
                if (!color.hasAnyColor(MagicColor.WUBRG[i])) continue;
                int n = i;
                map[n] = map[n] + 1;
            }
        }
        Arrays.sort(map);
        return map;
    }

    public static byte getMostProminentColorsFromList(CardCollectionView list, List<String> restrictedToColors) {
        ArrayList<Byte> colorRestrictions = Lists.newArrayList();
        for (String col : restrictedToColors) {
            colorRestrictions.add(MagicColor.fromName(col));
        }
        int cntColors = colorRestrictions.size();
        int[] map = new int[cntColors];
        for (Card crd : list) {
            ColorSet color = crd.getColor();
            for (int i = 0; i < cntColors; ++i) {
                if (!color.hasAnyColor(((Byte)colorRestrictions.get(i)).byteValue())) continue;
                int n = i;
                map[n] = map[n] + 1;
            }
        }
        byte mask = 0;
        int nMax = -1;
        for (int i = 0; i < cntColors; ++i) {
            if (map[i] > nMax) {
                mask = (Byte)colorRestrictions.get(i);
            } else {
                if (map[i] != nMax) continue;
                mask = (byte)(mask | (Byte)colorRestrictions.get(i));
            }
            nMax = map[i];
        }
        return mask;
    }

    public static int getMostProminentCreatureTypeSize(CardCollection list) {
        if (list.isEmpty()) {
            return 0;
        }
        int allCreatureType = 0;
        HashMap<String, Integer> map = Maps.newHashMap();
        for (Card c : list) {
            CardTypeView type = c.getType();
            if (type.hasAllCreatureTypes() && Iterables.isEmpty(type.getExcludedCreatureSubTypes())) {
                ++allCreatureType;
                continue;
            }
            Iterator<String> iterator = type.getCreatureTypes().iterator();
            while (iterator.hasNext()) {
                String creatureType;
                Integer count = (Integer)map.get(creatureType = iterator.next());
                map.put(creatureType, count == null ? 1 : count + 1);
            }
        }
        int max = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (max >= (Integer)entry.getValue()) continue;
            max = (Integer)entry.getValue();
        }
        return max + allCreatureType;
    }

    public static Iterable<String> getMostProminentCreatureType(CardCollectionView list) {
        if (list.isEmpty()) {
            return ImmutableList.of();
        }
        HashMap<String, Integer> map = Maps.newHashMap();
        for (Object c : list) {
            Iterator<String> iterator = ((Card)c).getType().getCreatureTypes().iterator();
            while (iterator.hasNext()) {
                String string;
                Integer count = (Integer)map.get(string = iterator.next());
                map.put(string, count == null ? 1 : count + 1);
            }
        }
        int max = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (max >= (Integer)entry.getValue()) continue;
            max = (Integer)entry.getValue();
        }
        if (max == 0) {
            return ImmutableList.of();
        }
        ArrayList<String> result = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            if (max != (Integer)entry.getValue()) continue;
            result.add((String)entry.getKey());
        }
        return result;
    }

    public static List<String> sharedKeywords(Iterable<String> kw, String[] restrictions, Iterable<ZoneType> zones, Card host, CardTraitBase ctb) {
        Player p = null;
        if (ctb instanceof SpellAbility) {
            p = ((SpellAbility)ctb).getActivatingPlayer();
        }
        if (p == null) {
            p = host.getController();
        }
        CardCollectionView cardlist = p.getGame().getCardsIn(zones);
        return CardFactoryUtil.getSharedKeywords(kw, CardLists.getValidCards((Iterable<Card>)cardlist, restrictions, p, host, ctb));
    }

    public static List<String> getSharedKeywords(Iterable<String> kw, CardCollection cards) {
        ArrayList<String> filteredkw = Lists.newArrayList();
        HashSet<String> landkw = Sets.newHashSet();
        HashSet<String> protectionkw = Sets.newHashSet();
        HashSet<String> protectionColorkw = Sets.newHashSet();
        HashSet<String> hexproofkw = Sets.newHashSet();
        HashSet<String> tramplekw = Sets.newHashSet();
        HashSet<String> allkw = Sets.newHashSet();
        for (Card c : cards) {
            for (KeywordInterface inst : c.getKeywords()) {
                String k = inst.getOriginal();
                if (inst.getKeyword().equals((Object)Keyword.LANDWALK)) {
                    landkw.add(k);
                    continue;
                }
                if (inst.getKeyword().equals((Object)Keyword.PROTECTION)) {
                    protectionkw.add(k);
                    for (byte col : MagicColor.WUBRG) {
                        String colString = MagicColor.toLongString(col);
                        String protString = "Protection from " + colString;
                        if (!k.equals(protString) && !k.contains(StringUtils.capitalize(colString) + ":" + colString)) continue;
                        protectionColorkw.add(protString);
                    }
                    continue;
                }
                if (inst.getKeyword().equals((Object)Keyword.HEXPROOF)) {
                    hexproofkw.add(k);
                    continue;
                }
                if (inst.getKeyword().equals((Object)Keyword.TRAMPLE)) {
                    tramplekw.add(k);
                    continue;
                }
                allkw.add(k.toLowerCase());
            }
        }
        for (String keyword : kw) {
            if (keyword.equals("Protection")) {
                filteredkw.addAll(protectionkw);
                continue;
            }
            if (keyword.equals("ProtectionColor")) {
                filteredkw.addAll(protectionColorkw);
                continue;
            }
            if (keyword.equals("Landwalk")) {
                filteredkw.addAll(landkw);
                continue;
            }
            if (keyword.equals("Hexproof")) {
                filteredkw.addAll(hexproofkw);
                continue;
            }
            if (keyword.equals("Trample")) {
                filteredkw.addAll(tramplekw);
                continue;
            }
            if (!allkw.contains(keyword.toLowerCase())) continue;
            filteredkw.add(keyword);
        }
        return filteredkw;
    }

    public static int getCardTypesFromList(CardCollectionView list) {
        EnumSet<CardType.CoreType> types = EnumSet.noneOf(CardType.CoreType.class);
        for (Card c1 : list) {
            Iterables.addAll(types, c1.getType().getCoreTypes());
        }
        return types.size();
    }

    public static final void addAbilityFactoryAbilities(Card card, Iterable<String> abilities) {
        for (String rawAbility : abilities) {
            try {
                SpellAbility intrinsicAbility = AbilityFactory.getAbility(rawAbility, card);
                card.addSpellAbility(intrinsicAbility);
                intrinsicAbility.setIntrinsic(true);
                intrinsicAbility.setCardState(card.getCurrentState());
            }
            catch (Exception e) {
                String msg = "CardFactoryUtil:addAbilityFactoryAbilities: crash in raw Ability";
                Breadcrumb bread = new Breadcrumb(msg);
                bread.setData("Card", card.getName());
                bread.setData("Ability", rawAbility);
                Sentry.addBreadcrumb(bread);
                throw new RuntimeException("crash in raw Ability, check card script of " + card.getName(), e);
            }
        }
    }

    public static void setupKeywordedAbilities(Card card) {
        for (KeywordInterface inst : card.getKeywords()) {
            inst.createTraits(card, true);
        }
    }

    private static ReplacementEffect createETBReplacement(CardState card, ReplacementLayer layer, String effect, boolean optional, boolean secondary, boolean intrinsic, String valid, String zone) {
        SpellAbility repAb = AbilityFactory.getAbility(effect, card);
        return CardFactoryUtil.createETBReplacement(card, layer, repAb, optional, secondary, intrinsic, valid, zone);
    }

    private static ReplacementEffect createETBReplacement(CardState card, ReplacementLayer layer, SpellAbility repAb, boolean optional, boolean secondary, boolean intrinsic, String valid, String zone) {
        Card host = card.getCard();
        String desc = repAb.getDescription();
        if (!intrinsic) {
            repAb.setIntrinsic(false);
        }
        StringBuilder repEffsb = new StringBuilder();
        repEffsb.append("Event$ Moved | ValidCard$ ").append(valid);
        repEffsb.append(" | Destination$ Battlefield | ReplacementResult$ Updated | Description$ ").append(desc);
        if (optional) {
            repEffsb.append(" | Optional$ True");
        }
        if (secondary) {
            repEffsb.append(" | Secondary$ True");
        }
        if (!zone.isEmpty()) {
            repEffsb.append(" | ActiveZones$ ").append(zone);
        }
        ReplacementEffect re = ReplacementHandler.parseReplacement(repEffsb.toString(), host, intrinsic, (IHasSVars)card);
        re.setLayer(layer);
        re.setOverridingAbility(repAb);
        return re;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getProtectionValid(String kw, boolean damage) {
        String validSource;
        block18: {
            validSource = "";
            if (kw.startsWith("Protection:")) {
                String[] kws = kw.split(":");
                String characteristic = kws[1];
                if (characteristic.startsWith("Player")) {
                    validSource = "ControlledBy " + characteristic;
                    break block18;
                } else {
                    if (!damage) return characteristic;
                    if (characteristic.endsWith("White")) return characteristic + "Source";
                    if (characteristic.endsWith("Blue")) return characteristic + "Source";
                    if (characteristic.endsWith("Black")) return characteristic + "Source";
                    if (characteristic.endsWith("Red")) return characteristic + "Source";
                    if (characteristic.endsWith("Green")) return characteristic + "Source";
                    if (characteristic.endsWith("Colorless")) return characteristic + "Source";
                    if (characteristic.endsWith("MonoColor")) return characteristic + "Source";
                    if (characteristic.endsWith("MultiColor")) return characteristic + "Source";
                    if (!characteristic.endsWith("EnemyColor")) return characteristic;
                    return characteristic + "Source";
                }
            }
            if (kw.startsWith("Protection from ")) {
                String protectType = kw.substring("Protection from ".length());
                if (protectType.equals("white")) {
                    validSource = "White" + (damage ? "Source" : "");
                } else if (protectType.equals("blue")) {
                    validSource = "Blue" + (damage ? "Source" : "");
                } else if (protectType.equals("black")) {
                    validSource = "Black" + (damage ? "Source" : "");
                } else if (protectType.equals("red")) {
                    validSource = "Red" + (damage ? "Source" : "");
                } else if (protectType.equals("green")) {
                    validSource = "Green" + (damage ? "Source" : "");
                } else if (protectType.equals("colorless")) {
                    validSource = "Colorless" + (damage ? "Source" : "");
                } else if (protectType.equals("each color")) {
                    validSource = "nonColorless" + (damage ? "Source" : "");
                } else {
                    if (!protectType.equals("everything")) throw new RuntimeException("unknown protection keyword: " + kw);
                    return "";
                }
            }
        }
        if (!validSource.isEmpty()) return "Card." + validSource + ",Emblem." + validSource;
        return validSource;
    }

    public static ReplacementEffect makeEtbCounter(String kw, CardState card, boolean intrinsic) {
        String parse = kw;
        String[] splitkw = parse.split(":");
        String desc = "CARDNAME enters with ";
        desc = desc + Lang.nounWithNumeralExceptOne(splitkw[2], CounterType.getType(splitkw[1]).getName().toLowerCase() + " counter");
        desc = desc + " on it.";
        String extraparams = "";
        String amount = splitkw[2];
        if (splitkw.length > 3 && !splitkw[3].equals("no Condition")) {
            extraparams = splitkw[3];
        }
        if (splitkw.length > 4) {
            desc = !splitkw[4].equals("no desc") ? splitkw[4] : "";
        }
        String abStr = "DB$ PutCounter | Defined$ Self | CounterType$ " + splitkw[1] + " | ETB$ True | CounterNum$ " + amount;
        if (splitkw[1].startsWith("EACH")) {
            abStr = abStr.replace("CounterType$ EACH ", "CounterTypes$ ");
        }
        SpellAbility sa = AbilityFactory.getAbility(abStr, card);
        if (!intrinsic) {
            sa.setIntrinsic(false);
        }
        String repeffstr = "Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield | Secondary$ True | ReplacementResult$ Updated | Description$ " + desc + (!extraparams.isEmpty() ? " | " + extraparams : "");
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, card.getCard(), intrinsic, (IHasSVars)card);
        re.setOverridingAbility(sa);
        return re;
    }

    public static void addTriggerAbility(KeywordInterface inst, Card card, boolean intrinsic) {
        String keyword = inst.getOriginal();
        if (keyword.startsWith("Afflict")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String trigStr = "Mode$ AttackerBlocked | ValidCard$ Card.Self | TriggerZones$ Battlefield  | ValidBlocker$ Creature | Secondary$ True  | TriggerDescription$ Afflict " + n + " (" + inst.getReminderText() + ")";
            String abStringAfflict = "DB$ LoseLife | Defined$ TriggeredDefendingPlayer | LifeAmount$ " + n;
            Trigger afflictTrigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic, null);
            afflictTrigger.setOverridingAbility(AbilityFactory.getAbility(abStringAfflict, card));
            inst.addTrigger(afflictTrigger);
        } else if (keyword.startsWith("Afterlife")) {
            Object[] k = keyword.split(":");
            String name = StringUtils.join(k, " ");
            StringBuilder sb = new StringBuilder();
            sb.append("Mode$ ChangesZone | Origin$ Battlefield | Destination$ Graveyard | ValidCard$ Card.Self ");
            sb.append("| Secondary$ True | TriggerDescription$ ").append(name);
            sb.append(" (").append(inst.getReminderText()).append(")");
            String effect = "DB$ Token | TokenAmount$ " + (String)k[1] + " | TokenScript$ wb_1_1_spirit_flying";
            Trigger trigger = TriggerHandler.parseTrigger(sb.toString(), card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Annihilator")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String trig = "Mode$ Attacks | ValidCard$ Card.Self | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Annihilator " + n + " (" + inst.getReminderText() + ")";
            String effect = "DB$ Sacrifice | Defined$ TriggeredDefendingPlayer | SacValid$ Permanent | Amount$ " + k[1];
            Trigger trigger = TriggerHandler.parseTrigger(trig, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Ascend")) {
            if (card.isPermanent() || card.isPlane()) {
                String trig = "Mode$ Always | TriggerZones$ " + (card.isPlane() ? "Command" : "Battlefield") + " | Secondary$ True | Static$ True | Blessing$ False | IsPresent$ Permanent.YouCtrl | PresentCompare$ GE10 | TriggerDescription$ Ascend (" + inst.getReminderText() + ")";
                String effect = "DB$ Ascend | Defined$ You";
                Trigger trigger = TriggerHandler.parseTrigger(trig, card, intrinsic);
                trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Ascend | Defined$ You", card));
                inst.addTrigger(trigger);
            }
        } else if (keyword.startsWith("Backup")) {
            String[] k = keyword.split(":");
            String magnitude = k[1];
            String backupVar = card.getSVar(k[2]);
            String descStr = "Backup " + magnitude;
            String trigStr = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ " + descStr;
            String putCounter = "DB$ PutCounter | ValidTgts$ Creature | CounterNum$ " + magnitude + " | CounterType$ P1P1";
            String addAbility = backupVar + " | ConditionDefined$ Targeted | ConditionPresent$ Card.Other | Defined$ Targeted";
            SpellAbility sa = AbilityFactory.getAbility(putCounter, card);
            AbilitySub backupSub = (AbilitySub)AbilityFactory.getAbility(addAbility, card);
            sa.setSubAbility(backupSub);
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            sa.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.equals("Battle cry")) {
            String trig = "Mode$ Attacks | ValidCard$ Card.Self | TriggerZones$ Battlefield | Secondary$ True  | TriggerDescription$ " + keyword + " (" + inst.getReminderText() + ")";
            String pumpStr = "DB$ PumpAll | ValidCards$ Creature.attacking+Other | NumAtt$ 1";
            SpellAbility sa = AbilityFactory.getAbility(pumpStr, card);
            sa.setIntrinsic(intrinsic);
            Trigger trigger = TriggerHandler.parseTrigger(trig, card, intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Bushido")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String trigBlock = "Mode$ Blocks | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ Bushido " + n + " (" + inst.getReminderText() + ")";
            String trigBlocked = "Mode$ AttackerBlocked | ValidCard$ Card.Self | Secondary$ True  | TriggerDescription$ Bushido " + n + " (" + inst.getReminderText() + ")";
            String pumpStr = "DB$ Pump | Defined$ Self | NumAtt$ " + n + " | NumDef$ " + n;
            SpellAbility pump = AbilityFactory.getAbility(pumpStr, card);
            Trigger bushidoTrigger1 = TriggerHandler.parseTrigger(trigBlock, card, intrinsic);
            Trigger bushidoTrigger2 = TriggerHandler.parseTrigger(trigBlocked, card, intrinsic);
            bushidoTrigger1.setOverridingAbility(pump);
            bushidoTrigger2.setOverridingAbility(pump);
            inst.addTrigger(bushidoTrigger1);
            inst.addTrigger(bushidoTrigger2);
        } else if (keyword.equals("Cascade")) {
            StringBuilder trigScript = new StringBuilder("Mode$ SpellCast | ValidCard$ Card.Self | TriggerZones$ Stack | Secondary$ True | TriggerDescription$ Cascade - CARDNAME");
            String abString = "DB$ DigUntil | Defined$ You | Amount$ 1 | Valid$ Card.nonLand+cmcLTCascadeX | FoundDestination$ Exile | RevealedDestination$ Exile | ImprintFound$ True | RememberRevealed$ True";
            SpellAbility dig = AbilityFactory.getAbility("DB$ DigUntil | Defined$ You | Amount$ 1 | Valid$ Card.nonLand+cmcLTCascadeX | FoundDestination$ Exile | RevealedDestination$ Exile | ImprintFound$ True | RememberRevealed$ True", card);
            dig.setSVar("CascadeX", "Count$CardManaCost");
            String dbLandPut = "DB$ ChangeZone | ConditionCheckSVar$ X | ConditionSVarCompare$ GE1 | Hidden$ True | Origin$ Exile | Destination$ Battlefield | ChangeType$ Land.IsRemembered | ChangeNum$ X | Tapped$ True | ForgetChanged$ True | SelectPrompt$ You may select a land to put on the battlefield tapped";
            AbilitySub landPut = (AbilitySub)AbilityFactory.getAbility("DB$ ChangeZone | ConditionCheckSVar$ X | ConditionSVarCompare$ GE1 | Hidden$ True | Origin$ Exile | Destination$ Battlefield | ChangeType$ Land.IsRemembered | ChangeNum$ X | Tapped$ True | ForgetChanged$ True | SelectPrompt$ You may select a land to put on the battlefield tapped", card);
            landPut.setSVar("X", "Count$Averna");
            dig.setSubAbility(landPut);
            String dbCascadeCast = "DB$ Play | Defined$ Imprinted | WithoutManaCost$ True | Optional$ True | ValidSA$ Spell.cmcLTCascadeX";
            AbilitySub cascadeCast = (AbilitySub)AbilityFactory.getAbility("DB$ Play | Defined$ Imprinted | WithoutManaCost$ True | Optional$ True | ValidSA$ Spell.cmcLTCascadeX", card);
            cascadeCast.setSVar("CascadeX", "Count$CardManaCost");
            landPut.setSubAbility(cascadeCast);
            String dbMoveToLib = "DB$ ChangeZoneAll | ChangeType$ Card.IsRemembered,Card.IsImprinted | Origin$ Exile | Destination$ Library | RandomOrder$ True | LibraryPosition$ -1";
            AbilitySub moveToLib = (AbilitySub)AbilityFactory.getAbility("DB$ ChangeZoneAll | ChangeType$ Card.IsRemembered,Card.IsImprinted | Origin$ Exile | Destination$ Library | RandomOrder$ True | LibraryPosition$ -1", card);
            cascadeCast.setSubAbility(moveToLib);
            String cascadeCleanup = "DB$ Cleanup | ClearRemembered$ True | ClearImprinted$ True";
            AbilitySub cleanup = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True | ClearImprinted$ True", card);
            moveToLib.setSubAbility(cleanup);
            dig.setIntrinsic(intrinsic);
            Trigger cascadeTrigger = TriggerHandler.parseTrigger(trigScript.toString(), card, intrinsic);
            cascadeTrigger.setOverridingAbility(dig);
            inst.addTrigger(cascadeTrigger);
        } else if (keyword.startsWith("Champion")) {
            String article;
            String[] k = keyword.split(":");
            String[] valid = k[1].split(",");
            String desc = Lang.joinHomogenous(Lists.newArrayList(valid), null, "or");
            String string = article = Lang.startsWithVowel(desc) ? "an" : "a";
            if (desc.equals("Creature")) {
                desc = "creature";
            }
            StringBuilder changeType = new StringBuilder();
            for (String v : valid) {
                if (changeType.length() != 0) {
                    changeType.append(",");
                }
                changeType.append(v).append(".YouCtrl+Other");
            }
            StringBuilder trig = new StringBuilder();
            trig.append("Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self");
            trig.append(" | TriggerDescription$ Champion ").append(article).append(" ").append(desc);
            trig.append(" (").append(Keyword.getInstance("Champion:" + desc).getReminderText()).append(")");
            StringBuilder trigReturn = new StringBuilder();
            trigReturn.append("Mode$ ChangesZone | Origin$ Battlefield | ValidCard$ Card.Self");
            trigReturn.append(" | Secondary$ True | TriggerDescription$ When this permanent leaves the battlefield, return the exiled card to the battlefield under its owner's control.");
            StringBuilder ab = new StringBuilder();
            ab.append("DB$ ChangeZone | Origin$ Battlefield | Destination$ Exile | RememberChanged$ True ");
            ab.append(" | Champion$ True | Hidden$ True | Optional$ True | ChangeType$ ").append((CharSequence)changeType);
            StringBuilder subAb = new StringBuilder();
            subAb.append("DB$ Sacrifice | ConditionDefined$ Remembered | ConditionPresent$ Card | ConditionCompare$ EQ0");
            String returnChampion = "DB$ ChangeZone | Defined$ Remembered | Origin$ Exile | Destination$ Battlefield";
            Trigger parsedTrigger = TriggerHandler.parseTrigger(trig.toString(), card, intrinsic);
            Trigger parsedTrigReturn = TriggerHandler.parseTrigger(trigReturn.toString(), card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility(ab.toString(), card);
            AbilitySub sub = (AbilitySub)AbilityFactory.getAbility(subAb.toString(), card);
            sa.setSubAbility(sub);
            sa.setIntrinsic(intrinsic);
            parsedTrigger.setOverridingAbility(sa);
            SpellAbility saReturn = AbilityFactory.getAbility(returnChampion, card);
            sub = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            saReturn.setSubAbility(sub);
            saReturn.setIntrinsic(intrinsic);
            parsedTrigReturn.setOverridingAbility(saReturn);
            inst.addTrigger(parsedTrigger);
            inst.addTrigger(parsedTrigReturn);
        } else if (keyword.startsWith("Casualty")) {
            String trigScript = "Mode$ SpellCast | ValidCard$ Card.Self | TriggerZones$ Stack | CheckSVar$ CasualtyPaid | Secondary$ True";
            String abString = "DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | MayChooseTarget$ True";
            String[] k = keyword.split(":");
            if (k.length > 2) {
                abString = abString + " | " + k[2];
            }
            Trigger casualtyTrigger = TriggerHandler.parseTrigger("Mode$ SpellCast | ValidCard$ Card.Self | TriggerZones$ Stack | CheckSVar$ CasualtyPaid | Secondary$ True", card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility(abString, card);
            sa.setSVar("CasualtyPaid", "Count$hasOptionalKeywordAmount");
            sa.setSVar("Casualty", "Count$OptionalKeywordAmount");
            casualtyTrigger.setOverridingAbility(sa);
            casualtyTrigger.setSVar("CasualtyPaid", "Count$hasOptionalKeywordAmount");
            casualtyTrigger.setSVar("Casualty", "Count$OptionalKeywordAmount");
            inst.addTrigger(casualtyTrigger);
        } else if (keyword.startsWith("Chapter")) {
            String[] k = keyword.split(":");
            String[] abs = k[2].split(",");
            if (abs.length != Integer.parseInt(k[1])) {
                throw new RuntimeException("Saga max differ from Ability amount");
            }
            Map result = IntStream.rangeClosed(1, abs.length).boxed().collect(Collectors.groupingBy(i -> abs[i - 1], LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry e : result.entrySet()) {
                String desc = ((List)e.getValue()).stream().map(TextUtil::toRoman).collect(Collectors.joining(", "));
                boolean secondary = false;
                for (Integer i2 : (List)e.getValue()) {
                    SpellAbility sa = AbilityFactory.getAbility(card, (String)e.getKey());
                    StringBuilder trigStr = new StringBuilder("Mode$ CounterAdded | ValidCard$ Card.Self | TriggerZones$ Battlefield");
                    trigStr.append("| Chapter$ ").append(i2).append(" | CounterType$ LORE | CounterAmount$ EQ").append(i2);
                    if (secondary) {
                        trigStr.append(" | Secondary$ True");
                    }
                    trigStr.append("| TriggerDescription$ ").append(desc).append(" \u2014 ").append(sa.getDescription());
                    Trigger t2 = TriggerHandler.parseTrigger(trigStr.toString(), card, intrinsic);
                    t2.setOverridingAbility(sa);
                    inst.addTrigger(t2);
                    secondary = true;
                }
            }
        } else if (keyword.equals("Conspire")) {
            String trigScript = "Mode$ SpellCast | ValidCard$ Card.Self | CheckSVar$ Conspire | TriggerZones$ Stack | Secondary$ True | TriggerDescription$ Copy CARDNAME if its conspire cost was paid";
            String abString = "DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | Amount$ 1 | MayChooseTarget$ True";
            Trigger conspireTrigger = TriggerHandler.parseTrigger("Mode$ SpellCast | ValidCard$ Card.Self | CheckSVar$ Conspire | TriggerZones$ Stack | Secondary$ True | TriggerDescription$ Copy CARDNAME if its conspire cost was paid", card, intrinsic);
            conspireTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | Amount$ 1 | MayChooseTarget$ True", card));
            conspireTrigger.setSVar("Conspire", "Count$OptionalKeywordAmount");
            inst.addTrigger(conspireTrigger);
        } else if (keyword.startsWith("Cumulative upkeep")) {
            String[] k = keyword.split(":");
            Cost cost = new Cost(k[1], false);
            String costDesc = cost.toSimpleString();
            if (!cost.isOnlyManaCost()) {
                costDesc = "\u2014" + costDesc;
            }
            String upkeepTrig = "Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | TriggerZones$ Battlefield  | IsPresent$ Card.Self | Secondary$ True | TriggerDescription$ " + k[0] + " " + costDesc + " (" + inst.getReminderText() + ")";
            String effect = "DB$ Sacrifice | SacValid$ Self | CumulativeUpkeep$ " + k[1];
            Trigger trigger = TriggerHandler.parseTrigger(upkeepTrig, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Daybound")) {
            String setDayTrig = "Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Neither | Secondary$ True | TriggerDescription$ Any time a player controls a permanent with daybound, if it's neither day nor night, it becomes day.";
            String setDayEff = "DB$ DayTime | Value$ Day";
            Trigger trigger = TriggerHandler.parseTrigger("Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Neither | Secondary$ True | TriggerDescription$ Any time a player controls a permanent with daybound, if it's neither day nor night, it becomes day.", card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(setDayEff, card));
            inst.addTrigger(trigger);
            String transformTrig = "Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Night | IsPresent$ Card.Self+FrontSide | Secondary$ True | TriggerDescription$ As it becomes night, if this permanent is front face up, transform it.";
            String transformEff = "DB$ SetState | Mode$ Transform";
            trigger = TriggerHandler.parseTrigger("Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Night | IsPresent$ Card.Self+FrontSide | Secondary$ True | TriggerDescription$ As it becomes night, if this permanent is front face up, transform it.", card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(transformEff, card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Decayed")) {
            String attackTrig = "Mode$ Attacks | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ When a creature with decayed attacks, sacrifice it at end of combat.";
            String delayTrigStg = "DB$ DelayedTrigger | Mode$ Phase | Phase$ EndCombat | ValidPlayer$ Player | TriggerDescription$ At end of combat, sacrifice CARDNAME.";
            String trigSacStg = "DB$ Sacrifice";
            SpellAbility delayTrigSA = AbilityFactory.getAbility("DB$ DelayedTrigger | Mode$ Phase | Phase$ EndCombat | ValidPlayer$ Player | TriggerDescription$ At end of combat, sacrifice CARDNAME.", card);
            AbilitySub sacSA = (AbilitySub)AbilityFactory.getAbility("DB$ Sacrifice", card);
            delayTrigSA.setAdditionalAbility("Execute", sacSA);
            Trigger parsedTrigger = TriggerHandler.parseTrigger("Mode$ Attacks | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ When a creature with decayed attacks, sacrifice it at end of combat.", card, intrinsic);
            delayTrigSA.setIntrinsic(intrinsic);
            parsedTrigger.setOverridingAbility(delayTrigSA);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Demonstrate")) {
            String trigScript = "Mode$ SpellCast | ValidCard$ Card.Self | TriggerZones$ Stack | TriggerDescription$ Demonstrate (" + inst.getReminderText() + ")";
            String youCopyStr = "DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | MayChooseTarget$ True | Optional$ True | RememberCopies$ True | IgnoreFreeze$ True";
            String chooseOppStr = "DB$ ChoosePlayer | Defined$ You | Choices$ Player.Opponent | ConditionDefined$ Remembered | ConditionPresent$ Spell";
            String oppCopyStr = "DB$ CopySpellAbility | Controller$ ChosenPlayer | Defined$ TriggeredSpellAbility | MayChooseTarget$ True | ConditionDefined$ Remembered | ConditionPresent$ Spell";
            String cleanupStr = "DB$ Cleanup | ClearRemembered$ True | ClearChosenPlayer$ True";
            Trigger trigger = TriggerHandler.parseTrigger(trigScript, card, intrinsic);
            SpellAbility youCopy = AbilityFactory.getAbility("DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | MayChooseTarget$ True | Optional$ True | RememberCopies$ True | IgnoreFreeze$ True", card);
            AbilitySub chooseOpp = (AbilitySub)AbilityFactory.getAbility("DB$ ChoosePlayer | Defined$ You | Choices$ Player.Opponent | ConditionDefined$ Remembered | ConditionPresent$ Spell", card);
            AbilitySub oppCopy = (AbilitySub)AbilityFactory.getAbility("DB$ CopySpellAbility | Controller$ ChosenPlayer | Defined$ TriggeredSpellAbility | MayChooseTarget$ True | ConditionDefined$ Remembered | ConditionPresent$ Spell", card);
            AbilitySub cleanup = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True | ClearChosenPlayer$ True", card);
            oppCopy.setSubAbility(cleanup);
            chooseOpp.setSubAbility(oppCopy);
            youCopy.setSubAbility(chooseOpp);
            trigger.setOverridingAbility(youCopy);
            inst.addTrigger(trigger);
        } else if (keyword.equals("Dethrone")) {
            StringBuilder trigScript = new StringBuilder("Mode$ Attacks | ValidCard$ Card.Self | Attacked$ Player.withMostLife | Secondary$ True | TriggerZones$ Battlefield | TriggerDescription$ Dethrone (" + inst.getReminderText() + ")");
            String abString = "DB$ PutCounter | Defined$ Self | CounterType$ P1P1 | CounterNum$ 1";
            Trigger dethroneTrigger = TriggerHandler.parseTrigger(trigScript.toString(), card, intrinsic);
            dethroneTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ PutCounter | Defined$ Self | CounterType$ P1P1 | CounterNum$ 1", card));
            inst.addTrigger(dethroneTrigger);
        } else if (keyword.equals("Double team")) {
            String trigString = "Mode$ Attacks | ValidCard$ Card.Self+nonToken | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Double team (" + inst.getReminderText() + ")";
            String maSt = "DB$ MakeCard | DefinedName$ Self | Zone$ Hand | RememberMade$ True | Conjure$ True";
            String puSt = "DB$ Pump | RememberObjects$ Self";
            String anSt = "DB$ Animate | Duration$ Perpetual | Defined$ Remembered | RemoveKeywords$ Double team";
            String clSt = "DB$ Cleanup | ClearRemembered$ True";
            Trigger trigger = TriggerHandler.parseTrigger(trigString, card, intrinsic);
            SpellAbility trigMake = AbilityFactory.getAbility("DB$ MakeCard | DefinedName$ Self | Zone$ Hand | RememberMade$ True | Conjure$ True", card);
            AbilitySub pump = (AbilitySub)AbilityFactory.getAbility("DB$ Pump | RememberObjects$ Self", card);
            AbilitySub remove = (AbilitySub)AbilityFactory.getAbility("DB$ Animate | Duration$ Perpetual | Defined$ Remembered | RemoveKeywords$ Double team", card);
            AbilitySub cleanup = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            trigMake.setSubAbility(pump);
            pump.setSubAbility(remove);
            remove.setSubAbility(cleanup);
            trigger.setOverridingAbility(trigMake);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Echo")) {
            String[] k = keyword.split(":");
            String cost = k[1];
            String upkeepTrig = "Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | TriggerZones$ Battlefield  | IsPresent$ Card.Self+cameUnderControlSinceLastUpkeep | Secondary$ True | TriggerDescription$ " + inst.getReminderText();
            String effect = "DB$ Sacrifice | SacValid$ Self | Echo$ " + cost;
            Trigger trigger = TriggerHandler.parseTrigger(upkeepTrig, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Evoke")) {
            StringBuilder trigStr = new StringBuilder("Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self+evoked | Secondary$ True | TriggerDescription$ Evoke (" + inst.getReminderText() + ")");
            String effect = "DB$ Sacrifice";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr.toString(), card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Sacrifice", card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Evolve")) {
            String trigStr = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Creature.YouCtrl+Other | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Evolve (" + inst.getReminderText() + ")";
            String effect = "DB$ PutCounter | Defined$ Self | CounterType$ P1P1 | CounterNum$ 1";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ PutCounter | Defined$ Self | CounterType$ P1P1 | CounterNum$ 1", card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Exalted")) {
            String trig = "Mode$ Attacks | ValidCard$ Creature.YouCtrl | Alone$ True | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Exalted (" + inst.getReminderText() + ")";
            String effect = "DB$ Pump | Defined$ TriggeredAttackerLKICopy | NumAtt$ +1 | NumDef$ +1";
            Trigger trigger = TriggerHandler.parseTrigger(trig, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Pump | Defined$ TriggeredAttackerLKICopy | NumAtt$ +1 | NumDef$ +1", card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Exploit")) {
            String trigStr = "Mode$ ChangesZone | ValidCard$ Card.Self | Destination$ Battlefield | Secondary$ True | TriggerDescription$ Exploit (" + inst.getReminderText() + ")";
            String effect = "DB$ Sacrifice | SacValid$ Creature | SacMessage$ creature | Optional$ True";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Sacrifice | SacValid$ Creature | SacMessage$ creature | Optional$ True", card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Extort")) {
            String extortTrigger = "Mode$ SpellCast | ValidCard$ Card | ValidActivatingPlayer$ You | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Extort (" + inst.getReminderText() + ")";
            String loseLifeStr = "AB$ LoseLife | Cost$ WB | Defined$ Player.Opponent | LifeAmount$ 1";
            String gainLifeStr = "DB$ GainLife | Defined$ You | LifeAmount$ AFLifeLost";
            SpellAbility loseLifeSA = AbilityFactory.getAbility("AB$ LoseLife | Cost$ WB | Defined$ Player.Opponent | LifeAmount$ 1", card);
            AbilitySub gainLifeSA = (AbilitySub)AbilityFactory.getAbility("DB$ GainLife | Defined$ You | LifeAmount$ AFLifeLost", card);
            loseLifeSA.setSVar("AFLifeLost", "Number$0");
            loseLifeSA.setSubAbility(gainLifeSA);
            loseLifeSA.setIntrinsic(intrinsic);
            Trigger parsedTrigger = TriggerHandler.parseTrigger(extortTrigger, card, intrinsic);
            parsedTrigger.setOverridingAbility(loseLifeSA);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("Fabricate")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String name = StringUtils.join(k);
            String trigStr = "Mode$ ChangesZone | Destination$ Battlefield  | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ Fabricate " + n + " (" + inst.getReminderText() + ")";
            String token = "DB$ Token | TokenAmount$ " + n + " | TokenScript$ c_1_1_a_servo | UnlessCost$ AddCounter<" + n + "/P1P1> | UnlessPayer$ You | UnlessAI$ " + name + " | SpellDescription$ Fabricate - Create " + Lang.nounWithNumeral(n, "1/1 colorless Servo artifact creature token") + ".";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility saChoose = AbilityFactory.getAbility(token, card);
            saChoose.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(saChoose);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Fading")) {
            String upkeepTrig = "Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ At the beginning of your upkeep, remove a fade counter from CARDNAME. If you can't, sacrifice CARDNAME.";
            String removeCounterStr = "DB$ RemoveCounter | Defined$ Self | CounterType$ FADE | CounterNum$ 1 | RememberRemoved$ True";
            String sacrificeStr = "DB$ Sacrifice | SacValid$ Self | ConditionCheckSVar$ FadingCheckSVar | ConditionSVarCompare$ EQ0";
            String cleanupStr = "DB$ Cleanup | ClearRemembered$ True";
            SpellAbility removeCounterSA = AbilityFactory.getAbility("DB$ RemoveCounter | Defined$ Self | CounterType$ FADE | CounterNum$ 1 | RememberRemoved$ True", card);
            AbilitySub sacrificeSA = (AbilitySub)AbilityFactory.getAbility("DB$ Sacrifice | SacValid$ Self | ConditionCheckSVar$ FadingCheckSVar | ConditionSVarCompare$ EQ0", card);
            sacrificeSA.setSVar("FadingCheckSVar", "Count$RememberedSize");
            removeCounterSA.setSubAbility(sacrificeSA);
            AbilitySub cleanupSA = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            sacrificeSA.setSubAbility(cleanupSA);
            Trigger trigger = TriggerHandler.parseTrigger(upkeepTrig, card, intrinsic);
            removeCounterSA.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(removeCounterSA);
            inst.addTrigger(trigger);
        } else if (keyword.equals("Flanking")) {
            StringBuilder trigFlanking = new StringBuilder("Mode$ AttackerBlockedByCreature | ValidCard$ Card.Self | ValidBlocker$ Creature.withoutFlanking  | TriggerZones$ Battlefield | Secondary$ True  | TriggerDescription$ Flanking (" + inst.getReminderText() + ")");
            String effect = "DB$ Pump | Defined$ TriggeredBlockerLKICopy | NumAtt$ -1 | NumDef$ -1";
            Trigger trigger = TriggerHandler.parseTrigger(trigFlanking.toString(), card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Pump | Defined$ TriggeredBlockerLKICopy | NumAtt$ -1 | NumDef$ -1", card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("For Mirrodin")) {
            StringBuilder sbTrig = new StringBuilder();
            sbTrig.append("Mode$ ChangesZone | Destination$ Battlefield | ");
            sbTrig.append("ValidCard$ Card.Self | TriggerDescription$ ");
            sbTrig.append("For Mirrodin! (").append(inst.getReminderText()).append(")");
            String sbRebel = "DB$ Token | TokenScript$ r_2_2_rebel | TokenOwner$ You | RememberTokens$ True";
            SpellAbility saRebel = AbilityFactory.getAbility("DB$ Token | TokenScript$ r_2_2_rebel | TokenOwner$ You | RememberTokens$ True", card);
            String sbAttach = "DB$ Attach | Defined$ Remembered";
            AbilitySub saAttach = (AbilitySub)AbilityFactory.getAbility("DB$ Attach | Defined$ Remembered", card);
            saRebel.setSubAbility(saAttach);
            String sbClear = "DB$ Cleanup | ClearRemembered$ True";
            AbilitySub saClear = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            saAttach.setSubAbility(saClear);
            Trigger etbTrigger = TriggerHandler.parseTrigger(sbTrig.toString(), card, intrinsic);
            etbTrigger.setOverridingAbility(saRebel);
            saRebel.setIntrinsic(intrinsic);
            inst.addTrigger(etbTrigger);
        } else if (keyword.equals("Gift")) {
            SpellAbility saGift = AbilityFactory.getAbility(card.getSVar("GiftAbility"), card);
            card.getFirstSpellAbility().setAdditionalAbility("GiftAbility", saGift);
            if (!card.isPermanent()) {
                saGift.setKeyword(inst);
                return;
            }
            String giftDescription = saGift.getParamOrDefault("GiftDescription", "<missing description>");
            StringBuilder sbTrig = new StringBuilder();
            sbTrig.append("Mode$ ChangesZone | Destination$ Battlefield | ");
            sbTrig.append("ValidCard$ Card.Self+PromisedGift | Secondary$ True | TriggerDescription$ ");
            sbTrig.append("Gift a ").append(giftDescription).append(" to ").append(card.getPromisedGift());
            Trigger etbTrigger = TriggerHandler.parseTrigger(sbTrig.toString(), card, intrinsic);
            etbTrigger.setOverridingAbility(saGift);
            saGift.setIntrinsic(intrinsic);
            inst.addTrigger(etbTrigger);
        } else if (keyword.startsWith("Graft")) {
            StringBuilder sb = new StringBuilder();
            sb.append("DB$ MoveCounter | Source$ Self | Defined$ TriggeredCardLKICopy");
            sb.append(" | CounterType$ P1P1 | CounterNum$ 1");
            if (card.hasSVar("AIGraftPreference")) {
                sb.append(" | AILogic$ ").append(card.getSVar("AIGraftPreference"));
            }
            String trigStr = "Mode$ ChangesZone | ValidCard$ Creature.Other| Origin$ Any | Destination$ Battlefield | TriggerZones$ Battlefield | OptionalDecider$ You | IsPresent$ Card.Self+counters_GE1_P1P1| Secondary$ True | TriggerDescription$ Whenever another creature enters, you may move a +1/+1 counter from this creature onto it.";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(sb.toString(), card));
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Gravestorm")) {
            String trigStr = "Mode$ SpellCast | ValidCard$ Card.Self | TriggerZones$ Stack | TriggerDescription$ Gravestorm (" + inst.getReminderText() + ")";
            String copyStr = "DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | Amount$ GravestormCount | MayChooseTarget$ True";
            SpellAbility copySa = AbilityFactory.getAbility(copyStr, card);
            copySa.setSVar("GravestormCount", "Count$ThisTurnEntered_Graveyard_from_Battlefield_Permanent");
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(copySa);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Haunt")) {
            String[] k = keyword.split(":");
            String hauntSVarName = k[1];
            ArrayList<Trigger> triggers = Lists.newArrayList();
            StringBuilder sb = new StringBuilder();
            if (card.isCreature()) {
                sb.append("When ").append(card.getName());
                sb.append(" enters or the creature it haunts dies, ");
            } else {
                sb.append("When the creature ").append(card.getName());
                sb.append(" haunts dies, ");
            }
            sb.append("ABILITY");
            String hauntDescription = sb.toString();
            StringBuilder sbDies = new StringBuilder();
            sbDies.append("Mode$ ChangesZone | Origin$ Battlefield | Destination$ Graveyard | TriggerZones$ Exile");
            sbDies.append(" | ValidCard$ Creature.HauntedBy | Execute$ ").append(hauntSVarName);
            sbDies.append(" | TriggerDescription$ ").append(hauntDescription);
            Trigger hauntedDies = TriggerHandler.parseTrigger(sbDies.toString(), card, intrinsic);
            StringBuilder sbUnExiled = new StringBuilder();
            sbUnExiled.append("Mode$ ChangesZone | Origin$ Exile | ");
            sbUnExiled.append("ValidCard$ Card.Self | Static$ True | Secondary$ True | ");
            sbUnExiled.append("TriggerDescription$ Blank");
            Trigger haunterUnExiled = TriggerHandler.parseTrigger(sbUnExiled.toString(), card, intrinsic);
            SpellAbility unhaunt = AbilityFactory.getAbility("DB$ Haunt", card);
            haunterUnExiled.setOverridingAbility(unhaunt);
            triggers.add(haunterUnExiled);
            StringBuilder sbHauntRemoved = new StringBuilder();
            sbHauntRemoved.append("Mode$ ChangesZone | Origin$ Battlefield | ");
            sbHauntRemoved.append("ValidCard$ Creature.HauntedBy | Static$ True | Secondary$ True | ");
            sbHauntRemoved.append("TriggerDescription$ Blank");
            Trigger trigHauntRemoved = TriggerHandler.parseTrigger(sbHauntRemoved.toString(), card, intrinsic);
            trigHauntRemoved.setOverridingAbility(unhaunt);
            triggers.add(trigHauntRemoved);
            if (card.isCreature()) {
                StringBuilder sbETB = new StringBuilder();
                sbETB.append("Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | Execute$ ");
                sbETB.append(hauntSVarName).append(" | Secondary$ True | TriggerDescription$ ");
                sbETB.append(hauntDescription);
                Trigger haunterETB = TriggerHandler.parseTrigger(sbETB.toString(), card, intrinsic);
                triggers.add(haunterETB);
            }
            StringBuilder sbHaunter = new StringBuilder();
            sbHaunter.append("Mode$ ChangesZone | Origin$ ");
            sbHaunter.append(card.isCreature() ? "Battlefield" : "Stack | Fizzle$ False");
            sbHaunter.append(" | Destination$ Graveyard | ValidCard$ Card.Self");
            sbHaunter.append(" | Secondary$ True | TriggerDescription$ Haunt (").append(inst.getReminderText()).append(")");
            Trigger haunterDies = TriggerHandler.parseTrigger(sbHaunter.toString(), card, intrinsic);
            String hauntDiesEffectStr = "DB$ Haunt | ValidTgts$ Creature | TgtPrompt$ Choose target creature to haunt";
            SpellAbility hauntDiesAbility = AbilityFactory.getAbility("DB$ Haunt | ValidTgts$ Creature | TgtPrompt$ Choose target creature to haunt", card);
            haunterDies.setOverridingAbility(hauntDiesAbility);
            triggers.add(haunterDies);
            triggers.add(hauntedDies);
            for (Trigger trigger : triggers) {
                inst.addTrigger(trigger);
            }
        } else if (keyword.startsWith("Hideaway")) {
            String[] k = keyword.split(":");
            String n = k[1];
            ArrayList<Trigger> triggers = Lists.newArrayList();
            StringBuilder sb = new StringBuilder();
            sb.append("Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | Secondary$ True | ");
            sb.append("TriggerDescription$ Hideaway ").append(n).append(" (").append(inst.getReminderText()).append(")");
            Trigger hideawayTrigger = TriggerHandler.parseTrigger(sb.toString(), card, intrinsic);
            String hideawayDig = "DB$ Dig | Defined$ You | DigNum$ " + n + " | DestinationZone$ Exile | ExileFaceDown$ True | RememberChanged$ True | RestRandomOrder$ True";
            String hideawayEffect = "DB$ Effect | StaticAbilities$ STHideawayEffectLookAtCard | ForgetOnMoved$ Exile | RememberObjects$ Remembered | Duration$ Permanent";
            String cleanupStr = "DB$ Cleanup | ClearRemembered$ True";
            String lookAtCard = "Mode$ Continuous | Affected$ Card.IsRemembered | MayLookAt$ EffectSourceController | EffectZone$ Command | AffectedZone$ Exile | Description$ Any player who has controlled the permanent that exiled this card may look at this card in the exile zone.";
            SpellAbility digSA = AbilityFactory.getAbility(hideawayDig, card);
            AbilitySub effectSA = (AbilitySub)AbilityFactory.getAbility(hideawayEffect, card);
            effectSA.setSVar("STHideawayEffectLookAtCard", lookAtCard);
            AbilitySub cleanSA = (AbilitySub)AbilityFactory.getAbility(cleanupStr, card);
            digSA.setSubAbility(effectSA);
            effectSA.setSubAbility(cleanSA);
            hideawayTrigger.setOverridingAbility(digSA);
            triggers.add(hideawayTrigger);
            for (Trigger trigger : triggers) {
                inst.addTrigger(trigger);
            }
        } else if (keyword.equals("Ingest")) {
            String trigStr = "Mode$ DamageDone | ValidSource$ Card.Self | ValidTarget$ Player | CombatDamage$ True| Secondary$ True | TriggerZones$ Battlefield | TriggerDescription$ Ingest (" + inst.getReminderText() + ")";
            String abStr = "DB$ Dig | DigNum$ 1 | ChangeNum$ All | DestinationZone$ Exile | Defined$ TriggeredTarget";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Dig | DigNum$ 1 | ChangeNum$ All | DestinationZone$ Exile | Defined$ TriggeredTarget", card));
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Impending")) {
            String endTrig = "Mode$ Phase | Phase$ End of Turn | ValidPlayer$ You | TriggerZones$ Battlefield | IsPresent$ Card.Self+impended+counters_GE1_TIME | Secondary$ True | TriggerDescription$ At the beginning of your end step, remove a time counter from it.";
            String remove = "DB$ RemoveCounter | Defined$ Self | CounterType$ TIME | CounterNum$ 1";
            Trigger parsedEndTrig = TriggerHandler.parseTrigger("Mode$ Phase | Phase$ End of Turn | ValidPlayer$ You | TriggerZones$ Battlefield | IsPresent$ Card.Self+impended+counters_GE1_TIME | Secondary$ True | TriggerDescription$ At the beginning of your end step, remove a time counter from it.", card, intrinsic);
            parsedEndTrig.setOverridingAbility(AbilityFactory.getAbility("DB$ RemoveCounter | Defined$ Self | CounterType$ TIME | CounterNum$ 1", card));
            inst.addTrigger(parsedEndTrig);
        } else if (keyword.equals("Living Weapon")) {
            StringBuilder sbTrig = new StringBuilder();
            sbTrig.append("Mode$ ChangesZone | Destination$ Battlefield | ");
            sbTrig.append("ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ ");
            sbTrig.append("Living Weapon (").append(inst.getReminderText()).append(")");
            StringBuilder sbGerm = new StringBuilder();
            sbGerm.append("DB$ Token | TokenAmount$ 1 | TokenScript$ b_0_0_phyrexian_germ | TokenOwner$ You | RememberTokens$ True");
            SpellAbility saGerm = AbilityFactory.getAbility(sbGerm.toString(), card);
            String sbAttach = "DB$ Attach | Defined$ Remembered";
            AbilitySub saAttach = (AbilitySub)AbilityFactory.getAbility("DB$ Attach | Defined$ Remembered", card);
            saGerm.setSubAbility(saAttach);
            String sbClear = "DB$ Cleanup | ClearRemembered$ True";
            AbilitySub saClear = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            saAttach.setSubAbility(saClear);
            Trigger etbTrigger = TriggerHandler.parseTrigger(sbTrig.toString(), card, intrinsic);
            etbTrigger.setOverridingAbility(saGerm);
            saGerm.setIntrinsic(intrinsic);
            inst.addTrigger(etbTrigger);
        } else if (keyword.startsWith("Madness")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String trigStr = "Mode$ Exiled | ValidCard$ Card.Self | Madness$ True | Secondary$ True | TriggerDescription$ Play Madness " + ManaCostParser.parse(manacost) + " - " + card.getName();
            String playMadnessStr = "DB$ Play | Defined$ Self | PlayCost$ " + manacost + " | ConditionDefined$ Self | ConditionPresent$ Card.StrictlySelf+inZoneExile | Optional$ True | RememberPlayed$ True | Madness$ True";
            String moveToYardStr = "DB$ ChangeZone | Defined$ Self.StrictlySelf | Origin$ Exile | Destination$ Graveyard | TrackDiscarded$ True | ConditionDefined$ Remembered | ConditionPresent$ Card Card | ConditionCompare$ EQ0";
            String cleanUpStr = "DB$ Cleanup | ClearRemembered$ True";
            Trigger parsedTrigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility playSA = AbilityFactory.getAbility(playMadnessStr, card);
            AbilitySub moveSA = (AbilitySub)AbilityFactory.getAbility("DB$ ChangeZone | Defined$ Self.StrictlySelf | Origin$ Exile | Destination$ Graveyard | TrackDiscarded$ True | ConditionDefined$ Remembered | ConditionPresent$ Card Card | ConditionCompare$ EQ0", card);
            AbilitySub cleanupSA = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            moveSA.setSubAbility(cleanupSA);
            playSA.setSubAbility(moveSA);
            playSA.setIntrinsic(intrinsic);
            parsedTrigger.setOverridingAbility(playSA);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Melee")) {
            String trigStr = "Mode$ Attacks | ValidCard$ Card.Self | Secondary$ True  | TriggerDescription$ Melee (" + inst.getReminderText() + ")";
            String effect = "DB$ Pump | Defined$ TriggeredAttackerLKICopy | NumAtt$ MeleeX | NumDef$ MeleeX";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility("DB$ Pump | Defined$ TriggeredAttackerLKICopy | NumAtt$ MeleeX | NumDef$ MeleeX", card);
            sa.setSVar("MeleeX", "TriggeredPlayersDefenders$Amount");
            sa.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.equals("Mentor")) {
            String trigStr = "Mode$ Attacks | ValidCard$ Card.Self | Secondary$ True  | TriggerDescription$ Mentor (" + inst.getReminderText() + ")";
            String effect = "DB$ PutCounter | CounterType$ P1P1 | CounterNum$ 1 | ValidTgts$ Creature.attacking+powerLTX | TgtPrompt$ Select target attacking creature with less power";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility("DB$ PutCounter | CounterType$ P1P1 | CounterNum$ 1 | ValidTgts$ Creature.attacking+powerLTX | TgtPrompt$ Select target attacking creature with less power", card);
            sa.setSVar("X", "Count$CardPower");
            sa.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Miracle")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String abStrReveal = "DB$ Reveal | Defined$ You | RevealDefined$ Self | MiracleCost$ " + manacost;
            String abStrPlay = "DB$ Play | Defined$ Self | Optional$ True | PlayCost$ " + manacost;
            String revealed = "DB$ ImmediateTrigger | TriggerDescription$ CARDNAME - Miracle";
            String trigStrDrawn = "Mode$ Drawn | ValidCard$ Card.Self | Number$ 1 | Secondary$ True | OptionalDecider$ You | Static$ True | TriggerDescription$ CARDNAME - Miracle";
            Trigger triggerDrawn = TriggerHandler.parseTrigger("Mode$ Drawn | ValidCard$ Card.Self | Number$ 1 | Secondary$ True | OptionalDecider$ You | Static$ True | TriggerDescription$ CARDNAME - Miracle", card, intrinsic);
            SpellAbility revealSA = AbilityFactory.getAbility(abStrReveal, card);
            AbilitySub immediateTriggerSA = (AbilitySub)AbilityFactory.getAbility(revealed, card);
            immediateTriggerSA.setAdditionalAbility("Execute", (AbilitySub)AbilityFactory.getAbility(abStrPlay, card));
            revealSA.setSubAbility(immediateTriggerSA);
            triggerDrawn.setOverridingAbility(revealSA);
            inst.addTrigger(triggerDrawn);
        } else if (keyword.startsWith("Modular")) {
            String abStr = "DB$ PutCounter | ValidTgts$ Artifact.Creature | TgtPrompt$ Select target artifact creature | CounterType$ P1P1 | CounterNum$ ModularX";
            String trigStr = "Mode$ ChangesZone | ValidCard$ Card.Self | Origin$ Battlefield | Destination$ Graveyard | OptionalDecider$ TriggeredCardController | Secondary$ True | TriggerDescription$ When CARDNAME dies, you may put a +1/+1 counter on target artifact creature for each +1/+1 counter on CARDNAME";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility ab = AbilityFactory.getAbility("DB$ PutCounter | ValidTgts$ Artifact.Creature | TgtPrompt$ Select target artifact creature | CounterType$ P1P1 | CounterNum$ ModularX", card);
            ab.setSVar("ModularX", "TriggeredCard$CardCounters.P1P1");
            trigger.setOverridingAbility(ab);
            inst.addTrigger(trigger);
        } else if (keyword.equals("Myriad")) {
            String actualTrigger = "Mode$ Attacks | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ Myriad (" + inst.getReminderText() + ")";
            String copyStr = "DB$ CopyPermanent | Defined$ Self | TokenTapped$ True | OptionalForEach$ True | TokenAttacking$ RememberedPlayer & Valid Planeswalker.ControlledBy Remembered| ForEach$ OppNonDefendingPlayer | AtEOT$ ExileCombat | CleanupForEach$ True";
            SpellAbility copySA = AbilityFactory.getAbility("DB$ CopyPermanent | Defined$ Self | TokenTapped$ True | OptionalForEach$ True | TokenAttacking$ RememberedPlayer & Valid Planeswalker.ControlledBy Remembered| ForEach$ OppNonDefendingPlayer | AtEOT$ ExileCombat | CleanupForEach$ True", card);
            copySA.setIntrinsic(intrinsic);
            Trigger parsedTrigger = TriggerHandler.parseTrigger(actualTrigger, card, intrinsic);
            parsedTrigger.setOverridingAbility(copySA);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Nightbound")) {
            String setDayTrig = "Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Neither | IsPresent$ Card.Daybound | PresentCompare$ EQ0 | Secondary$ True | TriggerDescription$ Any time a player controls a permanent with nightbound, if it's neither day nor night and there are no permanents with daybound on the battlefield, it becomes night.";
            String setDayEff = "DB$ DayTime | Value$ Night";
            Trigger trigger = TriggerHandler.parseTrigger("Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Neither | IsPresent$ Card.Daybound | PresentCompare$ EQ0 | Secondary$ True | TriggerDescription$ Any time a player controls a permanent with nightbound, if it's neither day nor night and there are no permanents with daybound on the battlefield, it becomes night.", card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(setDayEff, card));
            inst.addTrigger(trigger);
            String transformTrig = "Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Day | IsPresent$ Card.Self+BackSide | Secondary$ True | TriggerDescription$ As it becomes day, if this permanent is back face up, transform it";
            String transformEff = "DB$ SetState | Mode$ Transform";
            trigger = TriggerHandler.parseTrigger("Mode$ Always | TriggerZones$ Battlefield | Static$ True | DayTime$ Day | IsPresent$ Card.Self+BackSide | Secondary$ True | TriggerDescription$ As it becomes day, if this permanent is back face up, transform it", card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(transformEff, card));
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Offspring")) {
            String[] k = keyword.split(":");
            Cost cost = new Cost(k[1], false);
            String costDesc = cost.toSimpleString();
            if (!cost.isOnlyManaCost()) {
                costDesc = "\u2014" + costDesc;
            }
            String trigStr = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | CheckSVar$ Offspring | Secondary$ True | TriggerDescription$ Offspring " + costDesc + " (" + inst.getReminderText() + ")";
            String effect = "DB$ CopyPermanent | Defined$ TriggeredCardLKICopy | NumCopies$ 1 | SetPower$ 1 | SetToughness$ 1";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ CopyPermanent | Defined$ TriggeredCardLKICopy | NumCopies$ 1 | SetPower$ 1 | SetToughness$ 1", card));
            trigger.setSVar("Offspring", "Count$OptionalKeywordAmount");
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Partner:")) {
            String[] k = keyword.split(":");
            String trigStr = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | Secondary$ True | TriggerDescription$ Partner with " + k[1] + " (" + inst.getReminderText() + ")";
            k[1] = k[1].replace(",", ";");
            String effect = "DB$ ChangeZone | ValidTgts$ Player | Origin$ Library | Destination$ Hand | ChangeType$ Card.named" + k[1] + " | Hidden$ True | Chooser$ Targeted | Optional$ True";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("Persist")) {
            String trigStr = "Mode$ ChangesZone | Origin$ Battlefield | Destination$ Graveyard  | ValidCard$ Card.Self+counters_EQ0_M1M1 | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Persist (" + inst.getReminderText() + ")";
            String effect = "DB$ ChangeZone | Defined$ TriggeredNewCardLKICopy | Origin$ Graveyard | Destination$ Battlefield | WithCountersType$ M1M1";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility("DB$ ChangeZone | Defined$ TriggeredNewCardLKICopy | Origin$ Graveyard | Destination$ Battlefield | WithCountersType$ M1M1", card));
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Poisonous")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String trigStr = "Mode$ DamageDone | ValidSource$ Card.Self | ValidTarget$ Player | CombatDamage$ True | Secondary$ True | TriggerZones$ Battlefield | TriggerDescription$ Poisonous " + n + " (" + inst.getReminderText() + ")";
            Trigger parsedTrigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            String effect = "DB$ Poison | Defined$ TriggeredTarget | Num$ " + n;
            parsedTrigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Provoke")) {
            String actualTrigger = "Mode$ Attacks | ValidCard$ Card.Self | OptionalDecider$ You | Secondary$ True | TriggerDescription$ Provoke (" + inst.getReminderText() + ")";
            String blockStr = "DB$ MustBlock | Duration$ UntilEndOfCombat | ValidTgts$ Creature.ControlledBy TriggeredDefendingPlayer | TgtPrompt$ Select target creature defending player controls";
            String untapStr = "DB$ Untap | Defined$ Targeted";
            SpellAbility blockSA = AbilityFactory.getAbility("DB$ MustBlock | Duration$ UntilEndOfCombat | ValidTgts$ Creature.ControlledBy TriggeredDefendingPlayer | TgtPrompt$ Select target creature defending player controls", card);
            AbilitySub untapSA = (AbilitySub)AbilityFactory.getAbility("DB$ Untap | Defined$ Targeted", card);
            blockSA.setSubAbility(untapSA);
            Trigger parsedTrigger = TriggerHandler.parseTrigger(actualTrigger, card, intrinsic);
            blockSA.setIntrinsic(intrinsic);
            parsedTrigger.setOverridingAbility(blockSA);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Prowess")) {
            String trigProwess = "Mode$ SpellCast | ValidCard$ Card.nonCreature | ValidActivatingPlayer$ You | TriggerZones$ Battlefield | TriggerDescription$ Prowess (" + inst.getReminderText() + ")";
            String effect = "DB$ Pump | Defined$ Self | NumAtt$ +1 | NumDef$ +1";
            Trigger parsedTrigger = TriggerHandler.parseTrigger(trigProwess, card, intrinsic);
            parsedTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Pump | Defined$ Self | NumAtt$ +1 | NumDef$ +1", card));
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("Rampage")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String trigStr = "Mode$ AttackerBlocked | ValidCard$ Card.Self | TriggerZones$ Battlefield  | ValidBlocker$ Creature | Secondary$ True  | TriggerDescription$ Rampage " + n + " (" + inst.getReminderText() + ")";
            String effect = "DB$ Pump | Defined$ TriggeredAttackerLKICopy | NumAtt$ Rampage" + n + " | NumDef$ Rampage" + n;
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setSVar("Rampage" + n, "SVar$RampageCount/Times." + n);
            sa.setSVar("RampageCount", "Count$Valid Creature.blockingTriggeredAttacker/Minus.1");
            sa.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Ravenous")) {
            String ravenousTrig = "Mode$ ChangesZone | ValidCard$ Card.Self | Origin$ Any | Destination$ Battlefield | CheckSVar$ Count$xPaid | SVarCompare$ GE5 | Secondary$ True | TriggerDescription$ If X is 5 or more, draw a card when it enters.";
            String drawStr = "DB$ Draw";
            Trigger trigger = TriggerHandler.parseTrigger("Mode$ ChangesZone | ValidCard$ Card.Self | Origin$ Any | Destination$ Battlefield | CheckSVar$ Count$xPaid | SVarCompare$ GE5 | Secondary$ True | TriggerDescription$ If X is 5 or more, draw a card when it enters.", card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility("DB$ Draw", card);
            sa.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Renown")) {
            String[] k = keyword.split(":");
            String renownTrig = "Mode$ DamageDone | ValidSource$ Card.Self | ValidTarget$ Player | IsPresent$ Card.Self+!IsRenowned | CombatDamage$ True | Secondary$ True | TriggerDescription$ Renown " + k[1] + " (" + inst.getReminderText() + ")";
            String effect = "DB$ PutCounter | Defined$ Self | CounterType$ P1P1 | CounterNum$ " + k[1];
            Trigger parsedTrigger = TriggerHandler.parseTrigger(renownTrig, card, intrinsic);
            parsedTrigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("Recover")) {
            String recoverCost = keyword.split(":")[1];
            String changeStr = "DB$ ChangeZone | Defined$ Self | Origin$ Graveyard | Destination$ Hand | UnlessCost$ " + recoverCost + " | UnlessPayer$ You | UnlessSwitched$ True | UnlessResolveSubs$ WhenNotPaid";
            String exileStr = "DB$ ChangeZone | Defined$ Self | Origin$ Graveyard | Destination$ Exile";
            SpellAbility changeSA = AbilityFactory.getAbility(changeStr, card);
            AbilitySub exileSA = (AbilitySub)AbilityFactory.getAbility("DB$ ChangeZone | Defined$ Self | Origin$ Graveyard | Destination$ Exile", card);
            changeSA.setSubAbility(exileSA);
            Cost cost = new Cost(recoverCost, false);
            String costDesc = cost.toSimpleString();
            if (!cost.isOnlyManaCost()) {
                costDesc = "\u2014" + costDesc;
            }
            String trigObject = card.isCreature() ? "Creature.Other+YouOwn" : "Creature.YouOwn";
            String trigArticle = card.isCreature() ? "another" : "a";
            String trigStr = "Mode$ ChangesZone | ValidCard$ " + trigObject + " | Origin$ Battlefield | Destination$ Graveyard | TriggerZones$ Graveyard | Secondary$ True | TriggerDescription$ Recover " + costDesc + " (When " + trigArticle + " creature is put into your graveyard from the battlefield, you may pay " + costDesc + ". If you do, return CARDNAME from your graveyard to your hand. Otherwise, exile CARDNAME.)";
            Trigger myTrigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            changeSA.setIntrinsic(intrinsic);
            myTrigger.setOverridingAbility(changeSA);
            inst.addTrigger(myTrigger);
        } else if (keyword.startsWith("Replicate")) {
            String trigScript = "Mode$ SpellCast | ValidCard$ Card.Self | CheckSVar$ ReplicateAmount | Secondary$ True | TriggerDescription$ Copy CARDNAME for each time you paid its replicate cost.";
            String abString = "DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | Amount$ ReplicateAmount | MayChooseTarget$ True";
            Trigger replicateTrigger = TriggerHandler.parseTrigger("Mode$ SpellCast | ValidCard$ Card.Self | CheckSVar$ ReplicateAmount | Secondary$ True | TriggerDescription$ Copy CARDNAME for each time you paid its replicate cost.", card, intrinsic);
            SpellAbility replicateAbility = AbilityFactory.getAbility("DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | Amount$ ReplicateAmount | MayChooseTarget$ True", card);
            replicateAbility.setSVar("ReplicateAmount", "Count$OptionalKeywordAmount");
            replicateTrigger.setOverridingAbility(replicateAbility);
            replicateTrigger.setSVar("ReplicateAmount", "Count$OptionalKeywordAmount");
            inst.addTrigger(replicateTrigger);
        } else if (keyword.startsWith("Ripple")) {
            String[] k = keyword.split(":");
            String num = k[1];
            String actualTrigger = "Mode$ SpellCast | ValidCard$ Card.Self | OptionalDecider$ You |  Secondary$ True | TriggerDescription$ Ripple " + num + " - CARDNAME";
            String abString = "DB$ PeekAndReveal | PeekAmount$ " + num + " | RememberRevealed$ True";
            String dbCast = "DB$ Play | Valid$ Card.IsRemembered+sameName | ValidSA$ Spell | ValidZone$ Library | WithoutManaCost$ True | Optional$ True | Amount$ All";
            String toBottom = "DB$ ChangeZoneAll | ChangeType$ Card.IsRemembered | Origin$ Library | Destination$ Library | LibraryPosition$ -1";
            String cleanuptxt = "DB$ Cleanup | ClearRemembered$ True";
            SpellAbility sa = AbilityFactory.getAbility(abString, card);
            AbilitySub saCast = (AbilitySub)AbilityFactory.getAbility("DB$ Play | Valid$ Card.IsRemembered+sameName | ValidSA$ Spell | ValidZone$ Library | WithoutManaCost$ True | Optional$ True | Amount$ All", card);
            AbilitySub saBottom = (AbilitySub)AbilityFactory.getAbility("DB$ ChangeZoneAll | ChangeType$ Card.IsRemembered | Origin$ Library | Destination$ Library | LibraryPosition$ -1", card);
            AbilitySub saCleanup = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | ClearRemembered$ True", card);
            saBottom.setSubAbility(saCleanup);
            saCast.setSubAbility(saBottom);
            sa.setSubAbility(saCast);
            sa.setIntrinsic(intrinsic);
            Trigger parsedTrigger = TriggerHandler.parseTrigger(actualTrigger, card, intrinsic);
            parsedTrigger.setOverridingAbility(sa);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Soulbond")) {
            String actualTriggerSelf = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | IsPresent$ Creature.Other+YouCtrl+!Paired | Secondary$ True | TriggerDescription$ When CARDNAME enters, you may pair CARDNAME with another unpaired creature you control";
            String abStringSelf = "DB$ Bond | Defined$ TriggeredCardLKICopy | ValidCards$ Creature.Other+YouCtrl+!Paired";
            Trigger parsedTriggerSelf = TriggerHandler.parseTrigger("Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self | IsPresent$ Creature.Other+YouCtrl+!Paired | Secondary$ True | TriggerDescription$ When CARDNAME enters, you may pair CARDNAME with another unpaired creature you control", card, intrinsic);
            parsedTriggerSelf.setOverridingAbility(AbilityFactory.getAbility("DB$ Bond | Defined$ TriggeredCardLKICopy | ValidCards$ Creature.Other+YouCtrl+!Paired", card));
            String actualTriggerOther = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Creature.Other+YouCtrl | TriggerZones$ Battlefield |  IsPresent$ Creature.Self+!Paired | Secondary$ True |  TriggerDescription$ When another unpaired creature you control enters, you may pair it with CARDNAME";
            String abStringOther = "DB$ Bond | Defined$ TriggeredCardLKICopy | ValidCards$ Creature.Self+!Paired";
            Trigger parsedTriggerOther = TriggerHandler.parseTrigger("Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Creature.Other+YouCtrl | TriggerZones$ Battlefield |  IsPresent$ Creature.Self+!Paired | Secondary$ True |  TriggerDescription$ When another unpaired creature you control enters, you may pair it with CARDNAME", card, intrinsic);
            parsedTriggerOther.setOverridingAbility(AbilityFactory.getAbility("DB$ Bond | Defined$ TriggeredCardLKICopy | ValidCards$ Creature.Self+!Paired", card));
            inst.addTrigger(parsedTriggerSelf);
            inst.addTrigger(parsedTriggerOther);
        } else if (keyword.startsWith("Soulshift")) {
            String[] k = keyword.split(":");
            String actualTrigger = "Mode$ ChangesZone | Origin$ Battlefield | Destination$ Graveyard| Secondary$ True | OptionalDecider$ You | ValidCard$ Card.Self| TriggerDescription$ " + k[0] + " " + k[1] + " (" + inst.getReminderText() + ")";
            String effect = "DB$ ChangeZone | Origin$ Graveyard | Destination$ Hand| ValidTgts$ Spirit.YouOwn+cmcLE" + k[1];
            Trigger parsedTrigger = TriggerHandler.parseTrigger(actualTrigger, card, intrinsic);
            SpellAbility sp = AbilityFactory.getAbility(effect, card);
            parsedTrigger.setOverridingAbility(sp);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("Squad")) {
            String trigScript = "Mode$ ChangesZone | Origin$ Any | Destination$ Battlefield | ValidCard$ Card.Self+linkedCastSA | CheckSVar$ SquadAmount | Secondary$ True | TriggerDescription$ When this creature enters, create that many tokens that are copies of it.";
            String abString = "DB$ CopyPermanent | Defined$ TriggeredCardLKICopy | NumCopies$ SquadAmount";
            Trigger squadTrigger = TriggerHandler.parseTrigger("Mode$ ChangesZone | Origin$ Any | Destination$ Battlefield | ValidCard$ Card.Self+linkedCastSA | CheckSVar$ SquadAmount | Secondary$ True | TriggerDescription$ When this creature enters, create that many tokens that are copies of it.", card, intrinsic);
            SpellAbility squadAbility = AbilityFactory.getAbility("DB$ CopyPermanent | Defined$ TriggeredCardLKICopy | NumCopies$ SquadAmount", card);
            squadAbility.setSVar("SquadAmount", "Count$OptionalKeywordAmount");
            squadTrigger.setOverridingAbility(squadAbility);
            squadTrigger.setSVar("SquadAmount", "Count$OptionalKeywordAmount");
            inst.addTrigger(squadTrigger);
        } else if (keyword.equals("Storm")) {
            String actualTrigger = "Mode$ SpellCast | ValidCard$ Card.Self | TriggerZones$ Stack | Secondary$ True| TriggerDescription$ Storm (" + inst.getReminderText() + ")";
            String effect = "DB$ CopySpellAbility | Defined$ TriggeredSpellAbility | Amount$ StormCount | MayChooseTarget$ True";
            Trigger parsedTrigger = TriggerHandler.parseTrigger(actualTrigger, card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setSVar("StormCount", "TriggerCount$CurrentStormCount/Minus.1");
            parsedTrigger.setOverridingAbility(sa);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("Suspend")) {
            StringBuilder upkeepTrig = new StringBuilder();
            upkeepTrig.append("Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | TriggerZones$ Exile");
            upkeepTrig.append(" | IsPresent$ Card.Self+suspended | PresentZone$ Exile");
            upkeepTrig.append(" | Secondary$ True | TriggerDescription$ At the beginning of your upkeep, if this card is suspended, remove a time counter from it");
            String abRemove = "DB$ RemoveCounter | Defined$ Self | CounterType$ TIME | CounterNum$ 1";
            Trigger parsedUpkeepTrig = TriggerHandler.parseTrigger(upkeepTrig.toString(), card, intrinsic);
            parsedUpkeepTrig.setOverridingAbility(AbilityFactory.getAbility("DB$ RemoveCounter | Defined$ Self | CounterType$ TIME | CounterNum$ 1", card));
            StringBuilder playTrig = new StringBuilder();
            playTrig.append("Mode$ CounterRemoved | TriggerZones$ Exile | ValidCard$ Card.Self | CounterType$ TIME | NewCounterAmount$ 0 | Secondary$ True");
            playTrig.append(" | TriggerDescription$ When the last time counter is removed from this card, if it's exiled, play it without paying its mana cost if able.  ");
            playTrig.append("If you can't, it remains exiled. If you cast a creature spell this way, it gains haste until you lose control of the spell or the permanent it becomes.");
            String abPlay = "DB$ Play | Defined$ Self | WithoutManaCost$ True";
            if (card.isPermanent()) {
                abPlay = abPlay + "| RememberPlayed$ True";
            }
            SpellAbility saPlay = AbilityFactory.getAbility(abPlay, card);
            if (card.isPermanent()) {
                String abPump = "DB$ Pump | Defined$ Remembered | KW$ Haste | PumpZone$ Stack | ConditionDefined$ Remembered | ConditionPresent$ Creature | Duration$ UntilLoseControlOfHost";
                AbilitySub saPump = (AbilitySub)AbilityFactory.getAbility("DB$ Pump | Defined$ Remembered | KW$ Haste | PumpZone$ Stack | ConditionDefined$ Remembered | ConditionPresent$ Creature | Duration$ UntilLoseControlOfHost", card);
                String dbClean = "DB$ Cleanup | ClearRemembered$ True";
                AbilitySub saCleanup = (AbilitySub)AbilityFactory.getAbility(dbClean, card);
                saPump.setSubAbility(saCleanup);
                saPlay.setSubAbility(saPump);
            }
            Trigger parsedPlayTrigger = TriggerHandler.parseTrigger(playTrig.toString(), card, intrinsic);
            parsedPlayTrigger.setOverridingAbility(saPlay);
            inst.addTrigger(parsedUpkeepTrig);
            inst.addTrigger(parsedPlayTrigger);
        } else if (keyword.equals("Training")) {
            String trigStr = "Mode$ Attacks | ValidCard$ Card.Self | Secondary$ True | IsPresent$ Creature.attacking+Other+powerGTX | NoResolvingCheck$ True | TriggerDescription$ Training (" + inst.getReminderText() + ")";
            String effect = "DB$ PutCounter | CounterType$ P1P1 | CounterNum$ 1 | Defined$ Self | Training$ True";
            Trigger trigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            SpellAbility sa = AbilityFactory.getAbility("DB$ PutCounter | CounterType$ P1P1 | CounterNum$ 1 | Defined$ Self | Training$ True", card);
            trigger.setSVar("X", "Count$CardPower");
            sa.setIntrinsic(intrinsic);
            trigger.setOverridingAbility(sa);
            inst.addTrigger(trigger);
        } else if (keyword.startsWith("Tribute")) {
            String abStr = "TrigNotTribute";
            String desc = AbilityFactory.getMapParams(card.getSVar("TrigNotTribute")).get("SpellDescription");
            String trigStr = "Mode$ ChangesZone | Destination$ Battlefield | ValidCard$ Card.Self+notTributed  | Execute$ TrigNotTribute | TriggerDescription$ " + desc;
            Trigger parsedTrigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            inst.addTrigger(parsedTrigger);
        } else if (keyword.equals("Undying")) {
            String trigStr = "Mode$ ChangesZone | Origin$ Battlefield | Destination$ Graveyard  | ValidCard$ Card.Self+counters_EQ0_P1P1 | TriggerZones$ Battlefield | Secondary$ True | TriggerDescription$ Undying (" + inst.getReminderText() + ")";
            String effect = "DB$ ChangeZone | Defined$ TriggeredNewCardLKICopy | Origin$ Graveyard | Destination$ Battlefield | WithCountersType$ P1P1";
            Trigger parsedTrigger = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            parsedTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ ChangeZone | Defined$ TriggeredNewCardLKICopy | Origin$ Graveyard | Destination$ Battlefield | WithCountersType$ P1P1", card));
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("UpkeepCost")) {
            String[] k = keyword.split(":");
            Cost cost = new Cost(k[1], true);
            StringBuilder sb = new StringBuilder();
            sb.append("At the beginning of your upkeep, sacrifice CARDNAME unless you ");
            if (cost.isOnlyManaCost()) {
                sb.append("pay ");
            }
            String costStr = k.length == 3 ? k[2] : cost.toSimpleString();
            sb.append(costStr.substring(0, 1).toLowerCase()).append(costStr.substring(1));
            sb.append(".");
            String upkeepTrig = "Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | TriggerZones$ Battlefield | TriggerDescription$ " + sb.toString();
            String effect = "DB$ Sacrifice | UnlessPayer$ You | UnlessCost$ " + k[1];
            Trigger parsedTrigger = TriggerHandler.parseTrigger(upkeepTrig, card, intrinsic);
            parsedTrigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(parsedTrigger);
        } else if (keyword.startsWith("Vanishing")) {
            StringBuilder upkeepTrig = new StringBuilder("Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | TriggerZones$ Battlefield | IsPresent$ Card.Self+counters_GE1_TIME");
            if (keyword.contains(":")) {
                upkeepTrig.append(" | Secondary$ True");
            }
            upkeepTrig.append(" | TriggerDescription$ At the beginning of your upkeep, if CARDNAME has a time counter on it, remove a time counter from it.");
            String remove = "DB$ RemoveCounter | Defined$ Self | CounterType$ TIME | CounterNum$ 1";
            Trigger parsedUpkeepTrig = TriggerHandler.parseTrigger(upkeepTrig.toString(), card, intrinsic);
            parsedUpkeepTrig.setOverridingAbility(AbilityFactory.getAbility("DB$ RemoveCounter | Defined$ Self | CounterType$ TIME | CounterNum$ 1", card));
            StringBuilder sacTrig = new StringBuilder("Mode$ CounterRemoved | TriggerZones$ Battlefield | ValidCard$ Card.Self | NewCounterAmount$ 0 | CounterType$ TIME");
            if (keyword.contains(":")) {
                sacTrig.append("| Secondary$ True");
            }
            sacTrig.append("| TriggerDescription$ When the last time counter is removed from CARDNAME, sacrifice it.");
            String sac = "DB$ Sacrifice | SacValid$ Self";
            Trigger parsedSacTrigger = TriggerHandler.parseTrigger(sacTrig.toString(), card, intrinsic);
            parsedSacTrigger.setOverridingAbility(AbilityFactory.getAbility("DB$ Sacrifice | SacValid$ Self", card));
            inst.addTrigger(parsedUpkeepTrig);
            inst.addTrigger(parsedSacTrigger);
        } else if (keyword.startsWith("Visit")) {
            String[] k = keyword.split(":");
            SpellAbility sa = AbilityFactory.getAbility(card, k[1]);
            String descStr = "Visit \u2014 " + sa.getDescription();
            String trigStr = "Mode$ VisitAttraction | TriggerZones$ Battlefield | ValidCard$ Card.Self| TriggerDescription$ " + descStr;
            Trigger t3 = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            t3.setOverridingAbility(sa);
            inst.addTrigger(t3);
        } else if (keyword.startsWith("Prize")) {
            String[] k = keyword.split(":");
            SpellAbility sa = AbilityFactory.getAbility(card, k[1]);
            String descStr = "Prize \u2014 " + sa.getDescription();
            String trigStr = "Mode$ ClaimPrize | Static$ True | TriggerZones$ Battlefield | ValidCard$ Card.Self| TriggerDescription$ " + descStr;
            Trigger t4 = TriggerHandler.parseTrigger(trigStr, card, intrinsic);
            t4.setOverridingAbility(sa);
            inst.addTrigger(t4);
        } else if (keyword.startsWith("Dungeon")) {
            List<String> abs = Arrays.asList(keyword.substring("Dungeon:".length()).split(","));
            LinkedHashMap<String, SpellAbility> saMap = new LinkedHashMap<String, SpellAbility>();
            for (String ab : abs) {
                saMap.put(ab, AbilityFactory.getAbility(card, ab));
            }
            for (SpellAbility sa : saMap.values()) {
                String roomName = sa.getParam("RoomName");
                StringBuilder trigStr = new StringBuilder("Mode$ RoomEntered | TriggerZones$ Command");
                trigStr.append(" | ValidCard$ Card.Self | ValidRoom$ ").append(roomName);
                trigStr.append(" | TriggerDescription$ ").append(roomName).append(" \u2014 ").append(sa.getDescription());
                if (sa.hasParam("NextRoom")) {
                    boolean first = true;
                    StringBuilder nextRoomParam = new StringBuilder();
                    trigStr.append("  (Leads to: ");
                    for (String nextRoomSVar : sa.getParam("NextRoom").split(",")) {
                        if (!first) {
                            trigStr.append(", ");
                            nextRoomParam.append(",");
                        }
                        String nextRoomName = ((SpellAbility)saMap.get(nextRoomSVar)).getParam("RoomName");
                        trigStr.append(nextRoomName);
                        nextRoomParam.append(nextRoomName);
                        first = false;
                    }
                    trigStr.append(")");
                    sa.putParam("NextRoomName", nextRoomParam.toString());
                }
                Trigger t5 = TriggerHandler.parseTrigger(trigStr.toString(), card, false);
                t5.setOverridingAbility(sa);
                inst.addTrigger(t5);
            }
        } else if (keyword.startsWith("Ward")) {
            String[] k = keyword.split(":");
            Cost cost = new Cost(k[1], false);
            String costDesc = cost.toSimpleString();
            String strTrig = "Mode$ BecomesTarget | ValidSource$ SpellAbility.OppCtrl | ValidTarget$ Card.Self  | Secondary$ True | TriggerZones$ Battlefield | TriggerDescription$ Ward " + costDesc + " (" + inst.getReminderText() + ")";
            String effect = "DB$ Counter | Defined$ TriggeredSourceSA | UnlessCost$ " + k[1] + " | UnlessPayer$ TriggeredSourceSAController";
            Trigger trigger = TriggerHandler.parseTrigger(strTrig, card, intrinsic);
            trigger.setOverridingAbility(AbilityFactory.getAbility(effect, card));
            inst.addTrigger(trigger);
        } else if (keyword.equals("MayFlashSac")) {
            String strTrig = "Mode$ SpellCast | ValidCard$ Card.Self | ValidSA$ Spell.MayPlaySource | Static$ True | Secondary$ True  | TriggerDescription$ If you cast it any time a sorcery couldn't have been cast,  the controller of the permanent it becomes sacrifices it at the beginning of the next cleanup step.";
            String strDelay = "DB$ DelayedTrigger | Mode$ Phase | Phase$ Cleanup | RememberObjects$ Self | TriggerDescription$ At the beginning of the next cleanup step, sacrifice CARDNAME.";
            String strSac = "DB$ SacrificeAll | Defined$ DelayTriggerRememberedLKI";
            SpellAbility saDelay = AbilityFactory.getAbility("DB$ DelayedTrigger | Mode$ Phase | Phase$ Cleanup | RememberObjects$ Self | TriggerDescription$ At the beginning of the next cleanup step, sacrifice CARDNAME.", card);
            saDelay.setAdditionalAbility("Execute", (AbilitySub)AbilityFactory.getAbility("DB$ SacrificeAll | Defined$ DelayTriggerRememberedLKI", card));
            Trigger trigger = TriggerHandler.parseTrigger(strTrig, card, intrinsic);
            trigger.setOverridingAbility(saDelay);
            inst.addTrigger(trigger);
        }
    }

    public static void addReplacementEffect(KeywordInterface inst, CardState card, boolean intrinsic) {
        String repeffstr;
        ReplacementEffect re;
        Cost cost;
        String m4;
        ReplacementEffect re2;
        ReplacementEffect re3;
        ReplacementEffect re4;
        ReplacementEffect re5;
        SpellAbility saExile;
        String abExile;
        String repeffstr2;
        CharSequence sb;
        String repeffstr3;
        StringBuilder sb2;
        String[] k;
        Card host = card.getCard();
        String keyword = inst.getOriginal();
        if (keyword.startsWith("Absorb")) {
            k = keyword.split(":");
            String n = k[1];
            sb2 = new StringBuilder();
            sb2.append("Event$ DamageDone | ActiveZones$ Battlefield | ValidTarget$ Card.Self");
            sb2.append(" | PreventionEffect$ True | Secondary$ True | Description$ Absorb ").append(n);
            sb2.append(" (").append(inst.getReminderText()).append(")");
            repeffstr3 = sb2.toString();
            String abString = "DB$ ReplaceDamage | Amount$ " + n;
            SpellAbility replaceDamage = AbilityFactory.getAbility(abString, card);
            replaceDamage.setIntrinsic(intrinsic);
            ReplacementEffect re6 = ReplacementHandler.parseReplacement(repeffstr3, host, intrinsic, (IHasSVars)card);
            re6.setOverridingAbility(replaceDamage);
            inst.addReplacement(re6);
        } else if (keyword.equals("Aftermath") && card.getStateName().equals((Object)CardStateName.RightSplit)) {
            sb = new StringBuilder();
            ((StringBuilder)sb).append("Event$ Moved | ValidCard$ Card.Self | Origin$ Stack | ExcludeDestination$ Exile ");
            ((StringBuilder)sb).append("| ValidStackSa$ Spell.Aftermath | Description$ Aftermath");
            ((StringBuilder)sb).append(" (");
            ((StringBuilder)sb).append(inst.getReminderText());
            ((StringBuilder)sb).append(")");
            repeffstr2 = ((StringBuilder)sb).toString();
            abExile = "DB$ ChangeZone | Defined$ Self | Origin$ Stack | Destination$ Exile";
            saExile = AbilityFactory.getAbility(abExile, card);
            saExile.setIntrinsic(intrinsic);
            re5 = ReplacementHandler.parseReplacement(repeffstr2, host, intrinsic, (IHasSVars)card);
            re5.setOverridingAbility(saExile);
            inst.addReplacement(re5);
        } else if (keyword.startsWith("Amplify")) {
            String[] ampString = keyword.split(":");
            String amplifyMagnitude = ampString[1];
            String ampTypes = ampString[2];
            String[] refinedTypes = ampTypes.split(",");
            StringBuilder types = new StringBuilder();
            for (int i = 0; i < refinedTypes.length; ++i) {
                types.append("Card.").append(refinedTypes[i]).append("+YouCtrl");
                if (i + 1 == refinedTypes.length) continue;
                types.append(",");
            }
            String actualRep = "Event$ Moved | Destination$ Battlefield | ValidCard$ Card.Self | | ReplacementResult$ Updated | Description$ Amplify " + amplifyMagnitude + " (" + inst.getReminderText() + ")";
            String abString = "DB$ Reveal | AnyNumber$ True | RevealValid$ " + types.toString() + " | RememberRevealed$ True";
            SpellAbility saReveal = AbilityFactory.getAbility(abString, card);
            String dbString = "DB$ PutCounter | Defined$ ReplacedCard | CounterType$ P1P1 | CounterNum$ AmpMagnitude | ETB$ True";
            AbilitySub saPut = (AbilitySub)AbilityFactory.getAbility("DB$ PutCounter | Defined$ ReplacedCard | CounterType$ P1P1 | CounterNum$ AmpMagnitude | ETB$ True", card);
            saPut.setSVar("AmpMagnitude", "SVar$Revealed/Times." + amplifyMagnitude);
            saPut.setSVar("Revealed", "Remembered$Amount");
            String dbClean = "DB$ Cleanup | ClearRemembered$ True";
            AbilitySub saCleanup = (AbilitySub)AbilityFactory.getAbility(dbClean, card);
            saPut.setSubAbility(saCleanup);
            saReveal.setSubAbility(saPut);
            saReveal.setIntrinsic(intrinsic);
            ReplacementEffect re7 = ReplacementHandler.parseReplacement(actualRep, host, intrinsic, (IHasSVars)card);
            re7.setOverridingAbility(saReveal);
            inst.addReplacement(re7);
        } else if (keyword.startsWith("Bloodthirst")) {
            String numCounters = keyword.split(":")[1];
            String desc = numCounters.equals("X") ? "Bloodthirst X (This creature enters with X +1/+1 counters on it, where X is the damage dealt to your opponents this turn.)" : "Bloodthirst " + numCounters + " (" + inst.getReminderText() + ")";
            String etbCounter = "etbCounter:P1P1:" + numCounters + ":Bloodthirst$ True:" + desc;
            re4 = CardFactoryUtil.makeEtbCounter(etbCounter, card, intrinsic);
            if (numCounters.equals("X")) {
                re4.getOverridingAbility().setSVar("X", "Count$BloodthirstAmount");
            }
            inst.addReplacement(re4);
        } else if (keyword.startsWith("Buyback")) {
            k = keyword.split(":");
            Cost cost2 = new Cost(k[1], false);
            sb2 = new StringBuilder();
            sb2.append("Event$ Moved | ValidCard$ Card.Self | Origin$ Stack | Destination$ Graveyard | Fizzle$ False ");
            sb2.append("| Secondary$ True | ValidStackSa$ Spell.Buyback | Description$ Buyback");
            sb2.append(cost2.isOnlyManaCost() ? " " : "\u2014");
            sb2.append(cost2.toSimpleString());
            if (!cost2.isOnlyManaCost()) {
                sb2.append(".");
            }
            sb2.append(" (");
            sb2.append(inst.getReminderText());
            sb2.append(")");
            repeffstr3 = sb2.toString();
            String abReturn = "DB$ ChangeZone | Defined$ Self | Origin$ Stack | Destination$ Hand";
            SpellAbility saReturn = AbilityFactory.getAbility(abReturn, card);
            saReturn.setIntrinsic(intrinsic);
            ReplacementEffect re8 = ReplacementHandler.parseReplacement(repeffstr3, host, intrinsic, (IHasSVars)card);
            re8.setOverridingAbility(saReturn);
            inst.addReplacement(re8);
        } else if (keyword.equals("Compleated")) {
            sb = "etbCounter:LOYALTY:PhySpent:CheckSVar$ PhySpent | SVarCompare$ LT0:Compleated (" + inst.getReminderText() + ")";
            re3 = CardFactoryUtil.makeEtbCounter((String)sb, card, intrinsic);
            card.setSVar("PhySpent", "Count$EachPhyrexianPaidWithLife/Negative");
            inst.addReplacement(re3);
        } else if (keyword.startsWith("Dredge")) {
            String dredgeAmount = keyword.split(":")[1];
            String actualRep = "Event$ Draw | ActiveZones$ Graveyard | ValidPlayer$ You | Secondary$ True | Optional$ True | CheckSVar$ DredgeCheckLib | SVarCompare$ GE" + dredgeAmount + " | AICheckDredge$ True | Description$ CARDNAME - Dredge " + dredgeAmount;
            String abString = "DB$ Mill | Defined$ You | NumCards$ " + dredgeAmount;
            String moveToPlay = "DB$ ChangeZone | Origin$ Graveyard | Destination$ Hand | Defined$ Self";
            SpellAbility saMill = AbilityFactory.getAbility(abString, card);
            AbilitySub saMove = (AbilitySub)AbilityFactory.getAbility("DB$ ChangeZone | Origin$ Graveyard | Destination$ Hand | Defined$ Self", card);
            saMill.setSubAbility(saMove);
            saMill.setIntrinsic(intrinsic);
            ReplacementEffect re9 = ReplacementHandler.parseReplacement(actualRep, host, intrinsic, (IHasSVars)card);
            re9.setOverridingAbility(saMill);
            re9.setSVar("DredgeCheckLib", "Count$ValidLibrary Card.YouOwn");
            inst.addReplacement(re9);
        } else if (keyword.equals("Daybound")) {
            String actualRep = "Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield | DayTime$ Night | Secondary$ True | Layer$ Transform | ReplacementResult$ Updated | Description$ If it is night, this permanent enters transformed.";
            String abTransform = "DB$ SetState | Defined$ ReplacedCard | Mode$ Transform | ETB$ True";
            re2 = ReplacementHandler.parseReplacement("Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield | DayTime$ Night | Secondary$ True | Layer$ Transform | ReplacementResult$ Updated | Description$ If it is night, this permanent enters transformed.", host, intrinsic, (IHasSVars)card);
            SpellAbility saTransform = AbilityFactory.getAbility("DB$ SetState | Defined$ ReplacedCard | Mode$ Transform | ETB$ True", card);
            re2.setOverridingAbility(saTransform);
            inst.addReplacement(re2);
        } else if (keyword.startsWith("Devour")) {
            k = keyword.split(":");
            String magnitude = k[1];
            String valid = "Creature";
            String[] s2 = k[0].split(" ");
            if (s2.length > 1) {
                valid = s2[1].substring(0, 1).toUpperCase() + s2[1].substring(1);
            }
            String sacrificeStr = "DB$ Sacrifice | Defined$ You | Amount$ DevourSacX | SacValid$ " + valid + ".Other | SacMessage$ another " + valid.toLowerCase() + " (Devour " + magnitude + ") | RememberSacrificed$ True | Optional$ True";
            String counterStr = "DB$ PutCounter | ETB$ True | Defined$ Self | CounterType$ P1P1 | CounterNum$ DevourX";
            String cleanupStr = "DB$ Cleanup | ClearRemembered$ True";
            AbilitySub sacrificeSA = (AbilitySub)AbilityFactory.getAbility(sacrificeStr, card);
            sacrificeSA.setSVar("DevourSacX", "Count$Valid " + valid + ".YouCtrl+Other");
            AbilitySub counterSA = (AbilitySub)AbilityFactory.getAbility(counterStr, card);
            counterSA.setSVar("DevourX", "Count$RememberedSize/Times." + magnitude);
            sacrificeSA.setSubAbility(counterSA);
            AbilitySub cleanupSA = (AbilitySub)AbilityFactory.getAbility(cleanupStr, card);
            counterSA.setSubAbility(cleanupSA);
            String repeffstr4 = "Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield | Secondary$ True | ReplacementResult$ Updated | Description$ Devour " + magnitude + " (" + inst.getReminderText() + ")";
            ReplacementEffect re10 = ReplacementHandler.parseReplacement(repeffstr4, host, intrinsic, (IHasSVars)card);
            re10.setOverridingAbility(sacrificeSA);
            inst.addReplacement(re10);
        } else if (keyword.startsWith("Fading")) {
            k = keyword.split(":");
            m4 = k[1];
            sb2 = new StringBuilder("etbCounter:FADE:");
            sb2.append(m4).append(":no Condition:");
            sb2.append("Fading ");
            sb2.append(m4);
            sb2.append(" (").append(inst.getReminderText()).append(")");
            re4 = CardFactoryUtil.makeEtbCounter(sb2.toString(), card, intrinsic);
            inst.addReplacement(re4);
        } else if (keyword.startsWith("Flashback")) {
            sb = new StringBuilder();
            ((StringBuilder)sb).append("Event$ Moved | ValidCard$ Card.Self | Origin$ Stack | ExcludeDestination$ Exile ");
            ((StringBuilder)sb).append("| ValidStackSa$ Spell.Flashback+castKeyword | Description$ Flashback");
            if (keyword.contains(":")) {
                String extraDesc;
                String[] k2 = keyword.split(":");
                cost = new Cost(k2[1], false);
                ((StringBuilder)sb).append(cost.isOnlyManaCost() ? " " : "\u2014").append(cost.toSimpleString());
                ((StringBuilder)sb).append(cost.isOnlyManaCost() ? "" : ".");
                String string = extraDesc = k2.length > 3 ? k2[3] : "";
                if (!extraDesc.isEmpty()) {
                    ((StringBuilder)sb).append(cost.isOnlyManaCost() ? ". " : " ").append(extraDesc);
                }
            }
            ((StringBuilder)sb).append(" (").append(inst.getReminderText()).append(")");
            repeffstr2 = ((StringBuilder)sb).toString();
            abExile = "DB$ ChangeZone | Defined$ Self | Origin$ Stack | Destination$ Exile";
            saExile = AbilityFactory.getAbility(abExile, card);
            if (!intrinsic) {
                saExile.setIntrinsic(false);
            }
            re5 = ReplacementHandler.parseReplacement(repeffstr2, host, intrinsic, (IHasSVars)card);
            re5.setOverridingAbility(saExile);
            inst.addReplacement(re5);
        } else if (keyword.startsWith("Graft")) {
            k = keyword.split(":");
            m4 = k[1];
            sb2 = new StringBuilder("etbCounter:P1P1:");
            sb2.append(m4).append(":no Condition:");
            sb2.append("Graft ");
            sb2.append(m4);
            sb2.append(" (").append(inst.getReminderText()).append(")");
            re4 = CardFactoryUtil.makeEtbCounter(sb2.toString(), card, intrinsic);
            inst.addReplacement(re4);
        } else if (keyword.startsWith("Impending")) {
            k = keyword.split(":");
            m4 = k[1];
            cost = new Cost(k[2], false);
            StringBuilder desc = new StringBuilder();
            desc.append("Impending ");
            desc.append(m4).append("\u2014").append(cost.toSimpleString());
            String effect = "DB$ PutCounter | Defined$ ReplacedCard | CounterType$ TIME | CounterNum$ " + m4 + " | ETB$ True | SpellDescription$ " + desc;
            re = CardFactoryUtil.createETBReplacement(card, ReplacementLayer.Other, effect, false, true, intrinsic, "Card.Self+impended", "");
            inst.addReplacement(re);
        } else if (keyword.equals("Jump-start")) {
            sb = new StringBuilder();
            ((StringBuilder)sb).append("Event$ Moved | ValidCard$ Card.Self | Origin$ Stack | ExcludeDestination$ Exile ");
            ((StringBuilder)sb).append("| Secondary$ True | ValidStackSa$ Spell.Jumpstart | Description$ Jump-start (");
            ((StringBuilder)sb).append(inst.getReminderText());
            ((StringBuilder)sb).append(")");
            repeffstr2 = ((StringBuilder)sb).toString();
            abExile = "DB$ ChangeZone | Defined$ Self | Origin$ Stack | Destination$ Exile";
            saExile = AbilityFactory.getAbility(abExile, card);
            if (!intrinsic) {
                saExile.setIntrinsic(false);
            }
            re5 = ReplacementHandler.parseReplacement(repeffstr2, host, intrinsic, (IHasSVars)card);
            re5.setOverridingAbility(saExile);
            inst.addReplacement(re5);
        } else if (keyword.startsWith("Madness")) {
            repeffstr = "Event$ Moved | ActiveZones$ Hand | ValidCard$ Card.Self | Discard$ True | Secondary$ True  | Description$ Madness: If you discard this card, discard it into exile.";
            re3 = ReplacementHandler.parseReplacement(repeffstr, host, intrinsic, (IHasSVars)card);
            String sVarMadness = "DB$ ChangeZone | Hidden$ True | Origin$ All | Destination$ Exile | Defined$ ReplacedCard";
            re3.setOverridingAbility(AbilityFactory.getAbility(sVarMadness, card));
            inst.addReplacement(re3);
        } else if (keyword.startsWith("Modular")) {
            k = keyword.split(":");
            m4 = k[1];
            sb2 = new StringBuilder("etbCounter:P1P1:");
            sb2.append(m4).append(":no Condition:");
            sb2.append("Modular ");
            if (!StringUtils.isNumeric(m4)) {
                sb2.append("- ");
            }
            sb2.append(m4);
            sb2.append(" (").append(inst.getReminderText()).append(")");
            re4 = CardFactoryUtil.makeEtbCounter(sb2.toString(), card, intrinsic);
            if ("Sunburst".equals(m4)) {
                re4.getOverridingAbility().setSVar("Sunburst", "Count$Converge");
            }
            inst.addReplacement(re4);
        } else if (keyword.equals("Ravenous")) {
            String repeffStr = "Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield |  | ReplacementResult$ Updated | Description$ Ravenous (" + inst.getReminderText() + ")";
            String counterStr = "DB$ PutCounter | CounterType$ P1P1 | ETB$ True | CounterNum$ X";
            SpellAbility countersSA = AbilityFactory.getAbility(counterStr, card);
            if (!intrinsic) {
                countersSA.setIntrinsic(false);
            }
            re4 = ReplacementHandler.parseReplacement(repeffStr, host, intrinsic, (IHasSVars)card);
            re4.setOverridingAbility(countersSA);
            countersSA.setSVar("X", "Count$xPaid");
            inst.addReplacement(re4);
        } else if (keyword.equals("Read ahead")) {
            repeffstr = "Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield | Secondary$ True | ReplacementResult$ Updated | Description$ Choose a chapter and start with that many lore counters.";
            String effStr = "DB$ PutCounter | Defined$ Self | CounterType$ LORE | ETB$ True | UpTo$ True | UpToMin$ 1 | ReadAhead$ True | CounterNum$ FinalChapterNr";
            SpellAbility saCounter = AbilityFactory.getAbility(effStr, card);
            saCounter.setSVar("FinalChapterNr", "Count$FinalChapterNr");
            if (!intrinsic) {
                saCounter.setIntrinsic(false);
            }
            re4 = ReplacementHandler.parseReplacement(repeffstr, host, intrinsic, (IHasSVars)card);
            re4.setOverridingAbility(saCounter);
            inst.addReplacement(re4);
        } else if (keyword.equals("Rebound")) {
            repeffstr = "Event$ Moved | ValidLKI$ Card.Self+wasCastFromHand+YouOwn+YouCtrl  | Origin$ Stack | Destination$ Graveyard | Fizzle$ False  | Description$ Rebound (" + inst.getReminderText() + ")";
            String abExile2 = "DB$ ChangeZone | Defined$ ReplacedCard | Origin$ Stack | Destination$ Exile | RememberChanged$ True";
            String delTrig = "DB$ DelayedTrigger | Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You  | OptionalDecider$ You | RememberObjects$ Remembered | TriggerDescription$ At the beginning of your next upkeep, you may cast " + card.toString() + " without paying its mana cost.";
            String abPlay = "DB$ Play | Defined$ DelayTriggerRememberedLKI | WithoutManaCost$ True | Optional$ True";
            SpellAbility saExile2 = AbilityFactory.getAbility(abExile2, card);
            AbilitySub delsub = (AbilitySub)AbilityFactory.getAbility(delTrig, card);
            AbilitySub saPlay = (AbilitySub)AbilityFactory.getAbility(abPlay, card);
            delsub.setAdditionalAbility("Execute", saPlay);
            saExile2.setSubAbility(delsub);
            if (!intrinsic) {
                saExile2.setIntrinsic(false);
            }
            ReplacementEffect re11 = ReplacementHandler.parseReplacement(repeffstr, host, intrinsic, (IHasSVars)card);
            re11.setOverridingAbility(saExile2);
            inst.addReplacement(re11);
        } else if (keyword.startsWith("Reflect:")) {
            k = keyword.split(":");
            String repeatStr = "DB$ RepeatEach | RepeatPlayers$ Opponent";
            String payStr = "DB$ ImmediateTrigger | RememberObjects$ Player.IsRemembered | TriggerDescription$ Copy CARDNAME | UnlessPayer$ Player.IsRemembered | UnlessSwitched$ True | UnlessCost$ " + k[1];
            String copyStr = "DB$ CopyPermanent | Defined$ Self | Controller$ Player.IsTriggerRemembered | RemoveKeywords$ Reflect";
            SpellAbility repeatSA = AbilityFactory.getAbility("DB$ RepeatEach | RepeatPlayers$ Opponent", card);
            AbilitySub paySA = (AbilitySub)AbilityFactory.getAbility(payStr, card);
            AbilitySub copySA = (AbilitySub)AbilityFactory.getAbility("DB$ CopyPermanent | Defined$ Self | Controller$ Player.IsTriggerRemembered | RemoveKeywords$ Reflect", card);
            repeatSA.setAdditionalAbility("RepeatSubAbility", paySA);
            paySA.setAdditionalAbility("Execute", copySA);
            ReplacementEffect cardre = CardFactoryUtil.createETBReplacement(card, ReplacementLayer.Other, repeatSA, false, true, intrinsic, "Card.Self", "");
            inst.addReplacement(cardre);
        } else if (keyword.equals("Riot")) {
            String hasteStr = "DB$ Animate | Defined$ Self | Keywords$ Haste | Duration$ Permanent | UnlessCost$ AddCounter<1/P1P1> | UnlessPayer$ You | UnlessAI$ Riot | SpellDescription$ Riot";
            SpellAbility hasteSa = AbilityFactory.getAbility("DB$ Animate | Defined$ Self | Keywords$ Haste | Duration$ Permanent | UnlessCost$ AddCounter<1/P1P1> | UnlessPayer$ You | UnlessAI$ Riot | SpellDescription$ Riot", card);
            ReplacementEffect cardre = CardFactoryUtil.createETBReplacement(card, ReplacementLayer.Other, hasteSa, false, true, intrinsic, "Card.Self", "");
            inst.addReplacement(cardre);
        } else if (keyword.equals("Sunburst")) {
            CounterType t2 = CounterType.get(host.isCreature() ? CounterEnumType.P1P1 : CounterEnumType.CHARGE);
            StringBuilder sb3 = new StringBuilder("etbCounter:");
            sb3.append(t2).append(":Sunburst:no Condition:");
            sb3.append("Sunburst (").append(inst.getReminderText()).append(")");
            re2 = CardFactoryUtil.makeEtbCounter(sb3.toString(), card, intrinsic);
            re2.getOverridingAbility().setSVar("Sunburst", "Count$Converge");
            inst.addReplacement(re2);
        } else if (keyword.startsWith("Tribute")) {
            k = keyword.split(":");
            String tributeAmount = k[1];
            String effect = "DB$ PutCounter | Defined$ ReplacedCard | CounterType$ P1P1 | CounterNum$ " + tributeAmount + " | ETB$ True | SpellDescription$ Tribute " + tributeAmount + " (" + inst.getReminderText() + ")";
            ReplacementEffect cardre = CardFactoryUtil.createETBReplacement(card, ReplacementLayer.Other, effect, false, true, intrinsic, "Card.Self", "");
            inst.addReplacement(cardre);
        } else if (keyword.equals("Umbra armor")) {
            repeffstr = "Event$ Destroy | ActiveZones$ Battlefield | ValidCard$ Card.EnchantedBy | Secondary$ True | Description$ Umbra armor (" + inst.getReminderText() + ")";
            String abprevDamage = "DB$ DealDamage | Defined$ ReplacedCard | Remove$ All";
            String abdestroy = "DB$ Destroy | Defined$ Self";
            SpellAbility sa = AbilityFactory.getAbility(abprevDamage, card);
            AbilitySub dessub = (AbilitySub)AbilityFactory.getAbility(abdestroy, card);
            sa.setSubAbility(dessub);
            if (!intrinsic) {
                sa.setIntrinsic(false);
            }
            re = ReplacementHandler.parseReplacement(repeffstr, host, intrinsic, (IHasSVars)card);
            re.setOverridingAbility(sa);
            inst.addReplacement(re);
        } else if (keyword.equals("Unleash")) {
            String effect = "DB$ PutCounter | Defined$ Self | CounterType$ P1P1 | ETB$ True | CounterNum$ 1 | SpellDescription$ Unleash (" + inst.getReminderText() + ")";
            ReplacementEffect cardre = CardFactoryUtil.createETBReplacement(card, ReplacementLayer.Other, effect, true, true, intrinsic, "Card.Self", "");
            inst.addReplacement(cardre);
        } else if (keyword.startsWith("Vanishing") && keyword.contains(":")) {
            k = keyword.split(":");
            m4 = k[1];
            sb2 = new StringBuilder("etbCounter:TIME:");
            sb2.append(m4).append(":no Condition:");
            sb2.append("Vanishing ");
            sb2.append(m4);
            sb2.append(" (").append(inst.getReminderText()).append(")");
            re4 = CardFactoryUtil.makeEtbCounter(sb2.toString(), card, intrinsic);
            inst.addReplacement(re4);
        }
        if (keyword.startsWith("Prevent all ")) {
            boolean isCombat = false;
            boolean from = false;
            boolean to = false;
            if (keyword.equals("Prevent all combat damage that would be dealt to and dealt by CARDNAME.")) {
                to = true;
                from = true;
                isCombat = true;
            } else if (keyword.equals("Prevent all combat damage that would be dealt by CARDNAME.")) {
                from = true;
                isCombat = true;
            } else if (keyword.equals("Prevent all combat damage that would be dealt to CARDNAME.")) {
                to = true;
                isCombat = true;
            } else if (keyword.equals("Prevent all damage that would be dealt to and dealt by CARDNAME.")) {
                to = true;
                from = true;
            } else if (keyword.equals("Prevent all damage that would be dealt by CARDNAME.")) {
                from = true;
            } else if (keyword.equals("Prevent all damage that would be dealt to CARDNAME.")) {
                to = true;
            }
            String rep = "Event$ DamageDone | Prevent$ True";
            if (isCombat) {
                rep = rep + "| IsCombat$ True";
            }
            rep = rep + "| Secondary$ True | Description$ " + keyword;
            if (from) {
                String fromRep = rep + " | ValidSource$ Card.Self";
                re = ReplacementHandler.parseReplacement(fromRep, host, intrinsic, (IHasSVars)card);
                inst.addReplacement(re);
            }
            if (to) {
                String toRep = rep + " | ValidTarget$ Card.Self";
                re = ReplacementHandler.parseReplacement(toRep, host, intrinsic, (IHasSVars)card);
                inst.addReplacement(re);
            }
        } else if (keyword.startsWith("Protection")) {
            String validSource = CardFactoryUtil.getProtectionValid(keyword, true);
            String rep = "Event$ DamageDone | Prevent$ True | ActiveZones$ Battlefield | ValidTarget$ Card.Self";
            if (!validSource.isEmpty()) {
                rep = rep + " | ValidSource$ " + validSource;
            }
            rep = rep + " | Secondary$ True | Description$ " + keyword;
            re2 = ReplacementHandler.parseReplacement(rep, host, intrinsic, (IHasSVars)card);
            inst.addReplacement(re2);
        }
        if (keyword.startsWith("ETBReplacement")) {
            String[] splitkw = keyword.split(":");
            ReplacementLayer layer = ReplacementLayer.smartValueOf(splitkw[1]);
            boolean optional = splitkw.length >= 4 && splitkw[3].contains("Optional");
            String valid = splitkw.length >= 6 ? splitkw[5] : "Card.Self";
            String zone = splitkw.length >= 5 ? splitkw[4] : "";
            re = CardFactoryUtil.createETBReplacement(card, layer, card.getSVar(splitkw[2]), optional, false, intrinsic, valid, zone);
            inst.addReplacement(re);
        } else if (keyword.startsWith("etbCounter")) {
            ReplacementEffect re12 = CardFactoryUtil.makeEtbCounter(keyword, card, intrinsic);
            inst.addReplacement(re12);
        }
    }

    public static void addSpellAbility(KeywordInterface inst, CardState card, boolean intrinsic) {
        String keyword = inst.getOriginal();
        Card host = card.getCard();
        if (keyword.startsWith("Adapt")) {
            String[] k = keyword.split(":");
            String magnitude = k[1];
            String manacost = k[2];
            String reduceCost = k.length > 3 ? k[3] : null;
            String desc = "Adapt " + magnitude;
            String effect = "AB$ PutCounter | Cost$ " + manacost + " | Adapt$ True | CounterNum$ " + magnitude + " | CounterType$ P1P1 | StackDescription$ SpellDescription";
            if (reduceCost != null) {
                effect = effect + "| ReduceCost$ " + reduceCost;
                desc = desc + ". This ability costs {1} less to activate for each " + k[4] + ".";
            }
            effect = effect + "| SpellDescription$ " + desc + " (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.equals("Aftermath") && card.getStateName().equals((Object)CardStateName.RightSplit)) {
            SpellAbility origSA = card.getFirstSpellAbility();
            origSA.setAftermath(true);
            origSA.getRestrictions().setZone(ZoneType.Graveyard);
        } else if (keyword.startsWith("Aura swap")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String effect = "AB$ ExchangeZone | Cost$ " + manacost + " | Zone2$ Hand | Type$ Aura  | PrecostDesc$ Aura swap | CostDesc$ " + ManaCostParser.parse(manacost) + " | StackDescription$ SpellDescription | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Awaken")) {
            String[] k = keyword.split(":");
            String counters = k[1];
            Cost awakenCost = new Cost(k[2], false);
            SpellAbility awakenSpell = card.getFirstSpellAbility().copyWithDefinedCost(awakenCost);
            String awaken = "DB$ PutCounter | CounterType$ P1P1 | CounterNum$ " + counters + " | ValidTgts$ Land.YouCtrl | TgtPrompt$ Select target land you control | Awaken$ True";
            String animate = "DB$ Animate | Defined$ ParentTarget | Power$ 0 | Toughness$ 0 | Types$ Creature,Elemental | Duration$ Permanent | Keywords$ Haste";
            AbilitySub awakenSub = (AbilitySub)AbilityFactory.getAbility(awaken, card);
            AbilitySub animateSub = (AbilitySub)AbilityFactory.getAbility("DB$ Animate | Defined$ ParentTarget | Power$ 0 | Toughness$ 0 | Types$ Creature,Elemental | Duration$ Permanent | Keywords$ Haste", card);
            awakenSub.setSubAbility(animateSub);
            awakenSpell.appendSubAbility(awakenSub);
            String desc = "Awaken " + counters + "\u2014" + awakenCost.toSimpleString() + " (" + inst.getReminderText() + ")";
            awakenSpell.setDescription(desc);
            awakenSpell.setAlternativeCost(AlternativeCost.Awaken);
            awakenSpell.setIntrinsic(intrinsic);
            inst.addSpellAbility(awakenSpell);
        } else if (keyword.startsWith("Bestow")) {
            String[] params = keyword.split(":");
            String cost = params[1];
            StringBuilder sbAttach = new StringBuilder();
            sbAttach.append("SP$ Attach | Cost$ ");
            sbAttach.append(cost);
            sbAttach.append(" | AILogic$ ").append(params.length > 2 ? params[2] : "Pump");
            sbAttach.append(" | Bestow$ True | ValidTgts$ Creature");
            SpellAbility sa = AbilityFactory.getAbility(sbAttach.toString(), card);
            StringBuilder sbDesc = new StringBuilder();
            sbDesc.append("Bestow");
            Cost bCost = new Cost(cost, false);
            boolean onlyMana = bCost.isOnlyManaCost();
            String remTxt = inst.getReminderText();
            if (!onlyMana) {
                StringBuilder sbRem = new StringBuilder();
                sbRem.append("To pay this bestow cost, ");
                int i = 0;
                for (CostPart part : bCost.getCostParts()) {
                    if (part instanceof CostPartMana) {
                        sbRem.append("pay ").append(part);
                    } else if (part instanceof CostCollectEvidence) {
                        sbRem.append("exile cards with total mana value ").append(part.getAmount());
                        sbRem.append(" or greater from your graveyard");
                    } else {
                        sbRem.append(part);
                    }
                    sbRem.append(i + 1 == bCost.getCostParts().size() ? "." : " and ");
                    ++i;
                }
                remTxt = sbRem.toString();
            }
            sbDesc.append(onlyMana ? " " : "\u2014").append(bCost.toSimpleString()).append(!onlyMana ? "." : "");
            sbDesc.append(" (").append(remTxt).append(")");
            sa.setDescription(sbDesc.toString());
            sa.setStackDescription("Bestow - " + card.getName());
            sa.setAlternativeCost(AlternativeCost.Bestow);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Blitz")) {
            String[] k = keyword.split(":");
            Cost blitzCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithManaCostReplaced(host.getController(), blitzCost);
            if (k.length > 2) {
                newSA.getMapParams().put("ValidAfterStack", k[2]);
            }
            StringBuilder desc = new StringBuilder();
            desc.append("Blitz ").append(blitzCost.toSimpleString()).append(" (");
            desc.append(inst.getReminderText());
            desc.append(")");
            newSA.setDescription(desc.toString());
            StringBuilder sb = new StringBuilder();
            sb.append(card.getName()).append(" (Blitz)");
            newSA.setStackDescription(sb.toString());
            newSA.setAlternativeCost(AlternativeCost.Blitz);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.equals("Cipher")) {
            String dbStr = "DB$ Encode";
            AbilitySub newSA = (AbilitySub)AbilityFactory.getAbility(dbStr, card);
            SpellAbility origSA = card.getFirstSpellAbility();
            origSA.appendSubAbility(newSA);
        } else if (keyword.startsWith("Class")) {
            String[] k = keyword.split(":");
            int level = Integer.parseInt(k[1]);
            StringBuilder sbClass = new StringBuilder();
            sbClass.append("AB$ ClassLevelUp | Cost$ ").append(k[2]);
            sbClass.append(" | ClassLevel$ EQ").append(level - 1);
            sbClass.append(" | SorcerySpeed$ True");
            sbClass.append(" | StackDescription$ SpellDescription | SpellDescription$ Level ").append(level);
            SpellAbility sa = AbilityFactory.getAbility(sbClass.toString(), card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Dash")) {
            String[] k = keyword.split(":");
            Cost dashCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithDefinedCost(dashCost);
            StringBuilder desc = new StringBuilder();
            desc.append("Dash ").append(dashCost.toSimpleString()).append(" (");
            desc.append(inst.getReminderText());
            desc.append(")");
            newSA.setDescription(desc.toString());
            StringBuilder sb = new StringBuilder();
            sb.append(card.getName()).append(" (Dash)");
            newSA.setStackDescription(sb.toString());
            newSA.setAlternativeCost(AlternativeCost.Dash);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Disguise")) {
            String[] k = keyword.split(":");
            String reduceCost = k.length > 2 ? k[2] : null;
            SpellAbility faceDown = CardFactoryUtil.abilityCastFaceDown(card, intrinsic, "Disguise");
            faceDown.putParam("FaceDownKeyword", "Ward:2");
            SpellAbility faceUp = CardFactoryUtil.abilityDisguiseUp(card, k[1], intrinsic);
            if (reduceCost != null) {
                faceUp.putParam("ReduceCost", reduceCost);
                faceUp.setSVar(reduceCost, card.getSVar(reduceCost));
            }
            inst.addSpellAbility(faceDown);
            inst.addSpellAbility(faceUp);
        } else if (keyword.startsWith("Disturb")) {
            String[] k = keyword.split(":");
            Cost disturbCost = new Cost(k[1], true);
            SpellAbility newSA = host.getAlternateState().getFirstSpellAbilityWithFallback().copyWithDefinedCost(disturbCost);
            newSA.setCardState(host.getAlternateState());
            StringBuilder sbCost = new StringBuilder("Disturb");
            if (!disturbCost.isOnlyManaCost()) {
                sbCost.append("\u2014");
            } else {
                sbCost.append(" ");
            }
            newSA.putParam("PrecostDesc", sbCost.toString());
            newSA.putParam("CostDesc", disturbCost.toString());
            StringBuilder desc = new StringBuilder();
            desc.append(newSA.getCostDescription());
            desc.append("(").append(inst.getReminderText()).append(")");
            newSA.setDescription(desc.toString());
            newSA.putParam("AfterDescription", "(Disturbed)");
            newSA.setAlternativeCost(AlternativeCost.Disturb);
            newSA.getRestrictions().setZone(ZoneType.Graveyard);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Emerge")) {
            String[] kw = keyword.split(":");
            String costStr = kw[1];
            String validStr = kw.length > 2 ? kw[2] : "Creature";
            String desc = "(Emerge";
            if (kw.length > 2) {
                desc = desc + " from " + kw[2].toLowerCase();
            }
            desc = desc + ")";
            SpellAbility sa = card.getFirstSpellAbility();
            SpellAbility newSA = sa.copyWithDefinedCost(new Cost(costStr, false));
            newSA.getRestrictions().setIsPresent(validStr + ".YouCtrl+CanBeSacrificedBy");
            newSA.putParam("Secondary", "True");
            newSA.setAlternativeCost(AlternativeCost.Emerge);
            newSA.setDescription(sa.getDescription() + " " + desc);
            newSA.putParam("AfterDescription", desc);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Embalm")) {
            String[] kw = keyword.split(":");
            String costStr = kw[1];
            String effect = "AB$ CopyPermanent | Cost$ " + costStr + " ExileFromGrave<1/CARDNAME> | ActivationZone$ Graveyard | SorcerySpeed$ True | RemoveCost$ True | SetColor$ White | AddTypes$ Zombie| PrecostDesc$ Embalm | CostDesc$ " + ManaCostParser.parse(costStr) + " | Defined$ Self | StackDescription$ Embalm - CARDNAME | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.equals("Epic")) {
            String dbStr = "DB$ Effect | Triggers$ EpicTrigger | StaticAbilities$ EpicCantBeCast | Duration$ Permanent | Epic$ True";
            AbilitySub newSA = (AbilitySub)AbilityFactory.getAbility(dbStr, card);
            newSA.setSVar("EpicCantBeCast", "Mode$ CantBeCast | ValidCard$ Card | Caster$ You | EffectZone$ Command | Description$ For the rest of the game, you can't cast spells.");
            newSA.setSVar("EpicTrigger", "Mode$ Phase | Phase$ Upkeep | ValidPlayer$ You | Execute$ EpicCopy | TriggerDescription$ At the beginning of each of your upkeeps, copy " + card.toString() + " except for its epic ability.");
            newSA.setSVar("EpicCopy", "DB$ CopySpellAbility | Defined$ EffectSource | Epic$ True | MayChooseTarget$ True");
            SpellAbility origSA = card.getFirstSpellAbility();
            origSA.appendSubAbility(newSA);
        } else if (keyword.startsWith("Craft")) {
            if (!keyword.contains(":")) {
                System.err.println("Malformed Craft entry! - Card: " + card.toString());
                return;
            }
            String[] k = keyword.split(":");
            StringBuilder cd2 = new StringBuilder();
            cd2.append(k[0]).append(" with ");
            Cost kCost = new Cost(k[1], true);
            boolean plural = false;
            if (k[1].contains("XMin")) {
                String cutString = k[1].substring(k[1].indexOf("XMin") + 4);
                int number = Integer.parseInt(cutString.substring(0, cutString.indexOf(" ")));
                cd2.append(Lang.getNumeral(number)).append(" or more ");
                plural = true;
            }
            if (k.length > 2) {
                cd2.append(k[2].isEmpty() ? "" : k[2] + " ");
            } else {
                for (CostPart part : kCost.getCostParts()) {
                    String singNoun;
                    String partType;
                    int amt;
                    if (!(part instanceof CostExile)) continue;
                    String amount = part.getAmount();
                    if (StringUtils.isNumeric(amount) && (amt = Integer.parseInt(amount)) > 1) {
                        cd2.append(Lang.getNumeral(amt)).append(" ");
                        plural = true;
                    }
                    if ((partType = part.getType()).contains(".Other")) {
                        partType = partType.replace(".Other", "");
                    }
                    String string = part.getTypeDescription() != null ? part.getTypeDescription() : (singNoun = CardType.CoreType.isValidEnum(partType) ? partType.toLowerCase() : partType);
                    if (singNoun.equalsIgnoreCase("Permanent")) break;
                    String plurNoun = !singNoun.contains(" ") ? Lang.getPlural(singNoun) : singNoun;
                    cd2.append(plural ? plurNoun : singNoun).append(" ");
                    break;
                }
            }
            cd2.append(kCost.getCostMana() != null ? kCost.getCostMana().toString() : "no mana?");
            String ab = "AB$ ChangeZone | CostDesc$ " + cd2.toString() + " | Cost$ Exile<1/CARDNAME> " + k[1] + " | Origin$ Exile | Destination$ Battlefield | Transformed$ True | Defined$ CorrectedSelf | XAnnounceTitle$ " + Localizer.getInstance().getMessage("lblCraft", new Object[0]) + " | SorcerySpeed$ True | StackDescription$ Return this card transformed under its owner's control. (Craft) | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility newSA = AbilityFactory.getAbility(ab, card);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Equip")) {
            Cost cost;
            if (!keyword.contains(":")) {
                System.err.println("Malformed Equip entry! - Card: " + card.toString());
                return;
            }
            String[] k = keyword.split(":");
            String equipCost = k[1];
            String valid = k.length > 2 && !k[2].isEmpty() ? k[2] : "Creature.YouCtrl";
            String vstr = k.length > 3 && !k[3].isEmpty() ? k[3] : "creature";
            String extra = k.length > 4 ? k[4] : "";
            boolean altCost = extra.contains("AlternateCost");
            String extraDesc = k.length > 5 ? k[5] : "";
            StringBuilder abilityStr = new StringBuilder();
            abilityStr.append("AB$ Attach | Cost$ ");
            abilityStr.append(equipCost);
            abilityStr.append(" | ValidTgts$ ").append(valid);
            abilityStr.append(" | TgtPrompt$ Select target ").append(vstr).append(" you control");
            abilityStr.append(" | SorcerySpeed$ True | AILogic$ Pump");
            if (card.hasSVar("AttachAi")) {
                abilityStr.append("| ").append(card.getSVar("AttachAi"));
            }
            abilityStr.append(" | PrecostDesc$ Equip");
            if (k.length > 3 && !k[3].isEmpty()) {
                abilityStr.append(" ").append(vstr);
            }
            if (!(cost = new Cost(equipCost, true)).isOnlyManaCost() || altCost && extra.contains("<")) {
                abilityStr.append("\u2014");
            } else {
                abilityStr.append(" ");
            }
            if (!altCost) {
                abilityStr.append("| CostDesc$ ").append(cost.toSimpleString()).append(" ");
            }
            abilityStr.append(" | SpellDescription$ ");
            if (!extraDesc.isEmpty()) {
                abilityStr.append(". ").append(extraDesc).append(". ");
            }
            if (!altCost) {
                abilityStr.append("(").append(inst.getReminderText()).append(")");
            }
            if (!extra.isEmpty()) {
                abilityStr.append(" | ").append(extra);
            }
            SpellAbility newSA = AbilityFactory.getAbility(abilityStr.toString(), card);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Eternalize")) {
            String[] kw = keyword.split(":");
            String costStr = kw[1];
            Cost cost = new Cost(costStr, true);
            StringBuilder sb = new StringBuilder();
            sb.append("AB$ CopyPermanent | Cost$ ").append(costStr).append(" ExileFromGrave<1/CARDNAME>").append(" | Defined$ Self | ActivationZone$ Graveyard | SorcerySpeed$ True").append(" | RemoveCost$ True | SetColor$ Black | AddTypes$ Zombie | SetPower$ 4 | SetToughness$ 4");
            sb.append(" | PrecostDesc$ Eternalize");
            if (!cost.isOnlyManaCost()) {
                sb.append("\u2014");
            } else {
                sb.append(" ");
            }
            costStr = cost.toString();
            sb.append("| CostDesc$ ").append(costStr, 0, costStr.length() - 2);
            if (!cost.isOnlyManaCost()) {
                sb.append(".");
            }
            sb.append(" | StackDescription$ Eternalize - CARDNAME ").append("| SpellDescription$ (").append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(sb.toString(), card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Evoke")) {
            String[] k = keyword.split(":");
            Cost evokedCost = new Cost(k[1], false);
            SpellAbility sa = card.getFirstSpellAbility();
            SpellAbility newSA = sa.copyWithDefinedCost(evokedCost);
            StringBuilder desc = new StringBuilder();
            boolean onlyMana = evokedCost.isOnlyManaCost();
            desc.append("Evoke").append(onlyMana ? " " : "\u2014").append(evokedCost.toSimpleString());
            desc.append(onlyMana ? "" : ".").append(" (").append(inst.getReminderText()).append(")");
            newSA.setDescription(desc.toString());
            StringBuilder sb = new StringBuilder();
            sb.append(card.getName()).append(" (Evoked)");
            newSA.setStackDescription(sb.toString());
            newSA.setAlternativeCost(AlternativeCost.Evoke);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Foretell")) {
            AbilityStatic foretell = new AbilityStatic(card.getCard(), new Cost(ManaCost.TWO, false), null){

                @Override
                public boolean canPlay() {
                    if (!this.getRestrictions().canPlay(this.getHostCard(), this)) {
                        return false;
                    }
                    Player activator = this.getActivatingPlayer();
                    Game game = activator.getGame();
                    return activator.hasKeyword("Foretell on any player's turn") || game.getPhaseHandler().isPlayerTurn(activator);
                }

                @Override
                public boolean isForetelling() {
                    return true;
                }

                @Override
                public void resolve() {
                    Game game = this.getHostCard().getGame();
                    EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                    CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, this);
                    Card c = game.getAction().exile(this.getHostCard(), (SpellAbility)this, moveParams);
                    zoneMovements.triggerChangesZoneAll(game, this);
                    c.setForetold(true);
                    c.turnFaceDown(true);
                    c.addMayLookTemp(this.getActivatingPlayer());
                    this.getActivatingPlayer().addForetoldThisTurn();
                    if (!this.isIntrinsic()) {
                        c.setForetoldCostByEffect(true);
                    }
                    String sb = TextUtil.concatWithSpace(this.getActivatingPlayer().toString(), "has foretold.");
                    game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
                    game.fireEvent(new GameEventCardForetold(this.getActivatingPlayer()));
                }
            };
            StringBuilder sbDesc = new StringBuilder();
            sbDesc.append("Foretell (").append(inst.getReminderText()).append(")");
            foretell.setDescription(sbDesc.toString());
            foretell.putParam("Secondary", "True");
            foretell.setCardState(card);
            foretell.getRestrictions().setZone(ZoneType.Hand);
            foretell.setIntrinsic(intrinsic);
            inst.addSpellAbility(foretell);
        } else if (keyword.startsWith("Fortify")) {
            String[] k = keyword.split(":");
            String equipCost = k[1];
            StringBuilder abilityStr = new StringBuilder();
            abilityStr.append("AB$ Attach | Cost$ ");
            abilityStr.append(equipCost);
            abilityStr.append(" | ValidTgts$ Land.YouCtrl | TgtPrompt$ Select target land you control ");
            abilityStr.append("| SorcerySpeed$ True | AILogic$ Pump | IsPresent$ Fortification.Self+nonCreature ");
            abilityStr.append("| PrecostDesc$ Fortify");
            Cost cost = new Cost(equipCost, true);
            abilityStr.append(cost.isOnlyManaCost() ? " " : "\u2014");
            abilityStr.append("| CostDesc$ ").append(cost.toSimpleString());
            abilityStr.append(" | SpellDescription$ (");
            abilityStr.append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(abilityStr.toString(), card);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Freerunning")) {
            String[] k = keyword.split(":");
            Cost freerunningCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbilityWithFallback().copyWithDefinedCost(freerunningCost);
            if (host.isInstant() || host.isSorcery()) {
                newSA.putParam("Secondary", "True");
            }
            newSA.putParam("PrecostDesc", "Freerunning");
            StringBuilder costDesc = new StringBuilder();
            if (!freerunningCost.isOnlyManaCost()) {
                costDesc.append("\u2014");
            } else {
                costDesc.append(" ");
            }
            costDesc.append(freerunningCost.toSimpleString());
            newSA.putParam("CostDesc", costDesc.toString());
            StringBuilder sb = new StringBuilder();
            sb.append(newSA.getCostDescription());
            sb.append("(").append(inst.getReminderText()).append(")");
            newSA.setDescription(sb.toString());
            newSA.setAlternativeCost(AlternativeCost.Freerunning);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Fuse") && card.getStateName().equals((Object)CardStateName.Original)) {
            SpellAbility sa = AbilityFactory.buildFusedAbility(card.getCard());
            card.addSpellAbility(sa);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Haunt")) {
            if (!host.isCreature() && intrinsic) {
                String[] k = keyword.split(":");
                String hauntSVarName = k[1];
                String abString = TextUtil.concatNoSpace(TextUtil.fastReplace(card.getSVar(hauntSVarName), "DB$", "SP$"), " | Cost$ 0 | StackDescription$ SpellDescription");
                SpellAbility sa = AbilityFactory.getAbility(abString, card);
                sa.setPayCosts(new Cost(card.getManaCost(), false));
                sa.setIntrinsic(intrinsic);
                inst.addSpellAbility(sa);
            }
        } else if (keyword.startsWith("Impending")) {
            String[] k = keyword.split(":");
            Cost cost = new Cost(k[2], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithDefinedCost(cost);
            newSA.putParam("PrecostDesc", "Impending");
            StringBuilder costDesc = new StringBuilder();
            costDesc.append(k[1]).append("\u2014").append(cost.toSimpleString());
            newSA.putParam("CostDesc", costDesc.toString());
            StringBuilder sb = new StringBuilder();
            sb.append(newSA.getCostDescription());
            sb.append("(").append(inst.getReminderText()).append(")");
            newSA.setDescription(sb.toString());
            newSA.setAlternativeCost(AlternativeCost.Impending);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Level up")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            StringBuilder sb = new StringBuilder();
            sb.append("AB$ PutCounter | Cost$ ").append(manacost).append(" | PrecostDesc$ Level up | CostDesc$ ");
            sb.append(ManaCostParser.parse(manacost)).append(" | SorcerySpeed$ True | LevelUp$ True | Secondary$ True");
            sb.append("| CounterType$ LEVEL | StackDescription$ {p:You} levels up {c:Self}.");
            if (card.hasSVar("maxLevel")) {
                String strMaxLevel = card.getSVar("maxLevel");
                sb.append("| MaxLevel$ ").append(strMaxLevel);
            }
            sb.append(" | SpellDescription$ (").append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(sb.toString(), card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Monstrosity")) {
            String[] k = keyword.split(":");
            String magnitude = k[1];
            String manacost = k[2];
            String reduceCost = k.length > 3 ? k[3] : null;
            String desc = "Monstrosity " + magnitude;
            String effect = "AB$ PutCounter | Cost$ " + manacost + " | ConditionPresent$ Card.Self+!IsMonstrous | Monstrosity$ True | CounterNum$ " + magnitude + " | CounterType$ P1P1 | StackDescription$ SpellDescription";
            if (reduceCost != null) {
                effect = effect + "| ReduceCost$ " + reduceCost;
                desc = desc + ". This ability costs {1} less to activate for each " + k[4] + ".";
            }
            if (card.hasSVar("MonstrosityAILogic")) {
                effect = effect + "| AILogic$ " + card.getSVar("MonstrosityAILogic");
            }
            effect = effect + "| SpellDescription$ " + desc + " (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Morph")) {
            String[] k = keyword.split(":");
            inst.addSpellAbility(CardFactoryUtil.abilityCastFaceDown(card, intrinsic, "Morph"));
            inst.addSpellAbility(CardFactoryUtil.abilityMorphUp(card, k[1], false, intrinsic));
        } else if (keyword.startsWith("Megamorph")) {
            String[] k = keyword.split(":");
            inst.addSpellAbility(CardFactoryUtil.abilityCastFaceDown(card, intrinsic, "Morph"));
            inst.addSpellAbility(CardFactoryUtil.abilityMorphUp(card, k[1], true, intrinsic));
        } else if (keyword.startsWith("More Than Meets the Eye")) {
            String[] n = keyword.split(":");
            Cost convertCost = new Cost(n[1], false);
            SpellPermanent sa = new SpellPermanent(host, host.getAlternateState(), convertCost);
            sa.setDescription(host.getAlternateState().getName() + " (" + inst.getReminderText() + ")");
            sa.setCardState(host.getAlternateState());
            sa.setAlternativeCost(AlternativeCost.MTMtE);
            sa.putParam("PrecostDesc", n[0] + " ");
            sa.putParam("CostDesc", convertCost.toString());
            sa.putParam("AfterDescription", "(Converted)");
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Mutate")) {
            String[] params = keyword.split(":");
            String cost = params[1];
            StringBuilder sbMutate = new StringBuilder();
            sbMutate.append("SP$ Mutate | Cost$ ");
            sbMutate.append(cost);
            sbMutate.append(" | ValidTgts$ Creature.sharesOwnerWith+nonHuman");
            SpellAbility sa = AbilityFactory.getAbility(sbMutate.toString(), card);
            sa.setDescription("Mutate " + ManaCostParser.parse(cost) + " (" + inst.getReminderText() + ")");
            sa.setStackDescription("Mutate - " + card.getName());
            sa.setAlternativeCost(AlternativeCost.Mutate);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Ninjutsu")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String desc = "Ninjutsu";
            boolean commander = false;
            if (k.length > 2 && k[2].equals("Commander")) {
                desc = "Commander " + desc;
                commander = true;
            }
            String effect = "AB$ ChangeZone | Cost$ " + manacost + " Return<1/Creature.attacking+unblocked/unblocked attacker> | PrecostDesc$ " + desc + " | CostDesc$ " + ManaCostParser.parse(manacost) + "| ActivationZone$ Hand | Origin$ Hand| Destination$ Battlefield | Defined$ Self | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
            if (commander) {
                effect = "AB$ ChangeZone | Cost$ " + manacost + " Return<1/Creature.attacking+unblocked/unblocked attacker> | PrecostDesc$ " + desc + " | CostDesc$ " + ManaCostParser.parse(manacost) + "| ActivationZone$ Command | Origin$ Command| Destination$ Battlefield | Defined$ Self | Secondary$ True | SpellDescription$ (" + inst.getReminderText() + ")";
                sa = AbilityFactory.getAbility(effect, card);
                sa.setIntrinsic(intrinsic);
                inst.addSpellAbility(sa);
            }
        } else if (keyword.startsWith("Outlast")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            StringBuilder abilityStr = new StringBuilder();
            abilityStr.append("AB$ PutCounter | Cost$ ");
            abilityStr.append(manacost);
            abilityStr.append(" T | Defined$ Self | CounterType$ P1P1 | CounterNum$ 1 ");
            abilityStr.append("| SorcerySpeed$ True | PrecostDesc$ Outlast");
            Cost cost = new Cost(manacost, true);
            if (!cost.isOnlyManaCost()) {
                abilityStr.append("\u2014");
            } else {
                abilityStr.append(" ");
            }
            abilityStr.append("| CostDesc$ ").append(cost.toSimpleString());
            abilityStr.append(" | SpellDescription$ (").append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(abilityStr.toString(), card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Overload")) {
            String[] k = keyword.split(":");
            Cost overloadCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithDefinedCost(overloadCost);
            TargetRestrictions tgt = newSA.getTargetRestrictions();
            String defined = String.join((CharSequence)",", tgt.getValidTgts());
            if (tgt.canTgtPlayer()) {
                newSA.putParam("Defined", defined);
            } else {
                String zoneDef = "";
                if (!tgt.getZone().contains((Object)ZoneType.Battlefield)) {
                    zoneDef = StringUtils.join(tgt.getZone(), ",");
                }
                if (newSA.hasParam("TargetType")) {
                    defined = defined.replaceAll("Card", newSA.getParam("TargetType"));
                }
                newSA.putParam("Defined", "Valid" + zoneDef + " " + defined);
            }
            newSA.setTargetRestrictions(null);
            if (host.isInstant() || host.isSorcery()) {
                newSA.putParam("Secondary", "True");
            }
            newSA.putParam("PrecostDesc", "Overload");
            newSA.putParam("CostDesc", ManaCostParser.parse(k[1]));
            String stackD = newSA.getDescription().replaceAll("Target", "Each").replaceAll("target", "each");
            newSA.putParam("StackDescription", stackD);
            StringBuilder sb = new StringBuilder();
            sb.append(newSA.getCostDescription());
            sb.append("(").append(inst.getReminderText()).append(")");
            newSA.setDescription(sb.toString());
            newSA.getOriginalMapParams().putAll(newSA.getMapParams());
            newSA.setIntrinsic(intrinsic);
            newSA.setAlternativeCost(AlternativeCost.Overload);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Plot")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            AbilityStatic plot = new AbilityStatic(card.getCard(), new Cost(manacost, false), null){

                @Override
                public boolean canPlay() {
                    this.getRestrictions().setZone(ZoneType.Hand);
                    if (StaticAbilityPlotZone.plotZone(this.getHostCard())) {
                        this.getRestrictions().setZone(this.getHostCard().getLastKnownZone().getZoneType());
                    }
                    return this.getRestrictions().canPlay(this.getHostCard(), this);
                }

                @Override
                public boolean isPlotting() {
                    return true;
                }

                @Override
                public void resolve() {
                    Game game = this.getHostCard().getGame();
                    EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                    CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, this);
                    Card c = game.getAction().exile(this.getHostCard(), (SpellAbility)this, moveParams);
                    zoneMovements.triggerChangesZoneAll(game, this);
                    c.setPlotted(true);
                }
            };
            StringBuilder sbDesc = new StringBuilder();
            sbDesc.append("Plot (").append(inst.getReminderText()).append(")");
            plot.setDescription(sbDesc.toString());
            plot.putParam("Secondary", "True");
            plot.setCardState(card);
            plot.getRestrictions().setSorcerySpeed(true);
            plot.setIntrinsic(intrinsic);
            inst.addSpellAbility(plot);
        } else if (keyword.startsWith("Prototype")) {
            String[] k = keyword.split(":");
            if (k.length < 4) {
                System.err.println("Malformed Prototype entry! - Card: " + card.toString());
                return;
            }
            Cost protoCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithDefinedCost(protoCost);
            newSA.putParam("SetManaCost", k[1]);
            newSA.putParam("SetColorByManaCost", "True");
            newSA.putParam("SetPower", k[2]);
            newSA.putParam("SetToughness", k[3]);
            newSA.putParam("Prototype", "True");
            newSA.getOriginalMapParams().putAll(newSA.getMapParams());
            newSA.setDescription(k[0] + " " + ManaCostParser.parse(k[1]) + " [" + k[2] + "/" + k[3] + "]");
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Prowl")) {
            String[] k = keyword.split(":");
            Cost prowlCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbilityWithFallback().copyWithDefinedCost(prowlCost);
            if (host.isInstant() || host.isSorcery()) {
                newSA.putParam("Secondary", "True");
            }
            newSA.putParam("PrecostDesc", "Prowl");
            newSA.putParam("CostDesc", ManaCostParser.parse(k[1]));
            StringBuilder sb = new StringBuilder();
            sb.append(newSA.getCostDescription());
            sb.append("(").append(inst.getReminderText()).append(")");
            newSA.setDescription(sb.toString());
            newSA.setAlternativeCost(AlternativeCost.Prowl);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Reconfigure")) {
            if (!keyword.contains(":")) {
                System.err.println("Malformed Reconfigure entry! - Card: " + card.toString());
                return;
            }
            String[] k = keyword.split(":");
            String extra = k.length > 2 ? " | AlternateCost$ " + k[2] : "";
            String bothStr = "| Cost$ " + k[1] + " | SorcerySpeed$ True | Reconfigure$ True | PrecostDesc$ Reconfigure | Secondary$ True" + extra;
            StringBuilder attachStr = new StringBuilder();
            attachStr.append("AB$ Attach | ValidTgts$ Creature.YouCtrl+Other | TgtPrompt$ Select target creature you control ");
            attachStr.append("| AILogic$ Pump | SpellDescription$ Attach ").append(bothStr);
            StringBuilder unattachStr = new StringBuilder();
            unattachStr.append("AB$ Unattach | Defined$ Self | SpellDescription$ Unattach | IsPresent$ Card.Self+AttachedTo Creature");
            unattachStr.append(bothStr);
            SpellAbility attachSA = AbilityFactory.getAbility(attachStr.toString(), card);
            attachSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(attachSA);
            SpellAbility unattachSA = AbilityFactory.getAbility(unattachStr.toString(), card);
            unattachSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(unattachSA);
        } else if (keyword.startsWith("Reinforce")) {
            String[] k = keyword.split(":");
            String n = k[1];
            String manacost = k[2];
            StringBuilder sb = new StringBuilder();
            sb.append("AB$ PutCounter | CounterType$ P1P1 | ActivationZone$ Hand | ValidTgts$ Creature ");
            sb.append("| Cost$ ").append(manacost).append(" Discard<1/CARDNAME>");
            sb.append("| CounterNum$ ").append(n);
            sb.append("| CostDesc$ ").append(ManaCostParser.parse(manacost));
            sb.append("| PrecostDesc$ Reinforce ").append(n).append("\u2014");
            sb.append("| SpellDescription$ (").append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(sb.toString(), card);
            sa.setIntrinsic(intrinsic);
            if (n.equals("X")) {
                sa.setSVar("X", "Count$xPaid");
            }
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Saddle")) {
            String[] k = keyword.split(":");
            String power = k[1];
            String effect = "AB$ AlterAttribute | Cost$ tapXType<Any/Creature.Other+withTotalPowerGE" + power + ">| CostDesc$ Saddle " + power + " | Attributes$ Saddle | Secondary$ True | Defined$ Self | SorcerySpeed$ True | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Scavenge")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String effect = "AB$ PutCounter | Cost$ " + manacost + " ExileFromGrave<1/CARDNAME> | ActivationZone$ Graveyard | ValidTgts$ Creature | CounterType$ P1P1 | CounterNum$ ScavengeX | SorcerySpeed$ True | PrecostDesc$ Scavenge | CostDesc$ " + ManaCostParser.parse(manacost) + "| SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setSVar("ScavengeX", "Exiled$CardPower");
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Encore")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String extra = k.length > 2 ? "| " + k[2] : "";
            String effect = "AB$ CopyPermanent | Cost$ " + manacost + " ExileFromGrave<1/CARDNAME> | ActivationZone$ Graveyard| SorcerySpeed$ True | Defined$ Self | PumpKeywords$ Haste | RememberTokens$ True | ForEach$ Opponent| AtEOT$ Sacrifice | PrecostDesc$ Encore | CostDesc$ " + ManaCostParser.parse(manacost) + "| SpellDescription$ (" + inst.getReminderText() + ")" + extra;
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            String repeatStr = "DB$ RepeatEach | DefinedCards$ Remembered | UseImprinted$ True";
            AbilitySub repeatSub = (AbilitySub)AbilityFactory.getAbility("DB$ RepeatEach | DefinedCards$ Remembered | UseImprinted$ True", card);
            sa.setSubAbility(repeatSub);
            String effectStr = "DB$ Effect | RememberObjects$ Imprinted,ImprintedRemembered | ExileOnMoved$ Battlefield | StaticAbilities$ AttackChosen";
            AbilitySub effectSub = (AbilitySub)AbilityFactory.getAbility("DB$ Effect | RememberObjects$ Imprinted,ImprintedRemembered | ExileOnMoved$ Battlefield | StaticAbilities$ AttackChosen", card);
            repeatSub.setAdditionalAbility("RepeatSubAbility", effectSub);
            String attackStaticStr = "Mode$ MustAttack | ValidCreature$ Card.IsRemembered | MustAttack$ RememberedPlayer | Description$ This token copy attacks that opponent this turn if able.";
            effectSub.setSVar("AttackChosen", "Mode$ MustAttack | ValidCreature$ Card.IsRemembered | MustAttack$ RememberedPlayer | Description$ This token copy attacks that opponent this turn if able.");
            String cleanStr = "DB$ Cleanup | Defined$ Imprinted | ForgetDefined$ Remembered";
            AbilitySub cleanSub = (AbilitySub)AbilityFactory.getAbility("DB$ Cleanup | Defined$ Imprinted | ForgetDefined$ Remembered", card);
            effectSub.setSubAbility(cleanSub);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Specialize")) {
            String[] k = keyword.split(":");
            String cost = k[1];
            String flavor = k.length > 2 && !k[2].isEmpty() ? k[2] + " \u2013 " : "";
            String condition = k.length > 3 && !k[3].isEmpty() ? ". " + k[3] : "";
            String extra = k.length > 4 && !k[4].isEmpty() ? k[4] + " | " : "";
            String effect = "AB$ SetState | Cost$ " + cost + " ChooseColor<1> Discard<1/Card.ChosenColor;Card.AssociatedWithChosenColor/card of the chosen color or its associated basic land type> | Mode$ Specialize | SorcerySpeed$ True | " + extra + "PrecostDesc$ " + flavor + "Specialize | CostDesc$ " + ManaCostParser.parse(cost) + condition + " | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Spectacle")) {
            String[] k = keyword.split(":");
            Cost cost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithDefinedCost(cost);
            newSA.setAlternativeCost(AlternativeCost.Spectacle);
            String desc = "Spectacle " + cost.toSimpleString() + " (" + inst.getReminderText() + ")";
            newSA.setDescription(desc);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Surge")) {
            String[] k = keyword.split(":");
            Cost surgeCost = new Cost(k[1], false);
            SpellAbility newSA = card.getFirstSpellAbility().copyWithDefinedCost(surgeCost);
            newSA.setAlternativeCost(AlternativeCost.Surge);
            String desc = "Surge " + surgeCost.toSimpleString() + " (" + inst.getReminderText() + ")";
            newSA.setDescription(desc);
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Suspend") && !keyword.equals("Suspend")) {
            final String[] k = keyword.split(":");
            Cost cost = new Cost(k[2], true);
            AbilityStatic suspend = new AbilityStatic(host, cost, null){

                @Override
                public boolean canPlay() {
                    if (!this.getRestrictions().canPlay(this.getHostCard(), this)) {
                        return false;
                    }
                    if (this.getHostCard().getGame().getStack().isSplitSecondOnStack()) {
                        return false;
                    }
                    if (StaticAbilityCantBeCast.cantBeCastAbility(this, this.getHostCard(), this.getActivatingPlayer())) {
                        return false;
                    }
                    return this.getHostCard().getFirstSpellAbility().canCastTiming(this.getHostCard(), this.getActivatingPlayer());
                }

                @Override
                public void resolve() {
                    Game game = this.getHostCard().getGame();
                    EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                    CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, this);
                    Card c = game.getAction().exile(this.getHostCard(), (SpellAbility)this, moveParams);
                    zoneMovements.triggerChangesZoneAll(game, this);
                    int counters = AbilityUtils.calculateAmount(c, k[1], this);
                    GameEntityCounterTable table = new GameEntityCounterTable();
                    c.addCounter(CounterEnumType.TIME, counters, this.getActivatingPlayer(), table);
                    table.replaceCounterEffect(game, this, false);
                    String sb = TextUtil.concatWithSpace(this.getActivatingPlayer().toString(), "has suspended", c.getName(), "with", String.valueOf(counters), "time counters on it.");
                    game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
                    game.getAction().reveal(new CardCollection(c), c.getOwner(), true, c.getName() + " is suspended with " + counters + " time counters in ");
                }
            };
            StringBuilder sbDesc = new StringBuilder();
            sbDesc.append("Suspend ").append(k[1]).append("\u2014").append(cost.toSimpleString());
            sbDesc.append(k[2].contains("XMin1") ? ". X can't be 0." : "");
            sbDesc.append(" (").append(inst.getReminderText()).append(")");
            suspend.setDescription(sbDesc.toString());
            String svar = "X";
            suspend.setSVar(svar, card.getSVar(svar));
            suspend.setCardState(card);
            StringBuilder sbStack = new StringBuilder();
            sbStack.append(card.getName()).append(" suspending for ");
            sbStack.append(Lang.nounWithNumeral(k[1], "turn")).append(".)");
            suspend.setStackDescription(sbStack.toString());
            suspend.getRestrictions().setZone(ZoneType.Hand);
            inst.addSpellAbility(suspend);
        } else if (keyword.startsWith("Transfigure")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String effect = "AB$ ChangeZone | Cost$ " + manacost + " Sac<1/CARDNAME> | PrecostDesc$ Transfigure | CostDesc$ " + ManaCostParser.parse(manacost) + " | Origin$ Library | Destination$ Battlefield | ChangeType$ Creature.cmcEQTransfigureX | SorcerySpeed$ True | StackDescription$ SpellDescription | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setSVar("TransfigureX", "Count$CardManaCost");
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Transmute")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String effect = "AB$ ChangeZone | Cost$ " + manacost + " Discard<1/CARDNAME> | PrecostDesc$ Transmute | CostDesc$ " + ManaCostParser.parse(manacost) + " | ActivationZone$ Hand | Origin$ Library | Destination$ Hand | ChangeType$ Card.cmcEQTransmuteX | SorcerySpeed$ True | StackDescription$ SpellDescription | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setSVar("TransmuteX", "Count$CardManaCost");
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Unearth")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String effect = "AB$ ChangeZone | Cost$ " + manacost + " | Defined$ Self | Origin$ Graveyard | Destination$ Battlefield | SorcerySpeed$ True | ActivationZone$ Graveyard | Unearth$ True |  | PrecostDesc$ Unearth | CostDesc$ " + ManaCostParser.parse(manacost) + " | StackDescription$ Unearth: Return CARDNAME to the battlefield. | SpellDescription$ (" + inst.getReminderText() + ")";
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.endsWith(" offering")) {
            String offeringType = keyword.split(" ")[0];
            SpellAbility sa = card.getFirstSpellAbility();
            SpellAbility newSA = sa.copy();
            SpellAbilityRestriction sar = newSA.getRestrictions();
            sar.setIsPresent(offeringType + ".YouCtrl+CanBeSacrificedBy");
            sar.setInstantSpeed(true);
            newSA.putParam("Secondary", "True");
            newSA.setAlternativeCost(AlternativeCost.Offering);
            newSA.setPayCosts(sa.getPayCosts());
            newSA.setDescription(sa.getDescription() + " (" + offeringType + " offering)");
            newSA.setIntrinsic(intrinsic);
            inst.addSpellAbility(newSA);
        } else if (keyword.startsWith("Crew")) {
            String[] k = keyword.split(":");
            String power = k[1];
            String effect = "AB$ Animate | Cost$ tapXType<Any/Creature.Other+withTotalPowerGE" + power + "> | PrecostDesc$ Crew | CostDesc$ " + power + " (Tap any number of creatures you control with total power " + power + " or more: | Secondary$ True | Defined$ Self | Types$ Artifact,Creature | SpellDescription$ CARDNAME becomes an artifact creature until end of turn.)";
            if (k.length > 2) {
                effect = effect + " | " + k[2];
            }
            SpellAbility sa = AbilityFactory.getAbility(effect, card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("Cycling")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            Cost cost = new Cost(manacost, true);
            StringBuilder sb = new StringBuilder();
            sb.append("AB$ Draw | Cost$ ");
            sb.append(manacost);
            sb.append(" Discard<1/CARDNAME> | ActivationZone$ Hand | PrecostDesc$ Cycling");
            sb.append(cost.isOnlyManaCost() ? " " : "\u2014");
            sb.append("| CostDesc$ ").append(cost.toSimpleString());
            sb.append(" | SpellDescription$ (").append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(sb.toString(), card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        } else if (keyword.startsWith("TypeCycling")) {
            String[] k = keyword.split(":");
            String type = k[1];
            String manacost = k[2];
            StringBuilder sb = new StringBuilder();
            sb.append("AB$ ChangeZone | Cost$ ").append(manacost);
            String desc = type;
            if (type.equals("Basic")) {
                desc = "Basic land";
            } else if (type.equals("Land.Artifact")) {
                desc = "Artifact land";
            }
            sb.append(" Discard<1/CARDNAME> | ActivationZone$ Hand | PrecostDesc$ ").append(desc).append("cycling ");
            sb.append(" | CostDesc$ ").append(ManaCostParser.parse(manacost));
            sb.append("| Origin$ Library | Destination$ Hand |");
            sb.append("ChangeType$ ").append(type);
            sb.append(" | SpellDescription$ (").append(inst.getReminderText()).append(")");
            SpellAbility sa = AbilityFactory.getAbility(sb.toString(), card);
            sa.setIntrinsic(intrinsic);
            inst.addSpellAbility(sa);
        }
    }

    public static void addStaticAbility(KeywordInterface inst, CardState state, boolean intrinsic) {
        String keyword = inst.getOriginal();
        if (keyword.startsWith("Affinity")) {
            String desc;
            String[] k = keyword.split(":");
            String t2 = k[1];
            String d = "";
            if (k.length > 2) {
                StringBuilder s2 = new StringBuilder();
                s2.append(k[2]).append("s");
                d = s2.toString();
            }
            String string = desc = "Artifact".equals(t2) ? "artifacts" : CardType.getPluralType(t2);
            if (!d.isEmpty()) {
                desc = d;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Mode$ ReduceCost | ValidCard$ Card.Self | Type$ Spell | Amount$ AffinityX | EffectZone$ All");
            sb.append("| Description$ Affinity for ").append(desc);
            sb.append(" (").append(inst.getReminderText()).append(")");
            String effect = sb.toString();
            StaticAbility st = StaticAbility.create(effect, state.getCard(), state, intrinsic);
            StringBuilder sb2 = new StringBuilder();
            sb2.append("Count$Valid ").append(t2).append(t2.contains(".") ? "+" : ".").append("YouCtrl");
            st.setSVar("AffinityX", sb2.toString());
            inst.addStaticAbility(st);
        } else if (keyword.startsWith("Blitz")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            Cost cost = new Cost(manacost, false);
            StringBuilder sb = new StringBuilder("Blitz");
            if (!cost.isOnlyManaCost()) {
                sb.append("\u2014");
            } else {
                sb.append(" ");
            }
            sb.append(cost.toSimpleString());
            String effect = "Mode$ Continuous | Affected$ Card.Self+blitzed+castKeyword | AddKeyword$ Haste | AddTrigger$ Dies | Secondary$ True | Description$ " + sb.toString() + " (" + inst.getReminderText() + ")";
            String trig = "Mode$ ChangesZone | Origin$ Battlefield | Destination$ Graveyard | ValidCard$ Card.Self | Execute$ TrigDraw | Secondary$ True | TriggerDescription$ When this creature dies, draw a card.";
            String ab = "DB$ Draw | NumCards$ 1";
            StaticAbility st = StaticAbility.create(effect, state.getCard(), state, intrinsic);
            st.setSVar("Dies", trig);
            st.setSVar("TrigDraw", ab);
            inst.addStaticAbility(st);
        } else if (keyword.equals("Changeling")) {
            String effect = "Mode$ Continuous | EffectZone$ All | Affected$ Card.Self | CharacteristicDefining$ True | AddAllCreatureTypes$ True | Secondary$ True | Description$ Changeling (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Cipher")) {
            StringBuilder sb = new StringBuilder();
            sb.append("Mode$ Continuous | EffectZone$ Exile | Affected$ Card.EncodedWithSource");
            sb.append(" | AddTrigger$ CipherTrigger");
            sb.append(" | Description$ Cipher (").append(inst.getReminderText()).append(")");
            String effect = sb.toString();
            sb = new StringBuilder();
            sb.append("Mode$ DamageDone | ValidSource$ Card.Self | ValidTarget$ Player | Execute$ PlayEncoded");
            sb.append(" | CombatDamage$ True | OptionalDecider$ You | TriggerDescription$ ");
            sb.append("Whenever CARDNAME deals combat damage to a player, its controller may cast a copy of ");
            sb.append(state.getName()).append(" without paying its mana cost.");
            String trig = sb.toString();
            String ab = "DB$ Play | Defined$ OriginalHost | WithoutManaCost$ True | CopyCard$ True";
            StaticAbility st = StaticAbility.create(effect, state.getCard(), state, intrinsic);
            st.setSVar("CipherTrigger", trig);
            st.setSVar("PlayEncoded", ab);
            inst.addStaticAbility(st);
        } else if (keyword.startsWith("Class")) {
            String[] k = keyword.split(":");
            String level = k[1];
            String params = k[3];
            StringBuilder desc = new StringBuilder();
            boolean descAdded = false;
            Map<String, String> mapParams = AbilityFactory.getMapParams(params);
            if (mapParams.containsKey("AddTrigger")) {
                for (String s3 : mapParams.get("AddTrigger").split(" & ")) {
                    if (descAdded) {
                        desc.append("\r\n");
                    }
                    desc.append(AbilityFactory.getMapParams(state.getSVar(s3)).get("TriggerDescription"));
                    descAdded = true;
                }
            }
            if (mapParams.containsKey("AddStaticAbility")) {
                for (String s3 : mapParams.get("AddStaticAbility").split(" & ")) {
                    if (descAdded) {
                        desc.append("\r\n");
                    }
                    desc.append(AbilityFactory.getMapParams(state.getSVar(s3)).get("Description"));
                    descAdded = true;
                }
            }
            if (mapParams.containsKey("AddReplacementEffect")) {
                for (String s3 : mapParams.get("AddReplacementEffect").split(" & ")) {
                    if (descAdded) {
                        desc.append("\r\n");
                    }
                    desc.append(AbilityFactory.getMapParams(state.getSVar(s3)).get("Description"));
                    descAdded = true;
                }
            }
            String effect = "Mode$ Continuous | Affected$ Card.Self | ClassLevel$ " + level + " | " + params;
            if (descAdded) {
                effect = effect + " | Description$ " + desc.toString();
            }
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Dash")) {
            String effect = "Mode$ Continuous | Affected$ Card.Self+dashed+castKeyword | AddKeyword$ Haste";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Daybound")) {
            String effect = "Mode$ CantTransform | ValidCard$ Creature.Self | ExceptCause$ SpellAbility.Daybound | Secondary$ True | Description$ This permanent can't be transformed except by its daybound ability.";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Decayed")) {
            String effect = "Mode$ CantBlockBy | ValidBlocker$ Creature.Self | Secondary$ True | Description$ CARDNAME can't block.";
            StaticAbility st = StaticAbility.create(effect, state.getCard(), state, intrinsic);
            inst.addStaticAbility(st);
        } else if (keyword.equals("Defender")) {
            String effect = "Mode$ CantAttack | ValidCard$ Card.Self | Secondary$ True";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Devoid")) {
            String effect = "Mode$ Continuous | EffectZone$ All | Affected$ Card.Self | CharacteristicDefining$ True | SetColor$ Colorless | Secondary$ True | Description$ Devoid (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Escalate")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            Cost cost = new Cost(manacost, false);
            StringBuilder sb = new StringBuilder("Escalate");
            if (!cost.isOnlyManaCost()) {
                sb.append("\u2014");
            } else {
                sb.append(" ");
            }
            sb.append(cost.toSimpleString());
            String effect = "Mode$ RaiseCost | ValidCard$ Card.Self | Type$ Spell | Secondary$ True | Amount$ Escalate | Cost$ " + manacost + " | EffectZone$ All | Description$ " + sb.toString() + " (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Enlist")) {
            String effect = "Mode$ OptionalAttackCost | ValidCard$ Card.Self | Cost$ Enlist<1/CARDNAME/creature> | Secondary$ True| Trigger$ TrigEnlist | Description$ Enlist (" + inst.getReminderText() + ")";
            StaticAbility st = StaticAbility.create(effect, state.getCard(), state, intrinsic);
            st.setSVar("TrigEnlist", "DB$ Pump | NumAtt$ TriggerRemembered$CardPower | SpellDescription$ When you do, add its power to this creature's until end of turn.");
            inst.addStaticAbility(st);
        } else if (keyword.equals("Fear")) {
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | ValidBlocker$ Creature.nonArtifact+nonBlack | Secondary$ True | Description$ Fear (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Flying")) {
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | ValidBlocker$ Creature.withoutFlying+withoutReach | Secondary$ True | Description$ Flying (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Hexproof")) {
            StringBuilder sbDesc = new StringBuilder("Hexproof");
            StringBuilder sbValid = new StringBuilder();
            if (!keyword.equals("Hexproof")) {
                String[] k = keyword.split(":");
                sbDesc.append(" from ").append(k[2]);
                String param = k[2].contains("abilities") ? "ValidSA$ " : "ValidSource$ ";
                sbValid.append("| ").append(param).append(k[1]);
            }
            String effect = "Mode$ CantTarget | ValidCard$ Card.Self | Secondary$ True" + sbValid.toString() + " | Activator$ Opponent | Description$ " + sbDesc.toString() + " (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Horsemanship")) {
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | ValidBlocker$ Creature.withoutHorsemanship | Secondary$ True  | Description$ Horsemanship (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Impending")) {
            String effect = "Mode$ Continuous | Affected$ Card.Self+impended+counters_GE1_TIME | RemoveType$ Creature | Secondary$ True";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Intimidate")) {
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | ValidBlocker$ Creature.nonArtifact+!SharesColorWith | Secondary$ True  | Description$ Intimidate (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Landwalk")) {
            String[] k = keyword.split(":");
            String valid = k[1];
            String desc = k[k.length > 2 ? 2 : 1].toLowerCase(Locale.ROOT);
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | ValidDefender$ Player.controls" + valid + " | Description$ " + StringUtils.capitalize(desc) + "walk (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Living metal")) {
            String effect = "Mode$ Continuous | Affected$ Card.Self | AddType$ Creature | Condition$ PlayerTurn | Secondary$ True";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Nightbound")) {
            String effect = "Mode$ CantTransform | ValidCard$ Creature.Self | ExceptCause$ SpellAbility.Nightbound | Secondary$ True | Description$ This permanent can't be transformed except by its nightbound ability.";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Protection")) {
            String valid = CardFactoryUtil.getProtectionValid(keyword, false);
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | Secondary$ True ";
            String desc = "Protection (" + inst.getReminderText() + ")";
            if (!valid.isEmpty()) {
                effect = effect + "| ValidBlocker$ " + valid;
            }
            effect = effect + " | Description$ " + desc;
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
            effect = "Mode$ CantTarget | Protection$ True | ValidCard$ Card.Self | Secondary$ True ";
            if (!valid.isEmpty()) {
                effect = effect + "| ValidSource$ " + valid;
            }
            effect = effect + " | Description$ " + desc;
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
            effect = "Mode$ CantAttach | Protection$ True | Target$ Card.Self | Secondary$ True ";
            if (!valid.isEmpty()) {
                effect = effect + "| ValidCard$ " + valid;
            }
            if (keyword.startsWith("Protection:")) {
                String[] kws = keyword.split(":");
                if (kws.length > 3) {
                    effect = effect + "| Exceptions$ " + kws[3];
                }
                if (kws.length > 4) {
                    effect = effect + " | ExceptionSBA$ True";
                }
            }
            effect = effect + " | Description$ " + desc;
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Read ahead")) {
            String effect = "Mode$ DisableTriggers | ValidCard$ Card.Self+ThisTurnEntered | ValidTrigger$ Triggered.ChapterNotLore | Secondary$ True | Description$ Chapter abilities of this Saga can't trigger the turn it entered the battlefield unless it has exactly the number of lore counters on it specified in the chapter symbol of that ability.";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Shroud")) {
            String effect = "Mode$ CantTarget | ValidCard$ Card.Self | Secondary$ True | Description$ Shroud (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Skulk")) {
            String effect = "Mode$ CantBlockBy | ValidAttacker$ Creature.Self | ValidBlocker$ Creature.powerGTX | Secondary$ True  | Description$ Skulk (" + inst.getReminderText() + ")";
            StaticAbility st = StaticAbility.create(effect, state.getCard(), state, intrinsic);
            st.setSVar("X", "Count$CardPower");
            inst.addStaticAbility(st);
        } else if (keyword.equals("Spree")) {
            String effect = "Mode$ RaiseCost | ValidCard$ Card.Self | Type$ Spell | Secondary$ True | Amount$ Spree | EffectZone$ All | Description$ Spree (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.startsWith("Strive")) {
            String[] k = keyword.split(":");
            String manacost = k[1];
            String effect = "Mode$ RaiseCost | ValidCard$ Card.Self | Type$ Spell | Amount$ Strive | Cost$ " + manacost + " | EffectZone$ All | Description$ Strive - " + inst.getReminderText();
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Unleash")) {
            String effect = "Mode$ CantBlockBy | ValidBlocker$ Creature.Self+counters_GE1_P1P1 | Secondary$ True | Description$ CARDNAME can't block.";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Undaunted")) {
            String effect = "Mode$ ReduceCost | ValidCard$ Card.Self | Type$ Spell | Secondary$ True| Amount$ Undaunted | EffectZone$ All | Description$ Undaunted (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("Vigilance")) {
            String effect = "Mode$ AttackVigilance | ValidCard$ Card.Self | Secondary$ True | Description$ Vigilance (" + inst.getReminderText() + ")";
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        } else if (keyword.equals("MayFlashSac")) {
            String effect = "Mode$ Continuous | EffectZone$ All | Affected$ Card.Self | Secondary$ True | MayPlay$ True | MayPlayDontGrantZonePermissions$ True | MayPlayNotSorcerySpeed$ True | MayPlayWithFlash$ True | MayPlayText$ Sacrifice at the next cleanup step | AffectedZone$ Exile,Graveyard,Hand,Library,Stack | Description$ " + inst.getReminderText();
            inst.addStaticAbility(StaticAbility.create(effect, state.getCard(), state, intrinsic));
        }
    }

    public static void setupSiegeAbilities(Card card) {
        StringBuilder chooseSB = new StringBuilder();
        chooseSB.append("Event$ Moved | ValidCard$ Card.Self | Destination$ Battlefield | ReplacementResult$ Updated");
        chooseSB.append(" | Description$ (As a Siege enters, choose an opponent to protect it. You and others can attack it. When it's defeated, exile it, then cast it transformed.)");
        String chooseProtector = "DB$ ChoosePlayer | Defined$ You | Choices$ Opponent | Protect$ True | ChoiceTitle$ Choose an opponent to protect this battle";
        ReplacementEffect re = ReplacementHandler.parseReplacement(chooseSB.toString(), card, true);
        re.setOverridingAbility(AbilityFactory.getAbility(chooseProtector, card));
        card.addReplacementEffect(re);
        StringBuilder triggerDefeated = new StringBuilder();
        triggerDefeated.append("Mode$ CounterRemovedOnce | ValidCard$ Card.Self | Secondary$ True | CounterType$ DEFENSE | Remaining$ 0 | TriggerZones$ Battlefield |");
        triggerDefeated.append(" TriggerDescription$ When CARDNAME is defeated, exile it, then cast it transformed.");
        String castExileBattle = "DB$ ChangeZone | Defined$ Self | Origin$ Battlefield | Destination$ Exile | RememberChanged$ True";
        String castDefeatedBattle = "DB$ Play | Defined$ Remembered | WithoutManaCost$ True | Optional$ True | CastTransformed$ True";
        Trigger defeatedTrigger = TriggerHandler.parseTrigger(triggerDefeated.toString(), card, true);
        SpellAbility exileAbility = AbilityFactory.getAbility(castExileBattle, card);
        AbilitySub castAbility = (AbilitySub)AbilityFactory.getAbility(castDefeatedBattle, card);
        exileAbility.setSubAbility(castAbility);
        defeatedTrigger.setOverridingAbility(exileAbility);
        card.addTrigger(defeatedTrigger);
    }

    public static void setupAdventureAbility(Card card) {
        if (card.getCurrentStateName() != CardStateName.Adventure) {
            return;
        }
        SpellAbility sa = card.getFirstSpellAbility();
        if (sa == null) {
            return;
        }
        sa.setCardState(card.getCurrentState());
        StringBuilder sb = new StringBuilder();
        sb.append("Event$ Moved | ValidCard$ Card.Self | Origin$ Stack | ExcludeDestination$ Exile ");
        sb.append("| ValidStackSa$ Spell.Adventure | Fizzle$ False | Secondary$ True | Description$ Adventure");
        String repeffstr = sb.toString();
        String abExile = "DB$ ChangeZone | Defined$ Self | Origin$ Stack | Destination$ Exile | StackDescription$ None";
        SpellAbility saExile = AbilityFactory.getAbility(abExile, card);
        String abEffect = "DB$ Effect | RememberObjects$ Self | StaticAbilities$ Play | ForgetOnMoved$ Exile | Duration$ Permanent | ConditionDefined$ Self | ConditionPresent$ Card.!copiedSpell+nonToken";
        AbilitySub saEffect = (AbilitySub)AbilityFactory.getAbility(abEffect, card);
        StringBuilder sbPlay = new StringBuilder();
        sbPlay.append("Mode$ Continuous | MayPlay$ True | EffectZone$ Command | Affected$ Card.IsRemembered+nonAdventure");
        sbPlay.append(" | AffectedZone$ Exile | Description$ You may cast the card.");
        saEffect.setSVar("Play", sbPlay.toString());
        saExile.setSubAbility(saEffect);
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, card, true);
        re.setOverridingAbility(saExile);
        card.addReplacementEffect(re);
    }

    public static void setFaceDownState(final Card c, SpellAbility sa) {
        Card source = sa.getHostCard();
        CardState faceDown = c.getFaceDownState();
        if (sa.hasParam("FaceDownPower")) {
            faceDown.setBasePower(AbilityUtils.calculateAmount(source, sa.getParam("FaceDownPower"), sa));
        }
        if (sa.hasParam("FaceDownToughness")) {
            faceDown.setBaseToughness(AbilityUtils.calculateAmount(source, sa.getParam("FaceDownToughness"), sa));
        }
        if (sa.hasParam("FaceDownSetType")) {
            faceDown.setType(new CardType(Arrays.asList(sa.getParam("FaceDownSetType").split(" & ")), false));
        }
        if (sa.hasParam("FaceDownKeyword")) {
            faceDown.setIntrinsicKeywords(Lists.newArrayList(), false);
            faceDown.addIntrinsicKeywords((Iterable<String>)Arrays.asList(sa.getParam("FaceDownKeyword").split(" & ")));
        }
        if (sa.hasParam("FaceDownPower") || sa.hasParam("FaceDownToughness") || sa.hasParam("FaceDownSetType") || sa.hasParam("FaceDownKeyword")) {
            GameCommand unanimate = new GameCommand(){
                private static final long serialVersionUID = 8853789549297846163L;

                @Override
                public void run() {
                    c.clearStates(CardStateName.FaceDown, true);
                }
            };
            c.addFaceupCommand(unanimate);
        }
    }
}

