/*
 * Decompiled with CFR 0.152.
 */
package forge.game.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.ApiType;
import forge.game.ability.effects.DetachedCardEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardFactory;
import forge.game.card.CardState;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CardCopyService {
    private final Card copyFrom;
    private final Game toGame;

    public CardCopyService(Card copyFrom) {
        this(copyFrom, copyFrom == null ? null : copyFrom.getGame());
    }

    public CardCopyService(Card copyFrom, Game toGame) {
        this.copyFrom = copyFrom;
        this.toGame = toGame;
    }

    public final Card copyCard(boolean assignNewId) {
        return this.copyCard(assignNewId, this.copyFrom.getOwner());
    }

    public final Card copyCard(boolean assignNewId, Player owner) {
        int foil;
        Card out;
        if (this.copyFrom.isRealToken() || this.copyFrom.getCopiedPermanent() != null || this.copyFrom.getPaperCard() == null) {
            out = CardCopyService.copyStats(this.copyFrom, owner, assignNewId);
            out.setEffectSource(this.copyFrom.getEffectSource());
            out.setBoon(this.copyFrom.isBoon());
            out.dangerouslySetGame(this.toGame);
            out.setTokenSpawningAbility(this.copyFrom.getTokenSpawningAbility());
            out.setCopiedPermanent(this.copyFrom.getCopiedPermanent());
        } else {
            out = assignNewId ? CardFactory.getCard(this.copyFrom.getPaperCard(), owner, this.toGame) : CardFactory.getCard(this.copyFrom.getPaperCard(), owner, this.copyFrom.getId(), this.toGame);
        }
        out.setZone(this.copyFrom.getZone());
        out.setState(this.copyFrom.getFaceupCardStateName(), true);
        out.setBackSide(this.copyFrom.isBackSide());
        out.setGamePieceType(this.copyFrom.getGamePieceType());
        out.setTokenCard(this.copyFrom.isTokenCard());
        if (this.toGame == this.copyFrom.getGame()) {
            out.setCollectible(this.copyFrom.isCollectible());
            out.setAttachedCards(this.copyFrom.getAttachedCards());
            out.setEntityAttachedTo(this.copyFrom.getEntityAttachedTo());
            out.setLeavesPlayCommands(this.copyFrom.getLeavesPlayCommands());
            out.setSpecialized(this.copyFrom.isSpecialized());
            out.addRemembered(this.copyFrom.getRemembered());
            out.addImprintedCards(this.copyFrom.getImprintedCards());
            out.setCommander(this.copyFrom.isRealCommander());
        }
        if ((foil = this.copyFrom.getCurrentState().getFoil()) > 0) {
            out.setFoil(foil);
        }
        return out;
    }

    private static void copyState(Card from, CardStateName fromState, Card to, CardStateName toState) {
        CardCopyService.copyState(from, fromState, to, toState, true);
    }

    private static void copyState(Card from, CardStateName fromState, Card to, CardStateName toState, boolean updateView) {
        to.setText(from.getSpellText());
        if (!to.getStates().contains((Object)toState)) {
            to.addAlternateState(toState, updateView);
        }
        CardState toCharacteristics = to.getState(toState);
        CardState fromCharacteristics = from.getState(fromState);
        toCharacteristics.copyFrom(fromCharacteristics, false);
    }

    public static Card copyStats(Card in, Player newOwner, boolean assignNewId) {
        int id = in.getId();
        if (assignNewId) {
            id = newOwner == null ? 0 : newOwner.getGame().nextCardId();
        }
        Card c = in instanceof DetachedCardEffect ? new DetachedCardEffect((DetachedCardEffect)in, assignNewId) : new Card(id, in.getPaperCard(), in.getGame());
        c.setOwner(newOwner);
        c.setSetCode(in.getSetCode());
        for (CardStateName state : in.getStates()) {
            CardCopyService.copyState(in, state, c, state, false);
        }
        c.setState(in.getCurrentStateName(), false);
        c.setRules(in.getRules());
        if (in.isTransformed()) {
            c.incrementTransformedTimestamp();
        }
        return c;
    }

    @Deprecated
    public void copyCopiableCharacteristics(Card to, SpellAbility sourceSA, SpellAbility targetSA) {
        boolean fromIsTransformedCard;
        boolean toIsFaceDown = to.isFaceDown();
        if (toIsFaceDown) {
            to.setState(CardStateName.Original, false);
            this.copyCopiableCharacteristics(to, sourceSA, targetSA);
            to.setState(CardStateName.FaceDown, false);
            return;
        }
        boolean fromIsFlipCard = this.copyFrom.isFlipCard();
        boolean bl = fromIsTransformedCard = this.copyFrom.getCurrentStateName() == CardStateName.Transformed || this.copyFrom.getCurrentStateName() == CardStateName.Meld;
        if (fromIsFlipCard) {
            if (to.getCurrentStateName().equals((Object)CardStateName.Flipped)) {
                CardCopyService.copyState(this.copyFrom, CardStateName.Original, to, CardStateName.Original);
            } else {
                CardCopyService.copyState(this.copyFrom, CardStateName.Original, to, to.getCurrentStateName());
            }
            CardCopyService.copyState(this.copyFrom, CardStateName.Flipped, to, CardStateName.Flipped);
        } else if (this.copyFrom.isTransformable() && sourceSA != null && ApiType.CopySpellAbility.equals((Object)sourceSA.getApi()) && targetSA != null && targetSA.isSpell() && targetSA.getHostCard().isPermanent()) {
            CardCopyService.copyState(this.copyFrom, CardStateName.Original, to, CardStateName.Original);
            CardCopyService.copyState(this.copyFrom, CardStateName.Transformed, to, CardStateName.Transformed);
            to.setBackSide(this.copyFrom.isBackSide());
            if (this.copyFrom.isTransformed()) {
                to.incrementTransformedTimestamp();
            }
        } else if (fromIsTransformedCard) {
            CardCopyService.copyState(this.copyFrom, this.copyFrom.getCurrentStateName(), to, CardStateName.Original);
        } else {
            CardCopyService.copyState(this.copyFrom, this.copyFrom.getCurrentStateName(), to, to.getCurrentStateName());
        }
    }

    public static List<Card> getLKICopyList(Iterable<Card> in, Map<Integer, Card> cachedMap) {
        if (in == null) {
            return null;
        }
        ArrayList<Card> result = Lists.newArrayList();
        for (Card c : in) {
            result.add(new CardCopyService(c).getLKICopy(cachedMap));
        }
        return result;
    }

    public static Card getLKICopy(Card c) {
        return new CardCopyService(c).getLKICopy();
    }

    public static Card getLKICopy(Card c, Map<Integer, Card> cachedMap) {
        return new CardCopyService(c).getLKICopy(cachedMap);
    }

    public static GameEntity getLKICopy(GameEntity c, Map<Integer, Card> cachedMap) {
        if (c instanceof Card) {
            return new CardCopyService((Card)c).getLKICopy(cachedMap);
        }
        return c;
    }

    public Card getLKICopy() {
        return this.getLKICopy(Maps.newHashMap());
    }

    public Card getLKICopy(Map<Integer, Card> cachedMap) {
        if (this.copyFrom == null) {
            return null;
        }
        Card cachedCard = cachedMap.get(this.copyFrom.getId());
        if (cachedCard != null) {
            return cachedCard;
        }
        String msg = "CardUtil:getLKICopy copy object";
        Breadcrumb bread = new Breadcrumb(msg);
        bread.setData("Card", this.copyFrom.getName());
        bread.setData("CardState", this.copyFrom.getCurrentStateName().toString());
        bread.setData("Player", this.copyFrom.getController().getName());
        Sentry.addBreadcrumb(bread);
        Card newCopy = this.copyFrom instanceof DetachedCardEffect ? new DetachedCardEffect((DetachedCardEffect)this.copyFrom, false) : new Card(this.copyFrom.getId(), this.copyFrom.getPaperCard(), this.copyFrom.getGame(), null);
        cachedMap.put(this.copyFrom.getId(), newCopy);
        newCopy.setSetCode(this.copyFrom.getSetCode());
        newCopy.setOwner(this.copyFrom.getOwner());
        newCopy.setController(this.copyFrom.getController(), 0L);
        newCopy.setCommander(this.copyFrom.isCommander());
        newCopy.setCollectible(this.copyFrom.isCollectible());
        newCopy.setRules(this.copyFrom.getRules());
        newCopy.setLKICMC(this.copyFrom.getCMC());
        newCopy.setLastKnownZone(this.copyFrom.getLastKnownZone());
        newCopy.setEffectSource(CardCopyService.getLKICopy(this.copyFrom.getEffectSource(), cachedMap));
        if (this.copyFrom.isFlipCard()) {
            newCopy.getState(CardStateName.Original).copyFrom(this.copyFrom.getState(CardStateName.Original), true);
            newCopy.addAlternateState(CardStateName.Flipped, false);
            newCopy.getState(CardStateName.Flipped).copyFrom(this.copyFrom.getState(CardStateName.Flipped), true);
        } else if (this.copyFrom.isTransformable()) {
            newCopy.getState(CardStateName.Original).copyFrom(this.copyFrom.getState(CardStateName.Original), true);
            newCopy.addAlternateState(CardStateName.Transformed, false);
            newCopy.getState(CardStateName.Transformed).copyFrom(this.copyFrom.getState(CardStateName.Transformed), true);
        } else if (this.copyFrom.isAdventureCard()) {
            newCopy.getState(CardStateName.Original).copyFrom(this.copyFrom.getState(CardStateName.Original), true);
            newCopy.addAlternateState(CardStateName.Adventure, false);
            newCopy.getState(CardStateName.Adventure).copyFrom(this.copyFrom.getState(CardStateName.Adventure), true);
        } else if (this.copyFrom.isSplitCard()) {
            newCopy.getState(CardStateName.Original).copyFrom(this.copyFrom.getState(CardStateName.Original), true);
            newCopy.addAlternateState(CardStateName.LeftSplit, false);
            newCopy.getState(CardStateName.LeftSplit).copyFrom(this.copyFrom.getState(CardStateName.LeftSplit), true);
            newCopy.addAlternateState(CardStateName.RightSplit, false);
            newCopy.getState(CardStateName.RightSplit).copyFrom(this.copyFrom.getState(CardStateName.RightSplit), true);
        } else {
            newCopy.getCurrentState().copyFrom(this.copyFrom.getState(this.copyFrom.getFaceupCardStateName()), true);
        }
        newCopy.setFlipped(this.copyFrom.isFlipped());
        newCopy.setBackSide(this.copyFrom.isBackSide());
        if (this.copyFrom.isTransformed()) {
            newCopy.incrementTransformedTimestamp();
        }
        if (newCopy.hasAlternateState()) {
            newCopy.setState(this.copyFrom.getCurrentStateName(), false, true);
        }
        if (this.copyFrom.isFaceDown()) {
            newCopy.turnFaceDownNoUpdate();
            newCopy.setType(new CardType(this.copyFrom.getFaceDownState().getType()));
        }
        newCopy.updateStateForView();
        newCopy.setGamePieceType(this.copyFrom.getGamePieceType());
        newCopy.setTokenCard(this.copyFrom.isTokenCard());
        newCopy.setEmblem(this.copyFrom.isEmblem());
        newCopy.setBasePower(this.copyFrom.getCurrentPower());
        newCopy.setBaseToughness(this.copyFrom.getCurrentToughness());
        newCopy.setBasePowerString(this.copyFrom.getCurrentState().getBasePowerString());
        newCopy.setBaseToughnessString(this.copyFrom.getCurrentState().getBaseToughnessString());
        newCopy.setPTBoost(this.copyFrom.getPTBoostTable());
        newCopy.setCounters(Maps.newHashMap(this.copyFrom.getCounters()));
        newCopy.setTributed(this.copyFrom.isTributed());
        newCopy.setMonstrous(this.copyFrom.isMonstrous());
        newCopy.setRenowned(this.copyFrom.isRenowned());
        newCopy.setSolved(this.copyFrom.isSolved());
        newCopy.setSaddled(this.copyFrom.isSaddled());
        newCopy.setPromisedGift(this.copyFrom.getPromisedGift());
        if (newCopy.isSaddled()) {
            newCopy.setSaddledByThisTurn(this.copyFrom.getSaddledByThisTurn());
        }
        newCopy.setSuspectedTimestamp(this.copyFrom.getSuspectedTimestamp());
        newCopy.setColor(this.copyFrom.getColor().getColor());
        newCopy.setPhasedOut(this.copyFrom.getPhasedOut());
        newCopy.setTapped(this.copyFrom.isTapped());
        newCopy.setDamageHistory(this.copyFrom.getDamageHistory());
        newCopy.setDamageReceivedThisTurn(this.copyFrom.getDamageReceivedThisTurn());
        newCopy.setExcessDamageReceivedThisTurn(this.copyFrom.getExcessDamageThisTurn());
        newCopy.getBlockedThisTurn().addAll(this.copyFrom.getBlockedThisTurn());
        newCopy.getBlockedByThisTurn().addAll(this.copyFrom.getBlockedByThisTurn());
        newCopy.setAttachedCards(CardCopyService.getLKICopyList(this.copyFrom.getAttachedCards(), cachedMap));
        newCopy.setEntityAttachedTo(CardCopyService.getLKICopy(this.copyFrom.getEntityAttachedTo(), cachedMap));
        newCopy.setCopiedPermanent(this.copyFrom.getCopiedPermanent());
        newCopy.setHaunting(this.copyFrom.getHaunting());
        for (Card haunter : this.copyFrom.getHauntedBy()) {
            newCopy.addHauntedBy(haunter, false);
        }
        newCopy.setIntensity(this.copyFrom.getIntensity(false));
        newCopy.setPerpetual(this.copyFrom);
        newCopy.addRemembered(this.copyFrom.getRemembered());
        newCopy.addImprintedCards(this.copyFrom.getImprintedCards());
        newCopy.setChosenCards(this.copyFrom.getChosenCards());
        newCopy.setChosenType(this.copyFrom.getChosenType());
        newCopy.setChosenType2(this.copyFrom.getChosenType2());
        newCopy.setNamedCards(Lists.newArrayList(this.copyFrom.getNamedCards()));
        newCopy.setChosenColors(Lists.newArrayList(this.copyFrom.getChosenColors()));
        if (this.copyFrom.hasChosenNumber()) {
            newCopy.setChosenNumber(this.copyFrom.getChosenNumber());
        }
        newCopy.setChosenEvenOdd(this.copyFrom.getChosenEvenOdd());
        newCopy.setUnearthed(this.copyFrom.isUnearthed());
        newCopy.setChangedCardColors(this.copyFrom.getChangedCardColorsTable());
        newCopy.setChangedCardColorsCharacterDefining(this.copyFrom.getChangedCardColorsCharacterDefiningTable());
        newCopy.setChangedCardKeywords(this.copyFrom.getChangedCardKeywords());
        newCopy.setChangedCardTypes(this.copyFrom.getChangedCardTypesTable());
        newCopy.setChangedCardTypesCharacterDefining(this.copyFrom.getChangedCardTypesCharacterDefiningTable());
        newCopy.setChangedCardNames(this.copyFrom.getChangedCardNames());
        newCopy.setChangedCardTraits(this.copyFrom.getChangedCardTraits());
        newCopy.setStoredKeywords(this.copyFrom.getStoredKeywords(), true);
        newCopy.setStoredReplacements(this.copyFrom.getStoredReplacements());
        newCopy.copyChangedTextFrom(this.copyFrom);
        newCopy.setGameTimestamp(this.copyFrom.getGameTimestamp());
        newCopy.setLayerTimestamp(this.copyFrom.getLayerTimestamp());
        newCopy.setBestowTimestamp(this.copyFrom.getBestowTimestamp());
        newCopy.setForetold(this.copyFrom.isForetold());
        newCopy.setTurnInZone(this.copyFrom.getTurnInZone());
        newCopy.setForetoldCostByEffect(this.copyFrom.isForetoldCostByEffect());
        newCopy.setPlotted(this.copyFrom.isPlotted());
        newCopy.setMeldedWith(CardCopyService.getLKICopy(this.copyFrom.getMeldedWith(), cachedMap));
        for (CardStateName s2 : newCopy.getStates()) {
            newCopy.updateKeywordsCache(newCopy.getState(s2));
        }
        if (this.copyFrom.getCastSA() != null) {
            SpellAbility castSA = this.copyFrom.getCastSA().copy(newCopy, true);
            castSA.setLastStateBattlefield(CardCollection.EMPTY);
            castSA.setLastStateGraveyard(CardCollection.EMPTY);
            newCopy.setCastSA(castSA);
        }
        newCopy.setCastFrom(this.copyFrom.getCastFrom());
        newCopy.setExiledBy(this.copyFrom.getExiledBy());
        newCopy.setExiledWith(CardCopyService.getLKICopy(this.copyFrom.getExiledWith(), cachedMap));
        newCopy.addExiledCards(this.copyFrom.getExiledCards());
        newCopy.setDiscarded(this.copyFrom.wasDiscarded());
        newCopy.setMilled(this.copyFrom.wasMilled());
        newCopy.setSurveilled(this.copyFrom.wasSurveilled());
        newCopy.getAbilityActivatedThisTurn().putAll(this.copyFrom.getAbilityActivatedThisTurn());
        newCopy.getAbilityActivatedThisGame().putAll(this.copyFrom.getAbilityActivatedThisGame());
        newCopy.getAbilityResolvedThisTurn().putAll(this.copyFrom.getAbilityResolvedThisTurn());
        if (this.copyFrom.getGame().getCombat() != null && this.copyFrom.isPermanent()) {
            newCopy.setCombatLKI(this.copyFrom.getGame().getCombat().saveLKI(newCopy));
        }
        newCopy.getGoadMap().putAll(this.copyFrom.getGoadMap());
        return newCopy;
    }
}

