/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardLists;
import forge.game.event.GameEventRandomLog;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class VoteEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(VoteEffect.getDefinedPlayersOrTargeted(sa))).append(" vote ");
        if (sa.hasParam("VoteType")) {
            sb.append("for ").append(StringUtils.join((Object[])sa.getParam("VoteType").split(","), " or "));
        } else if (sa.hasParam("VoteMessage")) {
            sb.append(sa.getParam("VoteMessage"));
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        PlayerCollection tgtPlayers = VoteEffect.getDefinedPlayersOrTargeted(sa);
        ArrayList<Object> voteType = Lists.newArrayList();
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Player activator = sa.getActivatingPlayer();
        boolean secret = sa.hasParam("Secretly");
        boolean other = sa.hasParam("VotePlayer") && sa.getParam("VotePlayer").equals("Other");
        StringBuilder record = new StringBuilder();
        if (sa.hasParam("VoteType")) {
            voteType.addAll(Arrays.asList(sa.getParam("VoteType").split(",")));
        } else if (sa.hasParam("VoteCard")) {
            ZoneType zone = sa.hasParam("Zone") ? ZoneType.smartValueOf(sa.getParam("Zone")) : ZoneType.Battlefield;
            voteType.addAll(CardLists.getValidCards((Iterable<Card>)game.getCardsIn(zone), sa.getParam("VoteCard"), activator, host, (CardTraitBase)sa));
        } else if (sa.hasParam("VotePlayer")) {
            String param = other ? "Player" : sa.getParam("VotePlayer");
            voteType.addAll(AbilityUtils.getDefinedPlayers(host, param, sa));
        }
        if (voteType.isEmpty()) {
            return;
        }
        int aidx = tgtPlayers.indexOf(activator);
        if (aidx != -1) {
            Collections.rotate(tgtPlayers, -aidx);
        }
        ArrayListMultimap<Object, Player> votes = ArrayListMultimap.create();
        Player voter = game.getControlVote();
        for (Player p : tgtPlayers) {
            Object realVoter;
            ArrayList voteOpts = Lists.newArrayList(voteType);
            int n = p.getAdditionalVotesAmount() + 1;
            int optionalVotes = p.getAdditionalOptionalVotesAmount();
            Object object = realVoter = voter == null ? p : voter;
            if (other) {
                voteOpts.remove(realVoter);
                if (voteOpts.isEmpty()) continue;
            }
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Voter", realVoter);
            n += p.getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblHowManyAdditionalVotesDoYouWant", new Object[0]), 0, optionalVotes, params);
            for (int i = 0; i < n; ++i) {
                Object result = ((Player)realVoter).getController().vote(sa, host + " " + Localizer.getInstance().getMessage("lblVote", new Object[0]) + ":", voteOpts, votes, p, sa.hasParam("UpTo"));
                if (result == null) continue;
                votes.put(result, p);
                if (!secret) {
                    game.getAction().notifyOfValue(sa, p, result + "\r\n" + Localizer.getInstance().getMessage("lblCurrentVote", new Object[0]) + ":" + votes, p);
                }
                if (record.length() > 0) {
                    record.append("\r\n");
                }
                record.append(p).append(" ").append(Localizer.getInstance().getMessage("lblVotedFor", result));
            }
        }
        String voteResult = record.toString();
        if (secret) {
            game.getAction().notifyOfValue(sa, host, voteResult, null);
        }
        game.fireEvent(new GameEventRandomLog(voteResult));
        EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
        runParams.put(AbilityKey.AllVotes, votes);
        game.getTriggerHandler().runTrigger(TriggerType.Vote, runParams, false);
        if (sa.hasParam("EachVote")) {
            for (Map.Entry entry : votes.asMap().entrySet()) {
                SpellAbility action = AbilityFactory.getAbility(host, sa.getParam("Vote" + entry.getKey().toString()));
                action.setActivatingPlayer(sa.getActivatingPlayer());
                ((AbilitySub)action).setParent(sa);
                for (Player p : (Collection)entry.getValue()) {
                    host.addRemembered(p);
                    AbilityUtils.resolve(action);
                    host.removeRemembered(p);
                }
            }
        } else {
            ArrayList<String> subAbs = Lists.newArrayList();
            List<Object> list = VoteEffect.getMostVotes(votes);
            if (sa.hasParam("Tied") && list.size() > 1) {
                subAbs.add(sa.getParam("Tied"));
            } else if (sa.hasParam("VoteSubAbility")) {
                host.addRemembered(list);
                subAbs.add(sa.getParam("VoteSubAbility"));
            } else {
                for (Object type : list) {
                    subAbs.add(sa.getParam("Vote" + type.toString()));
                }
            }
            if (sa.hasParam("StoreVoteNum")) {
                for (Object type : voteType) {
                    sa.setSVar("VoteNum" + type, "Number$" + votes.get(type).size());
                }
            } else {
                for (String subAb : subAbs) {
                    SpellAbility action = AbilityFactory.getAbility(host, subAb);
                    action.setActivatingPlayer(sa.getActivatingPlayer());
                    ((AbilitySub)action).setParent(sa);
                    AbilityUtils.resolve(action);
                }
            }
            if (sa.hasParam("VoteSubAbility")) {
                host.clearRemembered();
            }
            if (sa.hasParam("RememberVotedObjects")) {
                host.addRemembered(votes.keySet());
            }
        }
    }

    private static List<Object> getMostVotes(ListMultimap<Object, Player> votes) {
        ArrayList<Object> most = Lists.newArrayList();
        int amount = 0;
        for (Object voteType : votes.keySet()) {
            int voteAmount = votes.get(voteType).size();
            if (voteAmount == amount) {
                most.add(voteType);
                continue;
            }
            if (voteAmount <= amount) continue;
            amount = voteAmount;
            most.clear();
            most.add(voteType);
        }
        return most;
    }
}

