/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.card.CardStateName;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardState;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class UnlockDoorEffect
extends SpellAbilityEffect {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resolve(SpellAbility sa) {
        CardCollection list;
        Card source = sa.getHostCard();
        Game game = source.getGame();
        Player activator = sa.getActivatingPlayer();
        if (sa.hasParam("Choices")) {
            Player chooser = activator;
            String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChoose", new Object[0]) + " ";
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("Choices"), activator, source, (CardTraitBase)sa);
            Card c = chooser.getController().chooseSingleEntityForEffect(choices, sa, title, Maps.newHashMap());
            if (c == null) {
                return;
            }
            list = new CardCollection(c);
        } else {
            list = UnlockDoorEffect.getTargetCards(sa);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Card c = (Card)iterator.next();
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Object", c);
            switch (sa.getParamOrDefault("Mode", "ThisDoor")) {
                case "ThisDoor": {
                    c.unlockRoom(activator, sa.getCardStateName());
                    break;
                }
                case "Unlock": {
                    List<CardState> states = c.getLockedRooms().stream().map(stateName -> c.getState((CardStateName)((Object)stateName))).collect(Collectors.toList());
                    CardState chosen = activator.getController().chooseSingleCardState(sa, states, "Choose Room to unlock", params);
                    if (chosen == null) break;
                    c.unlockRoom(activator, chosen.getStateName());
                    break;
                }
                case "LockOrUnlock": {
                    switch (c.getLockedRooms().size()) {
                        case 0: {
                            List<CardState> unlockStates = c.getUnlockedRooms().stream().map(stateName -> c.getState((CardStateName)((Object)stateName))).collect(Collectors.toList());
                            CardState chosenUnlock = activator.getController().chooseSingleCardState(sa, unlockStates, "Choose Room to lock", params);
                            if (chosenUnlock == null) break;
                            c.lockRoom(activator, chosenUnlock.getStateName());
                            break;
                        }
                        case 1: {
                            ArrayList<CardState> bothStates = Lists.newArrayList();
                            bothStates.add(c.getState(CardStateName.LeftSplit));
                            bothStates.add(c.getState(CardStateName.RightSplit));
                            CardState chosenBoth = activator.getController().chooseSingleCardState(sa, bothStates, "Choose Room to lock or unlock", params);
                            if (chosenBoth == null) break;
                            if (c.getLockedRooms().contains((Object)chosenBoth.getStateName())) {
                                c.unlockRoom(activator, chosenBoth.getStateName());
                                break;
                            }
                            c.lockRoom(activator, chosenBoth.getStateName());
                            break;
                        }
                        case 2: {
                            List<CardState> lockStates = c.getLockedRooms().stream().map(stateName -> c.getState((CardStateName)((Object)stateName))).collect(Collectors.toList());
                            CardState chosenLock = activator.getController().chooseSingleCardState(sa, lockStates, "Choose Room to unlock", params);
                            if (chosenLock == null) break;
                            c.unlockRoom(activator, chosenLock.getStateName());
                        }
                    }
                    break;
                }
            }
        }
        return;
    }
}

