/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.TokenEffectBase;
import forge.game.card.Card;
import forge.game.card.CardZoneTable;
import forge.game.event.GameEventCombatChanged;
import forge.game.event.GameEventTokenCreated;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class TokenEffect
extends TokenEffectBase {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("SpellDescription")) {
            Card host = sa.getHostCard();
            String desc = sa.getParam("SpellDescription");
            List<String> words = Arrays.asList(desc.split(" "));
            PlayerCollection creators = AbilityUtils.getDefinedPlayers(host, sa.getParamOrDefault("TokenOwner", "You"), sa);
            if (!words.get(0).equalsIgnoreCase("Create") && desc.contains(" create")) {
                String[] parts = desc.split(" create", 2);
                desc = parts[0] + " " + Lang.joinHomogenous(creators) + " create" + parts[1];
                if (creators.size() == 1) {
                    desc = desc.replaceAll(" create ", " creates ");
                }
                if (desc.contains("you")) {
                    desc = desc.replaceAll("you", sa.getActivatingPlayer().getName());
                }
            } else if (StringUtils.containsIgnoreCase(desc, "Create")) {
                int numTokens;
                String verb = creators.size() == 1 ? "creates" : "create";
                String start = Lang.joinHomogenous(creators) + " " + verb;
                String create = desc.contains("Create") ? "Create" : "create";
                desc = desc.replaceFirst(".*" + create, "");
                desc = start + desc;
                if (sa.hasParam("TokenAmount") && !StringUtils.isNumeric(sa.getParam("TokenAmount")) && (numTokens = AbilityUtils.calculateAmount(host, sa.getParam("TokenAmount"), sa)) != 0) {
                    if (numTokens != 1) {
                        String numeral = " " + Lang.getNumeral(numTokens) + " ";
                        List<String> words2 = Arrays.asList(desc.split(" "));
                        String target = " " + words2.get(words2.indexOf(verb) + 1) + " ";
                        desc = desc.replaceFirst(target, numeral);
                    }
                    String truncate = null;
                    if (desc.contains(", where")) {
                        truncate = ", where";
                    } else if (desc.contains(" for each")) {
                        truncate = " for each";
                    }
                    if (truncate != null) {
                        desc = (desc = desc.split(truncate)[0]).endsWith("token") && numTokens > 1 ? desc + "s." : desc + ".";
                    }
                }
                desc = desc.replace("you control", "they control");
            }
            return desc;
        }
        return sa.getDescription();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        if (sa.hasParam("TokenTypes") && sa.getParam("TokenTypes").contains("ChosenType") && !host.hasChosenType()) {
            return;
        }
        if (sa.hasParam("TokenColors") && sa.getParam("TokenColors").contains("ChosenColor") && !host.hasChosenColor()) {
            return;
        }
        MutableBoolean combatChanged = new MutableBoolean(false);
        boolean useZoneTable = true;
        CardZoneTable triggerList = sa.getChangeZoneTable();
        if (triggerList == null) {
            triggerList = new CardZoneTable();
            useZoneTable = false;
        }
        if (sa.hasParam("ChangeZoneTable")) {
            sa.setChangeZoneTable(triggerList);
            useZoneTable = true;
        }
        this.makeTokenTable(AbilityUtils.getDefinedPlayers(host, sa.getParamOrDefault("TokenOwner", "You"), sa), sa.getParam("TokenScript").split(","), AbilityUtils.calculateAmount(host, sa.getParamOrDefault("TokenAmount", "1"), sa), false, triggerList, combatChanged, sa);
        if (!useZoneTable) {
            triggerList.triggerChangesZoneAll(game, sa);
            triggerList.clear();
        }
        game.fireEvent(new GameEventTokenCreated());
        if (combatChanged.isTrue()) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
    }
}

