/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;

public class TapAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa instanceof AbilitySub) {
            return "Tap all valid cards.";
        }
        return sa.getParam("SpellDescription");
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        Card card = sa.getHostCard();
        boolean remTapped = sa.hasParam("RememberTapped");
        if (remTapped) {
            card.clearRemembered();
        }
        CardCollectionView cards = !sa.usesTargeting() && !sa.hasParam("Defined") ? game.getCardsIn(ZoneType.Battlefield) : TapAllEffect.getTargetPlayers(sa).getCardsIn(ZoneType.Battlefield);
        cards = AbilityUtils.filterListByType(cards, sa.getParam("ValidCards"), sa);
        Player tapper = activator;
        CardCollection tapped = new CardCollection();
        for (Card c : cards) {
            if (remTapped) {
                card.addRemembered(c);
            }
            if (sa.hasParam("TapperController")) {
                tapper = c.getController();
            }
            if (!c.tap(true, sa, tapper)) continue;
            tapped.add(c);
        }
        if (!tapped.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, tapped);
            game.getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
    }
}

