/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;

public class SurveilEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(SurveilEffect.getTargetPlayers(sa)));
        int num = 1;
        if (sa.hasParam("Amount")) {
            num = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
        }
        sb.append(" surveils (").append(num).append(").");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        int num = 1;
        if (sa.hasParam("Amount")) {
            num = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa);
        }
        if (num == 0) {
            return;
        }
        boolean isOptional = sa.hasParam("Optional");
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable table = AbilityKey.addCardZoneTableParams(moveParams, sa);
        for (Player p : SurveilEffect.getTargetPlayers(sa)) {
            if (!p.isInGame() || isOptional && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantSurveil", new Object[0]), null)) continue;
            p.surveil(num, sa, moveParams);
        }
        table.triggerChangesZoneAll(sa.getHostCard().getGame(), sa);
    }
}

