/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.TextUtil;

public class StoreSVarEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        String key = null;
        String type = null;
        String expr = null;
        if (sa.hasParam("SVar")) {
            String string = key = sa.getParam("SVar").equals("EachPlayer") ? ((Player)AbilityUtils.getDefinedPlayers(source, "Remembered", sa).get(false)).toString() : sa.getParam("SVar");
        }
        if (sa.hasParam("Type")) {
            type = sa.getParam("Type");
        }
        if (sa.hasParam("Expression")) {
            expr = sa.getParam("Expression");
        }
        if (key == null || type == null || expr == null) {
            System.out.println("SVar, Type and Expression paramaters required for StoreSVar. They are missing for " + source.getName());
            return;
        }
        int value = 0;
        if (type.equals("Count")) {
            value = AbilityUtils.xCount(source, expr, sa);
        } else if (type.equals("Number")) {
            value = Integer.parseInt(expr);
        } else if (type.equals("CountSVar")) {
            if (expr.contains("/")) {
                String exprMathVar = expr.split("\\/")[1].split("\\.")[1];
                int exprMath = AbilityUtils.calculateAmount(source, exprMathVar, sa);
                expr = TextUtil.fastReplace(expr, exprMathVar, Integer.toString(exprMath));
            }
            value = AbilityUtils.xCount(source, "SVar$" + expr, sa);
        } else if (type.equals("Targeted")) {
            value = AbilityUtils.handlePaid(sa.findTargetedCards(), expr, source, sa);
        } else if (type.equals("Triggered")) {
            Card trigCard = (Card)sa.getTriggeringObject(AbilityKey.Card);
            value = AbilityUtils.xCount(trigCard, expr, sa);
        } else if (type.equals("Calculate")) {
            value = AbilityUtils.calculateAmount(source, expr, sa);
        } else if (type.startsWith("AdditiveForEach")) {
            int current = source.hasSVar(key) ? AbilityUtils.calculateAmount(source, source.getSVar(key), sa) : 0;
            int toAdd = AbilityUtils.calculateAmount(source, expr, sa);
            value = current + toAdd;
        }
        StringBuilder numBuilder = new StringBuilder();
        numBuilder.append("Number$");
        numBuilder.append(value);
        source.setSVar(key, numBuilder.toString());
        for (SpellAbility root = sa.getRootAbility(); root != null; root = root.getSubAbility()) {
            root.setSVar(key, numBuilder.toString());
        }
    }
}

