/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import java.util.Iterator;

public class ShuffleEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        boolean optional = sa.hasParam("Optional");
        for (Player p : ShuffleEffect.getTargetPlayers(sa)) {
            boolean mustShuffle;
            if (!p.isInGame() || !(mustShuffle = !optional || sa.getActivatingPlayer().getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblHaveTargetShuffle", p.getName()), null))) continue;
            p.shuffle(sa);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = ShuffleEffect.getTargetPlayers(sa);
        if (tgtPlayers.size() > 0) {
            Iterator it = tgtPlayers.iterator();
            while (it.hasNext()) {
                sb.append(((Player)it.next()).getName());
                if (!it.hasNext()) continue;
                sb.append(" and ");
            }
        } else {
            sb.append("Error - no target players for Shuffle. ");
        }
        sb.append(" shuffle");
        if (tgtPlayers.size() > 1) {
            sb.append(" their libraries");
        } else {
            sb.append("s their library");
        }
        sb.append(".");
        return sb.toString();
    }
}

